/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol;

import java.io.Serializable;
import org.jSyncManager.API.Tools.UnsignedByte;

public class DLP_Packet
implements Serializable {
    public static final byte READ_USER_INFO = 16;
    public static final byte WRITE_USER_INFO = 17;
    public static final byte READ_SYSTEM_INFO = 18;
    public static final byte GET_TIME = 19;
    public static final byte SET_TIME = 20;
    public static final byte READ_STORAGE_INFO = 21;
    public static final byte READ_DATABASE_LIST = 22;
    public static final byte OPEN_DATABASE = 23;
    public static final byte CREATE_DATABASE = 24;
    public static final byte CLOSE_DATABASE = 25;
    public static final byte DELETE_DATABASE = 26;
    public static final byte READ_APP_BLOCK = 27;
    public static final byte WRITE_APP_BLOCK = 28;
    public static final byte READ_SORT_BLOCK = 29;
    public static final byte WRITE_SORT_BLOCK = 30;
    public static final byte READ_NEXT_MOD_REC = 31;
    public static final byte READ_RECORD = 32;
    public static final byte WRITE_RECORD = 33;
    public static final byte DELETE_RECORD = 34;
    public static final byte READ_RESOURCE = 35;
    public static final byte WRITE_RESOURCE = 36;
    public static final byte DELETE_RESOURCE = 37;
    public static final byte CLEANUP_DATABASE = 38;
    public static final byte RESET_SYNC_FLAGS = 39;
    public static final byte CALL_APPLICATION = 40;
    public static final byte RESET_SYSTEM = 41;
    public static final byte ADD_SYNC_LOG_ENTRY = 42;
    public static final byte READ_OPEN_DB_INFO = 43;
    public static final byte MOVE_CATEGORY = 44;
    public static final byte PROCESS_RPC = 45;
    public static final byte OPEN_CONDUIT = 46;
    public static final byte END_OF_SYNC = 47;
    public static final byte RESET_RECORD_INDEX = 48;
    public static final byte READ_REC_ID_LIST = 49;
    public static final byte READ_NEXT_REC_IN_CAT = 50;
    public static final byte READ_NEXT_MOD_REC_IN_CAT = 51;
    public static final byte READ_APP_PREFERENCE = 52;
    public static final byte WRITE_APP_PREFERENCE = 53;
    public static final byte READ_NET_SYNC_INFO = 54;
    public static final byte WRITE_NET_SYNC_INFO = 55;
    public static final byte READ_FEATURE = 56;
    public static final byte FIND_DB = 57;
    public static final byte SET_DB_INFO = 58;
    public static final char ERR_NONE = '\u0000';
    public static final char ERR_SYSTEM_ERROR = '\u0001';
    public static final char ERR_ILLEGAL_REQUEST = '\u0002';
    public static final char ERR_MEMORY_ERROR = '\u0003';
    public static final char ERR_INVALID_PARAMETER = '\u0004';
    public static final char ERR_NOT_FOUND = '\u0005';
    public static final char ERR_NONE_OPEN = '\u0006';
    public static final char ERR_DATABASE_OPEN = '\u0007';
    public static final char ERR_TOO_MANY_OPEN_DBS = '\b';
    public static final char ERR_ALREADY_EXISTS = '\t';
    public static final char ERR_UNABLE_TO_OPEN = '\n';
    public static final char ERR_RECORD_DELETED = '\u000b';
    public static final char ERR_RECORD_BUSY = '\f';
    public static final char ERR_NOT_SUPPORTED = '\r';
    public static final char ERR_ROM_BASED = '\u000e';
    public static final char ERR_READ_ONLY = '\u000f';
    public static final char ERR_INSUFFICIENT_SPACE = '\u0010';
    public static final char ERR_LIMIT_EXCEEDED = '\u0011';
    public static final char ERR_CANCEL_SYNC = '\u0012';
    public static final char ERR_BAD_WRAPPER = '\u0013';
    public static final char ERR_ARG_MISSING = '\u0014';
    public static final char ERR_INVALID_ARG_SIZE = '\u0015';
    private static final byte DLP_RESPONSE_FLAG = -128;
    private static final byte DLP_FUNCTION_ID_MASK = 127;
    public static final byte DLP_FIRST_ARG_ID = 32;
    private static final byte SMALL_ARGUMENT_FLAG = -128;
    private static final byte SMALL_ARGUMENT_ID_MASK = 127;
    private static final char LONG_ARGUMENT_FLAG = '\uc000';
    private static final char LONG_ARGUMENT_ID_MASK = '\u3fff';
    private static final long MAX_TINY_ARG_SIZE = 255L;
    private static final long MAX_SMALL_ARG_SIZE = 65535L;
    private static final long MAX_LONG_ARG_SIZE = -1L;
    private DLPHeader packet;
    public byte hostSocket;
    public byte serverSocket;

    private DLP_Packet() {
    }

    private DLP_Packet(byte funcID, byte numArgs, byte[] args) {
        this.packet = new DLPRequestHeader();
        this.packet.functionID = funcID;
        this.packet.argCount = numArgs;
        this.packet.args = this.parseArguments(UnsignedByte.intValue(numArgs), args);
    }

    private DLP_Packet(byte funcID, char error, byte numArgs, byte[] args) {
        this.packet = new DLPResponseHeader();
        this.packet.functionID = (byte)(funcID | 0xFFFFFF80);
        ((DLPResponseHeader)this.packet).errorCode = error;
        this.packet.argCount = numArgs;
        this.packet.args = args != null ? this.parseArguments(UnsignedByte.intValue(numArgs), args) : null;
    }

    DLP_Packet(byte funcID, char error, byte[][] args) {
        this.packet = new DLPResponseHeader();
        this.packet.functionID = (byte)(funcID | 0xFFFFFF80);
        ((DLPResponseHeader)this.packet).errorCode = error;
        if (args == null) {
            this.packet.argCount = 0;
            this.packet.args = null;
            return;
        }
        this.packet.argCount = (byte)args.length;
        this.packet.args = new Argument[args.length];
        int i = 0;
        while (i < this.packet.argCount) {
            this.packet.args[i] = this.createArgument(args[i], i + 32);
            ++i;
        }
    }

    DLP_Packet(byte funcID, byte[][] args) {
        this.packet = new DLPRequestHeader();
        this.packet.functionID = funcID;
        if (args == null) {
            this.packet.argCount = 0;
            this.packet.args = null;
            return;
        }
        this.packet.argCount = (byte)args.length;
        this.packet.args = new Argument[args.length];
        int i = 0;
        while (i < this.packet.argCount) {
            this.packet.args[i] = this.createArgument(args[i], i + 32);
            ++i;
        }
    }

    DLP_Packet(byte funcID, byte[][] args, int i) {
        this.packet = new DLPRequestHeader();
        this.packet.functionID = funcID;
        if (args == null) {
            this.packet.argCount = 0;
            this.packet.args = null;
            return;
        }
        this.packet.argCount = (byte)args.length;
        this.packet.args = new Argument[args.length];
        int j = 0;
        while (j < this.packet.argCount) {
            this.packet.args[j] = this.createArgument(args[j], j + i);
            ++j;
        }
    }

    static DLP_Packet bytes2Packet(byte[] pkt) {
        DLP_Packet dlp_packet = null;
        if ((pkt[0] & 0xFFFFFF80) == -128) {
            byte[] temp;
            if (pkt.length == 4) {
                temp = null;
            } else {
                temp = new byte[pkt.length - 4];
                int i = 4;
                while (i < pkt.length) {
                    temp[i - 4] = pkt[i];
                    ++i;
                }
            }
            dlp_packet = new DLP_Packet((byte)(pkt[0] & 0x7F), (char)(pkt[2] * 256 + pkt[3]), pkt[1], temp);
        } else {
            byte[] data = new byte[pkt.length - 2];
            System.arraycopy(pkt, 2, data, 0, pkt.length - 2);
            dlp_packet = new DLP_Packet((byte)(pkt[0] & 0x7F), pkt[1], data);
        }
        return dlp_packet;
    }

    private Argument createArgument(byte[] abyte0, int i) {
        Argument obj = null;
        if ((long)abyte0.length <= 255L) {
            obj = new TinyArgument();
            obj.argumentID = (byte)i;
            obj.argumentSize = (byte)abyte0.length;
            obj.data = abyte0;
        }
        if ((long)abyte0.length <= 65535L) {
            obj = new SmallArgument();
            ((SmallArgument)obj).argumentID = (byte)(i | 0xFFFFFF80);
            ((SmallArgument)obj).argumentSize = (char)abyte0.length;
            ((SmallArgument)obj).data = abyte0;
        }
        if ((long)abyte0.length <= -1L) {
            obj = new LongArgument();
            ((LongArgument)obj).argumentID = (char)(i | 0xC000);
            ((LongArgument)obj).argumentSize = abyte0.length;
            ((LongArgument)obj).data = abyte0;
        }
        return obj;
    }

    int getArgCount() {
        return this.packet.countArgs();
    }

    char getErrorCode() {
        if (this.getPacketType()) {
            return '\u0000';
        }
        return ((DLPResponseHeader)this.packet).errorCode;
    }

    byte getFunctionID() {
        return (byte)(this.packet.functionID & 0x7F);
    }

    boolean getPacketType() {
        return this.packet instanceof DLPRequestHeader;
    }

    byte[] packet2Bytes() {
        return this.packet.packet2Bytes();
    }

    private Argument parseArgument(byte[] abyte0) {
        Argument obj = null;
        char c = UnsignedByte.unsignedBytes2Char(abyte0[0], abyte0[1]);
        if ((c & 0xC000) == 49152) {
            obj = new LongArgument();
            obj = ((Argument)obj).bytes2Arg(abyte0);
        } else if ((abyte0[0] & 0xFFFFFF80) == -128) {
            obj = new SmallArgument();
            obj = ((Argument)obj).bytes2Arg(abyte0);
        } else {
            obj = new TinyArgument();
            obj = ((Argument)obj).bytes2Arg(abyte0);
        }
        return obj;
    }

    private Argument[] parseArguments(int i, byte[] abyte0) {
        Argument[] aargument = new Argument[i];
        int j = 0;
        boolean flag = false;
        int i1 = 0;
        while (i1 < i) {
            byte byte1;
            byte byte0;
            char c;
            int k = j;
            int l = ((c = UnsignedByte.unsignedBytes2Char(byte0 = abyte0[j++], byte1 = abyte0[j++])) & 0xC000) == 49152 ? UnsignedByte.unsignedBytes2Int(abyte0[j++], abyte0[j++], abyte0[j++], abyte0[j++]) + 6 : ((byte0 & 0xFFFFFF80) == -128 ? UnsignedByte.unsignedBytes2Char(abyte0[j++], abyte0[j++]) + 4 : UnsignedByte.intValue(byte1) + 2);
            j = k;
            byte[] abyte1 = new byte[l];
            System.arraycopy(abyte0, j, abyte1, 0, l);
            aargument[i1] = this.parseArgument(abyte1);
            ++i1;
        }
        return aargument;
    }

    byte[] readArgument(int i) {
        if (i > this.getArgCount() | i < 1) {
            return null;
        }
        return this.packet.getArg(i).getArgument();
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer();
        byte[] abyte0 = this.packet2Bytes();
        int i = 0;
        while (i < abyte0.length) {
            stringbuffer.append(UnsignedByte.toString(abyte0[i]));
            stringbuffer.append(" ");
            ++i;
        }
        return stringbuffer.toString();
    }

    private class LongArgument
    extends Argument
    implements Serializable {
        char argumentID;
        int argumentSize;
        byte[] data;

        LongArgument() {
        }

        Argument bytes2Arg(byte[] abyte0) {
            if (abyte0.length == 0) {
                return null;
            }
            LongArgument longargument = new LongArgument();
            longargument.argumentID = UnsignedByte.unsignedBytes2Char(abyte0[0], abyte0[1]);
            longargument.argumentSize = UnsignedByte.unsignedBytes2Int(abyte0[2], abyte0[3], abyte0[4], abyte0[5]);
            longargument.data = new byte[abyte0.length - 6];
            System.arraycopy(abyte0, 6, longargument.data, 0, abyte0.length - 6);
            return longargument;
        }

        byte[] arg2Bytes() {
            byte[] abyte0;
            if (this.data == null) {
                abyte0 = new byte[]{(byte)(this.argumentID / 256), (byte)(this.argumentID % 256), (byte)(this.argumentSize / 0x1000000), (byte)((this.argumentSize & 0xFF0000) / 65536), (byte)((this.argumentSize & 0xFF00) / 256), (byte)(this.argumentSize & 0xFF)};
            } else {
                abyte0 = new byte[this.data.length + 6];
                abyte0[0] = (byte)(this.argumentID / 256);
                abyte0[1] = (byte)(this.argumentID % 256);
                abyte0[2] = (byte)(this.argumentSize / 0x1000000);
                abyte0[3] = (byte)((this.argumentSize & 0xFF0000) / 65536);
                abyte0[4] = (byte)((this.argumentSize & 0xFF00) / 256);
                abyte0[5] = (byte)(this.argumentSize & 0x100);
                System.arraycopy(this.data, 0, abyte0, 6, abyte0.length - 6);
            }
            return abyte0;
        }

        int getSize() {
            if (this.data == null) {
                return 6;
            }
            return this.data.length + 6;
        }

        byte[] getArgument() {
            if (this.data == null) {
                return null;
            }
            return this.data;
        }
    }

    private class SmallArgument
    extends ShortArgument
    implements Serializable {
        byte unused = 0;
        char argumentSize;

        SmallArgument() {
        }

        Argument bytes2Arg(byte[] abyte0) {
            if (abyte0.length == 0) {
                return null;
            }
            SmallArgument smallargument = new SmallArgument();
            smallargument.argumentID = abyte0[0];
            smallargument.argumentSize = UnsignedByte.unsignedBytes2Char(abyte0[2], abyte0[3]);
            smallargument.data = new byte[abyte0.length - 4];
            System.arraycopy(abyte0, 4, smallargument.data, 0, abyte0.length - 4);
            return smallargument;
        }

        byte[] arg2Bytes() {
            byte[] abyte0;
            if (this.data == null) {
                abyte0 = new byte[]{this.argumentID, 0, (byte)(this.argumentSize / 256), (byte)(this.argumentSize % 256)};
            } else {
                abyte0 = new byte[this.data.length + 4];
                abyte0[0] = this.argumentID;
                abyte0[1] = 0;
                abyte0[2] = (byte)(this.argumentSize / 256);
                abyte0[3] = (byte)(this.argumentSize % 256);
                System.arraycopy(this.data, 0, abyte0, 4, abyte0.length - 4);
            }
            return abyte0;
        }

        int getSize() {
            if (this.data == null) {
                return 4;
            }
            return this.data.length + 4;
        }

        byte[] getArgument() {
            if (this.data == null) {
                return null;
            }
            return this.data;
        }
    }

    private class TinyArgument
    extends ShortArgument
    implements Serializable {
        byte argumentSize;

        TinyArgument() {
        }

        Argument bytes2Arg(byte[] abyte0) {
            if (abyte0.length == 0) {
                return null;
            }
            TinyArgument tinyargument = new TinyArgument();
            tinyargument.argumentID = abyte0[0];
            tinyargument.argumentSize = abyte0[1];
            tinyargument.data = new byte[abyte0.length - 2];
            System.arraycopy(abyte0, 2, tinyargument.data, 0, abyte0.length - 2);
            return tinyargument;
        }

        byte[] arg2Bytes() {
            byte[] abyte0;
            if (this.data == null) {
                abyte0 = new byte[]{this.argumentID, this.argumentSize};
            } else {
                abyte0 = new byte[this.data.length + 2];
                abyte0[0] = this.argumentID;
                abyte0[1] = this.argumentSize;
                System.arraycopy(this.data, 0, abyte0, 2, abyte0.length - 2);
            }
            return abyte0;
        }

        int getSize() {
            if (this.data == null) {
                return 2;
            }
            return this.data.length + 2;
        }

        byte[] getArgument() {
            if (this.data == null) {
                return null;
            }
            return this.data;
        }
    }

    private abstract class ShortArgument
    extends Argument
    implements Serializable {
        byte argumentID;
        byte[] data;

        ShortArgument() {
        }
    }

    private abstract class Argument
    implements Serializable {
        Argument() {
        }

        abstract Argument bytes2Arg(byte[] var1);

        abstract byte[] arg2Bytes();

        abstract int getSize();

        abstract byte[] getArgument();
    }

    private class DLPResponseHeader
    extends DLPHeader
    implements Serializable {
        char errorCode;

        DLPResponseHeader() {
        }

        int getSize() {
            int i = 4;
            if (this.args == null || this.args.length == 0) {
                return i;
            }
            int j = 0;
            while (j < this.args.length) {
                i += this.args[j].getSize();
                ++j;
            }
            return i;
        }

        byte[] packet2Bytes() {
            byte[] abyte0 = new byte[this.getSize()];
            int i = 0;
            abyte0[i++] = this.functionID;
            abyte0[i++] = this.argCount;
            abyte0[i++] = (byte)(this.errorCode / 256);
            abyte0[i++] = (byte)(this.errorCode % 256);
            if (this.args != null) {
                int j = 0;
                while (j < this.argCount) {
                    byte[] abyte1 = this.args[j].arg2Bytes();
                    System.arraycopy(abyte1, 0, abyte0, i, abyte1.length);
                    ++j;
                }
            }
            return abyte0;
        }
    }

    private class DLPRequestHeader
    extends DLPHeader
    implements Serializable {
        DLPRequestHeader() {
        }

        int getSize() {
            int i = 2;
            if (this.args == null || this.args.length == 0) {
                return i;
            }
            int j = 0;
            while (j < this.args.length) {
                i += this.args[j].getSize();
                ++j;
            }
            return i;
        }

        byte[] packet2Bytes() {
            byte[] abyte0 = new byte[this.getSize()];
            int i = 0;
            abyte0[i++] = this.functionID;
            abyte0[i++] = this.argCount;
            if (this.args != null) {
                int j = 0;
                while (j < this.argCount) {
                    byte[] abyte1 = this.args[j].arg2Bytes();
                    System.arraycopy(abyte1, 0, abyte0, i, abyte1.length);
                    ++j;
                }
            }
            return abyte0;
        }
    }

    private abstract class DLPHeader
    implements Serializable {
        byte functionID;
        byte argCount;
        Argument[] args = null;

        abstract int getSize();

        abstract byte[] packet2Bytes();

        int countArgs() {
            return this.args.length;
        }

        Argument getArg(int i) {
            if (i > this.args.length) {
                return null;
            }
            return this.args[i - 1];
        }

        DLPHeader() {
        }
    }
}

