/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol;

import java.io.Serializable;
import org.jSyncManager.API.Tools.UnsignedByte;

public class CMP_Packet
implements Serializable {
    public static final byte CHANGE_BAUD_RATE = -128;
    public static final byte ONE_MINUTE_TIMEOUT = 64;
    public static final byte TWO_MINUTE_TIMEOUT = 32;
    public static final byte CMP_WAKEUP = 1;
    public static final byte CMP_INIT = 2;
    public static final byte CMP_ABORT = 3;
    public static final byte CMP_EXTENDED = 4;
    public static final byte WAKEUP_TID = -1;
    public static final byte VERSION_MISMATCH = -128;
    public static final int DEFAULT_SPEED = 9600;
    public byte packetType;
    public byte flags;
    public byte majorVersion;
    public byte minorVersion;
    public int baudRate = 9600;

    CMP_Packet() {
    }

    CMP_Packet(byte pktType, byte flgs, byte majorVer, byte minorVer, int baud) {
        this.packetType = pktType;
        this.flags = flgs;
        this.majorVersion = majorVer;
        this.minorVersion = minorVer;
        this.baudRate = baud;
    }

    static CMP_Packet bytes2Packet(byte[] pkt) {
        CMP_Packet cmpPkt = new CMP_Packet();
        cmpPkt.packetType = pkt[0];
        cmpPkt.flags = pkt[1];
        cmpPkt.majorVersion = pkt[2];
        cmpPkt.minorVersion = pkt[3];
        cmpPkt.baudRate = UnsignedByte.unsignedBytes2Int(pkt[6], pkt[7], pkt[8], pkt[9]);
        return cmpPkt;
    }

    byte[] packet2Bytes() {
        byte[] data = new byte[]{this.packetType, this.flags, this.majorVersion, this.minorVersion, 0, 0, (byte)((this.baudRate & 0xFF000000) / 0x1000000), (byte)((this.baudRate & 0xFF0000) / 65536), (byte)((this.baudRate & 0xFF00) / 256), (byte)(this.baudRate & 0xFF)};
        return data;
    }
}

