/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Protocol;

import org.jSyncManager.API.Protocol.CMPDLPTransferInterface;
import org.jSyncManager.API.Protocol.CMP_Packet;
import org.jSyncManager.API.Protocol.DLPError;
import org.jSyncManager.API.Protocol.DLP_Packet;
import org.jSyncManager.API.Protocol.GenericPacket;
import org.jSyncManager.API.Protocol.NotConnectedException;
import org.jSyncManager.API.Protocol.PADP;
import org.jSyncManager.API.Protocol.PADP_PacketTooBigException;
import org.jSyncManager.API.Protocol.USB;
import org.jSyncManager.API.Tools.UnsignedByte;

public class CMP_DLP {
    protected CMPDLPTransferInterface padpHandler = null;
    protected boolean connected = false;
    protected int speed = 9600;

    protected CMP_DLP() {
    }

    public CMP_DLP(CMPDLPTransferInterface padp) {
        this.padpHandler = padp;
        this.padpHandler.connect();
    }

    public void connect() throws NotConnectedException {
        byte speedFlag = 0;
        if (this.padpHandler instanceof PADP) {
            GenericPacket genericpacket = this.padpHandler.readPacket();
            if (this.determinePacketType(genericpacket)) {
                return;
            }
            if (this.speed != 9600) {
                speedFlag = -128;
            }
            try {
                this.padpHandler.transmitPacket(new CMP_Packet(2, speedFlag, 0, 0, this.speed).packet2Bytes(), (byte)3, (byte)3);
            }
            catch (PADP_PacketTooBigException pADP_PacketTooBigException) {
                // empty catch block
            }
        }
        if (this.padpHandler instanceof USB) {
            try {
                this.rxHandshake();
            }
            catch (Exception e) {
                System.out.println("[CMP-DLP] - Caught Exception " + e);
            }
        }
        this.connected = true;
    }

    protected boolean determinePacketType(GenericPacket genericpacket) {
        return genericpacket.data[0] >= 16;
    }

    public void disconnect() {
        this.disconnect('\u0000');
    }

    public void disconnect(char c) {
        byte[][] data = new byte[1][2];
        data[0][0] = (byte)(c / 256);
        data[0][1] = (byte)(c % 256);
        if (this.connected) {
            DLP_Packet dlp_packet = new DLP_Packet(47, data);
            dlp_packet.hostSocket = (byte)3;
            dlp_packet.serverSocket = (byte)3;
            try {
                this.getDLPPacket(dlp_packet);
            }
            catch (NotConnectedException ex) {
            }
            catch (DLPError ex) {
                // empty catch block
            }
        }
        this.padpHandler.disconnect();
        this.connected = false;
    }

    public DLP_Packet getDLPPacket(DLP_Packet dlp_packet) throws NotConnectedException, DLPError {
        if (!this.connected) {
            throw new NotConnectedException("Not connected.");
        }
        try {
            this.padpHandler.transmitPacket(dlp_packet.packet2Bytes(), dlp_packet.hostSocket, dlp_packet.serverSocket);
        }
        catch (PADP_PacketTooBigException ex) {
            System.out.println("## Packet too big.");
            throw new NotConnectedException();
        }
        GenericPacket genericpacket = this.padpHandler.readPacket();
        if (genericpacket == null) {
            System.out.println("[CMP]  > Received a null packet!");
            throw new NotConnectedException();
        }
        if (genericpacket.data == null) {
            System.out.println("[CMP]  > Received a packet with null data!");
            throw new NotConnectedException();
        }
        if (genericpacket.data[0] < 16 & genericpacket.data[0] >= 0) {
            System.out.println("[CMP] - First byte is less than 0x10: " + UnsignedByte.toString(genericpacket.data[0]));
            return null;
        }
        DLP_Packet pkt = DLP_Packet.bytes2Packet(genericpacket.data);
        if (pkt.getErrorCode() != '\u0000') {
            throw new DLPError(pkt);
        }
        return pkt;
    }

    public int getSpeed() {
        return this.speed;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setSpeed(int newValue) {
        this.speed = newValue;
    }

    public void suspend() throws NotConnectedException {
        byte[][] data = new byte[][]{{0, 0}};
        if (!this.connected) {
            throw new NotConnectedException("Not connected.");
        }
        DLP_Packet dlp_packet = new DLP_Packet(47, data);
        dlp_packet.hostSocket = (byte)3;
        dlp_packet.serverSocket = (byte)3;
        try {
            this.getDLPPacket(dlp_packet);
        }
        catch (DLPError dLPError) {
            // empty catch block
        }
        this.connected = false;
        this.padpHandler.suspendConnection();
    }

    protected void rxHandshake() throws Exception {
        byte[] msg1 = new byte[]{18, 1, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 36, -1, -1, -1, -1, 60, 0, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, -64, -88, -91, 31, 4, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] msg2 = new byte[]{19, 1, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 32, -1, -1, -1, -1, 0, 60, 0, 60, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        GenericPacket pkt = this.padpHandler.readPacket();
        this.padpHandler.transmitPacket(msg1, (byte)0, (byte)0);
        pkt = this.padpHandler.readPacket();
        this.padpHandler.transmitPacket(msg2, (byte)0, (byte)0);
        GenericPacket genericPacket = this.padpHandler.readPacket();
    }
}

