/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Conduit;

import java.awt.Frame;
import java.util.Hashtable;
import java.util.Vector;
import org.jSyncManager.API.Conduit.ConduitHandlerException;
import org.jSyncManager.API.Conduit.ConduitManager;
import org.jSyncManager.API.Conduit.DatabaseNotFoundException;
import org.jSyncManager.API.Protocol.DLPFunctionCallException;
import org.jSyncManager.API.Protocol.JHotSync;
import org.jSyncManager.API.Protocol.NotConnectedException;
import org.jSyncManager.API.Protocol.Util.DLPAppPreference;
import org.jSyncManager.API.Protocol.Util.DLPBlock;
import org.jSyncManager.API.Protocol.Util.DLPDatabase;
import org.jSyncManager.API.Protocol.Util.DLPDatabaseInfo;
import org.jSyncManager.API.Protocol.Util.DLPRecord;
import org.jSyncManager.API.Protocol.Util.DLPResource;
import org.jSyncManager.API.Protocol.Util.DLPStorageInfo;
import org.jSyncManager.API.Protocol.Util.DLPSystemInfo;
import org.jSyncManager.API.Protocol.Util.DLPUserInfo;

public final class ConduitHandler {
    private ConduitManager cManager;
    private JHotSync jHotSync;
    private Hashtable hash = new Hashtable();
    public static final double version = 1.099;
    public static Frame frame = null;
    public static final byte READ_ID_LIST_SORT_FLAG = -128;
    public static final byte WRITE_APP_PREF_BACKUP = -128;

    public ConduitHandler(ConduitManager cmanager, JHotSync jhotsync) {
        this.cManager = cmanager;
        this.jHotSync = jhotsync;
    }

    public void addSyncLogEntry(String text) {
        this.cManager.appendToPalmSyncLog(text);
    }

    public void cleanupDatabase(byte dbID) throws ConduitHandlerException, NotConnectedException {
        try {
            this.jHotSync.cleanupDatabase(dbID);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public void closeAllDatabases() throws ConduitHandlerException, NotConnectedException {
        try {
            this.jHotSync.closeAllDatabases();
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public void closeDatabase(byte dbID) throws ConduitHandlerException, NotConnectedException {
        try {
            this.jHotSync.closeDatabase(dbID);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public byte createDatabase(String creator, String type, String dbName, char flags, char version) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.createDatabase((byte)0, creator, type, dbName, flags, version);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public void deleteDatabase(String dbName) throws ConduitHandlerException, NotConnectedException {
        try {
            this.jHotSync.deleteDatabase((byte)0, dbName);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public void deleteRecord(byte dbID, byte flags, int recordID) throws ConduitHandlerException, NotConnectedException {
        try {
            this.jHotSync.deleteRecord(dbID, flags, recordID);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public void deleteResource(byte dbID, byte flags, int type, char resourceID) throws ConduitHandlerException, NotConnectedException {
        try {
            this.jHotSync.deleteResource(dbID, flags, type, resourceID);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public DLPBlock getApplicationBlock(byte dbID) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.getApplicationBlock(dbID, 0, -1);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public DLPDatabaseInfo getDatabaseInfo(String dbName) throws ConduitHandlerException {
        try {
            return this.cManager.getDBInfo(dbName);
        }
        catch (DatabaseNotFoundException ex) {
            throw new ConduitHandlerException("Database Not Found.", null);
        }
    }

    public Vector getDatabaseInfoList() {
        return this.cManager.getDBInfo();
    }

    public Frame getFrameHandle() {
        return frame;
    }

    public int getOpenDatabaseInfo(byte dbID) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.getOpenDatabaseInfo(dbID);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public Object getProperty(Object key) {
        return this.hash.get(key);
    }

    public int getRecordCount(byte dbID) throws ConduitHandlerException, NotConnectedException {
        return this.getOpenDatabaseInfo(dbID);
    }

    public DLPBlock getSortBlock(byte dbID) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.getSortBlock(dbID, 0, -1);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public DLPStorageInfo getStorageInfo() {
        return this.cManager.getStorageInfo();
    }

    public DLPStorageInfo getStorageInfo(byte card) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.getStorageInfo(card);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public DLPSystemInfo getSystemInfo() {
        return this.cManager.getSystemInfo();
    }

    public DLPUserInfo getUserInfo() {
        return this.cManager.getUserInfo();
    }

    public static final double getVersion() {
        return 1.099;
    }

    public boolean hasDatabase(String dbName) throws NotConnectedException {
        try {
            this.getDatabaseInfo(dbName);
            return true;
        }
        catch (ConduitHandlerException ex) {
            return false;
        }
    }

    public boolean isModemSync() {
        return this.cManager.isModemListener();
    }

    public boolean isPopupAllowed() {
        return this.cManager.getPopupState();
    }

    public void moveCategory(byte dbID, byte to, byte from) throws ConduitHandlerException, NotConnectedException {
        try {
            this.jHotSync.moveCategory(dbID, to, from);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public void openConduit() throws ConduitHandlerException, NotConnectedException {
        try {
            this.jHotSync.openConduit();
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public byte openDatabase(String dbName, byte mode) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.openDatabase((byte)0, mode, dbName);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public void postToLog(String s) {
        this.cManager.postToLog(s);
    }

    public float queryDLPVersion() {
        try {
            return (float)this.cManager.getDLPVersion().getMajorVersion() + (float)this.cManager.getDLPVersion().getMinorVersion() / 10.0f;
        }
        catch (NullPointerException e) {
            return 1.0f;
        }
    }

    public DLPAppPreference readAppPreference(int creatorID, char prefID, char size, byte flags) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.readAppPreference(creatorID, prefID, size, flags);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public DLPDatabase readDatabase(String dbName) throws ConduitHandlerException, NotConnectedException {
        DLPDatabaseInfo dlpdatabaseinfo = this.getDatabaseInfo(dbName);
        try {
            DLPDatabase dlpdatabase;
            byte temp = this.openDatabase(dbName, (byte)-128);
            int k = this.jHotSync.getOpenDatabaseInfo(temp);
            if (dlpdatabaseinfo.checkDatabaseFlag('\u0001')) {
                dlpdatabase = new DLPDatabase(true, dlpdatabaseinfo);
                int i = 0;
                while (i < k) {
                    dlpdatabase.addElement(this.jHotSync.readResource(temp, (char)i, '\u0000', '\uffff'));
                    ++i;
                }
            } else {
                dlpdatabase = new DLPDatabase(false, dlpdatabaseinfo);
                int j = 0;
                while (j < k) {
                    dlpdatabase.addElement(this.jHotSync.readRecord(temp, (char)j, '\u0000', '\uffff'));
                    ++j;
                }
            }
            try {
                DLPBlock dlpblock = this.jHotSync.getApplicationBlock(temp, 0, 65535);
                dlpdatabase.setApplicationBlock(dlpblock);
            }
            catch (DLPFunctionCallException ex) {
                // empty catch block
            }
            try {
                DLPBlock dlpblock1 = this.jHotSync.getSortBlock(temp, 0, 65535);
                dlpdatabase.setSortBlock(dlpblock1);
            }
            catch (DLPFunctionCallException ex) {
                // empty catch block
            }
            if (temp != 0) {
                this.jHotSync.closeDatabase(temp);
            }
            return dlpdatabase;
        }
        catch (DLPFunctionCallException dlpfunctioncallexception) {
            throw new ConduitHandlerException(dlpfunctioncallexception.toString(), dlpfunctioncallexception);
        }
    }

    public DLPRecord readNextModifiedRecord(byte dbID) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.readNextModifiedRecord(dbID);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public DLPRecord readNextModifiedRecordInCategory(byte dbID, byte category) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.readNextModifiedRecordInCategory(dbID, category);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public DLPRecord readNextRecordInCategory(byte dbID, byte category) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.readNextRecordInCategory(dbID, category);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public DLPRecord readRecord(byte dbID, char index) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.readRecord(dbID, index, '\u0000', '\uffff');
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public DLPRecord readRecord(byte dbID, int recordID) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.readRecord(dbID, recordID, '\u0000', '\uffff');
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public DLPRecord readRecordByID(byte dbID, int recordID) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.readRecord(dbID, recordID, '\u0000', '\uffff');
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public DLPRecord readRecordByIndex(byte dbID, char recordIndex) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.readRecord(dbID, recordIndex, '\u0000', '\uffff');
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public int[] readRecordIDList(byte dbID, byte flags, char firstRecNum, char maximumEntries) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.readRecordIDList(dbID, flags, firstRecNum, maximumEntries);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public DLPResource readResource(byte dbID, char resourceIndex) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.readResource(dbID, resourceIndex, '\u0000', '\uffff');
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public DLPResource readResource(byte dbID, int type, char resourceID) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.readResource(dbID, type, resourceID, '\u0000', '\uffff');
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public DLPResource readResourceByID(byte dbID, int type, char resourceID) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.readResource(dbID, type, resourceID, '\u0000', '\uffff');
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public DLPResource readResourceByIndex(byte dbID, char resourceIndex) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.readResource(dbID, resourceIndex, '\u0000', '\uffff');
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public void resetRecordIndex(byte dbID) throws ConduitHandlerException, NotConnectedException {
        try {
            this.jHotSync.resetRecordIndex(dbID);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public void resetSyncFlags(byte dbID) throws ConduitHandlerException, NotConnectedException {
        try {
            this.jHotSync.resetSyncFlags(dbID);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public void resetSystem() throws ConduitHandlerException, NotConnectedException {
        try {
            this.jHotSync.resetSystem();
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public static void setFrameHandle(Frame f) {
        frame = f;
    }

    public void setStatus(String status) {
        this.cManager.setStatus(status);
    }

    public void startTickles() {
        this.jHotSync.startTickles();
    }

    public void stopTickles() {
        this.jHotSync.stopTickles();
    }

    public void storeProperty(Object key, Object data) {
        this.hash.put(key, data);
    }

    public void writeApplicationBlock(byte dbID, DLPBlock appBlock) throws ConduitHandlerException, NotConnectedException {
        try {
            this.jHotSync.writeApplicationBlock(dbID, appBlock);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public void writeApplicationBlock(byte dbID, byte[] appBlock) throws ConduitHandlerException, NotConnectedException {
        try {
            this.jHotSync.writeApplicationBlock(dbID, appBlock);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public void writeAppPreference(int creatorID, char prefID, byte flags, DLPAppPreference preference) throws ConduitHandlerException, NotConnectedException {
        try {
            this.jHotSync.writeAppPreference(creatorID, prefID, flags, preference);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public void writeDatabase(DLPDatabase dbName) throws ConduitHandlerException, NotConnectedException {
        byte byte0 = 0;
        Object obj = null;
        Object obj1 = null;
        DLPDatabase dbName1 = dbName;
        DLPDatabaseInfo dbNameinfo = dbName1.getDatabaseInfo();
        try {
            byte0 = this.jHotSync.createDatabase((byte)0, dbNameinfo.getCreator(), dbNameinfo.getType(), dbNameinfo.getName(), dbNameinfo.getDatabaseFlags(), (char)dbNameinfo.getVersion());
        }
        catch (DLPFunctionCallException ex) {
            byte0 = 0;
            try {
                this.jHotSync.deleteDatabase((byte)0, dbNameinfo.getName());
                byte0 = this.jHotSync.createDatabase((byte)0, dbNameinfo.getCreator(), dbNameinfo.getType(), dbNameinfo.getName(), dbNameinfo.getDatabaseFlags(), (char)dbNameinfo.getVersion());
            }
            catch (Throwable ex2) {
                byte0 = 0;
                System.out.println("Unable to write database object! 0");
                throw new ConduitHandlerException("Unable to write database object!", null);
            }
        }
        try {
            if (dbName1.getApplicationBlock() != null) {
                this.jHotSync.writeApplicationBlock(byte0, dbName1.getApplicationBlock().getData());
            }
            if (dbName1.getSortBlock() != null) {
                this.jHotSync.writeSortBlock(byte0, dbName1.getSortBlock().getData());
            }
            if (dbNameinfo.checkDatabaseFlag(' ') | dbNameinfo.getName().equals("NetSync")) {
                this.jHotSync.resetSystem();
            }
            if (dbNameinfo.checkDatabaseFlag('\u0001')) {
                int i = 0;
                while (i < dbName1.getElements()) {
                    try {
                        DLPResource dlpresource = (DLPResource)dbName1.getElement(i);
                        this.jHotSync.writeResource(byte0, dlpresource.getResourceType(), dlpresource.getResourceID(), dlpresource.getData());
                    }
                    catch (Throwable ex) {
                        System.out.println("Unable to write database object! 1");
                        throw new ConduitHandlerException("Unable to write database object!", null);
                    }
                    ++i;
                }
            } else {
                int j = 0;
                while (j < dbName1.getElements()) {
                    try {
                        DLPRecord dlprecord = (DLPRecord)dbName1.getElement(j);
                        this.jHotSync.writeRecord(byte0, (byte)0, 0, dlprecord.getAttributes(), dlprecord.getCategory(), dlprecord.getData());
                    }
                    catch (Throwable ex) {
                        System.out.println("Unable to write database object! 2");
                        throw new ConduitHandlerException("Unable to write database object!", null);
                    }
                    ++j;
                }
            }
            this.jHotSync.closeDatabase(byte0);
        }
        catch (Throwable ex) {
            try {
                this.jHotSync.closeDatabase(byte0);
            }
            catch (Throwable ex2) {
                // empty catch block
            }
            System.out.println("Unable to write database object!");
            throw new ConduitHandlerException("Unable to write database object! 3", null);
        }
    }

    public int writeRecord(byte dbID, byte flags, int recordID, byte attributes, byte category, byte[] data) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.writeRecord(dbID, flags, recordID, attributes, category, data);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public int writeRecord(byte dbID, byte flags, DLPRecord record) throws ConduitHandlerException, NotConnectedException {
        try {
            return this.jHotSync.writeRecord(dbID, flags, record);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public void writeResource(byte dbID, int type, char resourceID, byte[] data) throws ConduitHandlerException, NotConnectedException {
        try {
            this.jHotSync.writeResource(dbID, type, resourceID, data);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public void writeResource(byte dbID, DLPResource resource) throws ConduitHandlerException, NotConnectedException {
        try {
            this.jHotSync.writeResource(dbID, resource);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public void writeSortBlock(byte dbID, DLPBlock sortBlock) throws ConduitHandlerException, NotConnectedException {
        try {
            this.jHotSync.writeSortBlock(dbID, sortBlock);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }

    public void writeSortBlock(byte dbID, byte[] sortBlock) throws ConduitHandlerException, NotConnectedException {
        try {
            this.jHotSync.writeSortBlock(dbID, sortBlock);
        }
        catch (DLPFunctionCallException e) {
            throw new ConduitHandlerException(e.toString(), e);
        }
    }
}

