/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.API.Conduit;

import org.jSyncManager.API.Conduit.AbstractConduit;
import org.jSyncManager.API.Conduit.ConduitHandler;
import org.jSyncManager.API.Conduit.ConduitHandlerException;
import org.jSyncManager.API.Protocol.NotConnectedException;
import org.jSyncManager.API.Protocol.Util.DLPDatabase;
import org.jSyncManager.API.Protocol.Util.DLPUserInfo;

public abstract class AbstractInstaller
extends AbstractConduit {
    protected abstract DLPDatabase[] getDatabaseList();

    protected abstract boolean isDatabaseInstallAllowed(DLPDatabase var1, ConduitHandler var2, DLPUserInfo var3);

    protected abstract void clearDatabaseList();

    protected abstract void installingDatabase(DLPDatabase var1, ConduitHandler var2);

    protected abstract void skippingDatabase(DLPDatabase var1, ConduitHandler var2);

    protected abstract void exceptionInstallingDatabase(DLPDatabase var1, ConduitHandler var2, ConduitHandlerException var3);

    public void startSync(ConduitHandler cHandler, DLPUserInfo user) throws NotConnectedException {
        DLPDatabase[] dbList = this.getDatabaseList();
        int i = 0;
        while (i < dbList.length) {
            if (dbList[i] != null && this.isDatabaseInstallAllowed(dbList[i], cHandler, user)) {
                try {
                    this.installingDatabase(dbList[i], cHandler);
                    cHandler.writeDatabase(dbList[i]);
                }
                catch (ConduitHandlerException e) {
                    this.exceptionInstallingDatabase(dbList[i], cHandler, e);
                }
            } else {
                this.skippingDatabase(dbList[i], cHandler);
            }
            ++i;
        }
        this.clearDatabaseList();
    }
}

