/*

@echo off
cls
echo.
echo This INSTALL routine requires OS/2 REXX support installed.
echo Run Selective Installation from the OS/2 Setup Folder to
echo install REXX support before attempting to run this CMD file.
pause
exit

       *-------------------------------------------------------------*
       |                                                             |
       |           JAVA MOVIE DATABASE OS/2 INSTALL SCRIPT           |
       |                                                             |
       |   INSTOS2.CMD - Install procedure for Java Movie Database   |
       |                                                             |
       |             (C)Copyright 1999-2010 Juergen Ulbts            |
       |             All Rights Reserved                             |
       |                                                             |
       *-------------------------------------------------------------*
*/

PARSE ARG arg '[' WarpIN ']'

'@echo off'

BootDrive             = ''
JMDBInstallPath       = directory()
JavaEXEString         = 'JAVA.EXE'
searchJavaString01    = 'JAVA'
JDKInstallPath        = ''
JMDBIcon              = JMDBInstallPath||'\graphics\jmdbos2.ico'
searchDBDriverString  = 'mysql-connector-java*.jar'  /* NEW drivers directly from MySQL AB */
DBDriver              = ''
ErrorCodeDB           = 0     /* ErrorCodes:  1=DB Driver not found,...     */
ErrorCodeJAVA         = 0     /* ErrorCodes: 11=Java not found,...  */

CopyrightLine1  = 'OS/2 Install script for the Java Movie Database (JMDB) V1.xx.xx'
CopyrightLine2  = '(C) Copyright 1999-2010 - Juergen Ulbts'
CopyrightLine3  = 'All Rights Reserved'
CopyrightLine4  = 'The Java Movie Database (JMDB) is a freeware program!!!'
CopyrightLine5  = 'The latest version can be found at: http://www.jmdb.de/'

/* Load REXXUTIL */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs


AvailDrives = SysDriveMap('C:', 'LOCAL')

/* Get boot drive letter */
done = 0
do while \ done
  IF WarpIN >< "WarpIN" then call ShowScriptCopyright
  BootDrive=GetBootDrive()
  done = 1
end

/* get the name of the dbDriver that has to be added to the startup script */
call getJavaVersionFromBootDrive
if ErrorCodeJAVA = 0 then
  if JDKInstallPath='' then ErrorCodeJAVA = 11

/* get the name of the dbDriver that has to be added to the startup script */
call getDBDriver

if ErrorCodeDB=0 then
  if DBDriver='' then ErrorCodeDB = 1

/* Check if this is an automatically called script... */
if WarpIN = "WarpIN" then do
   call CreateSTARTOS2CMD_NOOUTPUT
   EXIT
end /* do */




/* --------------- */
if ((ErrorCodeDB=0) & (ErrorCodeJAVA=0)) then
	do forever   /* main selection loop */
		call ShowScriptCopyright
		say 'Select one of the following:'
		say
		say '  0. Exit JMDB install'
		say '  1. Create Java Movie Database Desktop objects (incl startos2*.cmd)'
		say '  2. Create Java Movie Database "startos2*.cmd"'
		say
		say '  ESC to quit'
		say
		call charout, 'Press 0,1,2 or ESC: '
		do forever 
			k = translate(SysGetKey('NOECHO'))
			if k = '0' | k = D2C(27) then
				call InstallEnd
			else do
				if k = '1' then do
					call CreatePMJMDBObjects
					leave
				end
			
				if k = '2' then do
					call CreateSTARTOS2CMD
					leave
				end
			end
			call beep 1760, 50
		end 
	end /* do forever */
/* --------------- */

Select
   when ErrorCodeDB=1 then do
        say 'ERROR 1: Database driver ('||searchDBDriverString||') was not found!'
        say
        call PressAnyKey
        call InstallEnd
   end /* do */

   when ErrorCodeJRE=11 then do
        say 'ERROR 11: Java Runtime not found! You have to manually update the CMD file!'
        say
        call PressAnyKey
        call InstallEnd
   end /* do */
        
   otherwise
        call InstallEnd
end  /* select */




/* ===================================== */
/*  ADDITIONAL PROCEDURES AND FUNCTIONS  */
/* ===================================== */


/* Create PM JMDB Objects on Desktop */
CreatePMJMDBObjects:
  call ShowScriptCopyright
  say
  call CreateSTARTOS2CMD_NOOUTPUT

  if SysCreateObject("WPFolder","Java Movie Database","<WP_DESKTOP>", "OBJECTID=<JMDB_Folder>", "R") Then
    if SysCreateObject("WPProgram", "JMDB",               "<JMDB_Folder>",  "EXENAME="JMDBInstallPath"\STARTOS2.CMD;STARTUPDIR="JMDBInstallPath";ICONFILE="JMDBIcon, "R") then 
      if SysCreateObject("WPProgram", "JMDB-JavaDebug",    "<JMDB_Folder>",  "EXENAME="JMDBInstallPath"\STARTOS2DEBUG.CMD;STARTUPDIR="JMDBInstallPath";ICONFILE="JMDBIcon, "R") then 
        if SysCreateObject("WPProgram", "JMDB Readme", "<JMDB_Folder>", "EXENAME=e.exe;PARAMETERS=readme.txt;STARTUPDIR="JMDBInstallPath";", "R") then
          if SysCreateObject("WPProgram", "JMDB History", "<JMDB_Folder>", "EXENAME=e.exe;PARAMETERS=history.txt;STARTUPDIR="JMDBInstallPath";", "R") then
            if SysCreateObject("WPProgram", "JMDB Bugs", "<JMDB_Folder>", "EXENAME=e.exe;PARAMETERS=bugs.txt;STARTUPDIR="JMDBInstallPath";", "R") then
              if SysCreateObject("WPProgram", "JMDB Log", "<JMDB_Folder>", "EXENAME=epm.exe;PARAMETERS=jmdb.log;STARTUPDIR="JMDBInstallPath";", "R") then
                if SysCreateObject("WPUrl", "JMDB Help", "<JMDB_Folder>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=file:///"translate(translate(JMDBInstallPath||"/doc","|",":"), "/", "\")"/jmdbhelp.html;", "R")  then
                  if SysCreateObject("WPUrl", "JMDB FAQ", "<JMDB_Folder>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://www.jmdb.de/content/eng/faq/faq.html;", "R") then
                    if SysCreateObject("WPUrl", "JMDB HomePage", "<JMDB_Folder>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://www.jmdb.de;", "R") then
                    say 'All objects were created!'
                  Else say 'Failed to create JMDB FAQ URL object!'
                Else say 'Failed to create JMDB help URL object!'
              Else say 'Failed to create JMDB log object!'
            Else say 'Failed to create JMDB bugs object!'
          Else say 'Failed to create JMDB history object!'
        Else say 'Failed to create JMDB readme object!'
      Else say 'Failed to create JMDB-JavaDebug program object!'
    Else say 'Failed to create JMDB program object!'
  Else say 'Failed to create JMDB folder on the desktop! No other objects were created!'




  if SysCreateObject("WPFolder","Additional Links","<JMDB_Folder>", "OBJECTID=<JMDB_Links>", "R") Then
    if SysCreateObject("WPUrl", "IMDb Homepage", "<JMDB_Links>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://www.imdb.com/;", "R") then
      if SysCreateObject("WPUrl", "IMDb Interfaces", "<JMDB_Links>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://us.imdb.com/interfaces/;", "R") then
        if SysCreateObject("WPUrl", "IMDb Help/FAQ", "<JMDB_Links>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://us.imdb.com/help/;", "R") then
          if SysCreateObject("WPUrl", "MySQL Homepage", "<JMDB_Links>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://www.mysql.com/;", "R") then
            if SysCreateObject("WPUrl", "PostgreSQL Homepage", "<JMDB_Links>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://www.postgresql.org/;", "R") then
              if SysCreateObject("WPUrl", "PostgreSQL JDBC Driver Homepage", "<JMDB_Links>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://jdbc.postgresql.org/;", "R") then
                if SysCreateObject("WPUrl", "PostgreSQL for OS/2 and eCS from Hobbes", "<JMDB_Links>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://hobbes.nmsu.edu/cgi-bin/h-search?key=postgres;", "R") then
                  if SysCreateObject("WPUrl", "PostgreSQL/MySQL from Paul Smedley", "<JMDB_Links>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://www.smedley.info/os2ports/index.html;", "R") then
                    if SysCreateObject("WPUrl", "MySQL/2 Yuri Dario's Homepage", "<JMDB_Links>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://www.os2power.com/yuri/mysql2/;", "R") then
                      if SysCreateObject("WPUrl", "GZIP V1.2.4 from Hobbes", "<JMDB_Links>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://hobbes.nmsu.edu/cgi-bin/h-search?key=gz124_16.zip;", "R") then
                        if SysCreateObject("WPUrl", "MySQL JDBC Driver Homepage", "<JMDB_Links>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://dev.mysql.com/downloads/connector/j/;", "R") then
                        say 'All additional LINKS were created!'
                      Else say 'Failed to create GZIP V1.2.4 from Hobbes URL object!'
                    Else say "Failed to create MySQL/2 Yuri Dario's homepage URL object!"
                  Else say 'Failed to create PostgreSQL/MySQL from Paul Smedley URL object!'
                Else say 'Failed to create PostgreSQL from Hobbes URL object!'
              Else say 'Failed to create PostgreSQL JDBC driver download URL object!'
            Else say 'Failed to create PostgreSQL Homepage URL object!'
          Else say 'Failed to create MySQL Homepage URL object!'
        Else say 'Failed to create IMDb FAQ URL object!'
      Else say 'Failed to create IMDb Interfaces URL object!'
    Else say 'Failed to create IMDb Homepage URL object!'
  Else say 'Failed to create additional LINKS folder on the desktop! No additional URL objects were created!'

  call PressAnyKey
  return




/* Create startos2.cmd */
CreateSTARTOS2CMD:
  call ShowScriptCopyright
  say
  startfile = 'startos2.cmd'
  '@del 'startfile' >nul 2>>&1'
  rc = lineout(startfile, "@ECHO OFF")
  rc = lineout(startfile, "REM You may have to add the path to the Java1xx runtime ('x:\java1xx\bin\jre\java.exe -cp ...') and maybe also the correct JDBC driver!")
  rc = lineout(startfile, JDKInstallPath||"JAVAW.EXE -Xmx400M -cp .;JMDB.jar;postgresql-8.4-701.jdbc3.jar;"||DBDriver||";.\plugins\export\itext-1.4.3.jar jmdb.base.JMDBMain")
  say 'STARTOS2.CMD created.'

  startfile = 'startos2debug.cmd'
  '@del 'startfile' >nul 2>>&1'
  rc = lineout(startfile, "@ECHO OFF")
  rc = lineout(startfile, "REM You may have to add the path to the Java1xx runtime ('x:\java1xx\bin\jre\java.exe -cp ...') and maybe also the correct JDBC driver!")
  rc = lineout(startfile, JDKInstallPath||"JAVA.EXE -Xmx400M -cp .;JMDB.jar;postgresql-8.4-701.jdbc3.jar;"||DBDriver||";.\plugins\export\itext-1.4.3.jar jmdb.base.JMDBMain")
  say 'STARTOS2DEBUG.CMD created.'

  call PressAnyKey
  return


/* Create startos2.cmd without screen output */
CreateSTARTOS2CMD_NOOUTPUT:
  startfile = 'startos2.cmd'
  '@del 'startfile' >nul 2>>&1'
  rc = lineout(startfile, "@ECHO OFF" )
  rc = lineout(startfile, "REM You may have to add the path to the Java1xx runtime ('x:\java1xx\bin\jre\java.exe -cp ...') and maybe also the correct JDBC driver!")
  rc = lineout(startfile, JDKInstallPath||"JAVAW.EXE -Xmx400M -cp .;JMDB.jar;postgresql-8.4-701.jdbc3.jar;"||DBDriver||";.\plugins\export\itext-1.4.3.jar jmdb.base.JMDBMain")
  
  startfile = 'startos2debug.cmd'
  '@del 'startfile' >nul 2>>&1'
  rc = lineout(startfile, "@ECHO OFF" )
  rc = lineout(startfile, "REM You may have to add the path to the Java1xx runtime ('x:\java1xx\bin\jre\java.exe -cp ...') and maybe also the correct JDBC driver!")
  rc = lineout(startfile, JDKInstallPath||"JAVA.EXE -Xmx400M -cp .;JMDB.jar;postgresql-8.4-701.jdbc3.jar;"||DBDriver||";.\plugins\export\itext-1.4.3.jar jmdb.base.JMDBMain")
  return


/* Show script copyright notice */
ShowScriptCopyright:
  call SysCls
  say
  say
  say CopyrightLine1
  say CopyrightLine2
  say CopyrightLine3
  say
  say CopyrightLine4
  say CopyrightLine5
  say
  say
  return


/* Get installed JAVA version from the BootDrive */
getJavaVersionFromBootDrive:
   rc = SysFileTree(BootDrive||'\'||searchJavaString01||'*', 'javaSysFileDir', 'DO')
   do jreCounter=javaSysFileDir.0 to 1 by -1
      PARSE UPPER VAR javaSysFileDir.jreCounter javaStr 

/* say 'JAVA Verzeichnis: '||javaStr */

      /* Start - Search in Directory for JAVA.EXE file... */
      rc = SysFileTree(javaStr||'\BIN\'||JavaEXEString, 'javaEXESysFileDir', 'FSO')
      do jreCounterEXE=1 to javaEXESysFileDir.0
         PARSE UPPER VAR javaEXESysFileDir.jreCounterEXE JDKInstallPath 'JAVA.EXE'
      end /* do - javaEXESysFileDir */

      if javaEXEPath='' then do
         rc = SysFileTree(javaStr||'\JRE\'||JavaEXEString, 'javaEXESysFileDir', 'FSO')
         do jreCounterEXE=1 to javaEXESysFileDir.0
            PARSE UPPER VAR javaEXESysFileDir.jreCounterEXE JDKInstallPath 'JAVA.EXE'
         end   /* do - javaEXESysFileDir */
      end /* do - if then */
      /* End - Search in Directory for JAVA.EXE file... */
      
/* say 'Java EXE Path: '||JDKInstallPath */

      if JDKInstallPath><'' then LEAVE
      
   end /* do - javaSysFileDir - Search for x:\JAVA* directories */

  return JDKInstallPath
/* END GetJavaVersionFromBootDrive*/



/* Get DBDriver from current directory and return only the name of the driver (strip path) */
getDBDriver:
  DBDRV_LATEST = 0
  /* search for old drivers (versionnumber one character long) */
  call SysFileTree searchDBDriverString, 'fileArray', 'FO'	/* get filename mask from current dir */
  do i=1 to fileArray.0
     DBDriver = SUBSTR(fileArray.i, LASTPOS('\',fileArray.i)+1,LENGTH(fileArray.i)-LASTPOS('\',fileArray.i)) 
     PARSE Var DBDriver  DBDRV_start1 '-' DBDRV_start2 '-' DBDRV_start3 '-' DBDRV_ver '.' DBDRV_rev1 '.' DBDRV_rev2 '-' DBDRV_rest
     DBDRV_Version = RIGHT(DBDRV_ver,2,0) || RIGHT(DBDRV_rev1,2,0) || RIGHT(DBDRV_rev2,2,0)
     IF DBDRV_Version > DBDRV_Latest then DBDRV_Latest = DBDRV_Version
  end /* do */

/*  SAY "Latest MySQL DB-driver version found: "||DBDRV_Latest  */

  call SysFileTree searchDBDriverString, 'fileArray', 'FO'	/* get filename mask from current dir */
  do i=1 to fileArray.0
     /* save (latest) DBDriverName found in DBDriver strip the path and return the filename */
     DBDriver = SUBSTR(fileArray.i, LASTPOS('\',fileArray.i)+1,LENGTH(fileArray.i)-LASTPOS('\',fileArray.i)) 
     PARSE Var DBDriver  DBDRV_start1 '-' DBDRV_start2 '-' DBDRV_start3 '-' DBDRV_ver '.' DBDRV_rev1 '.' DBDRV_rev2 '-' DBDRV_rest
     DBDRV_Version = RIGHT(DBDRV_ver,2,0) || RIGHT(DBDRV_rev1,2,0) || RIGHT(DBDRV_rev2,2,0)
     if DBDRV_Version = DBDRV_Latest then leave
  end /* do */
  return DBDriver 
/* END GetDBDriver*/



/* Wait for a key press */
PressAnyKey:
  call charout, 'Press any key to continue...'
  call SysGetKey 'NOECHO'
  return



/* Get path from user */
GetPath:
  call charout, '> '
  parse pull APath
  len = length(APath)
  if len > 0 then
    if substr(APath, len, 1) = '\' then
      APath = substr(APath, 1, len-1)
  return APath




/*
GetBootDrive
   Use SysBootDrive (RexxUtils) if it is available, use RxBootDrive
   (RxExtras) if it is available, or use an alternate method to get the
   value if neither is available.  Uncomment following if GetBootDrive
   is imbedded in a routine.
*/

/* Get Bootdrive */
GetBootDrive: Procedure
If \Rxfuncquery('SysBootDrive') Then
   bootdrive = SysBootDrive()       /* Object or Updated Classic Rexx */
Else
   Do
      If \Rxfuncquery('RxBootDrive') Then
         bootdrive = RxBootDrive()                        /* RxExtras */
      Else
         Do                       /* Examine various config.sys items */
            Parse Upper Value Value('PATH', ,'OS2ENVIRONMENT') ,
               With ':\OS2\SYSTEM' - 1 bootdrive + 2
            If bootdrive = '' Then
               bootdrive = ,
               Substr(Value('RUNWORKPLACE', ,'OS2ENVIRONMENT'), 1, 2 )
            If bootdrive = '' Then
               bootdrive = ,
               Substr(Value('COMSPEC', ,'OS2ENVIRONMENT'), 1, 2)
            If bootdrive = '' Then
               bootdrive = ,
               Substr(Value('OS2_SHELL', ,'OS2ENVIRONMENT'), 1, 2)
            If bootdrive = '' Then
               bootdrive = ,
               Substr(Value('SYSTEM_INI', ,'OS2ENVIRONMENT'), 1, 2)
            If bootdrive = '' Then
               bootdrive = ,
               Substr(Value('USER_INI', ,'OS2ENVIRONMENT'), 1, 2)
            If bootdrive = '' Then                      /* no guesses */
               bootdrive = 0
         End
   End
Return bootdrive               /* Returns BootDrive, letter and colon */



/* End message */
InstallEnd:
  call SysCls
  say
  say
  say 'Java Movie Database INSTALL ended.'
  exit

