/*
 * Decompiled with CFR 0.152.
 */
package net.sf.libgrowl;

import java.util.ArrayList;
import net.sf.libgrowl.Application;
import net.sf.libgrowl.Notification;
import net.sf.libgrowl.NotificationType;
import net.sf.libgrowl.internal.NotifyMessage;
import net.sf.libgrowl.internal.RegisterMessage;

public class GrowlConnector {
    private String mHost;
    private int mPort;
    private ArrayList<NotificationType> mRegisteredNotifications = new ArrayList();

    public GrowlConnector() {
        this("localhost");
    }

    public GrowlConnector(String host) {
        this(host, 23053);
    }

    public GrowlConnector(String host, int port) {
        this.mHost = host;
        this.mPort = port;
    }

    public final int register(Application application, NotificationType[] notificationTypes) {
        RegisterMessage message = new RegisterMessage(application, notificationTypes);
        int result = message.send(this.mHost, this.mPort);
        if (result == 0) {
            this.setNotificationsRegistered(notificationTypes);
        }
        return result;
    }

    private void setNotificationsRegistered(NotificationType[] notificationTypes) {
        NotificationType[] notificationTypeArray = notificationTypes;
        int n = notificationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            NotificationType notificationType = notificationTypeArray[n2];
            this.mRegisteredNotifications.add(notificationType);
            ++n2;
        }
    }

    public final int notify(Notification notification) {
        if (!this.isRegistered(notification.getNotificationType())) {
            System.err.println("You need to register the notification type " + notification.getNotificationType().getDisplayName() + " before using it in notifications.");
        }
        NotifyMessage message = new NotifyMessage(notification);
        return message.send(this.mHost, this.mPort);
    }

    private boolean isRegistered(NotificationType notificationType) {
        return this.mRegisteredNotifications.contains(notificationType);
    }

    public static void main(String[] args) {
        String host = args[0];
        String appName = args[1];
        String notificationName = args[2];
        String title = args[3];
        String message = args[4];
        GrowlConnector growl = new GrowlConnector(host);
        Application application = new Application(appName);
        NotificationType notificationType = new NotificationType(notificationName);
        NotificationType[] notificationTypes = new NotificationType[]{notificationType};
        growl.register(application, notificationTypes);
        Notification notification = new Notification(application, notificationType, title, message);
        growl.notify(notification);
    }
}

