/*
 * Decompiled with CFR 0.152.
 */
package jmdb.util;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jmdb.util.MessageText;

public class PDFExport
extends MessageText {
    private Document document;
    private Paragraph paragraph;

    public boolean addNewPageToDocument() {
        boolean bl = false;
        if (this.getDocument() != null && this.getParagraph() != null) {
            try {
                if (!this.getDocument().isOpen()) {
                    this.getDocument().open();
                }
                this.getDocument().newPage();
                bl = true;
            }
            catch (DocumentException documentException) {
                System.err.println(documentException.getMessage());
            }
        }
        return bl;
    }

    public boolean addParagraphToDocument() {
        boolean bl = false;
        if (this.getDocument() != null && this.getParagraph() != null) {
            try {
                if (!this.getDocument().isOpen()) {
                    this.getDocument().open();
                }
                this.getDocument().add((Element)this.getParagraph());
                bl = true;
            }
            catch (DocumentException documentException) {
                System.err.println(documentException.getMessage());
            }
        }
        return bl;
    }

    public boolean addPhraseToParagraph(String string) {
        boolean bl = false;
        if (this.getParagraph() != null && string != null) {
            this.getParagraph().add((Object)new Phrase(string));
            bl = true;
        }
        return bl;
    }

    public boolean addPhraseToParagraph(String string, Font font) {
        boolean bl = false;
        if (this.getParagraph() != null && string != null && font != null) {
            this.getParagraph().add((Object)new Phrase(string, font));
            bl = true;
        }
        return bl;
    }

    public boolean closeDocument() {
        boolean bl = false;
        if (this.getDocument() != null) {
            if (this.getDocument().isOpen()) {
                this.getDocument().close();
            }
            bl = true;
        }
        return bl;
    }

    public boolean createDocument(String string) throws ClassNotFoundException {
        boolean bl = false;
        this.setDocument(new Document());
        try {
            try {
                PdfWriter.getInstance((Document)this.getDocument(), (OutputStream)new FileOutputStream(string));
                this.getDocument().open();
                bl = true;
            }
            catch (DocumentException documentException) {
                System.err.println("DocumentException in PDFExport.createDocument(): " + (Object)((Object)documentException));
            }
            catch (IOException iOException) {
                System.err.println("IOException in PDFExport.createDocument(): " + iOException);
            }
            catch (Exception exception) {
                System.err.println("Exception :" + exception);
            }
        }
        catch (Throwable throwable) {}
        return bl;
    }

    public boolean createNewParagraph(String string) {
        boolean bl = false;
        if (this.getDocument() != null && string != null) {
            this.setParagraph(new Paragraph(string));
            bl = true;
        }
        return bl;
    }

    public boolean createNewParagraph(String string, Font font) {
        boolean bl = false;
        if (this.getDocument() != null && string != null && font != null) {
            this.setParagraph(new Paragraph(string));
            bl = true;
        }
        return bl;
    }

    private Document getDocument() {
        return this.document;
    }

    private Paragraph getParagraph() {
        return this.paragraph;
    }

    private void setDocument(Document document) {
        this.document = document;
    }

    private void setParagraph(Paragraph paragraph) {
        this.paragraph = paragraph;
    }
}

