/*
 * Decompiled with CFR 0.152.
 */
package jmdb.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import jmdb.base.JMDBMain;
import jmdb.database.DataBaseConverter2Thread;
import jmdb.util.SortableArray;
import jmdb.util.SortableArrayHeapSorter;

public class MovieArray
implements SortableArray {
    private int count;
    private int maxCount;
    private String[] title;
    private String tmpTitle;
    private String[] year;
    private String tmpYear;
    private String[] imdbId;
    private String tmpImdbId;

    public MovieArray(int n) {
        this.maxCount = n;
        this.title = new String[n];
        this.year = new String[n];
        this.imdbId = new String[n];
        this.count = 0;
    }

    public void add(String string, String string2) {
        this.title[this.count] = new String(string);
        this.year[this.count] = new String(string2);
        ++this.count;
    }

    public void addIMDbId(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        int n = this.getMovieid(string);
        if (n != -1) {
            this.imdbId[n - 1] = string2;
        }
    }

    public void check() {
        JMDBMain.myJMDBMain.log("Checking movieArray from 0 to " + this.count);
        JMDBMain.myJMDBMain.log("Checking NULL strings...");
        int n = 0;
        while (n < this.count) {
            if (this.title[n] == null) {
                JMDBMain.myJMDBMain.log("Title " + n + " is NULL!");
            }
            ++n;
        }
        JMDBMain.myJMDBMain.log("Checking double entries...");
        n = 1;
        while (n < this.count) {
            if (this.title[n - 1].equals(this.title[n])) {
                JMDBMain.myJMDBMain.log("Same entry!");
                JMDBMain.myJMDBMain.log("Title " + (n - 1) + " = " + this.title[n - 1]);
                JMDBMain.myJMDBMain.log("Title " + n + " = " + this.title[n]);
            }
            ++n;
        }
        JMDBMain.myJMDBMain.log("Checking if it can find all entries...");
        int n2 = 1;
        while (n2 <= this.count) {
            String string = this.getTitle(n2);
            int n3 = this.getMovieid(string);
            if (n3 == -1) {
                JMDBMain.myJMDBMain.log("ERROR: index=" + n2 + " getTitle=" + string);
            }
            if (n3 != n2) {
                JMDBMain.myJMDBMain.log("ERROR: index of found movie not the same: " + n2 + ", " + n3);
            }
            ++n2;
        }
        JMDBMain.myJMDBMain.log("Checking movieArray finished.");
    }

    public int compare(int n, int n2) {
        return this.title[n].compareTo(this.title[n2]);
    }

    public int compareTmp(int n) {
        return this.tmpTitle.compareTo(this.title[n]);
    }

    public void copy(int n, int n2) {
        this.year[n2] = this.year[n];
        this.title[n2] = this.title[n];
        this.imdbId[n2] = this.imdbId[n];
    }

    public void deletelogErrorsIMDb() {
        File file = new File(System.getProperty("user.dir"));
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isFile() && fileArray[n].getName().equals("IMDb_Error.log")) {
                fileArray[n].delete();
                break;
            }
            ++n;
        }
        MovieArray.logErrorsIMDb("This is a list of errors that were found while converting the IMDb files!\nThese are not errors of the Java Movie Database, but errors in the IMDb text files!\nThe error log doesn't use the same encoding as the original IMDb files!\nThis file was created " + new Date().toString() + "!\n===============================================================================");
    }

    public String getImdbId(int n) {
        return this.imdbId[n - 1];
    }

    public int getMovieid(String string) {
        int n;
        int n2 = 0;
        int n3 = this.count - 1;
        do {
            if (string.compareTo(this.title[n = (n2 + n3) / 2]) < 0) {
                n3 = n - 1;
                continue;
            }
            n2 = n + 1;
        } while (n2 <= n3 && !string.equals(this.title[n]));
        if (string.equals(this.title[n])) {
            return n + 1;
        }
        MovieArray.logErrorsIMDb("Title " + string + " not found. - Request from: " + DataBaseConverter2Thread.getImportFile().getFileName());
        return -1;
    }

    public String getTitle(int n) {
        return this.title[n - 1];
    }

    public void getTmp(int n) {
        this.year[n] = this.tmpYear;
        this.title[n] = this.tmpTitle;
        this.imdbId[n] = this.tmpImdbId;
    }

    public String getTmpString() {
        return this.tmpTitle;
    }

    public String getYear(int n) {
        return this.year[n - 1];
    }

    public void interchange(int n, int n2) {
        String string = this.year[n];
        this.year[n] = this.year[n2];
        this.year[n2] = string;
        string = this.title[n];
        this.title[n] = this.title[n2];
        this.title[n2] = string;
        string = this.imdbId[n];
        this.imdbId[n] = this.imdbId[n2];
        this.imdbId[n2] = string;
    }

    public static void logErrorsIMDb(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("IMDb_Error.log", true)));
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("IOException in jmdb.util.MovieArray.logErrorIMDb(): " + iOException);
        }
    }

    public void setTmp(int n) {
        this.tmpTitle = this.title[n];
        this.tmpYear = this.year[n];
        this.tmpImdbId = this.imdbId[n];
    }

    public void sort() {
        new SortableArrayHeapSorter().sort(this, this.count - 1);
    }
}

