/*
 * Decompiled with CFR 0.152.
 */
package jmdb.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class MessageText {
    private static final String BUNDLE_NAME = "languages/MessagesBundle";
    private static ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("languages/MessagesBundle");
    public static Locale LOCALE_ENGLISH = new Locale("en", "EN");
    public static Locale LOCALE_DEFAULT = new Locale("", "");

    public static boolean changeLocale(Locale locale) {
        if (LOCALE_ENGLISH.equals(locale)) {
            locale = LOCALE_DEFAULT;
        }
        if (!locale.equals(RESOURCE_BUNDLE.getLocale())) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, locale);
            if (resourceBundle.getLocale().equals(locale)) {
                RESOURCE_BUNDLE = resourceBundle;
                Locale.setDefault(locale);
                return true;
            }
            System.out.println("Messages: no message properties for Locale " + locale.getDisplayLanguage());
        }
        return false;
    }

    public static Locale getCurrentLocale() {
        Locale locale = RESOURCE_BUNDLE.getLocale();
        if (LOCALE_DEFAULT.equals(locale)) {
            locale = LOCALE_ENGLISH;
        }
        System.out.println("jmdb.util.MessageText.getCurrentLocale(): " + locale);
        return locale;
    }

    public static Locale[] getLocales() {
        Object object;
        String string = BUNDLE_NAME.replace('.', '/');
        final String string2 = BUNDLE_NAME.substring(BUNDLE_NAME.lastIndexOf(46) + 1);
        String string3 = ClassLoader.getSystemResource(string.concat(".properties")).toString();
        String[] stringArray = null;
        if (string3.startsWith("jar:file:/")) {
            try {
                int n = string3.indexOf(".jar!");
                String string4 = string3.substring(4, n + 4);
                System.out.println("jarName: " + string4);
                object = new JarFile(string4);
                Enumeration<JarEntry> enumeration = ((JarFile)object).entries();
                ArrayList<String> arrayList = new ArrayList<String>(250);
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    if (!jarEntry.getName().startsWith(string) || !jarEntry.getName().endsWith(".properties") || jarEntry.getName().length() >= string.length() + ".properties".length() + 7) continue;
                    arrayList.add(jarEntry.getName().substring(string.length() - string2.length()));
                }
                stringArray = arrayList.toArray(new String[arrayList.size()]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            File file = new File(string3).getParentFile();
            System.out.println("bundleDirectory: " + file.getAbsolutePath());
            stringArray = file.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.startsWith(string2) && string.endsWith(".properties");
                }
            });
        }
        Locale[] localeArray = new Locale[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n].substring(string2.length(), stringArray[n].length() - ".properties".length());
            localeArray[n] = ((String)object).length() == 0 ? LOCALE_ENGLISH : new Locale(((String)object).substring(1, 3), ((String)object).substring(4, 6));
            ++n;
        }
        return localeArray;
    }

    public static String getString(String string) {
        try {
            return RESOURCE_BUNDLE.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + string + '!';
        }
    }

    public static boolean isCurrentLocale(Locale locale) {
        if (LOCALE_ENGLISH.equals(locale)) {
            locale = LOCALE_DEFAULT;
        }
        return RESOURCE_BUNDLE.getLocale().equals(locale);
    }
}

