/*
 * Decompiled with CFR 0.152.
 */
package jmdb.util;

import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import jmdb.base.JMDBMain;

public class LookAndFeelManager {
    private static int lookAndFeelRecursiveCounter = 0;
    private static URLClassLoader urlClassLoader = null;

    public LookAndFeelManager(String string) {
        try {
            System.getProperty("path.separator");
            File file = new File(string);
            File[] fileArray = null;
            URL[] uRLArray = null;
            if (file.isDirectory() && (fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().toLowerCase().endsWith(".jar");
                }

                public String getDescription() {
                    return "JAVA-JAR(*.jar)";
                }
            })) != null && fileArray.length > 0) {
                uRLArray = new URL[fileArray.length];
                int n = 0;
                while (n < fileArray.length) {
                    uRLArray[n] = fileArray[n].toURL();
                    ++n;
                }
                urlClassLoader = new URLClassLoader(uRLArray);
            }
            fileArray = null;
            file = null;
            uRLArray = null;
        }
        catch (MalformedURLException malformedURLException) {
            JMDBMain.myJMDBMain.log("LookAndFeelManager.LookAndFeelManager(String): " + malformedURLException);
        }
    }

    public void addExternalLookAndFeels() {
        try {
            this.addJGoddiesLooks();
        }
        catch (NullPointerException nullPointerException) {}
        try {
            this.addLipstik();
        }
        catch (NullPointerException nullPointerException) {}
        try {
            this.addSubstance();
        }
        catch (NullPointerException nullPointerException) {}
        try {
            this.addTonic();
        }
        catch (NullPointerException nullPointerException) {}
        try {
            this.addNimROD();
        }
        catch (NullPointerException nullPointerException) {}
        try {
            this.addQuaqua();
        }
        catch (NullPointerException nullPointerException) {}
    }

    private void addJGoddiesLooks() {
        try {
            Class.forName("com.jgoodies.looks.windows.WindowsLookAndFeel", true, urlClassLoader);
            UIManager.installLookAndFeel("JGoodies Windows", "com.jgoodies.looks.windows.WindowsLookAndFeel");
            UIManager.installLookAndFeel("JGoodies Plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
            UIManager.installLookAndFeel("JGoodies Plastic 3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
            UIManager.installLookAndFeel("JGoodies Plastic XP", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            JMDBMain.myJMDBMain.log("Info - LookAndFeelManager.addJGoodiesLooks(): Could not add JGoodies Looks as it isn't supported with this version of the Java Runtime! " + unsupportedClassVersionError);
        }
    }

    private void addLipstik() {
        try {
            Class.forName("com.lipstikLF.LipstikLookAndFeel", true, urlClassLoader);
            UIManager.installLookAndFeel("Lipstik", "com.lipstikLF.LipstikLookAndFeel");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            JMDBMain.myJMDBMain.log("Info - LookAndFeelManager.addLipstik(): Could not add Lipstik as it isn't supported with this version of the Java Runtime! " + unsupportedClassVersionError);
        }
    }

    private void addNimROD() {
        try {
            Class.forName("com.nilo.plaf.nimrod.NimRODLookAndFeel", true, urlClassLoader);
            UIManager.installLookAndFeel("NimROD", "com.nilo.plaf.nimrod.NimRODLookAndFeel");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            JMDBMain.myJMDBMain.log("Info - LookAndFeelManager.addNimROD(): Could not add NimROD as it isn't supported with this version of the Java Runtime! " + unsupportedClassVersionError);
        }
    }

    private void addQuaqua() {
        try {
            Class.forName("ch.randelshofer.quaqua.QuaquaLookAndFeel", true, urlClassLoader);
            UIManager.installLookAndFeel("Quaqua", "ch.randelshofer.quaqua.QuaquaLookAndFeel");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            JMDBMain.myJMDBMain.log("Info - LookAndFeelManager.addQuaqua(): Could not add Quaqua as it isn't supported with this version of the Java Runtime! " + unsupportedClassVersionError);
        }
    }

    private void addSubstance() {
        try {
            Class.forName("org.jvnet.substance.SubstanceLookAndFeel", true, urlClassLoader);
            UIManager.installLookAndFeel("Substance", "org.jvnet.substance.SubstanceLookAndFeel");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            JMDBMain.myJMDBMain.log("Info - LookAndFeelManager.addSubstance(): Could not add Substance as it isn't supported with this version of the Java Runtime! " + unsupportedClassVersionError);
        }
    }

    private void addSynthetica() {
        try {
            Class.forName("de.javasoft.plaf.synthetica.SyntheticaStandardLookAndFeel", true, urlClassLoader);
            UIManager.installLookAndFeel("Synthetica Standard", "de.javasoft.plaf.synthetica.SyntheticaStandardLookAndFeel");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            JMDBMain.myJMDBMain.log("Info - LookAndFeelManager.addSynthetica(): Could not add Synthetica as it isn't supported with this version of the Java Runtime! " + unsupportedClassVersionError);
        }
    }

    private void addTonic() {
        try {
            Class.forName("com.digitprop.tonic.TonicLookAndFeel", true, urlClassLoader);
            UIManager.installLookAndFeel("Tonic", "com.digitprop.tonic.TonicLookAndFeel");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            JMDBMain.myJMDBMain.log("Info - LookAndFeelManager.addTonic(): Could not add Tonic as it isn't supported with this version of the Java Runtime! " + unsupportedClassVersionError);
        }
    }

    public String getLookAndFeel() {
        return UIManager.getLookAndFeel().getClass().getName();
    }

    public void setLookAndFeel(String string, Component component) {
        try {
            ++lookAndFeelRecursiveCounter;
            Class<?> clazz = Class.forName(string, true, urlClassLoader);
            UIManager.getDefaults().put("ClassLoader", urlClassLoader);
            UIManager.setLookAndFeel((LookAndFeel)clazz.newInstance());
            SwingUtilities.updateComponentTreeUI(component);
            lookAndFeelRecursiveCounter = 0;
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            if (lookAndFeelRecursiveCounter < 2) {
                this.setLookAndFeel(UIManager.getSystemLookAndFeelClassName(), component);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("IllegalAccessException in jmdb.util.LookAndFeelManager.setLookAndFeel(String) - LookAndFeel: " + illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ClassNotFoundException in jmdb.util.LookAndFeelManager.setLookAndFeel(String) - LookAndFeel: " + classNotFoundException);
        }
        catch (Exception exception) {
            System.out.println("Exception in jmdb.util.LookAndFeelManager.setLookAndFeel(String) - LookAndFeel: " + exception);
        }
    }
}

