/*
 * Decompiled with CFR 0.152.
 */
package jmdb.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmdb.base.JMDBMain;
import jmdb.base.JMDBSetup;
import jmdb.database.DataBaseConverter2;
import jmdb.sortabletable.SortButtonRenderer;
import jmdb.sortabletable.SortableTableModel2;
import jmdb.util.ImportFile;
import jmdb.util.ImportHelper;

public class ImportSelectionTableThread
extends Thread {
    private JTable myTable;
    private JMDBSetup myJMDBSetup = null;
    private SortButtonRenderer sortButtonRenderer;
    private TableColumnModel tableColumnModel;
    private JTextField myImportFileTextField;
    public ImportHelper myImportHelper = null;
    private static ResourceBundle resMessagesBundle = ResourceBundle.getBundle("languages/MessagesBundle");
    private static String headerId = resMessagesBundle.getString("JMDBSetup.tableheader.id");
    private static String headerFilename = resMessagesBundle.getString("JMDBSetup.tableheader.filename");
    private static String headerFilecheck = resMessagesBundle.getString("JMDBSetup.tableheader.filecheck");
    private static String headerRequired = resMessagesBundle.getString("JMDBSetup.tableheader.required");
    private static String headerImport = resMessagesBundle.getString("JMDBSetup.tableheader.import");
    private static String fileNotFoundMessage = resMessagesBundle.getString("JMDB.label.filenotfound").toUpperCase();
    private static String fileOkMessage = resMessagesBundle.getString("JMDB.label.fileok").toUpperCase();
    private static String fileUnableToCheckMessage = resMessagesBundle.getString("JMDB.label.fileunabletocheckafs").toUpperCase();

    public ImportSelectionTableThread(JMDBSetup jMDBSetup, JTable jTable, JTextField jTextField, ImportHelper importHelper) {
        this.myJMDBSetup = jMDBSetup;
        this.myTable = jTable;
        this.myImportFileTextField = jTextField;
        this.myImportHelper = importHelper;
    }

    private void addData() {
        SortableTableModel2 sortableTableModel2 = (SortableTableModel2)this.myTable.getModel();
        String string = this.getImportFilePath();
        if (this.myImportHelper != null) {
            ImportHelper importHelper = this.myImportHelper;
            this.myImportHelper.getImportFileList();
            Object[] objectArray = null;
            Enumeration enumeration = importHelper.getImportFileList().elements();
            while (enumeration.hasMoreElements()) {
                objectArray = new Object[5];
                ImportFile importFile = (ImportFile)enumeration.nextElement();
                objectArray[0] = new Integer(importFile.getFileId());
                objectArray[1] = importFile.getFileName();
                objectArray[2] = JMDBMain.myJMDBMain != null ? this.checkFileExistence(String.valueOf(string) + objectArray[1].toString()) : fileUnableToCheckMessage;
                objectArray[3] = new Boolean(importFile.isFileRequired());
                objectArray[4] = new Boolean(JMDBMain.getCfgDeselectedImportFiles().indexOf(";" + objectArray[1].toString() + ";") < 0 && JMDBMain.getCfgDeselectedImportFiles().indexOf(String.valueOf(objectArray[1].toString()) + ";") != 0);
                sortableTableModel2.addRow(objectArray);
            }
        }
    }

    private String checkFileExistence(String string) {
        String string2 = fileNotFoundMessage;
        if (new File(String.valueOf(string) + ".list.gz").exists()) {
            string2 = fileOkMessage;
        } else if (new File(String.valueOf(string) + ".list").exists()) {
            string2 = fileOkMessage;
        }
        return string2;
    }

    private Color getColor(String string) {
        if (string.equals("black")) {
            return Color.black;
        }
        if (string.equals("blue")) {
            return Color.blue;
        }
        if (string.equals("cyan")) {
            return Color.cyan;
        }
        if (string.equals("darkGray")) {
            return Color.darkGray;
        }
        if (string.equals("gray")) {
            return Color.gray;
        }
        if (string.equals("green")) {
            return Color.green;
        }
        if (string.equals("lightGray")) {
            return Color.lightGray;
        }
        if (string.equals("magenta")) {
            return Color.magenta;
        }
        if (string.equals("orange")) {
            return Color.orange;
        }
        if (string.equals("pink")) {
            return Color.pink;
        }
        if (string.equals("red")) {
            return Color.red;
        }
        if (string.equals("white")) {
            return Color.white;
        }
        if (string.equals("yellow")) {
            return Color.yellow;
        }
        return Color.decode(string);
    }

    private String getImportFilePath() {
        String string = "";
        if (this.myTable != null) {
            string = this.myImportFileTextField.getText();
            if (string.length() <= 0) {
                string = DataBaseConverter2.getCfgImportPath();
            }
            return string;
        }
        return DataBaseConverter2.getCfgImportPath();
    }

    private SortButtonRenderer getSortButtonRenderer() {
        return this.sortButtonRenderer;
    }

    private TableColumnModel getTableColumnModel() {
        return this.tableColumnModel;
    }

    public void run() {
        this.setupTable();
        this.addData();
        ((SortableTableModel2)this.myTable.getModel()).setSortEnabled(true);
    }

    private void setColumn(int n, int n2, int n3, int n4, String string, String string2) {
        TableColumn tableColumn = this.myTable.getColumnModel().getColumn(n);
        tableColumn.setHeaderValue(string);
        tableColumn.setHeaderRenderer(this.getSortButtonRenderer());
        if (n2 > 0) {
            tableColumn.setMinWidth(n2);
        }
        if (n4 > 0) {
            tableColumn.setMaxWidth(n4);
        }
        if (n3 > 0) {
            tableColumn.setPreferredWidth(n3);
        }
        if (n3 > 0) {
            tableColumn.setWidth(n3);
        }
        ((SortableTableModel2)this.myTable.getModel()).setColumnClass(n, string2);
    }

    public void setDefaultImportFileSettings() {
        int n = this.myTable.getRowCount();
        int n2 = this.myTable.getColumnCount();
        int n3 = 0;
        int n4 = 0;
        n3 = 0;
        while (n3 < n2) {
            if (this.myTable.getColumnName(n3).equalsIgnoreCase(headerImport)) break;
            ++n3;
        }
        n4 = 0;
        while (n4 < n2) {
            if (this.myTable.getColumnName(n4).equalsIgnoreCase(headerFilename)) break;
            ++n4;
        }
        String string = "";
        ImportFile importFile = null;
        int n5 = 0;
        while (n5 < n) {
            string = (String)this.myTable.getValueAt(n5, n4);
            importFile = JMDBMain.myJMDBMain.importHelper.getImportFile(string);
            if (importFile != null) {
                this.myTable.setValueAt(new Boolean(importFile.isDefaultFileImport()), n5, n3);
                importFile.setFileImport(importFile.isDefaultFileImport());
            } else {
                JMDBMain.myJMDBMain.log("Error restoring import file default settings because the ImportFile object couldn't be found using it's name (ImportHelper.getImportFile(" + string + ")).");
            }
            ++n5;
        }
    }

    private void setSortButtonRenderer(SortButtonRenderer sortButtonRenderer) {
        this.sortButtonRenderer = sortButtonRenderer;
    }

    private void setTableColumnModel(TableColumnModel tableColumnModel) {
        this.tableColumnModel = tableColumnModel;
    }

    private void setupTable() {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        SortableTableModel2 sortableTableModel2 = new SortableTableModel2(){

            public boolean isCellEditable(int n, int n2) {
                int n3 = -1;
                int n4 = -1;
                int n5 = ImportSelectionTableThread.this.myTable.getColumnCount();
                int n6 = 0;
                while (n6 < n5) {
                    if (ImportSelectionTableThread.this.myTable.getColumnName(n6).equalsIgnoreCase(headerImport)) {
                        n3 = n6;
                    } else if (ImportSelectionTableThread.this.myTable.getColumnName(n6).equalsIgnoreCase(headerRequired)) {
                        n4 = n6;
                    }
                    ++n6;
                }
                if (n3 >= 0 && n4 >= 0) {
                    if (n2 == n3) {
                        return !ImportSelectionTableThread.this.myTable.getValueAt(n, n4).toString().equals("true");
                    }
                    return false;
                }
                return false;
            }
        };
        Object[] objectArray = new String[]{headerId, headerFilename, headerFilecheck, headerRequired, headerImport};
        sortableTableModel2.setDataVector(new Object[0][], objectArray);
        this.myTable.setModel(sortableTableModel2);
        this.myTable.setShowVerticalLines(bl);
        this.myTable.setShowHorizontalLines(bl2);
        int n = bl ? 1 : 0;
        int n2 = bl2 ? 1 : 0;
        this.myTable.setIntercellSpacing(new Dimension(n, n2));
        this.setSortButtonRenderer(new SortButtonRenderer());
        this.setTableColumnModel(this.myTable.getColumnModel());
        JTableHeader jTableHeader = this.myTable.getTableHeader();
        jTableHeader.addMouseListener(new HeaderListener(jTableHeader, this.sortButtonRenderer));
        int n3 = 0;
        while (n3 < 5) {
            if (n3 == 0) {
                this.setColumn(n3, 38, 38, 38, (String)objectArray[n3], "int");
            } else if (n3 == 1 || n3 == 2) {
                this.setColumn(n3, 70, 0, 0, (String)objectArray[n3], "String");
            } else {
                this.setColumn(n3, 73, 73, 73, (String)objectArray[n3], "boolean");
            }
            ++n3;
        }
        this.myTable.setAutoResizeMode(bl3 ? 0 : 2);
        this.myTable.setRowSelectionAllowed(true);
        this.myTable.setSelectionMode(0);
    }

    public boolean updateFileExistence(String string) {
        int n = this.myTable.getRowCount();
        int n2 = this.myTable.getColumnCount();
        int n3 = 0;
        int n4 = 0;
        String string2 = "";
        boolean bl = false;
        String string3 = System.getProperty("file.separator");
        n4 = 0;
        while (n4 < n2) {
            if (this.myTable.getColumnName(n4).equalsIgnoreCase(headerFilecheck)) break;
            ++n4;
        }
        n3 = 0;
        while (n3 < n2) {
            if (this.myTable.getColumnName(n3).equalsIgnoreCase(headerFilename)) break;
            ++n3;
        }
        if (string != null && (string = string.trim()).length() > 0 && string.lastIndexOf(string3) != string.length() - 1) {
            string = String.valueOf(string) + string3;
        }
        int n5 = 0;
        while (n5 < n) {
            string2 = String.valueOf(string) + this.myTable.getValueAt(n5, n3).toString();
            if (new File(String.valueOf(string2) + ".list.gz").exists()) {
                this.myTable.setValueAt(fileOkMessage, n5, n4);
                bl = true;
            } else if (new File(String.valueOf(string2) + ".list").exists()) {
                this.myTable.setValueAt(fileOkMessage, n5, n4);
                bl = true;
            } else {
                this.myTable.setValueAt(fileNotFoundMessage, n5, n4);
            }
            ++n5;
        }
        return bl;
    }

    class HeaderListener
    extends MouseAdapter {
        JTableHeader header;
        SortButtonRenderer renderer;

        HeaderListener(JTableHeader jTableHeader, SortButtonRenderer sortButtonRenderer) {
            this.header = jTableHeader;
            this.renderer = sortButtonRenderer;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.header.getCursor().getType() == 11) {
                return;
            }
            int n = this.header.columnAtPoint(mouseEvent.getPoint());
            int n2 = this.header.getTable().convertColumnIndexToModel(n);
            this.renderer.setPressedColumn(n);
            this.renderer.setSelectedColumn(n);
            this.header.repaint();
            if (this.header.getTable().isEditing()) {
                this.header.getTable().getCellEditor().stopCellEditing();
            }
            boolean bl = 1 == this.renderer.getState(n);
            ((SortableTableModel2)this.header.getTable().getModel()).sortByColumn(n2, bl);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.header.columnAtPoint(mouseEvent.getPoint());
            this.renderer.setPressedColumn(-1);
            this.header.repaint();
        }
    }
}

