/*
 * Decompiled with CFR 0.152.
 */
package jmdb.util;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JOptionPane;
import jmdb.base.JMDBMain;
import jmdb.util.ImportFile;

public class ImportHelper {
    private static ResourceBundle resMessagesBundle = ResourceBundle.getBundle("languages/MessagesBundle");
    public Vector importFileList = new Vector();
    public String importStatusFile = "importStatus.log";
    public String lastImportedFile = "";
    public String userDir = System.getProperty("user.dir");
    public String directorySeparator = System.getProperty("file.separator");
    public boolean resume = false;

    public int checkUnfinishedConversion(Component component) {
        int n = 0;
        if (this.isUnfinishedConversionAvailable()) {
            n = JMDBMain.appCmdUnattendedImport ? 1 : (JOptionPane.showConfirmDialog(component, resMessagesBundle.getString("ImportHelper.dialogWindow.checkUnfinishedConversion.message"), resMessagesBundle.getString("ImportHelper.dialogWindow.checkUnfinishedConversion.title"), 0, 3) == 0 ? 1 : 2);
        }
        return n;
    }

    public int countNumberOfFilesToImport() {
        int n = 0;
        Enumeration enumeration = this.importFileList.elements();
        while (enumeration.hasMoreElements()) {
            ImportFile importFile = (ImportFile)enumeration.nextElement();
            if (!importFile.isFileImport()) continue;
            ++n;
        }
        return n;
    }

    public void deleteFileImportStatus() {
        this.setResume(false);
        this.writeFileImportStatus("");
    }

    public String getDirectorySeparator() {
        return this.directorySeparator;
    }

    ImportFile getImportFile(int n) {
        ImportFile importFile = null;
        Enumeration enumeration = this.getImportFileList().elements();
        while (enumeration.hasMoreElements()) {
            importFile = (ImportFile)enumeration.nextElement();
            if (n == importFile.getFileId()) break;
            importFile = null;
        }
        return importFile;
    }

    public ImportFile getImportFile(String string) {
        ImportFile importFile = null;
        Enumeration enumeration = this.getImportFileList().elements();
        while (enumeration.hasMoreElements()) {
            importFile = (ImportFile)enumeration.nextElement();
            if (string.equalsIgnoreCase(importFile.getFileName())) break;
            importFile = null;
        }
        return importFile;
    }

    public Vector getImportFileList() {
        return this.importFileList;
    }

    public String getImportStatusFile() {
        return this.importStatusFile;
    }

    public String getLastImportedFile() {
        return this.lastImportedFile;
    }

    public String getUserDir() {
        return this.userDir;
    }

    public boolean isResume() {
        return this.resume;
    }

    private boolean isUnfinishedConversionAvailable() {
        boolean bl = false;
        try {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(String.valueOf(this.getUserDir()) + this.getDirectorySeparator() + this.getImportStatusFile())));
                if (bufferedReader.ready() && (string = bufferedReader.readLine().trim()) != null && string.length() > 0) {
                    bl = true;
                }
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {}
        return bl;
    }

    private boolean readFileImportStatus(Component component) {
        boolean bl = false;
        this.setResume(false);
        this.setLastImportedFile("");
        try {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(String.valueOf(this.getUserDir()) + this.getDirectorySeparator() + this.getImportStatusFile())));
                if (bufferedReader.ready() && (string = bufferedReader.readLine().trim()) != null && string.length() > 0) {
                    MessageFormat messageFormat = new MessageFormat(resMessagesBundle.getString("ImportHelper.dialogWindow.readFileImportStatus.message"));
                    String[] stringArray = new String[]{string.toUpperCase()};
                    if (JMDBMain.appCmdUnattendedImport || JOptionPane.showConfirmDialog(component, messageFormat.format(stringArray), resMessagesBundle.getString("ImportHelper.dialogWindow.readFileImportStatus.title"), 0, 3) == 0) {
                        this.setLastImportedFile(string);
                        this.setResume(true);
                        bl = true;
                    }
                }
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {}
        return bl;
    }

    public void setDirectorySeparator(String string) {
        this.directorySeparator = string;
    }

    public void setImportStatusFile(String string) {
        this.importStatusFile = string;
    }

    public void setLastImportedFile(String string) {
        this.lastImportedFile = string;
    }

    private void setResume(boolean bl) {
        this.resume = bl;
    }

    public void setUserDir(String string) {
        this.userDir = string;
    }

    public boolean updateImportFileList() {
        boolean bl = this.isResume();
        if (bl) {
            JMDBMain.myJMDBMain.log("Info - updateImportFileList() setting - Converter resume available...");
            this.updateImportFileListResumeSelected();
        } else {
            JMDBMain.myJMDBMain.log("Info -  updateImportFileList() setting - Converter resume not available...");
            this.updateImportFileListNoResumeSelected();
        }
        return bl;
    }

    public boolean updateImportFileList(Component component) {
        this.readFileImportStatus(component);
        boolean bl = this.isResume();
        if (bl) {
            JMDBMain.myJMDBMain.log("Info - updateImportFileList(Component) setting - Converter resume available...");
            this.updateImportFileListResumeSelected();
        } else {
            JMDBMain.myJMDBMain.log("Info -  updateImportFileList(Component) setting - Converter resume not available...");
            this.updateImportFileListNoResumeSelected();
        }
        return bl;
    }

    public void updateImportFileListNoResumeSelected() {
        Enumeration enumeration = this.importFileList.elements();
        while (enumeration.hasMoreElements()) {
            ImportFile importFile = (ImportFile)enumeration.nextElement();
            if (JMDBMain.getCfgDeselectedImportFiles().indexOf(";" + importFile.getFileName() + ";") >= 0 || JMDBMain.getCfgDeselectedImportFiles().indexOf(String.valueOf(importFile.getFileName()) + ";") == 0) {
                importFile.setFileImport(false);
                continue;
            }
            importFile.setFileImport(true);
        }
    }

    public void updateImportFileListResumeSelected() {
        ImportFile importFile;
        int n = 0;
        Enumeration enumeration = this.getImportFileList().elements();
        while (enumeration.hasMoreElements()) {
            importFile = (ImportFile)enumeration.nextElement();
            if (!this.getLastImportedFile().equals(importFile.getFileName())) continue;
            n = importFile.getFileId();
            break;
        }
        enumeration = this.importFileList.elements();
        while (enumeration.hasMoreElements()) {
            importFile = (ImportFile)enumeration.nextElement();
            if (importFile.getFileId() < n) {
                importFile.setFileImport(false);
                continue;
            }
            if (JMDBMain.getCfgDeselectedImportFiles().indexOf(";" + importFile.getFileName() + ";") >= 0 || JMDBMain.getCfgDeselectedImportFiles().indexOf(String.valueOf(importFile.getFileName()) + ";") == 0) {
                importFile.setFileImport(false);
                continue;
            }
            importFile.setFileImport(true);
        }
    }

    public void writeFileImportStatus(String string) {
        try {
            FileWriter fileWriter = new FileWriter(String.valueOf(this.getUserDir()) + this.getDirectorySeparator() + this.getImportStatusFile(), false);
            fileWriter.write(string);
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException + " - FileWriter could not write FileImportStatus!");
        }
    }
}

