/*
 * Decompiled with CFR 0.152.
 */
package jmdb.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import jmdb.base.JMDBMain;
import jmdb.util.SortableArray;
import jmdb.util.SortableArrayHeapSorter;

public class Hotlist
implements SortableArray {
    private int roundedQueuePos = -1;
    private Object[] items;
    private Object[] roundedQueue;
    private int[] itemCounts;
    private int tmpItemCount;
    private Object tmpItem;
    private int roundedQueueCount = 0;

    public Hotlist(int n) {
        this.roundedQueue = new Object[n];
        this.items = new Object[n];
        this.itemCounts = new int[n];
    }

    public Hotlist(int n, String string) {
        this(n);
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            while (bufferedReader.ready()) {
                String string2 = bufferedReader.readLine();
                if (string2 == null || string2.length() <= 0) continue;
                this.count(string2);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("FileNotFoundException in jmdb.util.Hotlist.Hotlist(): " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.println("IOException in jmdb.util.Hotlist.Hotlist(): " + iOException);
        }
    }

    public int compare(int n, int n2) {
        return this.itemCounts[n2] - this.itemCounts[n];
    }

    public int compareTmp(int n) {
        return this.itemCounts[n] - this.tmpItemCount;
    }

    public void copy(int n, int n2) {
        this.itemCounts[n2] = this.itemCounts[n];
        this.items[n2] = this.items[n];
    }

    public void count(Object object) {
        this.roundedQueuePos = (this.roundedQueuePos + 1) % this.roundedQueue.length;
        this.roundedQueue[this.roundedQueuePos] = object;
        if (this.roundedQueueCount < this.roundedQueue.length) {
            ++this.roundedQueueCount;
        }
    }

    public Object[] getHotlist(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.items.length) {
            this.items[n3] = null;
            this.itemCounts[n3] = 0;
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.roundedQueueCount) {
            n3 = 0;
            while (n3 < n2 && !this.roundedQueue[n4].equals(this.items[n3])) {
                ++n3;
            }
            if (this.roundedQueue[n4].equals(this.items[n3])) {
                int n5 = n3;
                this.itemCounts[n5] = this.itemCounts[n5] + 1;
            } else {
                this.items[n2] = this.roundedQueue[n4];
                this.itemCounts[n2] = 1;
                ++n2;
            }
            ++n4;
        }
        new SortableArrayHeapSorter().sort(this, n2 - 1);
        int n6 = Math.min(n2, n);
        Object[] objectArray = new Object[n6];
        n3 = 0;
        while (n3 < n6) {
            objectArray[n3] = this.items[n3];
            ++n3;
        }
        return objectArray;
    }

    public void getTmp(int n) {
        this.itemCounts[n] = this.tmpItemCount;
        this.items[n] = this.tmpItem;
    }

    public void interchange(int n, int n2) {
        int n3 = this.itemCounts[n];
        this.itemCounts[n] = this.itemCounts[n2];
        this.itemCounts[n2] = n3;
        Object object = this.items[n];
        this.items[n] = this.items[n2];
        this.items[n2] = object;
    }

    public static void main(String[] stringArray) {
        System.out.println("10 element roundedQuenu");
        Hotlist hotlist = new Hotlist(15);
        String string = "1 times added";
        String string2 = "2 times added";
        String string3 = "3 times added";
        String string4 = "4 times added";
        String string5 = "5 times added";
        System.out.println("adding in this order: (34554) 3513424552");
        System.out.println("the first 5 values arent in the buffer at the end");
        hotlist.count(string3);
        hotlist.count(string4);
        hotlist.count(string5);
        hotlist.count(string5);
        hotlist.count(string4);
        hotlist.count(string3);
        hotlist.count(string5);
        hotlist.count(string);
        hotlist.count(string3);
        hotlist.count(string4);
        hotlist.count(string2);
        hotlist.count(string4);
        hotlist.count(string5);
        hotlist.count(string5);
        hotlist.count(string2);
        int n = 1;
        while (n <= 10) {
            Object[] objectArray = hotlist.getHotlist(n);
            int n2 = objectArray.length;
            System.out.print(String.valueOf(n2) + " items returned by hotlist, the " + n + " most used elements are ");
            int n3 = 0;
            while (n3 < n2) {
                System.out.print(" " + (String)objectArray[n3]);
                ++n3;
            }
            System.out.println();
            ++n;
        }
        System.out.println("End");
    }

    public void saveToFile(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(string)));
            int n = 1 + this.roundedQueuePos - this.roundedQueueCount;
            while (n <= this.roundedQueuePos) {
                int n2 = (n + this.roundedQueue.length) % this.roundedQueue.length;
                bufferedWriter.write((String)this.roundedQueue[n2]);
                bufferedWriter.newLine();
                ++n;
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            JMDBMain.myJMDBMain.log("Hotlist file " + string + " successfully written.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("FileNotFoundException in jmdb.util.Hotlist.saveToFile(): " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.println("IOException in jmdb.util.Hotlist.saveToFile(): " + iOException);
        }
    }

    public void setTmp(int n) {
        this.tmpItemCount = this.itemCounts[n];
        this.tmpItem = this.items[n];
    }
}

