/*
 * Decompiled with CFR 0.152.
 */
package jmdb.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ColorChooser
extends JPanel {
    private JLabel ivjJLabelBlue = null;
    private JLabel ivjJLabelGreen = null;
    private JLabel ivjJLabelRed = null;
    private GridLayout ivjColorChooserGridLayout = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JPanel ivjJPanelColor = null;
    private JTextField ivjJTextFieldBlue = null;
    private JTextField ivjJTextFieldGreen = null;
    private JTextField ivjJTextFieldRed = null;
    private Color color;
    private String colorString;
    private static ResourceBundle resMessagesBundle = ResourceBundle.getBundle("languages/MessagesBundle");

    public ColorChooser() {
        this.initialize();
    }

    public void colorChooser_PropertyChange() {
        this.getJLabelRed().setEnabled(this.isEnabled());
        this.getJTextFieldRed().setEnabled(this.isEnabled());
        this.getJLabelGreen().setEnabled(this.isEnabled());
        this.getJTextFieldGreen().setEnabled(this.isEnabled());
        this.getJLabelBlue().setEnabled(this.isEnabled());
        this.getJTextFieldBlue().setEnabled(this.isEnabled());
    }

    private void connEtoC1(KeyEvent keyEvent) {
        try {
            this.updateColor();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC2(KeyEvent keyEvent) {
        try {
            this.updateColor();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC3(KeyEvent keyEvent) {
        try {
            this.updateColor();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC4(PropertyChangeEvent propertyChangeEvent) {
        try {
            this.colorChooser_PropertyChange();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    public Color getColor() {
        return this.color;
    }

    private GridLayout getColorChooserGridLayout() {
        GridLayout gridLayout = null;
        try {
            gridLayout = new GridLayout();
            gridLayout.setHgap(5);
            gridLayout.setColumns(7);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return gridLayout;
    }

    public String getColorString() {
        return this.colorString;
    }

    private JLabel getJLabelBlue() {
        if (this.ivjJLabelBlue == null) {
            try {
                this.ivjJLabelBlue = new JLabel();
                this.ivjJLabelBlue.setName("JLabelBlue");
                this.ivjJLabelBlue.setText(resMessagesBundle.getString("ColorChooser.label.colorchooserblue"));
                this.ivjJLabelBlue.setHorizontalAlignment(0);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabelBlue;
    }

    private JLabel getJLabelGreen() {
        if (this.ivjJLabelGreen == null) {
            try {
                this.ivjJLabelGreen = new JLabel();
                this.ivjJLabelGreen.setName("JLabelGreen");
                this.ivjJLabelGreen.setText(resMessagesBundle.getString("ColorChooser.label.colorchoosergreen"));
                this.ivjJLabelGreen.setHorizontalAlignment(0);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabelGreen;
    }

    private JLabel getJLabelRed() {
        if (this.ivjJLabelRed == null) {
            try {
                this.ivjJLabelRed = new JLabel();
                this.ivjJLabelRed.setName("JLabelRed");
                this.ivjJLabelRed.setText(resMessagesBundle.getString("ColorChooser.label.colorchooserred"));
                this.ivjJLabelRed.setHorizontalAlignment(0);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabelRed;
    }

    private JPanel getJPanelColor() {
        if (this.ivjJPanelColor == null) {
            try {
                this.ivjJPanelColor = new JPanel();
                this.ivjJPanelColor.setName("JPanelColor");
                this.ivjJPanelColor.setLayout(null);
                this.ivjJPanelColor.setBackground(Color.black);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJPanelColor;
    }

    private JTextField getJTextFieldBlue() {
        if (this.ivjJTextFieldBlue == null) {
            try {
                this.ivjJTextFieldBlue = new JTextField();
                this.ivjJTextFieldBlue.setName("JTextFieldBlue");
                this.ivjJTextFieldBlue.setText("0");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJTextFieldBlue;
    }

    private JTextField getJTextFieldGreen() {
        if (this.ivjJTextFieldGreen == null) {
            try {
                this.ivjJTextFieldGreen = new JTextField();
                this.ivjJTextFieldGreen.setName("JTextFieldGreen");
                this.ivjJTextFieldGreen.setText("0");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJTextFieldGreen;
    }

    private JTextField getJTextFieldRed() {
        if (this.ivjJTextFieldRed == null) {
            try {
                this.ivjJTextFieldRed = new JTextField();
                this.ivjJTextFieldRed.setName("JTextFieldRed");
                this.ivjJTextFieldRed.setText("0");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJTextFieldRed;
    }

    private void handleException(Throwable throwable) {
    }

    public int hexToInt(String string) {
        if (string.length() != 2) {
            return -1;
        }
        String string2 = "0123456789ABCDEF";
        return string2.indexOf(string.charAt(0)) * 16 + string2.indexOf(string.charAt(1));
    }

    private void initConnections() throws Exception {
        this.getJTextFieldRed().addKeyListener(this.ivjEventHandler);
        this.getJTextFieldGreen().addKeyListener(this.ivjEventHandler);
        this.getJTextFieldBlue().addKeyListener(this.ivjEventHandler);
        this.addPropertyChangeListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("ColorChooser");
            this.setLayout(this.getColorChooserGridLayout());
            this.setSize(281, 31);
            this.add((Component)this.getJPanelColor(), this.getJPanelColor().getName());
            this.add((Component)this.getJLabelRed(), this.getJLabelRed().getName());
            this.add((Component)this.getJTextFieldRed(), this.getJTextFieldRed().getName());
            this.add((Component)this.getJLabelGreen(), this.getJLabelGreen().getName());
            this.add((Component)this.getJTextFieldGreen(), this.getJTextFieldGreen().getName());
            this.add((Component)this.getJLabelBlue(), this.getJLabelBlue().getName());
            this.add((Component)this.getJTextFieldBlue(), this.getJTextFieldBlue().getName());
            this.initConnections();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        this.setColor("0xFF8064");
    }

    public String intToHex(int n) {
        String string = "0123456789ABCDEF";
        return "" + string.charAt(n / 16) + string.charAt(n % 16);
    }

    public static void main(String[] stringArray) {
        try {
            JFrame jFrame = new JFrame();
            ColorChooser colorChooser = new ColorChooser();
            jFrame.setContentPane(colorChooser);
            ((Component)jFrame).setSize(colorChooser.getSize());
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            jFrame.show();
            Insets insets = jFrame.getInsets();
            ((Component)jFrame).setSize(jFrame.getWidth() + insets.left + insets.right, jFrame.getHeight() + insets.top + insets.bottom);
            ((Component)jFrame).setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in jmdb.util.ColorChooser.main()");
            throwable.printStackTrace(System.out);
        }
    }

    public void setColor(String string) {
        this.colorString = string;
        this.color = Color.decode(string);
        this.ivjJPanelColor.setBackground(this.color);
        this.ivjJTextFieldRed.setText("" + this.hexToInt(string.substring(2, 4)));
        this.ivjJTextFieldGreen.setText("" + this.hexToInt(string.substring(4, 6)));
        this.ivjJTextFieldBlue.setText("" + this.hexToInt(string.substring(6, 8)));
    }

    private void updateColor() {
        int n = Math.max(0, Math.min(255, new Integer(this.ivjJTextFieldRed.getText())));
        int n2 = Math.max(0, Math.min(255, new Integer(this.ivjJTextFieldGreen.getText())));
        int n3 = Math.max(0, Math.min(255, new Integer(this.ivjJTextFieldBlue.getText())));
        float[] fArray = Color.RGBtoHSB(n, n2, n3, null);
        this.color = Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
        this.ivjJPanelColor.setBackground(this.color);
        this.colorString = "0x" + this.intToHex(n) + this.intToHex(n2) + this.intToHex(n3);
    }

    class IvjEventHandler
    implements KeyListener,
    PropertyChangeListener {
        IvjEventHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getSource() == ColorChooser.this.getJTextFieldRed()) {
                ColorChooser.this.connEtoC1(keyEvent);
            }
            if (keyEvent.getSource() == ColorChooser.this.getJTextFieldGreen()) {
                ColorChooser.this.connEtoC2(keyEvent);
            }
            if (keyEvent.getSource() == ColorChooser.this.getJTextFieldBlue()) {
                ColorChooser.this.connEtoC3(keyEvent);
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == ColorChooser.this) {
                ColorChooser.this.connEtoC4(propertyChangeEvent);
            }
        }
    }
}

