/*
 * Decompiled with CFR 0.152.
 */
package jmdb.database;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

abstract class UsrDataImport {
    public BufferedReader bufferedReader;
    public String line;
    public StringBuffer dataString = new StringBuffer();
    public String[] resArray;
    private int errorCode = 0;
    private String errorLine = new String();

    public UsrDataImport(String string) {
        if (string == null) {
            string = "";
        }
        boolean bl = false;
        InputStreamReader inputStreamReader = null;
        try {
            if (new File(string).canRead()) {
                bl = true;
                inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string), "ISO8859_1");
                this.bufferedReader = new BufferedReader(inputStreamReader);
            }
            if (!bl) {
                System.out.println("file ('" + string + "') not found...");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found or unknown file format. " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.println("File not found or unknown file format. " + iOException);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            this.bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Error closing file.");
        }
    }

    protected int countOccurrences(String string, String string2) {
        int n = 0;
        int n2 = 0;
        do {
            if ((n = string.indexOf(string2, n)) == -1) continue;
            ++n;
            ++n2;
        } while (n != -1);
        return n2;
    }

    public abstract boolean getData();

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorLine() {
        return this.errorLine;
    }

    public String getErrorMessage() {
        if (this.getErrorCode() == 0) {
            return "No error!";
        }
        if (this.getErrorCode() == 1) {
            return "Data Format not correct or changed (User file - FormatError)!";
        }
        if (this.getErrorCode() == 2) {
            return "Data Format not correct (NullPointerException)!";
        }
        if (this.getErrorCode() == 3) {
            return "Data read/write error (IOException)!";
        }
        if (this.getErrorCode() == 99) {
            return "Unknown Error!";
        }
        return "No error message for error code (" + this.getErrorCode() + ")!";
    }

    protected String replaceAll(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while ((n2 = string.indexOf(string2, n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public void resetErrorStatus() {
        this.setErrorCode(0);
        this.setErrorLine(new String());
    }

    public void setErrorCode(int n) {
        this.errorCode = n;
    }

    public void setErrorLine(String string) {
        this.errorLine = string;
    }
}

