/*
 * Decompiled with CFR 0.152.
 */
package jmdb.database;

import jmdb.database.SQLWorkerAbstract;

public class SQLWorkerPostgres71x
extends SQLWorkerAbstract {
    private int maxAdditionLength = 1000;
    private int maxTitleLength = 400;
    private int maxCharacterNameLength = 1000;
    private int maxNameLength = 250;

    protected int getMaxAdditionLength() {
        return this.maxAdditionLength;
    }

    public int getMaxCharacterNameLength() {
        return this.maxCharacterNameLength;
    }

    public int getMaxNameLength() {
        return this.maxNameLength;
    }

    public int getMaxTitleLength() {
        return this.maxTitleLength;
    }

    protected String getSQLBeginTransaction() {
        return "BEGIN;";
    }

    public String getSQLCountActors() {
        return "SELECT COUNT(*) FROM actors;";
    }

    public String getSQLCountActors(char c) {
        return "SELECT COUNT(*) FROM actors WHERE sex='" + c + "';";
    }

    public String getSQLCountMovies() {
        return "SELECT COUNT(*) FROM movies;";
    }

    protected String getSQLCreateActors() {
        return "CREATE TABLE actors (actorid SERIAL NOT NULL PRIMARY KEY, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, sex CHARACTER(1));";
    }

    protected String getSQLCreateAKANames() {
        return "CREATE TABLE akanames (name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, akaname VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "));";
    }

    protected String getSQLCreateAKATitles() {
        return "CREATE TABLE akatitles (movieid INTEGER NOT NULL, language CHAR(3) NOT NULL, title VARCHAR(" + this.getMaxTitleLength() + ") NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "));";
    }

    protected String getSQLCreateAlternateVersions() {
        return "CREATE TABLE altversions (movieid INTEGER NOT NULL, versiontext TEXT);";
    }

    protected String getSQLCreateBiographies() {
        return "CREATE TABLE biographies (bioid SERIAL NOT NULL PRIMARY KEY, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, biotext TEXT);";
    }

    protected String getSQLCreateBusiness() {
        return "CREATE TABLE business (movieid INTEGER NOT NULL PRIMARY KEY, businesstext TEXT);";
    }

    protected String getSQLCreateCertificates() {
        return "CREATE TABLE certificates (movieid INTEGER NOT NULL, country VARCHAR(50), certification VARCHAR(255) NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + ") );";
    }

    protected String getSQLCreateCinematographers() {
        return "CREATE TABLE cinematgrs (cinematid SERIAL NOT NULL PRIMARY KEY, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL);";
    }

    protected String getSQLCreateColorinfo() {
        return "CREATE TABLE colorinfo (movieid INTEGER NOT NULL, color VARCHAR NOT NULL, addition VARCHAR);";
    }

    protected String getSQLCreateComposers() {
        return "CREATE TABLE composers (composerid SERIAL NOT NULL PRIMARY KEY, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL);";
    }

    protected String getSQLCreateCostumeDesigners() {
        return "CREATE TABLE costdesigners (costdesid SERIAL NOT NULL PRIMARY KEY, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL);";
    }

    protected String getSQLCreateCountries() {
        return "CREATE TABLE countries (movieid INTEGER NOT NULL, country VARCHAR(50) NOT NULL);";
    }

    protected String getSQLCreateCrazyCredits() {
        return "CREATE TABLE crazycredits (movieid INTEGER NOT NULL, credittext TEXT);";
    }

    protected String getSQLCreateDatabase(String string) {
        if (string == null || string.trim().length() == 0) {
            string = "jmdb";
        }
        return "CREATE DATABASE " + string + ";";
    }

    protected String getSQLCreateDirectors() {
        return "CREATE TABLE directors (directorid SERIAL NOT NULL PRIMARY KEY, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL);";
    }

    protected String getSQLCreateDistributors() {
        return "CREATE TABLE distributors (movieid INTEGER NOT NULL, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL);";
    }

    protected String getSQLCreateEditors() {
        return "CREATE TABLE editors (editorid SERIAL NOT NULL PRIMARY KEY, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL);";
    }

    protected String getSQLCreateGenres() {
        return "CREATE TABLE genres (movieid INTEGER NOT NULL, genre VARCHAR(50) NOT NULL);";
    }

    protected String getSQLCreateGoofs() {
        return "CREATE TABLE goofs (movieid INTEGER NOT NULL, gooftext TEXT);";
    }

    protected String getSQLCreateIndex(String string, String string2, int n) {
        return "CREATE INDEX " + string + "_" + string2 + " ON " + string + " (" + string2 + ");";
    }

    protected String getSQLCreateKeywords() {
        return "CREATE TABLE keywords (movieid INTEGER NOT NULL, keyword VARCHAR NOT NULL);";
    }

    protected String getSQLCreateLanguage() {
        return "CREATE TABLE language (movieid INTEGER NOT NULL, language VARCHAR(100) NOT NULL);";
    }

    protected String getSQLCreateLiterature() {
        return "CREATE TABLE literature (movieid INTEGER NOT NULL, literaturetext TEXT);";
    }

    protected String getSQLCreateLocations() {
        return "CREATE TABLE locations (movieid INTEGER NOT NULL, location VARCHAR(" + this.getMaxAdditionLength() + ") NOT NULL);";
    }

    protected String getSQLCreateMiscellaneous() {
        return "CREATE TABLE misc (miscid SERIAL NOT NULL PRIMARY KEY, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL);";
    }

    protected String getSQLCreateMovieLinks() {
        return "CREATE TABLE movielinks (movieid INTEGER NOT NULL, movielinkstext TEXT);";
    }

    protected String getSQLCreateMovies() {
        return "CREATE TABLE movies (movieid SERIAL NOT NULL PRIMARY KEY, title VARCHAR(" + this.getMaxTitleLength() + ") NOT NULL, year VARCHAR(100), imdbid VARCHAR(10));";
    }

    protected String getSQLCreateMovies2Actors() {
        return "CREATE TABLE movies2actors (movieid INTEGER NOT NULL, actorid INTEGER NOT NULL, as_character VARCHAR(" + this.getMaxCharacterNameLength() + "));";
    }

    protected String getSQLCreateMovies2Cinematographers() {
        return "CREATE TABLE movies2cinematgrs (movieid INTEGER NOT NULL, cinematid INTEGER NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "));";
    }

    protected String getSQLCreateMovies2Composers() {
        return "CREATE TABLE movies2composers (movieid INTEGER NOT NULL, composerid INTEGER NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "));";
    }

    protected String getSQLCreateMovies2CostumeDesigners() {
        return "CREATE TABLE movies2costdes (movieid INTEGER NOT NULL, costdesid INTEGER NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "));";
    }

    protected String getSQLCreateMovies2Directors() {
        return "CREATE TABLE movies2directors (movieid INTEGER NOT NULL, directorid INTEGER NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "));";
    }

    protected String getSQLCreateMovies2Editors() {
        return "CREATE TABLE movies2editors (movieid INTEGER NOT NULL, editorid INTEGER NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "));";
    }

    protected String getSQLCreateMovies2Miscellaneous() {
        return "CREATE TABLE movies2misc (movieid INTEGER NOT NULL, miscid INTEGER NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "));";
    }

    protected String getSQLCreateMovies2Producers() {
        return "CREATE TABLE movies2producers (movieid INTEGER NOT NULL, producerid INTEGER NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "));";
    }

    protected String getSQLCreateMovies2ProductionDesigners() {
        return "CREATE TABLE movies2proddes (movieid INTEGER NOT NULL, proddesid INTEGER NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "));";
    }

    protected String getSQLCreateMovies2Writers() {
        return "CREATE TABLE movies2writers (movieid INTEGER NOT NULL, writerid INTEGER NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "));";
    }

    protected String getSQLCreateMPAARatingsReasons() {
        return "CREATE TABLE mpaaratings (movieid INTEGER NOT NULL, reasontext TEXT);";
    }

    protected String getSQLCreatePlots() {
        return "CREATE TABLE plots (movieid INTEGER NOT NULL, plottext TEXT);";
    }

    protected String getSQLCreateProducers() {
        return "CREATE TABLE producers (producerid SERIAL NOT NULL PRIMARY KEY, name varchar(" + this.getMaxNameLength() + ") NOT NULL);";
    }

    protected String getSQLCreateProductionCompanies() {
        return "CREATE TABLE prodcompanies (movieid INTEGER NOT NULL, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL);";
    }

    protected String getSQLCreateProductionDesigners() {
        return "CREATE TABLE proddesigners (proddesid SERIAL NOT NULL PRIMARY KEY, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL);";
    }

    protected String getSQLCreateQuotes() {
        return "CREATE TABLE quotes (movieid INTEGER NOT NULL, quotetext TEXT);";
    }

    protected String getSQLCreateRatings() {
        return "CREATE TABLE ratings (movieid INTEGER NOT NULL, rank CHAR(4) NOT NULL, votes INTEGER, distribution CHAR(10) NOT NULL);";
    }

    protected String getSQLCreateReleasedates() {
        return "CREATE TABLE releasedates (movieid INTEGER NOT NULL, country VARCHAR(50), imdbdate VARCHAR(50) NOT NULL, releasedate DATE, addition VARCHAR(" + this.getMaxAdditionLength() + "));";
    }

    protected String getSQLCreateRunningtimes() {
        return "CREATE TABLE runningtimes (movieid INTEGER NOT NULL, time VARCHAR(50) NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + ") NOT NULL);";
    }

    protected String getSQLCreateTaglines() {
        return "CREATE TABLE taglines (movieid INTEGER NOT NULL, taglinetext TEXT);";
    }

    protected String getSQLCreateTechnical() {
        return "CREATE TABLE technical (movieid INTEGER NOT NULL, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL);";
    }

    public String getSQLCreateTemporaryTableActorsDirectorsProducers(String string, String string2) {
        return "CREATE " + this.getSQLMetaTemporaryTable() + " " + string + " (name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, " + string2 + " INTEGER NOT NULL);";
    }

    public String getSQLCreateTemporaryTableMovieAndReleasedates(String string) {
        return "CREATE " + this.getSQLMetaTemporaryTable() + " " + string + " (title VARCHAR(" + this.getMaxTitleLength() + ") NOT NULL, movieid INTEGER NOT NULL, year VARCHAR(100));";
    }

    protected String getSQLCreateTrivia() {
        return "CREATE TABLE trivia (movieid INTEGER NOT NULL, triviatext TEXT);";
    }

    protected String getSQLCreateUsrMLItems() {
        return "CREATE TABLE usr_ml_items (itemid INTEGER NOT NULL, movieid INTEGER, itemtitle VARCHAR(" + this.getMaxTitleLength() + ") NOT NULL, healeditemtitle VARCHAR(" + this.getMaxTitleLength() + ") );";
    }

    protected String getSQLCreateWriters() {
        return "CREATE TABLE writers (writerid SERIAL NOT NULL PRIMARY KEY, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL);";
    }

    protected String getSQLDeleteTableEntry(String string, String string2, String string3, int n) {
        return "DELETE FROM " + string + " WHERE " + string2 + " " + string3 + " " + n + ";";
    }

    protected String getSQLDeleteTableEntry(String string, String string2, String string3, String string4) {
        return "DELETE FROM " + string + " WHERE " + string2 + " " + string3 + " '" + string4 + "';";
    }

    public String getSQLDropDatabase(String string) {
        return "DROP DATABASE " + string + ";";
    }

    public String getSQLDropTable(String string) {
        return "DROP TABLE " + string + ";";
    }

    protected String getSQLEndTransaction() {
        return "COMMIT;";
    }

    public String getSQLExcludeEpisodes(String string) {
        return "NOT (" + string + " " + this.getSQLMetaLikeCaseInsensitive() + " '\"%}')";
    }

    protected String getSQLInsertIntoActors() {
        return "INSERT INTO actors (name, sex) VALUES (?,?)";
    }

    protected String getSQLInsertIntoAKANames() {
        return "INSERT INTO akanames (name, akaname, addition) VALUES (?,?,?)";
    }

    protected String getSQLInsertIntoAKATitles() {
        return "INSERT INTO akatitles (movieid, language, title, addition) VALUES (?,?,?,?)";
    }

    protected String getSQLInsertIntoAlternateVersions() {
        return "INSERT INTO altversions (movieid, versiontext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoBiographies() {
        return "INSERT INTO biographies (name, biotext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoBusiness() {
        return "INSERT INTO business (movieid, businesstext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoCertificates() {
        return "INSERT INTO certificates (movieid, country, certification, addition) VALUES (?,?,?,?)";
    }

    protected String getSQLInsertIntoCinematographers() {
        return "INSERT INTO cinematgrs (name) VALUES (?)";
    }

    protected String getSQLInsertIntoColorinfo() {
        return "INSERT INTO colorinfo (movieid, color) VALUES (?,?)";
    }

    protected String getSQLInsertIntoComposers() {
        return "INSERT INTO composers (name) VALUES (?)";
    }

    protected String getSQLInsertIntoCostumeDesigners() {
        return "INSERT INTO costdesigners (name) VALUES (?)";
    }

    protected String getSQLInsertIntoCountries() {
        return "INSERT INTO countries (movieid, country) VALUES (?,?)";
    }

    protected String getSQLInsertIntoCrazyCredits() {
        return "INSERT INTO crazycredits (movieid, credittext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoDirectors() {
        return "INSERT INTO directors (name) VALUES (?)";
    }

    protected String getSQLInsertIntoDistributors() {
        return "INSERT INTO distributors (movieid, name) VALUES (?,?)";
    }

    protected String getSQLInsertIntoEditors() {
        return "INSERT INTO editors (name) VALUES (?)";
    }

    protected String getSQLInsertIntoGenres() {
        return "INSERT INTO genres (movieid, genre) VALUES (?,?)";
    }

    protected String getSQLInsertIntoGoofs() {
        return "INSERT INTO goofs (movieid, gooftext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoKeywords() {
        return "INSERT INTO keywords (movieid, keyword) VALUES (?,?)";
    }

    protected String getSQLInsertIntoLanguage() {
        return "INSERT INTO language (movieid, language) VALUES (?,?)";
    }

    protected String getSQLInsertIntoLiterature() {
        return "INSERT INTO literature (movieid, literaturetext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoLocations() {
        return "INSERT INTO locations (movieid, location) VALUES (?,?)";
    }

    protected String getSQLInsertIntoMiscellaneous() {
        return "INSERT INTO misc (name) VALUES (?)";
    }

    protected String getSQLInsertIntoMovieLinks() {
        return "INSERT INTO movielinks (movieid, movielinkstext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoMovies() {
        return "INSERT INTO movies (title, year, imdbid) VALUES (?,?,?)";
    }

    protected String getSQLInsertIntoMovies2Actors() {
        return "INSERT INTO movies2actors (movieid, actorid, as_character) VALUES (?,?,?)";
    }

    protected String getSQLInsertIntoMovies2Cinematographers() {
        return "INSERT INTO movies2cinematgrs (movieid, cinematid, addition) values (?,?,?)";
    }

    protected String getSQLInsertIntoMovies2Composers() {
        return "INSERT INTO movies2composers (movieid, composerid, addition) values (?,?,?)";
    }

    protected String getSQLInsertIntoMovies2CostumeDesigners() {
        return "INSERT INTO movies2costdes (movieid, costdesid, addition) values (?,?,?)";
    }

    protected String getSQLInsertIntoMovies2Directors() {
        return "INSERT INTO movies2directors (movieid, directorid, addition) VALUES (?,?,?)";
    }

    protected String getSQLInsertIntoMovies2Editors() {
        return "INSERT INTO movies2editors (movieid, editorid, addition) values (?,?,?)";
    }

    protected String getSQLInsertIntoMovies2Miscellaneous() {
        return "INSERT INTO movies2misc (movieid, miscid, addition) values (?,?,?)";
    }

    protected String getSQLInsertIntoMovies2Producers() {
        return "INSERT INTO movies2producers (movieid, producerid, addition) values (?,?,?)";
    }

    protected String getSQLInsertIntoMovies2ProductionDesigners() {
        return "INSERT INTO movies2proddes (movieid, proddesid, addition) values (?,?,?)";
    }

    protected String getSQLInsertIntoMovies2Writers() {
        return "INSERT INTO movies2writers (movieid, writerid, addition) values (?,?,?)";
    }

    protected String getSQLInsertIntoMPAARatingsReasons() {
        return "INSERT INTO mpaaratings (movieid, reasontext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoPlots() {
        return "INSERT INTO plots (movieid, plottext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoProducers() {
        return "INSERT INTO producers (name) VALUES (?)";
    }

    protected String getSQLInsertIntoProductionCompanies() {
        return "INSERT INTO prodcompanies (movieid, name) VALUES (?,?)";
    }

    protected String getSQLInsertIntoProductionDesigners() {
        return "INSERT INTO proddesigners (name) VALUES (?)";
    }

    protected String getSQLInsertIntoQuotes() {
        return "INSERT INTO quotes (movieid, quotetext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoRatings() {
        return "INSERT INTO ratings (movieid, rank, votes, distribution) VALUES (?,?,?,?)";
    }

    protected String getSQLInsertIntoReleasedates() {
        return "INSERT INTO releasedates (movieid, country, imdbdate, releasedate, addition) VALUES (?,?,?,?,?)";
    }

    protected String getSQLInsertIntoRunningtimes() {
        return "INSERT INTO runningtimes (movieid, time, addition) VALUES (?,?,?)";
    }

    protected String getSQLInsertIntoTaglines() {
        return "INSERT INTO taglines (movieid, taglinetext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoTechnical() {
        return "INSERT INTO technical (movieid, name) VALUES (?,?)";
    }

    protected String getSQLInsertIntoTrivia() {
        return "INSERT INTO trivia (movieid, triviatext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoUsrMLItems() {
        return "INSERT INTO usr_ml_items (itemid, movieid, itemtitle, healeditemtitle) VALUES (?, ?, ?, ?)";
    }

    protected String getSQLInsertIntoWriters() {
        return "INSERT INTO writers (name) VALUES (?)";
    }

    protected String getSQLMetaAnalyse() {
        return "ANALYSE;";
    }

    public String getSQLMetaConcat(String string, String string2) {
        return new String(String.valueOf(string) + "||" + string2);
    }

    public String getSQLMetaControlDB() {
        return new String("postgres");
    }

    public String getSQLMetaDayOfMonthFromDate(String string) {
        return "EXTRACT(day FROM " + string + ")";
    }

    public String getSQLMetaLikeCaseInsensitive() {
        return "ILIKE";
    }

    public String getSQLMetaLimit(int n, int n2) {
        return "LIMIT " + n2 + " OFFSET " + n;
    }

    public String getSQLMetaMonthFromDate(String string) {
        return "EXTRACT(month FROM " + string + ")";
    }

    public String getSQLMetaNotNullValue(String string, String string2) {
        return new String("COALESCE(" + string + ", " + string2 + ")");
    }

    public String getSQLMetaRegExp() {
        return "SIMILAR TO";
    }

    public String getSQLMetaShowDatabases() {
        return new String("SELECT datname FROM pg_database WHERE datistemplate='false';");
    }

    public String getSQLMetaShowIndexes(String string) {
        return null;
    }

    public String getSQLMetaShowTables() {
        return new String("SELECT tablename FROM pg_tables WHERE schemaname='public';");
    }

    public String getSQLMetaTemporaryTable() {
        return "TEMPORARY TABLE";
    }

    public String getSQLMetaYearFromDate(String string) {
        return "EXTRACT(year FROM " + string + ")";
    }

    protected String getSQLSelectLowestActressesID() {
        return "SELECT min(actorid) FROM actors WHERE sex='F';";
    }

    public boolean isSQLMetaCreateTableCanCreateIndex() {
        return false;
    }

    public boolean isSQLMetaLimitSupported() {
        return true;
    }

    public boolean isSQLMetaSubselectLimitSupported() {
        return true;
    }

    public boolean isSQLMetaSubselectSupported() {
        return true;
    }

    public boolean isSQLMetaTransactionSupported() {
        return true;
    }
}

