/*
 * Decompiled with CFR 0.152.
 */
package jmdb.database;

import jmdb.database.SQLWorkerAbstract;

public class SQLWorkerMySQL323xx
extends SQLWorkerAbstract {
    private int maxAdditionLength = 255;
    private int maxTitleLength = 255;
    private int maxCharacterNameLength = 255;
    private int maxNameLength = 250;
    protected int textSearchMinLength = 4;

    protected int getMaxAdditionLength() {
        return this.maxAdditionLength;
    }

    public int getMaxCharacterNameLength() {
        return this.maxCharacterNameLength;
    }

    public int getMaxNameLength() {
        return this.maxNameLength;
    }

    public int getMaxTitleLength() {
        return this.maxTitleLength;
    }

    public String getSQLCountActors() {
        return "SELECT COUNT(*) FROM actors;";
    }

    public String getSQLCountActors(char c) {
        return "SELECT COUNT(*) FROM actors WHERE sex='" + c + "';";
    }

    public String getSQLCountMovies() {
        return "SELECT COUNT(*) FROM movies;";
    }

    protected String getSQLCreateActors() {
        return "CREATE TABLE actors (actorid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, sex ENUM('M','F'), PRIMARY KEY (actorid) ) ENGINE = MyISAM;";
    }

    protected String getSQLCreateAKANames() {
        return "CREATE TABLE akanames (name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, akaname VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + ")) ENGINE = MyISAM;";
    }

    protected String getSQLCreateAKATitles() {
        return "CREATE TABLE akatitles (movieid MEDIUMINT UNSIGNED NOT NULL, language CHAR(3) NOT NULL, title VARCHAR(" + this.getMaxTitleLength() + ") NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + ")) ENGINE = MyISAM;";
    }

    protected String getSQLCreateAlternateVersions() {
        return "CREATE TABLE altversions (movieid MEDIUMINT UNSIGNED NOT NULL, versiontext TEXT, KEY (movieid));";
    }

    protected String getSQLCreateBiographies() {
        return "CREATE TABLE biographies (bioid MEDIUMINT UNSIGNED AUTO_INCREMENT, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, biotext MEDIUMTEXT, PRIMARY KEY (bioid), KEY name (name(10)) );";
    }

    protected String getSQLCreateBusiness() {
        return "CREATE TABLE business (movieid MEDIUMINT UNSIGNED NOT NULL, businesstext TEXT, PRIMARY KEY (movieid));";
    }

    protected String getSQLCreateCertificates() {
        return "CREATE TABLE certificates (movieid MEDIUMINT UNSIGNED NOT NULL, country VARCHAR(50), certification VARCHAR(255) NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "), KEY (movieid), KEY country(country), KEY certification(certification) );";
    }

    protected String getSQLCreateCinematographers() {
        return "CREATE TABLE cinematgrs (cinematid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, PRIMARY KEY (cinematid), KEY name (name(10)));";
    }

    protected String getSQLCreateColorinfo() {
        return "CREATE TABLE colorinfo (movieid MEDIUMINT UNSIGNED NOT NULL, color VARCHAR(100) NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "), KEY (movieid), KEY color(color(15)));";
    }

    protected String getSQLCreateComposers() {
        return "CREATE TABLE composers (composerid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, PRIMARY KEY (composerid), KEY name (name(10)));";
    }

    protected String getSQLCreateCostumeDesigners() {
        return "CREATE TABLE costdesigners (costdesid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, PRIMARY KEY (costdesid), KEY name (name(10)));";
    }

    protected String getSQLCreateCountries() {
        return "CREATE TABLE countries (movieid MEDIUMINT UNSIGNED NOT NULL, country VARCHAR(50) NOT NULL, KEY (movieid), KEY country(country(15)));";
    }

    protected String getSQLCreateCrazyCredits() {
        return "CREATE TABLE crazycredits (movieid MEDIUMINT UNSIGNED NOT NULL, credittext TEXT, KEY (movieid));";
    }

    protected String getSQLCreateDatabase(String string) {
        if (string == null || string.trim().length() == 0) {
            string = "jmdb";
        }
        return "CREATE DATABASE " + string + ";";
    }

    protected String getSQLCreateDirectors() {
        return "CREATE TABLE directors (directorid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, PRIMARY KEY (directorid) ) ENGINE = MyISAM;";
    }

    protected String getSQLCreateDistributors() {
        return "CREATE TABLE distributors (movieid MEDIUMINT UNSIGNED NOT NULL, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, KEY (movieid));";
    }

    protected String getSQLCreateEditors() {
        return "CREATE TABLE editors (editorid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, PRIMARY KEY (editorid), KEY name (name(10)));";
    }

    protected String getSQLCreateGenres() {
        return "CREATE TABLE genres (movieid MEDIUMINT UNSIGNED NOT NULL, genre VARCHAR(50) NOT NULL, KEY (movieid), KEY genre(genre(15)));";
    }

    protected String getSQLCreateGoofs() {
        return "CREATE TABLE goofs (movieid MEDIUMINT UNSIGNED NOT NULL, gooftext TEXT, KEY (movieid));";
    }

    protected String getSQLCreateIndex(String string, String string2, int n) {
        if (n > 0) {
            return "CREATE INDEX " + string2 + " ON " + string + " (" + string2 + "(" + n + "));";
        }
        return "CREATE INDEX " + string2 + " ON " + string + " (" + string2 + ");";
    }

    protected String getSQLCreateIndexFullText(String string, String string2, String string3, String string4) {
        return "CREATE FULLTEXT INDEX " + string + "_" + string2 + "_fulltext ON " + string + " (" + string2 + ");";
    }

    protected String getSQLCreateKeywords() {
        return "CREATE TABLE keywords (movieid MEDIUMINT UNSIGNED NOT NULL, keyword VARCHAR(125) NOT NULL, KEY (movieid), KEY keyword(keyword(15)));";
    }

    protected String getSQLCreateLanguage() {
        return "CREATE TABLE language (movieid MEDIUMINT UNSIGNED NOT NULL, language VARCHAR(100) NOT NULL, KEY (movieid));";
    }

    protected String getSQLCreateLiterature() {
        return "CREATE TABLE literature (movieid MEDIUMINT UNSIGNED NOT NULL, literaturetext TEXT, KEY (movieid));";
    }

    protected String getSQLCreateLocations() {
        return "CREATE TABLE locations (movieid MEDIUMINT UNSIGNED NOT NULL, location VARCHAR(" + this.getMaxAdditionLength() + ") NOT NULL, KEY (movieid));";
    }

    protected String getSQLCreateMiscellaneous() {
        return "CREATE TABLE misc (miscid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, PRIMARY KEY (miscid), KEY name (name(10)));";
    }

    protected String getSQLCreateMovieLinks() {
        return "CREATE TABLE movielinks (movieid MEDIUMINT UNSIGNED NOT NULL, movielinkstext TEXT, KEY (movieid));";
    }

    protected String getSQLCreateMovies() {
        return "CREATE TABLE movies (movieid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, title VARCHAR(" + this.getMaxTitleLength() + ") NOT NULL, year VARCHAR(100), imdbid VARCHAR(10), PRIMARY KEY (movieid) ) ENGINE = MyISAM;";
    }

    protected String getSQLCreateMovies2Actors() {
        return "CREATE TABLE movies2actors (movieid MEDIUMINT UNSIGNED NOT NULL, actorid MEDIUMINT UNSIGNED NOT NULL, as_character VARCHAR(" + this.getMaxCharacterNameLength() + "));";
    }

    protected String getSQLCreateMovies2Cinematographers() {
        return "CREATE TABLE movies2cinematgrs (movieid MEDIUMINT UNSIGNED NOT NULL, cinematid MEDIUMINT UNSIGNED NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "), KEY (movieid), KEY (cinematid));";
    }

    protected String getSQLCreateMovies2Composers() {
        return "CREATE TABLE movies2composers (movieid MEDIUMINT UNSIGNED NOT NULL, composerid MEDIUMINT UNSIGNED NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "), KEY (movieid), KEY (composerid));";
    }

    protected String getSQLCreateMovies2CostumeDesigners() {
        return "CREATE TABLE movies2costdes (movieid MEDIUMINT UNSIGNED NOT NULL, costdesid MEDIUMINT UNSIGNED NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "), KEY (movieid), KEY (costdesid));";
    }

    protected String getSQLCreateMovies2Directors() {
        return "CREATE TABLE movies2directors (movieid MEDIUMINT UNSIGNED NOT NULL, directorid MEDIUMINT UNSIGNED NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "));";
    }

    protected String getSQLCreateMovies2Editors() {
        return "CREATE TABLE movies2editors (movieid MEDIUMINT UNSIGNED NOT NULL, editorid MEDIUMINT UNSIGNED NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "), KEY (movieid), KEY (editorid));";
    }

    protected String getSQLCreateMovies2Miscellaneous() {
        return "CREATE TABLE movies2misc (movieid MEDIUMINT UNSIGNED NOT NULL, miscid MEDIUMINT UNSIGNED NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "), KEY (movieid), KEY (miscid));";
    }

    protected String getSQLCreateMovies2Producers() {
        return "CREATE TABLE movies2producers (movieid MEDIUMINT UNSIGNED NOT NULL, producerid MEDIUMINT UNSIGNED NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "));";
    }

    protected String getSQLCreateMovies2ProductionDesigners() {
        return "CREATE TABLE movies2proddes (movieid MEDIUMINT UNSIGNED NOT NULL, proddesid MEDIUMINT UNSIGNED NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "), KEY (movieid), KEY (proddesid));";
    }

    protected String getSQLCreateMovies2Writers() {
        return "CREATE TABLE movies2writers (movieid MEDIUMINT UNSIGNED NOT NULL, writerid MEDIUMINT UNSIGNED NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + "), KEY (movieid), KEY (writerid));";
    }

    protected String getSQLCreateMPAARatingsReasons() {
        return "CREATE TABLE mpaaratings (movieid MEDIUMINT UNSIGNED NOT NULL, reasontext TEXT, KEY (movieid));";
    }

    protected String getSQLCreatePlots() {
        return "CREATE TABLE plots (movieid MEDIUMINT UNSIGNED NOT NULL, plottext TEXT, KEY (movieid));";
    }

    protected String getSQLCreateProducers() {
        return "CREATE TABLE producers (producerid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, PRIMARY KEY (producerid) ) ENGINE = MyISAM;";
    }

    protected String getSQLCreateProductionCompanies() {
        return "CREATE TABLE prodcompanies (movieid MEDIUMINT UNSIGNED NOT NULL, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, KEY (movieid), KEY name(name(15)));";
    }

    protected String getSQLCreateProductionDesigners() {
        return "CREATE TABLE proddesigners (proddesid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, PRIMARY KEY (proddesid), KEY name (name(10)));";
    }

    protected String getSQLCreateQuotes() {
        return "CREATE TABLE quotes (movieid MEDIUMINT UNSIGNED NOT NULL, quotetext MEDIUMTEXT, KEY (movieid));";
    }

    protected String getSQLCreateRatings() {
        return "CREATE TABLE ratings (movieid MEDIUMINT UNSIGNED NOT NULL, rank CHAR(4) NOT NULL, votes MEDIUMINT UNSIGNED, distribution CHAR(10) NOT NULL, KEY (movieid));";
    }

    protected String getSQLCreateReleasedates() {
        return "CREATE TABLE releasedates (movieid MEDIUMINT UNSIGNED NOT NULL, country VARCHAR(50), imdbdate VARCHAR(50) NOT NULL, releasedate DATE, addition VARCHAR(" + this.getMaxAdditionLength() + "),  KEY (movieid), KEY country(country), KEY releasedate(releasedate) );";
    }

    protected String getSQLCreateRunningtimes() {
        return "CREATE TABLE runningtimes (movieid MEDIUMINT UNSIGNED NOT NULL, time VARCHAR(50) NOT NULL, addition VARCHAR(" + this.getMaxAdditionLength() + ") NOT NULL, KEY (movieid));";
    }

    protected String getSQLCreateTaglines() {
        return "CREATE TABLE taglines (movieid MEDIUMINT UNSIGNED NOT NULL, taglinetext TEXT, KEY (movieid));";
    }

    protected String getSQLCreateTechnical() {
        return "CREATE TABLE technical (movieid MEDIUMINT UNSIGNED NOT NULL, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, KEY (movieid), KEY name(name(15)));";
    }

    public String getSQLCreateTemporaryTableActorsDirectorsProducers(String string, String string2) {
        return "CREATE " + this.getSQLMetaTemporaryTable() + " " + string + " (name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, " + string2 + " MEDIUMINT(8) UNSIGNED NOT NULL);";
    }

    public String getSQLCreateTemporaryTableMovieAndReleasedates(String string) {
        return "CREATE " + this.getSQLMetaTemporaryTable() + " " + string + " (title VARCHAR(" + this.getMaxTitleLength() + ") NOT NULL, movieid MEDIUMINT(8) UNSIGNED NOT NULL, year VARCHAR(100));";
    }

    protected String getSQLCreateTrivia() {
        return "CREATE TABLE trivia (movieid MEDIUMINT UNSIGNED NOT NULL, triviatext TEXT, KEY (movieid));";
    }

    protected String getSQLCreateUsrMLItems() {
        return "CREATE TABLE usr_ml_items (itemid MEDIUMINT UNSIGNED NOT NULL, movieid MEDIUMINT UNSIGNED, itemtitle VARCHAR(" + this.getMaxTitleLength() + ") NOT NULL, healeditemtitle VARCHAR(" + this.getMaxTitleLength() + ") );";
    }

    protected String getSQLCreateWriters() {
        return "CREATE TABLE writers (writerid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, name VARCHAR(" + this.getMaxNameLength() + ") NOT NULL, PRIMARY KEY (writerid), KEY name (name(10)));";
    }

    protected String getSQLDeleteTableEntry(String string, String string2, String string3, int n) {
        return "DELETE FROM " + string + " WHERE " + string2 + " " + string3 + " " + n + ";";
    }

    protected String getSQLDeleteTableEntry(String string, String string2, String string3, String string4) {
        return "DELETE FROM " + string + " WHERE " + string2 + " " + string3 + " '" + string4 + "';";
    }

    protected String getSQLDropDatabase(String string) {
        return "DROP DATABASE " + string + ";";
    }

    public String getSQLDropTable(String string) {
        return "DROP TABLE " + string + ";";
    }

    public String getSQLExcludeEpisodes(String string) {
        return " NOT (" + string + " " + this.getSQLMetaLikeCaseInsensitive() + " '\"%}')";
    }

    protected String getSQLInsertIntoActors() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + " INTO actors (name, sex) VALUES (?,?)";
    }

    protected String getSQLInsertIntoAKANames() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO akanames (name, akaname, addition) VALUES (?,?,?)";
    }

    protected String getSQLInsertIntoAKATitles() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO akatitles (movieid, language, title, addition) VALUES (?,?,?,?)";
    }

    protected String getSQLInsertIntoAlternateVersions() {
        return "INSERT INTO altversions (movieid, versiontext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoBiographies() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO biographies (name, biotext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoBusiness() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO business (movieid, businesstext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoCertificates() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO certificates (movieid, country, certification, addition) VALUES (?,?,?,?)";
    }

    protected String getSQLInsertIntoCinematographers() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO cinematgrs (name) VALUES (?)";
    }

    protected String getSQLInsertIntoColorinfo() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO colorinfo (movieid, color) VALUES (?,?)";
    }

    protected String getSQLInsertIntoComposers() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO composers (name) VALUES (?)";
    }

    protected String getSQLInsertIntoCostumeDesigners() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO costdesigners (name) VALUES (?)";
    }

    protected String getSQLInsertIntoCountries() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO countries (movieid, country) VALUES (?,?)";
    }

    protected String getSQLInsertIntoCrazyCredits() {
        return "INSERT INTO crazycredits (movieid, credittext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoDirectors() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO directors (name) VALUES (?)";
    }

    protected String getSQLInsertIntoDistributors() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO distributors (movieid, name) VALUES (?,?)";
    }

    protected String getSQLInsertIntoEditors() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO editors (name) VALUES (?)";
    }

    protected String getSQLInsertIntoGenres() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO genres (movieid, genre) VALUES (?,?)";
    }

    protected String getSQLInsertIntoGoofs() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO goofs (movieid, gooftext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoKeywords() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO keywords (movieid, keyword) VALUES (?,?)";
    }

    protected String getSQLInsertIntoLanguage() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO language (movieid, language) VALUES (?,?)";
    }

    protected String getSQLInsertIntoLiterature() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO literature (movieid, literaturetext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoLocations() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO locations (movieid, location) VALUES (?,?)";
    }

    protected String getSQLInsertIntoMiscellaneous() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO misc (name) VALUES (?)";
    }

    protected String getSQLInsertIntoMovieLinks() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO movielinks (movieid, movielinkstext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoMovies() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO movies (title, year, imdbid) VALUES (?,?,?)";
    }

    protected String getSQLInsertIntoMovies2Actors() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO movies2actors (movieid, actorid, as_character) VALUES (?,?,?)";
    }

    protected String getSQLInsertIntoMovies2Cinematographers() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO movies2cinematgrs (movieid, cinematid, addition) values (?,?,?)";
    }

    protected String getSQLInsertIntoMovies2Composers() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO movies2composers (movieid, composerid, addition) values (?,?,?)";
    }

    protected String getSQLInsertIntoMovies2CostumeDesigners() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO movies2costdes (movieid, costdesid, addition) values (?,?,?)";
    }

    protected String getSQLInsertIntoMovies2Directors() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO movies2directors (movieid, directorid, addition) VALUES (?,?,?)";
    }

    protected String getSQLInsertIntoMovies2Editors() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO movies2editors (movieid, editorid, addition) values (?,?,?)";
    }

    protected String getSQLInsertIntoMovies2Miscellaneous() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO movies2misc (movieid, miscid, addition) values (?,?,?)";
    }

    protected String getSQLInsertIntoMovies2Producers() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO movies2producers (movieid, producerid, addition) values (?,?,?)";
    }

    protected String getSQLInsertIntoMovies2ProductionDesigners() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO movies2proddes (movieid, proddesid, addition) values (?,?,?)";
    }

    protected String getSQLInsertIntoMovies2Writers() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO movies2writers (movieid, writerid, addition) values (?,?,?)";
    }

    protected String getSQLInsertIntoMPAARatingsReasons() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO mpaaratings (movieid, reasontext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoPlots() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO plots (movieid, plottext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoProducers() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO producers (name) VALUES (?)";
    }

    protected String getSQLInsertIntoProductionCompanies() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO prodcompanies (movieid, name) VALUES (?,?)";
    }

    protected String getSQLInsertIntoProductionDesigners() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO proddesigners (name) VALUES (?)";
    }

    protected String getSQLInsertIntoQuotes() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO quotes (movieid, quotetext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoRatings() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO ratings (movieid, rank, votes, distribution) VALUES (?,?,?,?)";
    }

    protected String getSQLInsertIntoReleasedates() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO releasedates (movieid, country, imdbdate, releasedate, addition) VALUES (?,?,?,?,?)";
    }

    protected String getSQLInsertIntoRunningtimes() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO runningtimes (movieid, time, addition) VALUES (?,?,?)";
    }

    protected String getSQLInsertIntoTaglines() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO taglines (movieid, taglinetext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoTechnical() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO technical (movieid, name) VALUES (?,?)";
    }

    protected String getSQLInsertIntoTrivia() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO trivia (movieid, triviatext) VALUES (?,?)";
    }

    protected String getSQLInsertIntoUsrMLItems() {
        return "INSERT INTO usr_ml_items (itemid, movieid, itemtitle, healeditemtitle) VALUES (?, ?, ?, ?)";
    }

    protected String getSQLInsertIntoWriters() {
        return "INSERT " + this.getSQLMetaInsertIntoOption() + "INTO writers (name) VALUES (?)";
    }

    public String getSQLMetaConcat(String string, String string2) {
        return new String("CONCAT(" + string + ", " + string2 + ")");
    }

    public String getSQLMetaControlDB() {
        return null;
    }

    public String getSQLMetaDayOfMonthFromDate(String string) {
        return "DAYOFMONTH(" + string + ")";
    }

    protected String getSQLMetaInsertIntoOption() {
        return "";
    }

    public String getSQLMetaLikeCaseInsensitive() {
        return "LIKE";
    }

    public String getSQLMetaLimit(int n, int n2) {
        return "LIMIT " + n + "," + n2;
    }

    public String getSQLMetaMonthFromDate(String string) {
        return "MONTH(" + string + ")";
    }

    public String getSQLMetaNotNullValue(String string, String string2) {
        return new String("IFNULL(" + string + ", " + string2 + ")");
    }

    public String getSQLMetaRegExp() {
        return "REGEXP";
    }

    public String getSQLMetaShowDatabases() {
        return new String("SHOW DATABASES;");
    }

    public String getSQLMetaShowIndexes(String string) {
        return new String("SHOW INDEX FROM " + string + ";");
    }

    public String getSQLMetaShowTables() {
        return new String("SHOW TABLES;");
    }

    public String getSQLMetaTemporaryTable() {
        return "TEMPORARY TABLE";
    }

    public String getSQLMetaTextSearch(String string) {
        return "MATCH " + string + " AGAINST (? IN BOOLEAN MODE)";
    }

    public char getSQLMetaTextSearchDefaultOperationChar() {
        return ' ';
    }

    public char[] getSQLMetaTextSearchOperationChars() {
        char[] cArray = new char[]{'-', '+', ' '};
        return cArray;
    }

    public String getSQLMetaYearFromDate(String string) {
        return "YEAR(" + string + ")";
    }

    protected String getSQLSelectLowestActressesID() {
        return "SELECT min(actorid) FROM actors WHERE sex='F';";
    }

    public boolean isSQLMetaCreateTableCanCreateIndex() {
        return true;
    }

    public boolean isSQLMetaLimitSupported() {
        return true;
    }

    public boolean isSQLMetaListIndexesSupported() {
        return true;
    }

    public boolean isSQLMetaTextSearchSupported() {
        return true;
    }
}

