/*
 * Decompiled with CFR 0.152.
 */
package jmdb.database;

import java.awt.Component;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import jmdb.base.JMDBMain;

public class JDBCAdapter
extends AbstractTableModel {
    Connection connection;
    Statement statement;
    PreparedStatement preparedStatement;
    public ResultSet resultSet;
    String[] columnNames = new String[0];
    Vector rows = new Vector();
    ResultSetMetaData metaData;
    public int columnCount;
    public int rowCount;
    private static ResourceBundle resMessagesBundle = ResourceBundle.getBundle("languages/MessagesBundle");
    private int debugMode = 0;
    private int errorCount = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public JDBCAdapter(String string, String string2, String string3, String string4) {
        try {
            Class.forName(string2);
            if (string.indexOf("?") == -1) {
                this.connection = DriverManager.getConnection(string, string3, string4);
            } else {
                if (string3 != "" && string.indexOf("user=") == -1) {
                    string = String.valueOf(string) + "&user=" + string3 + "&password=" + string4;
                }
                this.connection = DriverManager.getConnection(string);
            }
            this.statement = this.connection.createStatement();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("jmdb.database.JDBCAdapter.JDBCAdapter() - Cannot find the database driver classes: " + classNotFoundException);
            System.err.println(classNotFoundException);
            JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter.JDBCAdapter() - Cannot find the database driver classes: " + classNotFoundException);
        }
        catch (SQLException sQLException) {
            System.err.println("jmdb.database.JDBCAdapter.JDBCAdapter() - Cannot connect to this database: " + sQLException);
            System.err.println(sQLException);
            JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter.JDBCAdapter() - Cannot connect to this database: " + sQLException);
        }
    }

    public void close() throws SQLException {
        try {
            if (this.isResultSet()) {
                this.resultSet.close();
            }
            if (this.isStatement()) {
                this.statement.close();
            }
            if (this.isPreparedStatement()) {
                this.preparedStatement.close();
            }
            if (this.isConnection()) {
                this.connection.close();
            }
        }
        catch (NullPointerException nullPointerException) {
            JMDBMain.myJMDBMain.log("NullPointerExceptionSQLException in jmdb.database.JDBCAdapter.close(): " + nullPointerException);
            System.out.println("NullPointerExceptionSQLException in jmdb.database.JDBCAdapter.close(): " + nullPointerException);
        }
    }

    public void closedb() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            JMDBMain.myJMDBMain.log("SQLException in jmdb.database.JDBCAdapter.closedb(): " + sQLException);
            System.out.println("SQLException in jmdb.database.JDBCAdapter.closedb(): " + sQLException);
        }
    }

    public void closePreparedStatement() {
        if (this.preparedStatement != null) {
            try {
                this.preparedStatement.close();
            }
            catch (SQLException sQLException) {
                JMDBMain.myJMDBMain.log("Error closing preparedStatement in jmdb.database.JDBCAdapter().closePreparedStatement(): " + sQLException);
            }
        }
    }

    public String dbRepresentation(int n, Object object) {
        int n2;
        if (object == null) {
            return "null";
        }
        try {
            n2 = this.metaData.getColumnType(n + 1);
        }
        catch (SQLException sQLException) {
            return object.toString();
        }
        switch (n2) {
            case 4: 
            case 6: 
            case 8: {
                return object.toString();
            }
            case -7: {
                return (Boolean)object != false ? "1" : "0";
            }
            case 91: {
                return object.toString();
            }
        }
        return "\"" + object.toString() + "\"";
    }

    public boolean executeCommand(String string) {
        boolean bl = false;
        if (this.connection == null || this.statement == null || string == null) {
            System.err.println("jmdb.database.JDBCAdapter.executeCommand(): There is no database connection/statement/query to execute.");
            return bl;
        }
        try {
            try {
                this.statement.execute(string);
                this.fireTableChanged(null);
                bl = true;
            }
            catch (SQLException sQLException) {
                System.err.println("SQLException in jmdb.database.JDBCAdapter.executeCommand(String): " + sQLException);
                JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executeCommand(String): " + sQLException);
                bl = false;
            }
        }
        catch (Throwable throwable) {}
        return bl;
    }

    public void executePreparedBatch() {
        if (this.connection == null || this.preparedStatement == null) {
            System.err.println("jmdb.database.JDBCAdapter.executePreparedBatch(): There is no database to execute the sql command or the prepared statement is null.");
            return;
        }
        try {
            this.preparedStatement.executeBatch();
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
            JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedBatch(): " + sQLException);
            JMDBMain.myJMDBMain.log("The preparedStatement showing the error: " + this.getPreparedStatement().toString());
            if (this.errorCount == 0) {
                if (JMDBMain.isAppLogTemporarilyDisabled()) {
                    JMDBMain.setAppLogTemporarilyDisabled(false);
                    JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedBatch(): Logging enabled again as the errorCount was 0!");
                }
                this.setDebugMode(1);
            } else if (this.errorCount > 9) {
                this.setDebugMode(0);
                JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedBatch(): Logging temporarily disabled due to several errors!");
                JMDBMain.setAppLogTemporarilyDisabled(true);
            }
            ++this.errorCount;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void executePreparedCommand(String[] var1_1, int[] var2_2) {
        block15: {
            if (this.connection == null || this.statement == null) {
                System.err.println("jmdb.database.JDBCAdapter.executePreparedCommand(String[], int[]): There is no database to execute the query or the statement is null.");
                return;
            }
            try {
                var3_3 = 0;
                while (var3_3 < var1_1.length) {
                    if (var1_1[var3_3] != null) {
                        this.preparedStatement.setString(var3_3 + 1, var1_1[var3_3]);
                    } else if (var2_2[var3_3] != 0) {
                        this.preparedStatement.setInt(var3_3 + 1, var2_2[var3_3]);
                    } else {
                        this.preparedStatement.setString(var3_3 + 1, null);
                    }
                    ++var3_3;
                }
                this.preparedStatement.execute();
                break block15;
            }
            catch (SQLException var3_4) {
                System.out.println(var3_4);
                JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(String[], int[]): " + var3_4);
                if (this.errorCount == 0) {
                    if (JMDBMain.isAppLogTemporarilyDisabled()) {
                        JMDBMain.setAppLogTemporarilyDisabled(false);
                        JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(String[], int[]): Logging enabled again as the errorCount was 0!");
                    }
                    this.setDebugMode(1);
                } else if (this.errorCount > 9) {
                    this.setDebugMode(0);
                    JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(String[], int[]): Logging temporarily disabled due to several errors!");
                    JMDBMain.setAppLogTemporarilyDisabled(true);
                }
                ++this.errorCount;
                if (this.getDebugMode() <= 0) break block15;
                var4_5 = 0;
                ** while (var4_5 < var1_1.length)
            }
lbl-1000:
            // 1 sources

            {
                if (var1_1[var4_5] != null) {
                    JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(String[], int[]): String[" + var4_5 + "] = " + var1_1[var4_5].toString());
                } else {
                    JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(String[], int[]): int[" + var4_5 + "]    = " + var2_2[var4_5]);
                }
                ++var4_5;
                continue;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void executePreparedCommand(String[] var1_1, int[] var2_2, int var3_3) {
        block17: {
            if (this.connection == null || this.statement == null) {
                System.err.println("jmdb.database.JDBCAdapter.executePreparedCommand(String[], int[], int): There is no database to execute the query or the statement is null.");
                return;
            }
            try {
                var4_4 = 0;
                while (var4_4 < var1_1.length) {
                    if (var1_1[var4_4] != null) {
                        if (var3_3 == var4_4) {
                            this.preparedStatement.setDate(var4_4 + 1, Date.valueOf(var1_1[var4_4]));
                        } else {
                            this.preparedStatement.setString(var4_4 + 1, var1_1[var4_4]);
                        }
                    } else if (var2_2[var4_4] != 0) {
                        this.preparedStatement.setInt(var4_4 + 1, var2_2[var4_4]);
                    } else {
                        this.preparedStatement.setString(var4_4 + 1, null);
                    }
                    ++var4_4;
                }
                this.preparedStatement.execute();
                break block17;
            }
            catch (SQLException var4_5) {
                System.out.println(var4_5);
                JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(String[], int[], int): " + var4_5);
                if (this.errorCount == 0) {
                    if (JMDBMain.isAppLogTemporarilyDisabled()) {
                        JMDBMain.setAppLogTemporarilyDisabled(false);
                        JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(String[], int[], int): Logging enabled again as the errorCount was 0!");
                    }
                    this.setDebugMode(1);
                } else if (this.errorCount > 9) {
                    this.setDebugMode(0);
                    JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(String[], int[], int): Logging temporarily disabled due to several errors!");
                    JMDBMain.setAppLogTemporarilyDisabled(true);
                }
                ++this.errorCount;
                if (this.getDebugMode() <= 0) break block17;
                var5_6 = 0;
                ** while (var5_6 < var1_1.length)
            }
lbl-1000:
            // 1 sources

            {
                if (var1_1[var5_6] != null) {
                    JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(String[], int[], int): String[" + var5_6 + "] = " + var1_1[var5_6].toString());
                } else {
                    JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(String[], int[], int): int[" + var5_6 + "]    = " + var2_2[var5_6]);
                }
                ++var5_6;
                continue;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void executePreparedCommand(String var1_1, String[] var2_2, int[] var3_3) {
        block13: {
            if (this.connection == null || var1_1 == null || var1_1.length() == 0) {
                System.err.println("jmdb.database.JDBCAdapter.executePreparedCommand(): There is no database to execute the query or there is no preparedCommand to use.");
                return;
            }
            try {
                this.preparedStatement = this.connection.prepareStatement(var1_1);
                var4_4 = 0;
                while (var4_4 < var2_2.length) {
                    if (var2_2[var4_4] != null) {
                        this.preparedStatement.setString(var4_4 + 1, var2_2[var4_4]);
                    } else {
                        this.preparedStatement.setInt(var4_4 + 1, var3_3[var4_4]);
                    }
                    ++var4_4;
                }
                this.preparedStatement.execute();
                break block13;
            }
            catch (SQLException var4_5) {
                System.out.println(var4_5);
                JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(String, String[], int[]): " + var4_5);
                if (this.errorCount == 0) {
                    if (JMDBMain.isAppLogTemporarilyDisabled()) {
                        JMDBMain.setAppLogTemporarilyDisabled(false);
                        JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(String, String[], int[]): Logging enabled again as the errorCount was 0!");
                    }
                    this.setDebugMode(1);
                } else if (this.errorCount > 9) {
                    this.setDebugMode(0);
                    JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(String, String[], int[]): Logging temporarily disabled due to several errors!");
                    JMDBMain.setAppLogTemporarilyDisabled(true);
                }
                ++this.errorCount;
                if (this.getDebugMode() <= 0) break block13;
                JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(String, String[], int[]): SQL command = " + var1_1);
                var5_6 = 0;
                ** while (var5_6 < var2_2.length)
            }
lbl-1000:
            // 1 sources

            {
                if (var2_2[var5_6] != null) {
                    JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(String, String[], int[]): String[" + var5_6 + "] = " + var2_2[var5_6].toString());
                } else {
                    JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(String, String[], int[]): int[" + var5_6 + "]    = " + var3_3[var5_6]);
                }
                ++var5_6;
                continue;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executePreparedCommand(List var1_1, List var2_2) {
        block21: {
            if (this.connection == null || this.statement == null) {
                System.err.println("jmdb.database.JDBCAdapter.executePreparedCommand(int, List): There is no database to execute the query or the statement is null.");
                return;
            }
            var3_3 = new StringBuffer();
            try {
                try {
                    if (var1_1.isEmpty()) {
                        JMDBMain.myJMDBMain.log("Error found...'empty' primaryKeyList, no processing done!");
                    }
                    if (var2_2.isEmpty()) {
                        JMDBMain.myJMDBMain.log("Error found...'empty' dataList, no processing done!");
                    }
                    var5_4 = "INSERT INTO keywords (movieid, keyword) VALUES ";
                    var6_7 = 2;
                    var7_10 = 0;
                    block7: while (true) {
                        block22: {
                            if (var7_10 < var2_2.size()) break block22;
                            var3_3.replace(var3_3.length() - 1, var3_3.length(), "");
                            this.setPreparedStatement(String.valueOf(var5_4) + var3_3.toString().trim() + ";");
                            var7_10 = 1;
                            var8_11 = 0;
                            if (true) ** GOTO lbl71
                        }
                        var3_3.append(" (");
                        var8_11 = 0;
                        while (true) {
                            if (var8_11 >= var6_7) {
                                var3_3.replace(var3_3.length() - 2, var3_3.length(), "");
                                var3_3.append("),");
                                ++var7_10;
                                continue block7;
                            }
                            var3_3.append("?, ");
                            ++var8_11;
                        }
                        break;
                    }
                }
                catch (SQLException var5_5) {
                    System.out.println(var5_5);
                    JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(List, List): " + var5_5);
                    if (this.errorCount == 0) {
                        if (JMDBMain.isAppLogTemporarilyDisabled()) {
                            JMDBMain.setAppLogTemporarilyDisabled(false);
                            JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(List, List): Logging enabled again as the errorCount was 0!");
                        }
                        this.setDebugMode(1);
                    } else if (this.errorCount > 9) {
                        this.setDebugMode(0);
                        JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(List, List): Logging temporarily disabled due to several errors!");
                        JMDBMain.setAppLogTemporarilyDisabled(true);
                    }
                    ++this.errorCount;
                    if (this.getDebugMode() <= 0) break block21;
                    var6_7 = 0;
                    if (true) ** GOTO lbl81
                }
            }
            catch (Throwable var5_6) {
                var4_12 = null;
                var3_3 = null;
                if (this.preparedStatement == null) throw var5_6;
                try {
                    this.preparedStatement.close();
                    throw var5_6;
                }
                catch (SQLException var6_8) {
                    JMDBMain.myJMDBMain.log("Error closing preparedStatement in jmdb.database.JDBCAdapter().executePreparedCommand(List, List): " + var6_8);
                }
                throw var5_6;
            }
            do {
                this.preparedStatement.setInt(var7_10, (Integer)var1_1.get(var8_11));
                this.preparedStatement.setString(var7_10 + 1, var2_2.get(var8_11).toString());
                var7_10 += var6_7;
                ++var8_11;
lbl71:
                // 2 sources

            } while (var8_11 < var2_2.size());
            this.preparedStatement.execute();
            break block21;
            do {
                if (var2_2.get(var6_7).toString() != null) {
                    JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(List, List): List[" + var6_7 + "] = " + var2_2.get(var6_7).toString());
                } else {
                    JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedCommand(List, List): int    = " + var1_1.get(var6_7));
                }
                ++var6_7;
lbl81:
                // 2 sources

            } while (var6_7 < var2_2.size());
        }
        var4_13 = null;
        var3_3 = null;
        if (this.preparedStatement == null) return;
        try {}
        catch (SQLException var6_9) {
            JMDBMain.myJMDBMain.log("Error closing preparedStatement in jmdb.database.JDBCAdapter().executePreparedCommand(List, List): " + var6_9);
            return;
        }
        this.preparedStatement.close();
    }

    public void executePreparedQuery(String[] stringArray, int[] nArray) {
        if (this.connection == null || this.statement == null) {
            System.err.println("jmdb.database.JDBCAdapter.executePreparedQuery(): There is no database to execute the query or the statement is null.");
            return;
        }
        try {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    this.preparedStatement.setString(n + 1, stringArray[n]);
                } else {
                    this.preparedStatement.setInt(n + 1, nArray[n]);
                }
                ++n;
            }
            this.resultSet = this.preparedStatement.executeQuery();
            this.metaData = this.resultSet.getMetaData();
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
            JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedQuery(String[], int[]): " + sQLException);
        }
    }

    public void executePreparedQuery(String string, String[] stringArray, int[] nArray) {
        if (this.connection == null || string == null || string.length() == 0) {
            System.err.println("jmdb.database.JDBCAdapter.executePreparedQuery(): There is no database to execute the query or there is no queryStatement to use.");
            return;
        }
        try {
            this.preparedStatement = this.connection.prepareStatement(string);
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    this.preparedStatement.setString(n + 1, stringArray[n]);
                } else {
                    this.preparedStatement.setInt(n + 1, nArray[n]);
                }
                ++n;
            }
            this.resultSet = this.preparedStatement.executeQuery();
            this.metaData = this.resultSet.getMetaData();
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
            JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executePreparedQuery(String, String[], int[]): " + sQLException);
        }
    }

    public void executeQuery(String string) {
        if (this.connection == null || this.statement == null || string == null || string.length() == 0) {
            System.err.println("jmdb.database.JDBCAdapter.executeQuery(): There is no database to execute the query, the statement is null or there is no queryStatement to use.");
            return;
        }
        try {
            this.resultSet = this.statement.executeQuery(string);
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException);
            JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executeQuery(String): " + sQLException);
        }
    }

    public boolean executeQuery(String string, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.connection == null || this.statement == null || string == null || string.length() == 0 || defaultMutableTreeNode == null) {
            System.err.println("jmdb.database.JDBCAdapter.executeQuery(): There is no database to execute the query, the statment is null,there is no queryStatement to use or treeNode is null.");
            return false;
        }
        try {
            this.resultSet = this.statement.executeQuery(string);
            this.metaData = this.resultSet.getMetaData();
            while (this.resultSet.next()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.resultSet.getString(1)));
            }
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException);
            JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executeQuery(String, DefaultMutableTreeNode): " + sQLException);
        }
        return true;
    }

    public int executeUpdate(String string) {
        int n;
        block5: {
            n = -1;
            try {
                try {
                    if (this.connection == null || this.statement == null || string == null || string.length() == 0) {
                        System.err.println("jmdb.database.JDBCAdapter.executeUpdate(String): There is no database to execute the update or there is no sqlUpdate to use.");
                        break block5;
                    }
                    n = this.statement.executeUpdate(string);
                    this.fireTableChanged(null);
                }
                catch (SQLException sQLException) {
                    System.err.println(sQLException);
                    JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().executeUpdate(String): " + sQLException);
                }
            }
            catch (Throwable throwable) {}
        }
        return n;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public Class getColumnClass(int n) {
        int n2;
        try {
            n2 = this.metaData.getColumnType(n + 1);
        }
        catch (SQLException sQLException) {
            return super.getColumnClass(n);
        }
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case -7: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case -6: 
            case 4: 
            case 5: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case -5: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 6: 
            case 8: {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 91: {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("java.sql.Date");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
        }
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        if (this.columnNames[n] != null) {
            return this.columnNames[n];
        }
        return "";
    }

    public Connection getConnection() {
        return this.connection;
    }

    private int getDebugMode() {
        return this.debugMode;
    }

    public PreparedStatement getPreparedStatement() {
        return this.preparedStatement;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getValueAt(int n, int n2) {
        Vector vector = (Vector)this.rows.elementAt(n);
        return vector.elementAt(n2);
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public boolean isConnection() {
        return this.connection != null;
    }

    public boolean isPreparedStatement() {
        return this.preparedStatement != null;
    }

    public boolean isResultSet() {
        return this.resultSet != null;
    }

    public boolean isStatement() {
        return this.statement != null;
    }

    public boolean preparedQuery(String string, String[] stringArray, int[] nArray, JList jList) {
        this.setPreparedStatement(string);
        this.executePreparedQuery(stringArray, nArray);
        try {
            int n = 0;
            this.resultSet.last();
            String[] stringArray2 = new String[this.resultSet.getRow()];
            this.resultSet.beforeFirst();
            while (this.resultSet.next()) {
                stringArray2[n++] = new String(this.resultSet.getString(1));
            }
            jList.setListData(stringArray2);
        }
        catch (SQLException sQLException) {
            JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().preparedQuery(String, String[], int[], JList): " + sQLException);
            System.out.println("SQLException in jmdb.database.JDBCAdaper.preparedQuery(String, String[], int[], JList): " + sQLException);
        }
        return true;
    }

    public boolean preparedQuery(String string, String[] stringArray, int[] nArray, DefaultMutableTreeNode defaultMutableTreeNode) {
        this.setPreparedStatement(string);
        this.executePreparedQuery(stringArray, nArray);
        try {
            while (this.resultSet.next()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.resultSet.getString(1)));
            }
        }
        catch (SQLException sQLException) {
            JMDBMain.myJMDBMain.log("jmdb.database.JDBCAdapter().preparedQuery(String, String[], int[], DefaultMutableTreeNode): " + sQLException);
            System.out.println("SQLException in jmdb.database.JDBCAdaper.preparedQuery(String, String[], int[], DefaultMutableTreeNode): " + sQLException);
        }
        return true;
    }

    public void setDebugMode(int n) {
        this.debugMode = n;
    }

    public void setErrorCount(int n) {
        this.errorCount = n;
    }

    public void setPreparedStatement(String string) {
        if (this.connection == null || string == null || string.length() == 0) {
            System.err.println("jmdb.database.JDBCAdapter.setPreparedStatement(): There is no database to execute the query or there is not preparedQuery to use.");
            return;
        }
        try {
            this.preparedStatement = this.connection.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
        }
    }

    void setPreparedStatement(PreparedStatement preparedStatement) {
        this.preparedStatement = preparedStatement;
    }

    public void setValueAt(Object object, int n, int n2) {
        Object object2;
        try {
            object2 = this.metaData.getTableName(n2 + 1);
            if (object2 == null) {
                System.out.println("Table name returned null.");
            }
            String string = this.getColumnName(n2);
            String string2 = "update " + (String)object2 + " set " + string + " = " + this.dbRepresentation(n2, object) + " where ";
            int n3 = 0;
            while (n3 < this.getColumnCount()) {
                String string3 = this.getColumnName(n3);
                if (!string3.equals("")) {
                    if (n3 != 0) {
                        string2 = String.valueOf(string2) + " and ";
                    }
                    string2 = String.valueOf(string2) + string3 + " = " + this.dbRepresentation(n3, this.getValueAt(n, n3));
                }
                ++n3;
            }
            System.out.println(string2);
            System.out.println("Not sending update to database");
        }
        catch (SQLException sQLException) {
            System.err.println("Update failed");
        }
        object2 = (Vector)this.rows.elementAt(n);
        ((Vector)object2).setElementAt(object, n2);
    }

    public void showConnectionErrorMessageDialog(Component component) {
        JOptionPane.showMessageDialog(component, resMessagesBundle.getString("JDBCAdapter.dialogWindow.showConnectionErrorMessage.message"), resMessagesBundle.getString("JDBCAdapter.dialogWindow.showConnectionErrorMessage.title"), 0);
    }

    public void showConnectionErrorMessageDialog(Component component, String string) {
        JOptionPane.showMessageDialog(component, string, resMessagesBundle.getString("JDBCAdapter.dialogWindow.showConnectionErrorMessage.title"), 0);
    }
}

