/*
 * Decompiled with CFR 0.152.
 */
package jmdb.database;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;

abstract class DataImport {
    public BufferedReader bufferedReader;
    public String line;
    public StringBuffer dataString = new StringBuffer();
    public String[] resArray;
    public int skipLines;
    private int errorCode = 0;
    private String errorLine = new String();

    public DataImport(String string, String string2, int n) {
        if (string == null) {
            string = "";
        }
        this.skipLines = n;
        boolean bl = false;
        try {
            InputStreamReader inputStreamReader;
            String string3 = String.valueOf(string) + ".list";
            if (new File(string3).canRead()) {
                bl = true;
                inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string3), "ISO8859_1");
                this.bufferedReader = new BufferedReader(inputStreamReader);
            } else {
                string3 = String.valueOf(string) + ".list.gz";
                if (new File(string3).canRead()) {
                    bl = true;
                    inputStreamReader = new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(string3)), "ISO8859_1");
                    this.bufferedReader = new BufferedReader(inputStreamReader);
                }
            }
            if (bl) {
                if (string2 != null) {
                    this.line = this.bufferedReader.readLine().trim();
                    while (this.line != null && !this.line.equals(string2)) {
                        this.line = this.bufferedReader.readLine();
                    }
                    int n2 = 0;
                    while (n2 < this.skipLines) {
                        if (this.line != null) {
                            this.line = this.bufferedReader.readLine();
                        }
                        ++n2;
                    }
                }
            } else {
                System.out.println("file ('" + string + ".list / .list.gz') not found...");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found or unknown file format.");
        }
        catch (IOException iOException) {
            System.out.println("File not found or unknown file format.");
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            this.bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Error closing file.");
        }
    }

    public abstract boolean getData();

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorLine() {
        return this.errorLine;
    }

    public String getErrorMessage() {
        if (this.getErrorCode() == 0) {
            return "No error!";
        }
        if (this.getErrorCode() == 1) {
            return "Data Format not correct or changed (IMDb - FormatError)!";
        }
        if (this.getErrorCode() == 2) {
            return "Data Format not correct (NullPointerException)!";
        }
        if (this.getErrorCode() == 3) {
            return "Data read/write error (IOException)!";
        }
        if (this.getErrorCode() == 99) {
            return "Unknown Error!";
        }
        return "No error message for error code (" + this.getErrorCode() + ")!";
    }

    /*
     * Unable to fully structure code
     */
    public String ltrim(String var1_1) {
        if (var1_1 == null) {
            return "";
        }
        if (!var1_1.trim().equals("")) ** GOTO lbl6
        return "";
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.substring(1);
lbl6:
            // 2 sources

            ** while (var1_1.charAt((int)0) == ' ')
        }
lbl7:
        // 1 sources

        return var1_1;
    }

    public String replaceInlineLink(String string, String string2) {
        String string3 = "#http://www.IMDb.com/title/tt";
        if (string2.indexOf("tt") == -1) {
            string3 = "#http://www.IMDb.com/name/nm";
        }
        if (string != null) {
            int n = -1;
            int n2 = -1;
            while (string.indexOf(string2) != -1) {
                n = string.indexOf(string2);
                n2 = -1;
                int n3 = n;
                while (n3 < string.length()) {
                    if (string.indexOf("##", n3) > n + 2) {
                        n2 = string.indexOf("##", n3);
                        break;
                    }
                    if (string.indexOf("##", n3) == -1) break;
                    ++n3;
                }
                if (n2 <= n) continue;
                string = String.valueOf(string.substring(0, n)) + string3 + string.substring(n + string2.length(), n2) + "/#" + string.substring(n2 + 2);
            }
        }
        return string;
    }

    public void resetErrorStatus() {
        this.setErrorCode(0);
        this.setErrorLine(new String());
    }

    public String rtrim(String string) {
        if (string == null) {
            return "";
        }
        if (string.trim().equals("")) {
            return "";
        }
        int n = string.length();
        while (string.charAt(n - 1) == ' ') {
            string = string.substring(0, n - 1);
            --n;
        }
        return string;
    }

    public void setErrorCode(int n) {
        this.errorCode = n;
    }

    public void setErrorLine(String string) {
        this.errorLine = string;
    }

    public String subString(String string, int n, int n2) {
        if (n >= string.length()) {
            return new String("");
        }
        if (n2 > string.length()) {
            n2 = string.length();
        }
        return string.substring(n, n2);
    }
}

