/*
 * Decompiled with CFR 0.152.
 */
package jmdb.database;

import java.io.File;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import jmdb.base.JMDBMain;
import jmdb.database.DataBaseConverter2;
import jmdb.database.DataImportType1;
import jmdb.database.DataImportType10;
import jmdb.database.DataImportType11;
import jmdb.database.DataImportType12;
import jmdb.database.DataImportType13;
import jmdb.database.DataImportType14;
import jmdb.database.DataImportType15;
import jmdb.database.DataImportType16;
import jmdb.database.DataImportType1_CountEntries;
import jmdb.database.DataImportType2;
import jmdb.database.DataImportType3;
import jmdb.database.DataImportType4;
import jmdb.database.DataImportType5;
import jmdb.database.DataImportType6;
import jmdb.database.DataImportType7;
import jmdb.database.DataImportType8;
import jmdb.database.DataImportType9;
import jmdb.database.JDBCAdapter;
import jmdb.database.SQLWorkerAbstract;
import jmdb.database.UsrDataImportType1;
import jmdb.exception.OutOfMemoryException;
import jmdb.util.ImportFile;
import jmdb.util.MovieArray;
import jmdb.util.StopWatch;

public class DataBaseConverter2Thread
extends Thread {
    private JTextPane myTextPane;
    private JLabel myStatus;
    private String myItem;
    private Document doc;
    private JProgressBar myBar;
    private DataBaseConverter2 myDataBaseConverter;
    private String commando;
    private static ResourceBundle resMessagesBundle = ResourceBundle.getBundle("languages/MessagesBundle");
    private Vector existingTables = new Vector();
    protected boolean cancelImport = false;
    private SQLWorkerAbstract sqlWorker = null;
    private static ImportFile importFile = null;
    private Vector importFileList = null;
    private MovieArray movieArray = null;
    private String okMessage = resMessagesBundle.getString("DatabaseConverter.statusmessagetext.ok");
    private String errorMessage = resMessagesBundle.getString("DatabaseConverter.statusmessagetext.error");
    private String convertingMessage = resMessagesBundle.getString("DatabaseConverter.statusmessageheading_and_text.converting");
    private String creatingTableMessage = resMessagesBundle.getString("DatabaseConverter.statusmessagetext.creatingtable");
    private String readingMessage = resMessagesBundle.getString("DatabaseConverter.statusmessagetext.reading");
    private String readMessage = resMessagesBundle.getString("DatabaseConverter.statusmessagetext.read");
    private String nowMessage = resMessagesBundle.getString("DatabaseConverter.statusmessagetext.now");
    private String connBrokenMessage = resMessagesBundle.getString("DatabaseConverter.statusmessagetext.connectionbroken");
    private String analysingTablesMessage = resMessagesBundle.getString("DatabaseConverter.statusmessagetext.analysingtables");
    private String analyseMessage = resMessagesBundle.getString("DatabaseConverter.statusmessageheading_and_text.analysing");
    private StopWatch stopWatch = null;
    private int m2x_count = 0;
    private int m2x_maxcount = 0;
    private int[] m2x_xid;
    private int[] m2x_movieid;
    private String[] m2x_addinfo;
    private int numberOfFilesToImport = 0;
    private int importCounter = 0;
    private PreparedStatement akaTitleSearchStatement = null;
    private PreparedStatement titleSearchStatement = null;

    public DataBaseConverter2Thread(DataBaseConverter2 dataBaseConverter2, JTextPane jTextPane, JLabel jLabel, JProgressBar jProgressBar, String string) {
        this.myDataBaseConverter = dataBaseConverter2;
        this.commando = string;
        this.myTextPane = jTextPane;
        this.myStatus = jLabel;
        this.myBar = jProgressBar;
        this.doc = jTextPane.getDocument();
        this.sqlWorker = DataBaseConverter2.getSQLWorker();
    }

    private void analyseDatabaseStructure(JDBCAdapter jDBCAdapter) {
        if (!this.isCancelImport() && this.getSQLWorker().getSQLMetaAnalyse() != null) {
            this.writeHeading("\n\n" + this.getAnalyseMessage());
            this.writeText("\n" + this.getAnalysingTablesMessage() + "...");
            if (jDBCAdapter.executeCommand(this.getSQLWorker().getSQLMetaAnalyse())) {
                this.writeText(this.getOkMessage());
            } else {
                this.writeText(this.getErrorMessage());
            }
            this.getStopWatch().restart("Analyse: completed");
        }
    }

    private boolean brokenConnection(JDBCAdapter jDBCAdapter) {
        boolean bl = true;
        jDBCAdapter.executeQuery(this.getSQLWorker().getSQLMetaShowTables());
        try {
            try {
                if (jDBCAdapter.resultSet.next()) {
                    bl = false;
                }
            }
            catch (SQLException sQLException) {
                JMDBMain.myJMDBMain.log("DataBaseConverter2Thread.brokenConnection() - SQLException: " + sQLException);
            }
        }
        catch (Throwable throwable) {}
        if (!this.isCancelImport() && bl) {
            this.writeText(String.valueOf(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.error")) + ": " + resMessagesBundle.getString("DatabaseConverter.statusmessagetext.connectionbroken"));
            JMDBMain.myJMDBMain.log("ERROR: Database connection broken... - DatabaseConverter2Thread canceled processing of further data");
            this.setCancelImport(bl);
        }
        return bl;
    }

    private boolean buildIndex(JDBCAdapter jDBCAdapter, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = this.getStopWatch() != null;
        this.writeText("\n" + resMessagesBundle.getString("DatabaseConverter.statusmessagetext.checkingindexes"));
        if (this.getSQLWorker().isSQLMetaListIndexesSupported()) {
            jDBCAdapter.executeQuery(this.getSQLWorker().getSQLMetaShowIndexes("movies2actors"));
            try {
                if (jDBCAdapter.resultSet.next()) {
                    bl3 = true;
                }
                this.writeText(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.ok"));
            }
            catch (SQLException sQLException) {
                JMDBMain.myJMDBMain.log("DataBaseConverter2Thread.buildIndex() - SQLException: " + sQLException);
            }
        }
        if (!bl3) {
            this.writeText("\n" + resMessagesBundle.getString("DatabaseConverter.statusmessagetext.creatingindexesformovies2actorstable"));
            this.writeText("\n" + resMessagesBundle.getString("DatabaseConverter.statusmessagetext.operationcannotbecanceled"));
            if (bl) {
                this.myBar.setValue(0);
            }
            MessageFormat messageFormat = new MessageFormat(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.createindex_xxx_onmovies2actors"));
            String[] stringArray = new String[]{"movieid"};
            this.myStatus.setText(messageFormat.format(stringArray));
            this.writeText("\n" + messageFormat.format(stringArray));
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies2actors", "movieid", 0));
            this.writeText(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.ok"));
            this.getStopWatch().restart("movies2actors: index movieid completed");
            if (bl) {
                this.myBar.setValue(50);
            }
            messageFormat = new MessageFormat(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.createindex_xxx_onmovies2actors"));
            stringArray = new String[]{"actorid"};
            this.myStatus.setText(messageFormat.format(stringArray));
            this.writeText("\n" + messageFormat.format(stringArray));
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies2actors", "actorid", 0));
            this.writeText(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.ok"));
            if (bl4) {
                this.getStopWatch().restart("movies2actors: index actorid completed");
            } else {
                this.getStopWatch().stop("movies2actors: index actorid completed");
                this.setStopWatch(null);
            }
            bl2 = true;
            if (bl) {
                this.myBar.setValue(100);
                this.myStatus.setText(resMessagesBundle.getString("JMDB.label.status_finished"));
                this.writeHeading("\n" + resMessagesBundle.getString("DatabaseConverter.statusmessageheading.finished"));
                this.myBar.setVisible(false);
            }
        }
        return bl2;
    }

    private boolean checkTableExistence(JDBCAdapter jDBCAdapter, String string) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                JMDBMain.myJMDBMain.log("DataBaseConverter2Thread.checkTableExistence() - InterruptedExcetion while leaving sleep: " + interruptedException);
            }
            jDBCAdapter.executeQuery(this.getSQLWorker().getSQLMetaShowTables());
            try {
                try {
                    String string2 = null;
                    while (jDBCAdapter.resultSet.next()) {
                        string2 = jDBCAdapter.resultSet.getString(1);
                        if (!string2.equalsIgnoreCase(string)) continue;
                        bl = true;
                        break;
                    }
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("DataBaseConverter2Thread.checkTableExistence() - SQLException: " + sQLException);
                }
            }
            catch (Throwable throwable) {}
            if (!this.isCancelImport() && !bl) {
                MessageFormat messageFormat = new MessageFormat(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.tablenotcreated"));
                String[] stringArray = new String[]{string};
                this.writeText(messageFormat.format(stringArray));
                JMDBMain.myJMDBMain.log("ERROR: Table " + string + " has not been created (connection broken)... - DatabaseConverter2Thread.checkTableExistence(JDBCAdapter, String) -  Canceled processing of further data");
                this.setCancelImport(!bl);
            }
            return bl;
        }
        return bl;
    }

    private void createIndex() {
        block13: {
            boolean bl = false;
            this.myBar.setValue(0);
            this.myBar.setVisible(true);
            this.myStatus.setText("");
            JDBCAdapter jDBCAdapter = null;
            JMDBMain.myJMDBMain.getDburl();
            String string = JMDBMain.myJMDBMain.getDbname();
            this.writeHeading(resMessagesBundle.getString("DatabaseConverter.statusmessageheading.creatingindexmovies2actors"));
            try {
                try {
                    StopWatch stopWatch = new StopWatch();
                    this.writeText("\n" + resMessagesBundle.getString("DatabaseConverter.statusmessagetext.checkingconnectiontodbserver") + " (" + DataBaseConverter2.getCfgUrl() + ")...");
                    jDBCAdapter = JMDBMain.myJMDBMain.getNewJDBCAdapter();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    this.writeText(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.ok"));
                    this.writeText("\n" + resMessagesBundle.getString("DatabaseConverter.statusmessagetext.checkingdatabases"));
                    jDBCAdapter.executeQuery(this.getSQLWorker().getSQLMetaShowDatabases());
                    try {
                        while (jDBCAdapter.resultSet.next()) {
                            if (!jDBCAdapter.resultSet.getString(1).equalsIgnoreCase(string)) continue;
                            bl2 = true;
                            break;
                        }
                        this.writeText(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.ok"));
                    }
                    catch (SQLException sQLException) {
                        JMDBMain.myJMDBMain.log("DataBaseConverter2Thread.createIndex() - SQLException: " + sQLException);
                    }
                    if (bl2) {
                        this.writeText("\n" + resMessagesBundle.getString("DatabaseConverter.statusmessagetext.checkingtables"));
                        jDBCAdapter.executeQuery(this.getSQLWorker().getSQLMetaShowTables());
                        try {
                            if (jDBCAdapter.resultSet.next()) {
                                jDBCAdapter.resultSet.getString(1).equalsIgnoreCase("movies2actors");
                                bl3 = true;
                            }
                            this.writeText(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.ok"));
                        }
                        catch (SQLException sQLException) {
                            JMDBMain.myJMDBMain.log("DataBaseConverter2Thread.createIndex() - SQLException: " + sQLException);
                        }
                    }
                    if (bl3 && !(bl = this.buildIndex(jDBCAdapter, true))) {
                        this.writeText("\n" + resMessagesBundle.getString("DatabaseConverter.statusmessagetext.indexmovies2actorsalreadyexists"));
                    }
                    stopWatch.stop("The complete index time!");
                }
                catch (NullPointerException nullPointerException) {
                    JMDBMain.myJMDBMain.log("DataBaseConverter2Thread.createIndex() - NullPointerException: " + nullPointerException);
                }
            }
            catch (Throwable throwable) {
                Object var4_11 = null;
                if (jDBCAdapter != null) {
                    jDBCAdapter.closedb();
                }
                throw throwable;
            }
            Object var4_12 = null;
            if (jDBCAdapter == null) break block13;
            jDBCAdapter.closedb();
        }
    }

    private boolean dataBaseOK() {
        String string = new String(JMDBMain.myJMDBMain.getDburl());
        String string2 = new String(JMDBMain.myJMDBMain.getDbname());
        String string3 = string;
        if (this.getSQLWorker().getSQLMetaControlDB() != null) {
            string3 = String.valueOf(string) + (string.endsWith("/") ? "" : "/") + this.getSQLWorker().getSQLMetaControlDB();
        } else if (this.getSQLWorker().isSQLMetaAutocreateDatabase() || this.getSQLWorker().isSQLMetaFileDB()) {
            string3 = DataBaseConverter2.getCfgUrl();
        }
        boolean bl = false;
        boolean bl2 = false;
        this.writeHeading("\n\n" + resMessagesBundle.getString("DatabaseConverter.statusmessageheading.checkingdbserverconnection"));
        this.writeText("\n" + resMessagesBundle.getString("DatabaseConverter.statusmessagetext.checkingconnectiontodbserver") + " (" + string3 + ")...");
        try {
            JDBCAdapter jDBCAdapter = new JDBCAdapter(string3, DataBaseConverter2.getCfgJdbcDriver(), DataBaseConverter2.getCfgUserID(), new String(DataBaseConverter2.getCfgPassword()));
            if (jDBCAdapter == null) {
                this.writeText(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.error"));
                return false;
            }
            if (!jDBCAdapter.isConnection()) {
                this.writeText(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.error"));
                return false;
            }
            this.writeText(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.ok"));
            this.writeHeading("\n\n" + resMessagesBundle.getString("DatabaseConverter.statusmessageheading.checkingdbname"));
            MessageFormat messageFormat = new MessageFormat(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.checkdbnamedoesntexist"));
            String[] stringArray = new String[]{"" + string2};
            this.writeText("\n" + messageFormat.format(stringArray));
            if (this.getSQLWorker().getSQLMetaShowDatabases() != null) {
                jDBCAdapter.executeQuery(this.getSQLWorker().getSQLMetaShowDatabases());
                while (jDBCAdapter.resultSet.next()) {
                    if (!jDBCAdapter.resultSet.getString(1).equalsIgnoreCase(string2)) continue;
                    bl2 = true;
                    break;
                }
            } else if (this.getSQLWorker().isSQLMetaAutocreateDatabase()) {
                bl2 = true;
            }
            if (bl2) {
                if (JMDBMain.myJMDBMain.importHelper.isResume()) {
                    bl = true;
                    this.writeText(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.ok_with_resume"));
                } else if (this.getSQLWorker().isSQLMetaAutocreateDatabase()) {
                    bl = true;
                    this.writeText(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.ok"));
                } else {
                    bl = false;
                    this.writeText(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.error"));
                }
            } else {
                bl = true;
                this.writeText(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.ok"));
            }
            if (jDBCAdapter.isConnection()) {
                jDBCAdapter.close();
            }
            jDBCAdapter = null;
            return bl;
        }
        catch (SQLException sQLException) {
            JMDBMain.myJMDBMain.log("DataBaseConverter2Thread.databaseOk() - SQLException: " + sQLException);
            return false;
        }
    }

    public void flushLinks(JDBCAdapter jDBCAdapter, String string, int[] nArray, int[] nArray2, String[] stringArray, int n) {
        jDBCAdapter.setPreparedStatement(string);
        this.startTransaction(jDBCAdapter, "flushing links");
        try {
            int n2 = 0;
            while (n2 <= n) {
                if (this.isCancelImport()) break;
                jDBCAdapter.getPreparedStatement().setInt(1, nArray2[n2]);
                jDBCAdapter.getPreparedStatement().setInt(2, nArray[n2]);
                jDBCAdapter.getPreparedStatement().setString(3, stringArray[n2]);
                jDBCAdapter.getPreparedStatement().addBatch();
                if (n2 % 999 == 0) {
                    jDBCAdapter.executePreparedBatch();
                }
                ++n2;
            }
            jDBCAdapter.executePreparedBatch();
        }
        catch (SQLException sQLException) {
            JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
        }
        this.stopTransaction(jDBCAdapter, "flushing links");
        jDBCAdapter.closePreparedStatement();
    }

    private int getActressesId(JDBCAdapter jDBCAdapter) {
        int n = -1;
        jDBCAdapter.executeQuery(this.getSQLWorker().getSQLSelectLowestActressesID());
        try {
            try {
                if (jDBCAdapter.resultSet.next()) {
                    n = jDBCAdapter.resultSet.getInt(1);
                }
            }
            catch (SQLException sQLException) {
                JMDBMain.myJMDBMain.log("DataBaseConverter2Thread.getActressesId() - SQLException: " + sQLException);
            }
        }
        catch (Throwable throwable) {}
        return n;
    }

    private String getAnalyseMessage() {
        return this.analyseMessage;
    }

    private String getAnalysingTablesMessage() {
        return this.analysingTablesMessage;
    }

    private String getConnBrokenMessage() {
        return this.connBrokenMessage;
    }

    private String getConvertingMessage() {
        return this.convertingMessage;
    }

    private String getCreatingTableMessage() {
        return this.creatingTableMessage;
    }

    private String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean getExistingTableByName(String string) {
        boolean bl = false;
        Enumeration enumeration = this.getExistingTables().elements();
        while (enumeration.hasMoreElements()) {
            if (!((String)enumeration.nextElement()).equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Vector getExistingTables() {
        return this.existingTables;
    }

    public static ImportFile getImportFile() {
        return importFile;
    }

    private Vector getImportFileList() {
        return this.importFileList;
    }

    private String[] getM2x_addinfo() {
        return this.m2x_addinfo;
    }

    private int getM2x_count() {
        return this.m2x_count;
    }

    private int getM2x_maxcount() {
        return this.m2x_maxcount;
    }

    private int[] getM2x_movieid() {
        return this.m2x_movieid;
    }

    private int[] getM2x_xid() {
        return this.m2x_xid;
    }

    public MovieArray getMovieArray() {
        return this.movieArray;
    }

    private int getMovieIdByTitle(JDBCAdapter jDBCAdapter, String string, boolean bl, boolean bl2) {
        int n;
        block31: {
            SQLException sQLException4;
            n = 0;
            int n2 = -1;
            String string2 = null;
            String string3 = null;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            ResultSet resultSet = null;
            ResultSet resultSet2 = null;
            try {
                try {
                    if (!bl) {
                        n2 = string.indexOf(")");
                        if (n2 != -1) {
                            string3 = String.valueOf(string.substring(0, n2)) + (bl2 ? "%" : ")");
                            this.titleSearchStatement.setString(1, string3);
                            resultSet = this.titleSearchStatement.executeQuery();
                            if (resultSet.next()) {
                                n = resultSet.getInt(1);
                            } else {
                                this.akaTitleSearchStatement.setString(1, string3);
                                resultSet2 = this.akaTitleSearchStatement.executeQuery();
                                if (resultSet2.next()) {
                                    n = resultSet2.getInt(1);
                                }
                            }
                        }
                    } else {
                        n2 = string.indexOf(")");
                        if (n2 != -1 && n2 > 4) {
                            string2 = string.substring(0, n2 - 4);
                            n3 = new Integer(string.substring(n2 - 4, n2));
                            n4 = n3 - 1;
                            n5 = n3 + 1;
                            this.titleSearchStatement.setString(1, String.valueOf(string2) + n4 + (bl2 ? "%" : ")"));
                            resultSet = this.titleSearchStatement.executeQuery();
                            if (resultSet.next()) {
                                n = resultSet.getInt(1);
                            } else {
                                this.titleSearchStatement.setString(1, String.valueOf(string2) + n5 + (bl2 ? "%" : ")"));
                                resultSet = this.titleSearchStatement.executeQuery();
                                if (resultSet.next()) {
                                    n = resultSet.getInt(1);
                                } else {
                                    this.akaTitleSearchStatement.setString(1, String.valueOf(string2) + n4 + (bl2 ? "%" : ")"));
                                    resultSet2 = this.akaTitleSearchStatement.executeQuery();
                                    if (resultSet2.next()) {
                                        n = resultSet2.getInt(1);
                                    } else {
                                        this.akaTitleSearchStatement.setString(1, String.valueOf(string2) + n5 + (bl2 ? "%" : ")"));
                                        resultSet2 = this.akaTitleSearchStatement.executeQuery();
                                        if (resultSet2.next()) {
                                            n = resultSet2.getInt(1);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                catch (SQLException sQLException2) {
                    JMDBMain.myJMDBMain.log("ERROR: Catched SQLException in getMovieIdByTitle: " + sQLException2);
                }
                catch (NumberFormatException numberFormatException) {
                    JMDBMain.myJMDBMain.log("ERROR: Catched NumberFormatException in getMovieIdByTitle...title (" + string + "): " + numberFormatException);
                }
            }
            catch (Throwable throwable) {
                SQLException sQLException32;
                Object var14_17 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException32) {
                        JMDBMain.myJMDBMain.log("Warning: Could not close titleResultSet. " + sQLException32);
                    }
                }
                if (resultSet2 != null) {
                    try {
                        resultSet2.close();
                    }
                    catch (SQLException sQLException32) {
                        JMDBMain.myJMDBMain.log("Warning: Could not close akaTitleResultSet. " + sQLException32);
                    }
                }
                throw throwable;
            }
            Object var14_18 = null;
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException4) {
                    JMDBMain.myJMDBMain.log("Warning: Could not close titleResultSet. " + sQLException4);
                }
            }
            if (resultSet2 == null) break block31;
            try {
                resultSet2.close();
            }
            catch (SQLException sQLException4) {
                JMDBMain.myJMDBMain.log("Warning: Could not close akaTitleResultSet. " + sQLException4);
            }
        }
        return n;
    }

    private String getNowMessage() {
        return this.nowMessage;
    }

    private int getNumberOfFilesToImport() {
        return this.numberOfFilesToImport;
    }

    private String getOkMessage() {
        return this.okMessage;
    }

    private String getReadingMessage() {
        return this.readingMessage;
    }

    private String getReadMessage() {
        return this.readMessage;
    }

    private SQLWorkerAbstract getSQLWorker() {
        return this.sqlWorker;
    }

    private StopWatch getStopWatch() {
        return this.stopWatch;
    }

    private boolean imdbFilesReadable() {
        this.writeHeading("\n\n" + resMessagesBundle.getString("DatabaseConverter.statusmessageheading.checkingimdbfiles"));
        Enumeration enumeration = JMDBMain.myJMDBMain.importHelper.getImportFileList().elements();
        while (enumeration.hasMoreElements()) {
            ImportFile importFile = (ImportFile)enumeration.nextElement();
            if (!importFile.isFileImport()) continue;
            String string = new String(importFile.getFileName());
            this.writeText("\n" + resMessagesBundle.getString("DatabaseConverter.statusmessagetext.checkingfile") + " " + string + ".* (.list.gz/.list)...");
            if (new File(String.valueOf(DataBaseConverter2.getCfgImportPath()) + string + ".list.gz").canRead()) {
                this.writeText(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.ok"));
                continue;
            }
            if (new File(String.valueOf(DataBaseConverter2.getCfgImportPath()) + string + ".list").canRead()) {
                this.writeText(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.ok"));
                continue;
            }
            this.writeText(String.valueOf(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.error")) + "\n");
            this.writeHeading("\n" + resMessagesBundle.getString("DatabaseConverter.statusmessageheading.error_missingfile"));
            return false;
        }
        return true;
    }

    private void importActorsAndActresses(JDBCAdapter jDBCAdapter) {
        int n = 0;
        int n2 = -1;
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("actresses"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            if (this.getExistingTableByName("actors") && this.getExistingTableByName("movies2actors")) {
                DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("actors"));
                if (DataBaseConverter2Thread.getImportFile() != null && !DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
                    int n3 = this.getActressesId(jDBCAdapter);
                    if (n3 > 0) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDeleteTableEntry("actors", "actorid", ">=", n3));
                    }
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDeleteTableEntry("actors", "sex", "=", "F"));
                    this.writeHeading("\n\n" + this.getConvertingMessage() + " actors & actresses (" + resMessagesBundle.getString("DatabaseConverter.statusmessageheading.this_will_take_a_while") + ")");
                }
            } else {
                DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("actors"));
                if (DataBaseConverter2Thread.getImportFile() != null) {
                    DataBaseConverter2Thread.getImportFile().setFileImport(true);
                }
            }
        }
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("actors"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            if (this.getExistingTableByName("movies2actors")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("movies2actors"));
            }
            if (this.getExistingTableByName("actors")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("actors"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " actors and actresses (this will take a while)");
            this.writeText("\n" + this.getCreatingTableMessage() + " movies2actors...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateMovies2Actors());
            if (this.checkTableExistence(jDBCAdapter, "movies2actors")) {
                this.writeText(this.getOkMessage());
            }
            this.writeText("\n" + this.getCreatingTableMessage() + " actors...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateActors());
            if (this.checkTableExistence(jDBCAdapter, "actors")) {
                this.writeText(this.getOkMessage());
            }
        }
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("actors"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            this.writeText("\n" + this.getConvertingMessage() + " actors...");
            JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
            String[] cfr_ignored_0 = new String[3];
            int[] cfr_ignored_1 = new int[3];
            n = 0;
            this.setM2x_count(0);
            jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoActors());
            DataImportType2 dataImportType2 = new DataImportType2(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "actors", "THE ACTORS LIST", 4);
            JMDBMain.myJMDBMain.log("Reading actors...");
            this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " actors...");
            this.startTransaction(jDBCAdapter, "actors.list");
            try {
                while (dataImportType2.getData() && !this.isCancelImport()) {
                    if (dataImportType2.resArray[0] == null || dataImportType2.resArray[1] == null) continue;
                    if (!dataImportType2.resArray[0].equals("")) {
                        jDBCAdapter.getPreparedStatement().setString(1, dataImportType2.resArray[0]);
                        jDBCAdapter.getPreparedStatement().setString(2, "M");
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 == 0) {
                            jDBCAdapter.executePreparedBatch();
                        }
                        if (this.getM2x_count() >= this.getM2x_maxcount()) {
                            jDBCAdapter.executePreparedBatch();
                            this.stopTransaction(jDBCAdapter, "actors.list");
                            this.myStatus.setText(String.valueOf(this.getNowMessage()) + " " + n + " actors/actresses " + this.getReadMessage() + ".");
                            this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2Actors(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
                            this.setM2x_count(0);
                            jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoActors());
                            this.startTransaction(jDBCAdapter, "actors.list");
                        }
                    }
                    if ((n2 = this.movieArray.getMovieid(dataImportType2.resArray[1])) <= 0) continue;
                    this.m2x_xid[this.getM2x_count()] = n;
                    this.m2x_movieid[this.getM2x_count()] = n2;
                    this.m2x_addinfo[this.getM2x_count()] = new String(dataImportType2.resArray[2]);
                    ++this.m2x_count;
                }
            }
            catch (SQLException sQLException) {
                JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
            }
            jDBCAdapter.executePreparedBatch();
            this.stopTransaction(jDBCAdapter, "actors.list");
            if (!this.isCancelImport()) {
                this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2Actors(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
            }
            this.myStatus.setText("");
            if (!this.isCancelImport()) {
                if (this.brokenConnection(jDBCAdapter)) {
                    this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                } else {
                    this.writeText(this.getOkMessage());
                }
                this.getStopWatch().restart("actors: import completed");
                System.gc();
            }
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("actresses"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            this.writeText("\n" + this.getConvertingMessage() + " actresses...");
            JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
            this.setM2x_count(0);
            jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoActors());
            DataImportType2 dataImportType2 = new DataImportType2(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "actresses", "THE ACTRESSES LIST", 4);
            JMDBMain.myJMDBMain.log("Reading actresses...");
            this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " actresses...");
            this.startTransaction(jDBCAdapter, "actresses.list");
            try {
                while (dataImportType2.getData() && !this.isCancelImport()) {
                    if (dataImportType2.resArray[0] == null || dataImportType2.resArray[1] == null) continue;
                    if (!dataImportType2.resArray[0].equals("")) {
                        jDBCAdapter.getPreparedStatement().setString(1, dataImportType2.resArray[0]);
                        jDBCAdapter.getPreparedStatement().setString(2, "F");
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 == 0) {
                            jDBCAdapter.executePreparedBatch();
                        }
                        if (this.getM2x_count() >= this.getM2x_maxcount()) {
                            jDBCAdapter.executePreparedBatch();
                            this.stopTransaction(jDBCAdapter, "actresses.list");
                            this.myStatus.setText(String.valueOf(this.getNowMessage()) + " " + n + " actors/actresses " + this.getReadMessage() + ".");
                            this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2Actors(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
                            this.setM2x_count(0);
                            jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoActors());
                            this.startTransaction(jDBCAdapter, "actresses.list");
                        }
                    }
                    if ((n2 = this.movieArray.getMovieid(dataImportType2.resArray[1])) <= 0) continue;
                    this.m2x_xid[this.getM2x_count()] = n;
                    this.m2x_movieid[this.getM2x_count()] = this.movieArray.getMovieid(dataImportType2.resArray[1]);
                    this.m2x_addinfo[this.getM2x_count()] = new String(dataImportType2.resArray[2]);
                    ++this.m2x_count;
                }
            }
            catch (SQLException sQLException) {
                JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
            }
            jDBCAdapter.executePreparedBatch();
            this.stopTransaction(jDBCAdapter, "actresses.list");
            jDBCAdapter.closePreparedStatement();
            if (!this.isCancelImport()) {
                this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2Actors(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
            }
            this.myStatus.setText("");
            if (!this.isCancelImport()) {
                if (this.brokenConnection(jDBCAdapter)) {
                    this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                } else {
                    this.writeText(this.getOkMessage());
                }
                this.getStopWatch().restart("actresses: import completed");
                System.gc();
            }
        }
        if (!this.isCancelImport() && this.commando.equals("IMPORT_INDEX")) {
            JMDBMain.myJMDBMain.importHelper.writeFileImportStatus("index_movies2actors");
            DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("actresses"));
            if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport()) {
                this.buildIndex(jDBCAdapter, false);
            } else {
                DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("actors"));
                if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport()) {
                    this.buildIndex(jDBCAdapter, false);
                }
            }
        }
        if (!this.isCancelImport()) {
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("actors", "name", 10));
            if (this.getSQLWorker().isSQLMetaTextSearchSupported()) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndexFullText("actors", "name", null, null));
            }
        }
        if (this.importCounter > 0 && this.getNumberOfFilesToImport() > 0 && !this.isCancelImport()) {
            this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
        }
    }

    private void importAKANames(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("aka-names"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("akanames")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("akanames"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " akanames");
            this.writeText("\n" + this.getCreatingTableMessage() + " akanames...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateAKANames());
            if (this.checkTableExistence(jDBCAdapter, "akanames")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " aka-names...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoAKANames());
                DataImportType4 dataImportType4 = new DataImportType4(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "aka-names", "AKA NAMES LIST", 2);
                JMDBMain.myJMDBMain.log("Reading aka-names...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " aka-names...");
                int n = 0;
                this.startTransaction(jDBCAdapter, "aka-names.list");
                try {
                    while (dataImportType4.getData() && !this.isCancelImport()) {
                        if (dataImportType4.resArray[0] == null || dataImportType4.resArray[1] == null) continue;
                        jDBCAdapter.getPreparedStatement().setString(1, dataImportType4.resArray[0]);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType4.resArray[1]);
                        jDBCAdapter.getPreparedStatement().setString(3, dataImportType4.resArray[2]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "aka-names.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("akanames", "name", 10));
                }
                if (!this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("akanames", "akaname", 10));
                    if (this.getSQLWorker().isSQLMetaTextSearchSupported()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndexFullText("akanames", "akaname", null, null));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("aka-names: import completed");
                }
                dataImportType4 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importAKATitles(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("aka-titles"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            this.writeHeading("\n\n" + this.getConvertingMessage() + " aka-titles");
        } else {
            DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("german-aka-titles"));
            if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
                this.writeHeading("\n\n" + this.getConvertingMessage() + " aka-titles");
            } else {
                DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("italian-aka-titles"));
                if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
                    this.writeHeading("\n\n" + this.getConvertingMessage() + " aka-titles");
                }
            }
        }
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("aka-titles"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("akatitles")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("akatitles"));
            }
            this.writeText("\n" + this.getCreatingTableMessage() + " akatitles...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateAKATitles());
            if (this.checkTableExistence(jDBCAdapter, "akatitles")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " aka-titles...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoAKATitles());
                DataImportType4 dataImportType4 = new DataImportType4(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "aka-titles", "AKA TITLES LIST", 3);
                JMDBMain.myJMDBMain.log("Reading aka-titles...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " aka-titles...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "aka-titles.list");
                try {
                    while (dataImportType4.getData() && !this.isCancelImport()) {
                        if (dataImportType4.resArray[0] == null || dataImportType4.resArray[1] == null || (n2 = this.movieArray.getMovieid(dataImportType4.resArray[0])) <= 0) continue;
                        ++n;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, "ENG");
                        jDBCAdapter.getPreparedStatement().setString(3, dataImportType4.resArray[1]);
                        jDBCAdapter.getPreparedStatement().setString(4, dataImportType4.resArray[2]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "aka-titles.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("akatitles", "movieid", 0));
                }
                if (!this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("akatitles", "title", 15));
                    if (this.getSQLWorker().isSQLMetaTextSearchSupported()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndexFullText("akatitles", "title", null, null));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("aka-titles: import completed");
                }
                dataImportType4 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importAKATitles_German(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("german-aka-titles"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("akatitles") || this.checkTableExistence(jDBCAdapter, "akatitles")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDeleteTableEntry("akatitles", "language", "=", "GER"));
            } else {
                this.writeText("\n" + this.getCreatingTableMessage() + " akatitles...");
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateAKATitles());
                if (this.checkTableExistence(jDBCAdapter, "akatitles")) {
                    this.writeText(this.getOkMessage());
                }
            }
            this.writeText("\n" + this.getConvertingMessage() + " german-aka-titles...");
            JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
            jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoAKATitles());
            DataImportType4 dataImportType4 = new DataImportType4(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "german-aka-titles", "AKA TITLES LIST GERMAN", 2);
            JMDBMain.myJMDBMain.log("Reading german-aka-titles...");
            this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " german-aka-titles...");
            int n = 0;
            int n2 = -1;
            this.startTransaction(jDBCAdapter, "german-aka-titles.list");
            try {
                while (dataImportType4.getData() && !this.isCancelImport()) {
                    if (dataImportType4.resArray[0] == null || dataImportType4.resArray[1] == null || (n2 = this.movieArray.getMovieid(dataImportType4.resArray[0])) <= 0) continue;
                    ++n;
                    jDBCAdapter.getPreparedStatement().setInt(1, n2);
                    jDBCAdapter.getPreparedStatement().setString(2, "GER");
                    jDBCAdapter.getPreparedStatement().setString(3, dataImportType4.resArray[1]);
                    jDBCAdapter.getPreparedStatement().setString(4, dataImportType4.resArray[2]);
                    jDBCAdapter.getPreparedStatement().addBatch();
                    if (n % 1000 != 0) continue;
                    jDBCAdapter.executePreparedBatch();
                }
                jDBCAdapter.executePreparedBatch();
            }
            catch (SQLException sQLException) {
                JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
            }
            this.stopTransaction(jDBCAdapter, "german-aka-titles.list");
            jDBCAdapter.closePreparedStatement();
            if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex()) {
                if (!this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("akatitles", "movieid", 0));
                }
                if (!this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("akatitles", "title", 15));
                }
            }
            this.myStatus.setText("");
            if (!this.isCancelImport()) {
                if (this.brokenConnection(jDBCAdapter)) {
                    this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                } else {
                    this.writeText(this.getOkMessage());
                }
                this.getStopWatch().restart("german-aka-titles: import completed");
            }
            dataImportType4 = null;
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importAKATitles_Italian(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("italian-aka-titles"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("akatitles") || this.checkTableExistence(jDBCAdapter, "akatitles")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDeleteTableEntry("akatitles", "language", "=", "ITA"));
            } else {
                this.writeText("\n" + this.getCreatingTableMessage() + " akatitles...");
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateAKATitles());
                if (this.checkTableExistence(jDBCAdapter, "akatitles")) {
                    this.writeText(this.getOkMessage());
                }
            }
            this.writeText("\n" + this.getConvertingMessage() + " italian-aka-titles...");
            JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
            jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoAKATitles());
            DataImportType4 dataImportType4 = new DataImportType4(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "italian-aka-titles", "AKA TITLES LIST ITALIAN", 3);
            JMDBMain.myJMDBMain.log("Reading italian-aka-titles...");
            this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " italian-aka-titles...");
            int n = 0;
            int n2 = -1;
            this.startTransaction(jDBCAdapter, "italian-aka-titles.list");
            try {
                while (dataImportType4.getData() && !this.isCancelImport()) {
                    if (dataImportType4.resArray[0] == null || dataImportType4.resArray[1] == null || (n2 = this.movieArray.getMovieid(dataImportType4.resArray[0])) <= 0) continue;
                    ++n;
                    jDBCAdapter.getPreparedStatement().setInt(1, n2);
                    jDBCAdapter.getPreparedStatement().setString(2, "ITA");
                    jDBCAdapter.getPreparedStatement().setString(3, dataImportType4.resArray[1]);
                    jDBCAdapter.getPreparedStatement().setString(4, dataImportType4.resArray[2]);
                    jDBCAdapter.getPreparedStatement().addBatch();
                    if (n % 1000 != 0) continue;
                    jDBCAdapter.executePreparedBatch();
                }
                jDBCAdapter.executePreparedBatch();
            }
            catch (SQLException sQLException) {
                JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
            }
            this.stopTransaction(jDBCAdapter, "italian-aka-titles.list");
            jDBCAdapter.closePreparedStatement();
            if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex()) {
                if (!this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("akatitles", "movieid", 0));
                }
                if (!this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("akatitles", "title", 15));
                }
            }
            this.myStatus.setText("");
            if (!this.isCancelImport()) {
                if (this.brokenConnection(jDBCAdapter)) {
                    this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                } else {
                    this.writeText(this.getOkMessage());
                }
                this.getStopWatch().restart("italian-aka-titles: import completed");
            }
            dataImportType4 = null;
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    public void importAlternateVersions(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("alternate-versions"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("altversions")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("altversions"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " alternate-versions");
            this.writeText("\n" + this.getCreatingTableMessage() + " altversions...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateAlternateVersions());
            if (this.checkTableExistence(jDBCAdapter, "altversions")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " alternate-versions...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoAlternateVersions());
                DataImportType11 dataImportType11 = new DataImportType11(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "alternate-versions", "ALTERNATE VERSIONS LIST", 3);
                JMDBMain.myJMDBMain.log("Reading alternate-versions...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " alternate-versions...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "alternate-versions.list");
                try {
                    while (dataImportType11.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType11.resArray[0]);
                        if (n2 <= 0) continue;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType11.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "alternate-versions.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex() && !this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("altversions", "movieid", 0));
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("alternate-versions: import completed");
                }
                dataImportType11 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importBiographies(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("biographies"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("biographies")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("biographies"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " biographies");
            this.writeText("\n" + this.getCreatingTableMessage() + " biographies...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateBiographies());
            if (this.checkTableExistence(jDBCAdapter, "biographies")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " biographies...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                DataImportType12 dataImportType12 = new DataImportType12(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "biographies", "BIOGRAPHY LIST", 2);
                JMDBMain.myJMDBMain.log("Reading biographies...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " biographies...");
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoBiographies());
                int n = 0;
                this.startTransaction(jDBCAdapter, "biographies.list");
                try {
                    while (dataImportType12.getData() && !this.isCancelImport()) {
                        jDBCAdapter.getPreparedStatement().setString(1, dataImportType12.resArray[0]);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType12.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "biographies.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex() && !this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("biographies", "name", 10));
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("biographies: import completed");
                }
                dataImportType12 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importBusiness(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("business"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("business")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("business"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " business");
            this.writeText("\n" + this.getCreatingTableMessage() + " business...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateBusiness());
            if (this.checkTableExistence(jDBCAdapter, "business")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " business...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoBusiness());
                DataImportType8 dataImportType8 = new DataImportType8(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "business", "BUSINESS LIST", 2);
                JMDBMain.myJMDBMain.log("Reading business...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " business...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "business.list");
                try {
                    while (dataImportType8.getData() && !this.isCancelImport()) {
                        if (dataImportType8.resArray[0] == null || dataImportType8.resArray[1] == null || dataImportType8.resArray[1].length() <= 0) break;
                        n2 = this.movieArray.getMovieid(dataImportType8.resArray[0]);
                        if (n2 <= 0) continue;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType8.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "business.list");
                jDBCAdapter.closePreparedStatement();
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("business: import completed");
                }
                dataImportType8 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importCertificates(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("certificates"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("certificates")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("certificates"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " certificates");
            this.writeText("\n" + this.getCreatingTableMessage() + " certificates...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateCertificates());
            if (this.checkTableExistence(jDBCAdapter, "certificates")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " certificates...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoCertificates());
                DataImportType14 dataImportType14 = new DataImportType14(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "certificates", "CERTIFICATES LIST", 1);
                JMDBMain.myJMDBMain.log("Reading certificates...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " certificates...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "certificates.list");
                try {
                    while (dataImportType14.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType14.resArray[0]);
                        if (n2 <= 0) continue;
                        ++n;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType14.resArray[1]);
                        jDBCAdapter.getPreparedStatement().setString(3, dataImportType14.resArray[2]);
                        jDBCAdapter.getPreparedStatement().setString(4, dataImportType14.resArray[3]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "certificates.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex()) {
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("certificates", "movieid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("certificates", "country", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("certificates", "certification", 0));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("certificates: import completed");
                }
                dataImportType14 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importCinematographers(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("cinematographers"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("movies2cinematgrs")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("movies2cinematgrs"));
            }
            if (this.getExistingTableByName("cinematgrs")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("cinematgrs"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " cinematographers");
            this.writeText("\n" + this.getCreatingTableMessage() + " movies2cinematgrs (cinematographers)...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateMovies2Cinematographers());
            if (this.checkTableExistence(jDBCAdapter, "movies2cinematgrs")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getCreatingTableMessage() + " cinematgrs (cinematographers)...");
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateCinematographers());
                if (this.checkTableExistence(jDBCAdapter, "cinematgrs")) {
                    this.writeText(this.getOkMessage());
                }
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " cinematographers...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                int n = 0;
                this.setM2x_count(0);
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoCinematographers());
                DataImportType2 dataImportType2 = new DataImportType2(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "cinematographers", "THE CINEMATOGRAPHERS LIST", 4);
                JMDBMain.myJMDBMain.log("Reading cinematographers...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " cinematographers...");
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "cinematographers.list");
                try {
                    while (dataImportType2.getData() && !this.isCancelImport()) {
                        if (dataImportType2.resArray[0] == null || dataImportType2.resArray[1] == null) continue;
                        if (!dataImportType2.resArray[0].equals("")) {
                            jDBCAdapter.getPreparedStatement().setString(1, dataImportType2.resArray[0]);
                            jDBCAdapter.getPreparedStatement().addBatch();
                            if (++n % 1000 == 0) {
                                jDBCAdapter.executePreparedBatch();
                            }
                            if (this.getM2x_count() >= this.getM2x_maxcount()) {
                                jDBCAdapter.executePreparedBatch();
                                this.stopTransaction(jDBCAdapter, "cinematographers.list");
                                this.myStatus.setText(String.valueOf(this.getNowMessage()) + " " + n + " cinematographers " + this.getReadMessage() + ".");
                                this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2Cinematographers(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
                                this.setM2x_count(0);
                                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoCinematographers());
                                this.startTransaction(jDBCAdapter, "cinematographers.list");
                            }
                        }
                        if ((n2 = this.movieArray.getMovieid(dataImportType2.resArray[1])) <= 0) continue;
                        this.m2x_xid[this.getM2x_count()] = n;
                        this.m2x_movieid[this.getM2x_count()] = n2;
                        this.m2x_addinfo[this.getM2x_count()] = new String(dataImportType2.resArray[2]);
                        ++this.m2x_count;
                    }
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                jDBCAdapter.executePreparedBatch();
                this.stopTransaction(jDBCAdapter, "cinematographers.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.isCancelImport()) {
                    this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2Cinematographers(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
                }
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex()) {
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies2cinematgrs", "movieid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies2cinematgrs", "cinematid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("cinematgrs", "name", 10));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("cinematographers: import completed");
                }
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importColorInfo(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("color-info"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("colorinfo")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("colorinfo"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " color-info");
            this.writeText("\n" + this.getCreatingTableMessage() + " colorinfo...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateColorinfo());
            if (this.checkTableExistence(jDBCAdapter, "colorinfo")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " color-info...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoColorinfo());
                DataImportType1 dataImportType1 = new DataImportType1(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "color-info", "COLOR INFO LIST", 1);
                JMDBMain.myJMDBMain.log("Reading color-info...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " color-info...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "color-info.list");
                try {
                    while (dataImportType1.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType1.resArray[0]);
                        if (n2 <= 0) continue;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType1.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "color-info.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex()) {
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("colorinfo", "movieid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("colorinfo", "color", 15));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("color-info: import completed");
                }
                dataImportType1 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importComposers(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("composers"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("movies2composers")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("movies2composers"));
            }
            if (this.getExistingTableByName("composers")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("composers"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " composers");
            this.writeText("\n" + this.getCreatingTableMessage() + " movies2composers...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateMovies2Composers());
            if (this.checkTableExistence(jDBCAdapter, "movies2composers")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getCreatingTableMessage() + " composers...");
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateComposers());
                if (this.checkTableExistence(jDBCAdapter, "composers")) {
                    this.writeText(this.getOkMessage());
                }
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " composers...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                int n = 0;
                this.setM2x_count(0);
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoComposers());
                DataImportType2 dataImportType2 = new DataImportType2(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "composers", "THE COMPOSERS LIST", 4);
                JMDBMain.myJMDBMain.log("Reading composers...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " composers...");
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "composers.list");
                try {
                    while (dataImportType2.getData() && !this.isCancelImport()) {
                        if (dataImportType2.resArray[0] == null || dataImportType2.resArray[1] == null) continue;
                        if (!dataImportType2.resArray[0].equals("")) {
                            jDBCAdapter.getPreparedStatement().setString(1, dataImportType2.resArray[0]);
                            jDBCAdapter.getPreparedStatement().addBatch();
                            if (++n % 1000 == 0) {
                                jDBCAdapter.executePreparedBatch();
                            }
                            if (this.getM2x_count() >= this.getM2x_maxcount()) {
                                jDBCAdapter.executePreparedBatch();
                                this.stopTransaction(jDBCAdapter, "composers.list");
                                this.myStatus.setText(String.valueOf(this.getNowMessage()) + " " + n + " composers " + this.getReadMessage() + ".");
                                this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2Composers(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
                                this.setM2x_count(0);
                                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoComposers());
                                this.startTransaction(jDBCAdapter, "composers.list");
                            }
                        }
                        if ((n2 = this.movieArray.getMovieid(dataImportType2.resArray[1])) <= 0) continue;
                        this.m2x_xid[this.getM2x_count()] = n;
                        this.m2x_movieid[this.getM2x_count()] = n2;
                        this.m2x_addinfo[this.getM2x_count()] = new String(dataImportType2.resArray[2]);
                        ++this.m2x_count;
                    }
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                jDBCAdapter.executePreparedBatch();
                this.stopTransaction(jDBCAdapter, "composers.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.isCancelImport()) {
                    this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2Composers(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
                }
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex()) {
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies2composers", "movieid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies2composers", "composerid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("composers", "name", 10));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("composers: import completed");
                }
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importCostumeDesigners(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("costume-designers"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("movies2costdes")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("movies2costdes"));
            }
            if (this.getExistingTableByName("costdesigners")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("costdesigners"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " costume-designers");
            this.writeText("\n" + this.getCreatingTableMessage() + " movies2costdes (costume designers)...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateMovies2CostumeDesigners());
            if (this.checkTableExistence(jDBCAdapter, "movies2costdes")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getCreatingTableMessage() + " costdesigners (costume designers)...");
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateCostumeDesigners());
                if (this.checkTableExistence(jDBCAdapter, "costdesigners")) {
                    this.writeText(this.getOkMessage());
                }
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " costume-designers...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                int n = 0;
                this.setM2x_count(0);
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoCostumeDesigners());
                DataImportType2 dataImportType2 = new DataImportType2(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "costume-designers", "THE COSTUME DESIGNERS LIST", 4);
                JMDBMain.myJMDBMain.log("Reading costume designers...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " costume designers...");
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "costume-designers.list");
                try {
                    while (dataImportType2.getData() && !this.isCancelImport()) {
                        if (dataImportType2.resArray[0] == null || dataImportType2.resArray[1] == null) continue;
                        if (!dataImportType2.resArray[0].equals("")) {
                            jDBCAdapter.getPreparedStatement().setString(1, dataImportType2.resArray[0]);
                            jDBCAdapter.getPreparedStatement().addBatch();
                            if (++n % 1000 == 0) {
                                jDBCAdapter.executePreparedBatch();
                            }
                            if (this.getM2x_count() >= this.getM2x_maxcount()) {
                                jDBCAdapter.executePreparedBatch();
                                this.stopTransaction(jDBCAdapter, "costume-designers.list");
                                this.myStatus.setText(String.valueOf(this.getNowMessage()) + " " + n + " costume designers " + this.getReadMessage() + ".");
                                this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2CostumeDesigners(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
                                this.setM2x_count(0);
                                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoCostumeDesigners());
                                this.startTransaction(jDBCAdapter, "costume-designers.list");
                            }
                        }
                        if ((n2 = this.movieArray.getMovieid(dataImportType2.resArray[1])) <= 0) continue;
                        this.m2x_xid[this.getM2x_count()] = n;
                        this.m2x_movieid[this.getM2x_count()] = n2;
                        this.m2x_addinfo[this.getM2x_count()] = new String(dataImportType2.resArray[2]);
                        ++this.m2x_count;
                    }
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                jDBCAdapter.executePreparedBatch();
                this.stopTransaction(jDBCAdapter, "costume-designers.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.isCancelImport()) {
                    this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2CostumeDesigners(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
                }
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex()) {
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies2costdes", "movieid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies2costdes", "costdesid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("costdesigners", "name", 10));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("costume-designers: import completed");
                }
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importCountries(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("countries"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("countries")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("countries"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " countries");
            this.writeText("\n" + this.getCreatingTableMessage() + " countries...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateCountries());
            if (this.checkTableExistence(jDBCAdapter, "countries")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " countries...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoCountries());
                DataImportType1 dataImportType1 = new DataImportType1(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "countries", "COUNTRIES LIST", 1);
                JMDBMain.myJMDBMain.log("Reading countries...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " countries...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "countries.list");
                try {
                    while (dataImportType1.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType1.resArray[0]);
                        if (n2 <= 0) continue;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType1.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "countries.list");
                jDBCAdapter.closePreparedStatement();
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex()) {
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("countries", "movieid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("countries", "country", 15));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("countries: import completed");
                }
                dataImportType1 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    public void importCrazyCredits(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("crazy-credits"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("crazycredits")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("crazycredits"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " crazy-credits");
            this.writeText("\n" + this.getCreatingTableMessage() + " crazycredits...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateCrazyCredits());
            if (this.checkTableExistence(jDBCAdapter, "crazycredits")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " crazy-credits...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoCrazyCredits());
                DataImportType11 dataImportType11 = new DataImportType11(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "crazy-credits", "CRAZY CREDITS", 1);
                JMDBMain.myJMDBMain.log("Reading crazy-credits...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " crazy-credits...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "crazy-credits.list");
                try {
                    while (dataImportType11.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType11.resArray[0]);
                        if (n2 <= 0) continue;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType11.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "crazy-credits.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex() && !this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("crazycredits", "movieid", 0));
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("crazy-credits: import completed");
                }
                dataImportType11 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importData(String string) throws OutOfMemoryException {
        block17: {
            String string2;
            if (!this.isCancelImport()) {
                this.myBar.setValue(0);
            }
            this.myBar.setVisible(true);
            this.myStatus.setText("");
            this.writeHeading(resMessagesBundle.getString("DatabaseConverter.statusmessageheading.fileimportstarted"));
            if (!this.imdbFilesReadable() || !this.dataBaseOK()) break block17;
            JMDBMain.myJMDBMain.log(new java.util.Date().toString());
            String string3 = JMDBMain.myJMDBMain.getDbname();
            String string4 = string2 = JMDBMain.myJMDBMain.getDburl();
            if (this.getSQLWorker().getSQLMetaControlDB() != null) {
                string4 = String.valueOf(string2) + (string2.endsWith("/") ? "" : "/") + this.getSQLWorker().getSQLMetaControlDB();
            } else if (this.sqlWorker.isSQLMetaAutocreateDatabase() || this.sqlWorker.isSQLMetaFileDB()) {
                string4 = DataBaseConverter2.getCfgUrl();
            }
            JDBCAdapter jDBCAdapter = new JDBCAdapter(string4, DataBaseConverter2.getCfgJdbcDriver(), DataBaseConverter2.getCfgUserID(), DataBaseConverter2.getCfgPassword());
            StopWatch stopWatch = new StopWatch();
            this.setStopWatch(new StopWatch());
            DataBaseConverter2Thread.setImportFile(new ImportFile());
            this.setImportFileList(JMDBMain.myJMDBMain.importHelper.getImportFileList());
            this.writeHeading("\n\n" + resMessagesBundle.getString("DatabaseConverter.statusmessageheading.create_and_or_connect"));
            if (!JMDBMain.myJMDBMain.importHelper.isResume() || this.getSQLWorker().isSQLMetaAutocreateDatabase()) {
                this.writeText("\n" + resMessagesBundle.getString("DatabaseConverter.statusmessagetext.createdb") + " " + string3 + "...");
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateDatabase(string3));
            }
            this.writeText("\n" + resMessagesBundle.getString("DatabaseConverter.statusmessagetext.connectingtodb") + " " + string3 + "...");
            if (jDBCAdapter != null) {
                jDBCAdapter.closedb();
            }
            jDBCAdapter = new JDBCAdapter(DataBaseConverter2.getCfgUrl(), DataBaseConverter2.getCfgJdbcDriver(), DataBaseConverter2.getCfgUserID(), DataBaseConverter2.getCfgPassword());
            this.writeText(this.getOkMessage());
            jDBCAdapter.executeQuery(this.getSQLWorker().getSQLMetaShowTables());
            try {
                while (jDBCAdapter.resultSet.next()) {
                    this.getExistingTables().add(jDBCAdapter.resultSet.getString(1));
                }
            }
            catch (SQLException sQLException) {}
            this.setNumberOfFilesToImport(JMDBMain.myJMDBMain.importHelper.countNumberOfFilesToImport());
            this.importCounter = 0;
            try {
                try {
                    this.importMovies(jDBCAdapter);
                    this.importKeywords(jDBCAdapter);
                    this.importProductionCompanies(jDBCAdapter);
                    this.importCountries(jDBCAdapter);
                    this.importReleasedates(jDBCAdapter);
                    this.importGenres(jDBCAdapter);
                    this.importColorInfo(jDBCAdapter);
                    this.importTechnical(jDBCAdapter);
                    this.importBusiness(jDBCAdapter);
                    this.importRatings(jDBCAdapter);
                    this.importRunningtimes(jDBCAdapter);
                    this.importLanguage(jDBCAdapter);
                    this.importDistributors(jDBCAdapter);
                    this.importAKATitles(jDBCAdapter);
                    this.importAKATitles_German(jDBCAdapter);
                    this.importAKATitles_Italian(jDBCAdapter);
                    this.importPlots(jDBCAdapter);
                    this.importActorsAndActresses(jDBCAdapter);
                    this.importBiographies(jDBCAdapter);
                    this.importAKANames(jDBCAdapter);
                    this.importDirectors(jDBCAdapter);
                    this.importProducers(jDBCAdapter);
                    this.importMiscellaneous(jDBCAdapter);
                    this.importWriters(jDBCAdapter);
                    this.importComposers(jDBCAdapter);
                    this.importCinematographers(jDBCAdapter);
                    this.importEditors(jDBCAdapter);
                    this.importProductionDesigners(jDBCAdapter);
                    this.importCostumeDesigners(jDBCAdapter);
                    this.importMPAARatingsReasons(jDBCAdapter);
                    this.importQuotes(jDBCAdapter);
                    this.importTrivia(jDBCAdapter);
                    this.importTaglines(jDBCAdapter);
                    this.importGoofs(jDBCAdapter);
                    this.importCertificates(jDBCAdapter);
                    this.importMovieLinks(jDBCAdapter);
                    this.importLiterature(jDBCAdapter);
                    this.importLocations(jDBCAdapter);
                    this.importAlternateVersions(jDBCAdapter);
                    this.importCrazyCredits(jDBCAdapter);
                    this.importUsrMovieLensItems100k(jDBCAdapter);
                    this.analyseDatabaseStructure(jDBCAdapter);
                    if (!this.isCancelImport()) {
                        this.myBar.setValue(100);
                        this.myStatus.setText(resMessagesBundle.getString("JMDB.label.status_finished"));
                        this.myBar.setVisible(false);
                        this.writeHeading("\n\n" + resMessagesBundle.getString("DatabaseConverter.statusmessageheading.finished"));
                        JMDBMain.myJMDBMain.importHelper.deleteFileImportStatus();
                    }
                    this.getStopWatch().stop("displaying last messages");
                    stopWatch.stop("The complete import time!");
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw new OutOfMemoryException(resMessagesBundle.getString("JMDB.exception.outOfMemoryError.message"));
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (this.movieArray != null) {
                    this.movieArray = null;
                }
                jDBCAdapter.closedb();
                System.gc();
                throw throwable;
            }
            Object var7_9 = null;
            if (this.movieArray != null) {
                this.movieArray = null;
            }
            jDBCAdapter.closedb();
            System.gc();
        }
    }

    private void importDirectors(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("directors"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("movies2directors")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("movies2directors"));
            }
            if (this.getExistingTableByName("directors")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("directors"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " directors");
            this.writeText("\n" + this.getCreatingTableMessage() + " movies2directors...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateMovies2Directors());
            if (this.checkTableExistence(jDBCAdapter, "movies2directors")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getCreatingTableMessage() + " directors...");
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateDirectors());
                if (this.checkTableExistence(jDBCAdapter, "directors")) {
                    this.writeText(this.getOkMessage());
                }
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " directors...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                int n = 0;
                this.setM2x_count(0);
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoDirectors());
                DataImportType2 dataImportType2 = new DataImportType2(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "directors", "THE DIRECTORS LIST", 4);
                JMDBMain.myJMDBMain.log("Reading directors...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " directors...");
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "directors.list");
                try {
                    while (dataImportType2.getData() && !this.isCancelImport()) {
                        if (dataImportType2.resArray[0] == null || dataImportType2.resArray[1] == null) continue;
                        if (!dataImportType2.resArray[0].equals("")) {
                            jDBCAdapter.getPreparedStatement().setString(1, dataImportType2.resArray[0]);
                            jDBCAdapter.getPreparedStatement().addBatch();
                            if (++n % 1000 == 0) {
                                jDBCAdapter.executePreparedBatch();
                            }
                            if (this.getM2x_count() >= this.getM2x_maxcount()) {
                                jDBCAdapter.executePreparedBatch();
                                this.stopTransaction(jDBCAdapter, "directors.list");
                                this.myStatus.setText(String.valueOf(this.getNowMessage()) + " " + n + " directors " + this.getReadMessage() + ".");
                                this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2Directors(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
                                this.setM2x_count(0);
                                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoDirectors());
                                this.startTransaction(jDBCAdapter, "directors.list");
                            }
                        }
                        if ((n2 = this.movieArray.getMovieid(dataImportType2.resArray[1])) <= 0) continue;
                        this.m2x_xid[this.getM2x_count()] = n;
                        this.m2x_movieid[this.getM2x_count()] = n2;
                        this.m2x_addinfo[this.getM2x_count()] = new String(dataImportType2.resArray[2]);
                        ++this.m2x_count;
                    }
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                jDBCAdapter.executePreparedBatch();
                this.stopTransaction(jDBCAdapter, "directors.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.isCancelImport()) {
                    this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2Directors(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
                }
                if (!this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies2directors", "movieid", 0));
                }
                if (!this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies2directors", "directorid", 0));
                }
                if (!this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("directors", "name", 10));
                    if (this.getSQLWorker().isSQLMetaTextSearchSupported()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndexFullText("directors", "name", null, null));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("directors: import completed");
                }
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importDistributors(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("distributors"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("distributors")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("distributors"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " distributors");
            this.writeText("\n" + this.getCreatingTableMessage() + " distributors...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateDistributors());
            if (this.checkTableExistence(jDBCAdapter, "distributors")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " distributors...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoDistributors());
                DataImportType1 dataImportType1 = new DataImportType1(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "distributors", "DISTRIBUTORS LIST", 2);
                JMDBMain.myJMDBMain.log("Reading distributors...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " distributors...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "distributors.list");
                try {
                    while (dataImportType1.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType1.resArray[0]);
                        if (n2 <= 0) continue;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType1.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "distributors.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex() && !this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("distributors", "movieid", 0));
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("distributors: import completed");
                }
                dataImportType1 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importEditors(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("editors"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("movies2editors")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("movies2editors"));
            }
            if (this.getExistingTableByName("editors")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("editors"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " editors");
            this.writeText("\n" + this.getCreatingTableMessage() + " movies2editors...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateMovies2Editors());
            if (this.checkTableExistence(jDBCAdapter, "movies2editors")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getCreatingTableMessage() + " editors...");
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateEditors());
                if (this.checkTableExistence(jDBCAdapter, "editors")) {
                    this.writeText(this.getOkMessage());
                }
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " editors...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                int n = 0;
                this.setM2x_count(0);
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoEditors());
                DataImportType2 dataImportType2 = new DataImportType2(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "editors", "THE EDITORS LIST", 5);
                JMDBMain.myJMDBMain.log("Reading editors...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " editors...");
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "editors.list");
                try {
                    while (dataImportType2.getData() && !this.isCancelImport()) {
                        if (dataImportType2.resArray[0] == null || dataImportType2.resArray[1] == null) continue;
                        if (!dataImportType2.resArray[0].equals("")) {
                            jDBCAdapter.getPreparedStatement().setString(1, dataImportType2.resArray[0]);
                            jDBCAdapter.getPreparedStatement().addBatch();
                            if (++n % 1000 == 0) {
                                jDBCAdapter.executePreparedBatch();
                            }
                            if (this.getM2x_count() >= this.getM2x_maxcount()) {
                                jDBCAdapter.executePreparedBatch();
                                this.stopTransaction(jDBCAdapter, "editors.list");
                                this.myStatus.setText(String.valueOf(this.getNowMessage()) + " " + n + " editors " + this.getReadMessage() + ".");
                                this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2Editors(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
                                this.setM2x_count(0);
                                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoEditors());
                                this.startTransaction(jDBCAdapter, "editors.list");
                            }
                        }
                        if ((n2 = this.movieArray.getMovieid(dataImportType2.resArray[1])) <= 0) continue;
                        this.m2x_xid[this.getM2x_count()] = n;
                        this.m2x_movieid[this.getM2x_count()] = n2;
                        this.m2x_addinfo[this.getM2x_count()] = new String(dataImportType2.resArray[2]);
                        ++this.m2x_count;
                    }
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                jDBCAdapter.executePreparedBatch();
                this.stopTransaction(jDBCAdapter, "editors.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.isCancelImport()) {
                    this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2Editors(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
                }
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex()) {
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies2editors", "movieid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies2editors", "editorid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("editors", "name", 10));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("editors: import completed");
                }
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importGenres(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("genres"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("genres")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("genres"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " genres");
            this.writeText("\n" + this.getCreatingTableMessage() + " genres...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateGenres());
            if (this.checkTableExistence(jDBCAdapter, "genres")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " genres...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoGenres());
                DataImportType1 dataImportType1 = new DataImportType1(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "genres", "8: THE GENRES LIST", 2);
                JMDBMain.myJMDBMain.log("Reading genres...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " genres...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "genres.list");
                try {
                    while (dataImportType1.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType1.resArray[0]);
                        if (n2 <= 0) continue;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType1.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "genres.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex()) {
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("genres", "movieid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("genres", "genre", 15));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("genres: import completed");
                }
                dataImportType1 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importGoofs(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("goofs"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("goofs")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("goofs"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " goofs");
            this.writeText("\n" + this.getCreatingTableMessage() + " goofs...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateGoofs());
            if (this.checkTableExistence(jDBCAdapter, "goofs")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " goofs...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoGoofs());
                DataImportType5 dataImportType5 = new DataImportType5(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "goofs", "GOOFS LIST", 2);
                JMDBMain.myJMDBMain.log("Reading goofs...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " goofs...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "goofs.list");
                try {
                    while (dataImportType5.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType5.resArray[0]);
                        if (n2 <= 0) continue;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType5.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "goofs.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex() && !this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("goofs", "movieid", 0));
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("goofs: import completed");
                }
                dataImportType5 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importKeywords(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("keywords"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("keywords")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("keywords"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " keywords");
            this.writeText("\n" + this.getCreatingTableMessage() + " keywords...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateKeywords());
            if (this.checkTableExistence(jDBCAdapter, "keywords")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " keywords...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoKeywords());
                DataImportType1 dataImportType1 = new DataImportType1(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "keywords", "8: THE KEYWORDS LIST", 2);
                JMDBMain.myJMDBMain.log("Reading keywords...");
                this.myStatus.setText("\n" + this.getReadingMessage() + " keywords...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "keywords.list");
                try {
                    while (dataImportType1.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType1.resArray[0]);
                        if (n2 <= 0) continue;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType1.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "keywords.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex()) {
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("keywords", "movieid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("keywords", "keyword", 15));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("keywords: import completed");
                }
                dataImportType1 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importKeywordsTest(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("keywords"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            DataImportType1 dataImportType1 = null;
            int n = 250;
            while (n <= 5000) {
                if (this.getExistingTableByName("keywords")) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("keywords"));
                }
                this.writeHeading("\n\n" + this.getConvertingMessage() + " keywords");
                this.writeText("\n" + this.getCreatingTableMessage() + " keywords...");
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateKeywords());
                if (this.checkTableExistence(jDBCAdapter, "keywords")) {
                    this.writeText(this.getOkMessage());
                }
                if (!this.isCancelImport()) {
                    this.writeText("\n" + this.getConvertingMessage() + " keywords...");
                    JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                    String[] cfr_ignored_0 = new String[2];
                    int[] cfr_ignored_1 = new int[2];
                    jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoKeywords());
                    dataImportType1 = new DataImportType1(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "keywords", "8: THE KEYWORDS LIST", 2);
                    JMDBMain.myJMDBMain.log("Reading keywords...");
                    this.myStatus.setText("\n" + this.getReadingMessage() + " keywords...");
                    long l = System.currentTimeMillis();
                    this.startTransaction(jDBCAdapter, "keywords.list");
                    int n2 = -1;
                    int n3 = 0;
                    int n4 = n;
                    try {
                        JMDBMain.myJMDBMain.log("Run using blockWriteSize = " + n4);
                        while (dataImportType1.getData() && !this.isCancelImport()) {
                            n2 = this.movieArray.getMovieid(dataImportType1.resArray[0]);
                            if (n2 <= 0) continue;
                            jDBCAdapter.getPreparedStatement().setInt(1, n2);
                            jDBCAdapter.getPreparedStatement().setString(2, dataImportType1.resArray[1]);
                            jDBCAdapter.getPreparedStatement().addBatch();
                            if (++n3 % n4 != 0) continue;
                            jDBCAdapter.getPreparedStatement().executeBatch();
                        }
                        jDBCAdapter.getPreparedStatement().executeBatch();
                    }
                    catch (SQLException sQLException) {
                        JMDBMain.myJMDBMain.log("SQL Exception processing keyword: " + jDBCAdapter.getPreparedStatement().toString() + " - " + sQLException);
                    }
                    this.stopTransaction(jDBCAdapter, "keywords.list");
                    jDBCAdapter.closePreparedStatement();
                    long l2 = System.currentTimeMillis();
                    long l3 = l2 - l;
                    long l4 = l3 / 1000L;
                    long l5 = l4 / 3600L;
                    long l6 = (l4 %= 3600L) / 60L;
                    long l7 = l4 % 60L;
                    DecimalFormat decimalFormat = new DecimalFormat("00");
                    JMDBMain.myJMDBMain.log(String.valueOf(n3) + " rows in: " + decimalFormat.format(l5) + " h " + decimalFormat.format(l6) + " min " + decimalFormat.format(l7) + " sec" + " --- rows/permilli: " + (double)n3 / (double)l3);
                }
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex()) {
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("keywords", "movieid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("keywords", "keyword", 15));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("keywords: import completed");
                }
                dataImportType1 = null;
                n += 250;
            }
        }
    }

    private void importLanguage(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("language"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("language")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("language"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " language");
            this.writeText("\n" + this.getCreatingTableMessage() + " language...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateLanguage());
            if (this.checkTableExistence(jDBCAdapter, "language")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " language...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoLanguage());
                DataImportType1 dataImportType1 = new DataImportType1(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "language", "LANGUAGE LIST", 1);
                JMDBMain.myJMDBMain.log("Reading languages...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " languages...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "language.list");
                try {
                    while (dataImportType1.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType1.resArray[0]);
                        if (n2 <= 0) continue;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType1.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "language.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex() && !this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("language", "movieid", 0));
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("languages: import completed");
                }
                dataImportType1 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importLiterature(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("literature"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("literature")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("literature"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " literature");
            this.writeText("\n" + this.getCreatingTableMessage() + " literature...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateLiterature());
            if (this.checkTableExistence(jDBCAdapter, "literature")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " literature...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoLiterature());
                DataImportType16 dataImportType16 = new DataImportType16(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "literature", "LITERATURE LIST", 2);
                JMDBMain.myJMDBMain.log("Reading literature...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " literature...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "literature.list");
                try {
                    while (dataImportType16.getData() && !this.isCancelImport()) {
                        if (dataImportType16.resArray[0] == null || dataImportType16.resArray[1] == null || dataImportType16.resArray[1].length() <= 0) break;
                        n2 = this.movieArray.getMovieid(dataImportType16.resArray[0]);
                        if (n2 <= 0) continue;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType16.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "literature.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex() && !this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("literature", "movieid", 0));
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("literature: import completed");
                }
                dataImportType16 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importLocations(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("locations"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("locations")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("locations"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " locations");
            this.writeText("\n" + this.getCreatingTableMessage() + " locations...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateLocations());
            if (this.checkTableExistence(jDBCAdapter, "locations")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " locations...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoLocations());
                DataImportType1 dataImportType1 = new DataImportType1(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "locations", "LOCATIONS LIST", 2);
                JMDBMain.myJMDBMain.log("Reading locations...");
                this.myStatus.setText("\n" + this.getReadingMessage() + " locations...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "locations.list");
                try {
                    while (dataImportType1.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType1.resArray[0]);
                        if (n2 <= 0) continue;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType1.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "locations.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex() && !this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("locations", "movieid", 0));
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("locations: import completed");
                }
                dataImportType1 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importMiscellaneous(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("miscellaneous"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("movies2misc")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("movies2misc"));
            }
            if (this.getExistingTableByName("misc")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("misc"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " miscellaneous");
            this.writeText("\n" + this.getCreatingTableMessage() + " movies2misc (miscellaneous)...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateMovies2Miscellaneous());
            if (this.checkTableExistence(jDBCAdapter, "movies2misc")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getCreatingTableMessage() + " misc (miscellaneous)...");
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateMiscellaneous());
                if (this.checkTableExistence(jDBCAdapter, "misc")) {
                    this.writeText(this.getOkMessage());
                }
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " miscellaneous...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                int n = 0;
                this.setM2x_count(0);
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoMiscellaneous());
                DataImportType2 dataImportType2 = new DataImportType2(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "miscellaneous", "THE MISCELLANEOUS FILMOGRAPHY LIST", 5);
                JMDBMain.myJMDBMain.log("Reading miscellaneous...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " miscellaneous...");
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "miscellaneous.list");
                try {
                    while (dataImportType2.getData() && !this.isCancelImport()) {
                        if (dataImportType2.resArray[0] == null || dataImportType2.resArray[1] == null) continue;
                        if (!dataImportType2.resArray[0].equals("")) {
                            jDBCAdapter.getPreparedStatement().setString(1, dataImportType2.resArray[0]);
                            jDBCAdapter.getPreparedStatement().addBatch();
                            if (++n % 1000 == 0) {
                                jDBCAdapter.executePreparedBatch();
                            }
                            if (this.getM2x_count() >= this.getM2x_maxcount()) {
                                jDBCAdapter.executePreparedBatch();
                                this.stopTransaction(jDBCAdapter, "miscellaneous.list");
                                this.myStatus.setText(String.valueOf(this.getNowMessage()) + " " + n + " miscellaneous " + this.getReadMessage() + ".");
                                this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2Miscellaneous(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
                                this.setM2x_count(0);
                                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoMiscellaneous());
                                this.startTransaction(jDBCAdapter, "miscellaneous.list");
                            }
                        }
                        if ((n2 = this.movieArray.getMovieid(dataImportType2.resArray[1])) <= 0) continue;
                        this.m2x_xid[this.getM2x_count()] = n;
                        this.m2x_movieid[this.getM2x_count()] = n2;
                        this.m2x_addinfo[this.getM2x_count()] = new String(dataImportType2.resArray[2]);
                        ++this.m2x_count;
                    }
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                jDBCAdapter.executePreparedBatch();
                this.stopTransaction(jDBCAdapter, "miscellaneous.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.isCancelImport()) {
                    this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2Miscellaneous(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
                }
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex()) {
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies2misc", "movieid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies2misc", "miscid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("misc", "name", 10));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("miscellaneous: import completed");
                }
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importMovieLinks(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("movie-links"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("movielinks")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("movielinks"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " movie-links");
            this.writeText("\n" + this.getCreatingTableMessage() + " movielinks...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateMovieLinks());
            if (this.checkTableExistence(jDBCAdapter, "movielinks")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " movie-links...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoMovieLinks());
                DataImportType15 dataImportType15 = new DataImportType15(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "movie-links", "MOVIE LINKS LIST", 2);
                JMDBMain.myJMDBMain.log("Reading movie-links...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " movie-links...");
                int n = 0;
                int n2 = 0;
                this.startTransaction(jDBCAdapter, "movie-links.list");
                try {
                    while (dataImportType15.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType15.resArray[0]);
                        if (n2 <= 0) continue;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType15.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "movie-links.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex() && !this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movielinks", "movieid", 0));
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("movie-links: import completed");
                }
                dataImportType15 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importMovies(JDBCAdapter jDBCAdapter) {
        this.writeHeading("\n\n" + this.getConvertingMessage() + " movies");
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("movies"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
        }
        this.writeText("\n" + resMessagesBundle.getString("DatabaseConverter.statusmessagetext.counting") + " movies...");
        DataImportType1_CountEntries dataImportType1_CountEntries = new DataImportType1_CountEntries(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "movies", "MOVIES LIST", 2);
        int n = 0;
        while (dataImportType1_CountEntries.getData() && !this.isCancelImport()) {
            if (++n % 20000 != 0) continue;
            this.myStatus.setText(String.valueOf(n) + " " + resMessagesBundle.getString("DatabaseConverter.statusmessagetext.entriesfound") + ".");
        }
        JMDBMain.myJMDBMain.log(String.valueOf(n) + " movies found. - to end of file");
        this.writeText(this.getOkMessage());
        this.getStopWatch().restart("movies: counting completed");
        dataImportType1_CountEntries = null;
        this.setMovieArray(new MovieArray(n));
        this.getMovieArray().deletelogErrorsIMDb();
        int n2 = 0;
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("movies"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileRequired() && !this.isCancelImport()) {
            ++this.importCounter;
            this.writeText("\n" + this.getReadingMessage() + " movies...");
            DataImportType1 dataImportType1 = new DataImportType1(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "movies", "MOVIES LIST", 2);
            JMDBMain.myJMDBMain.log("Entering while loop to fill movie array...");
            while (dataImportType1.getData() && !this.isCancelImport()) {
                if (++n2 % 20000 == 0) {
                    this.myStatus.setText(String.valueOf(n2) + " movies " + this.getReadMessage());
                    if (n2 / (n / 100) >= 90 && this.myDataBaseConverter.checkMemoryUtilisation(false) == 0) {
                        this.setCancelImport(true);
                    }
                }
                this.movieArray.add(dataImportType1.resArray[0], dataImportType1.resArray[1]);
            }
            JMDBMain.myJMDBMain.log("Left while loop to fill movie array...");
            if (!this.isCancelImport()) {
                this.getStopWatch().restart("movies: add to array completed");
                this.movieArray.sort();
                this.getStopWatch().restart("movies: sorting completed");
                this.movieArray.check();
                this.getStopWatch().restart("movies: checking completed");
            }
            this.myDataBaseConverter.checkMemoryUtilisation(true);
            if (dataImportType1.getErrorCode() != 0) {
                JMDBMain.myJMDBMain.log("Error message - movies.list: " + dataImportType1.getErrorMessage());
                JMDBMain.myJMDBMain.log("Error line - movies.list: " + dataImportType1.getErrorLine());
                this.writeText(String.valueOf(this.getOkMessage()) + " (IMDb bug)");
            } else {
                this.writeText(this.getOkMessage());
            }
            dataImportType1 = null;
            String string = "movies_imdbid";
            if (new File(String.valueOf(DataBaseConverter2.getCfgImportPath()) + string + ".list").exists() || new File(String.valueOf(DataBaseConverter2.getCfgImportPath()) + string + ".list.gz").exists()) {
                dataImportType1 = new DataImportType1(String.valueOf(DataBaseConverter2.getCfgImportPath()) + string, null, 0);
                this.writeText("\n" + this.getReadingMessage() + " movies_imdbId...");
                JMDBMain.myJMDBMain.log("Entering while loop to add imdbid to movie array...");
                int n3 = 0;
                while (dataImportType1.getData() && !this.isCancelImport()) {
                    if (dataImportType1.resArray[1] == null || dataImportType1.resArray[1].equalsIgnoreCase("no_imdb_id")) continue;
                    if (++n3 % 20000 == 0) {
                        System.gc();
                        this.myStatus.setText(String.valueOf(n3) + " movie IMDb Ids " + this.getReadMessage());
                        if (this.myDataBaseConverter.checkMemoryUtilisation(false) == 0) {
                            this.setCancelImport(true);
                        }
                    }
                    this.movieArray.addIMDbId(dataImportType1.resArray[0], dataImportType1.resArray[1]);
                }
                if (!this.isCancelImport()) {
                    this.getStopWatch().restart("movies: add IMDb IDs to array completed");
                }
                if (dataImportType1.getErrorCode() != 0) {
                    JMDBMain.myJMDBMain.log("Error message - movies_imdbId.list: " + dataImportType1.getErrorMessage());
                    JMDBMain.myJMDBMain.log("Error line - movies_imdbId.list: " + dataImportType1.getErrorLine());
                    this.writeText(String.valueOf(this.getOkMessage()) + " (IMDb bug)");
                } else {
                    this.writeText(this.getOkMessage());
                }
                this.myDataBaseConverter.checkMemoryUtilisation(true);
            }
            dataImportType1 = null;
        }
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("movies"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            if (this.getExistingTableByName("movies")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("movies"));
            }
            this.writeText("\n" + this.getCreatingTableMessage() + " movies...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateMovies());
            if (this.checkTableExistence(jDBCAdapter, "movies")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " movies...");
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoMovies());
                JMDBMain.myJMDBMain.log("Entering while loop to fill movies into DB table...");
                this.startTransaction(jDBCAdapter, "movies.list");
                try {
                    int n4 = 1;
                    while (n4 <= n2) {
                        if (this.isCancelImport()) break;
                        jDBCAdapter.getPreparedStatement().setString(1, this.movieArray.getTitle(n4));
                        jDBCAdapter.getPreparedStatement().setString(2, this.movieArray.getYear(n4));
                        jDBCAdapter.getPreparedStatement().setString(3, this.movieArray.getImdbId(n4));
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (n4 % 1000 == 0) {
                            jDBCAdapter.executePreparedBatch();
                            if (n4 % 20000 == 0) {
                                this.myStatus.setText(String.valueOf(n4) + " " + resMessagesBundle.getString("JMDB.label.x_movies_written"));
                            }
                        }
                        ++n4;
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "movies.list");
                jDBCAdapter.closePreparedStatement();
                this.isCancelImport();
                if (!this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies", "title", 15));
                    if (this.getSQLWorker().isSQLMetaTextSearchSupported()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndexFullText("movies", "title", null, null));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("movies: import completed");
                }
                dataImportType1_CountEntries = null;
            }
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
        this.setM2x_maxcount(50000);
        this.m2x_xid = new int[this.getM2x_maxcount() + 5000];
        this.m2x_movieid = new int[this.getM2x_maxcount() + 5000];
        this.m2x_addinfo = new String[this.getM2x_maxcount() + 5000];
        this.setM2x_count(0);
    }

    private void importMPAARatingsReasons(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("mpaa-ratings-reasons"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("mpaaratings")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("mpaaratings"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " mpaa-ratings-reasons");
            this.writeText("\n" + this.getCreatingTableMessage() + " mpaaratings...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateMPAARatingsReasons());
            if (this.checkTableExistence(jDBCAdapter, "mpaaratings")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " mpaa-ratings-reasons...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoMPAARatingsReasons());
                DataImportType10 dataImportType10 = new DataImportType10(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "mpaa-ratings-reasons", "MPAA RATINGS REASONS LIST", 2);
                JMDBMain.myJMDBMain.log("Reading mpaa-ratings-reasons...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " mpaa-ratings-reasons...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "mpaa-ratings-reasons.list");
                try {
                    while (dataImportType10.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType10.resArray[0]);
                        if (n2 <= 0) continue;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType10.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "mpaa-ratings-reasons.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex() && !this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("mpaaratings", "movieid", 0));
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("mpaa-ratings-reasons: import completed");
                }
                dataImportType10 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importPlots(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("plot"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("plots")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("plots"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " plot");
            this.writeText("\n" + this.getCreatingTableMessage() + " plots...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreatePlots());
            if (this.checkTableExistence(jDBCAdapter, "plots")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " plot...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                DataImportType3 dataImportType3 = new DataImportType3(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "plot", "PLOT SUMMARIES LIST", 2);
                JMDBMain.myJMDBMain.log("Reading plots...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " plots...");
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoPlots());
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "plots.list");
                try {
                    while (dataImportType3.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType3.resArray[0]);
                        if (n2 <= 0) continue;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType3.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                        if (n % 2000 != 0) continue;
                        this.myStatus.setText(String.valueOf(n) + " plots converted");
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "plots.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex() && !this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("plots", "movieid", 0));
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("plots: import completed");
                }
                dataImportType3 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importProducers(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("producers"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("movies2producers")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("movies2producers"));
            }
            if (this.getExistingTableByName("producers")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("producers"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " producers");
            this.writeText("\n" + this.getCreatingTableMessage() + " movies2producers...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateMovies2Producers());
            if (this.checkTableExistence(jDBCAdapter, "movies2producers")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getCreatingTableMessage() + " producers...");
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateProducers());
                if (this.checkTableExistence(jDBCAdapter, "producers")) {
                    this.writeText(this.getOkMessage());
                }
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " producers...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                int n = 0;
                this.setM2x_count(0);
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoProducers());
                DataImportType2 dataImportType2 = new DataImportType2(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "producers", "THE PRODUCERS LIST", 4);
                JMDBMain.myJMDBMain.log("Reading producers...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " producers...");
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "producers.list");
                try {
                    while (dataImportType2.getData() && !this.isCancelImport()) {
                        if (dataImportType2.resArray[0] == null || dataImportType2.resArray[1] == null) continue;
                        if (!dataImportType2.resArray[0].equals("")) {
                            jDBCAdapter.getPreparedStatement().setString(1, dataImportType2.resArray[0]);
                            jDBCAdapter.getPreparedStatement().addBatch();
                            if (++n % 1000 == 0) {
                                jDBCAdapter.executePreparedBatch();
                            }
                            if (this.getM2x_count() >= this.getM2x_maxcount()) {
                                jDBCAdapter.executePreparedBatch();
                                this.stopTransaction(jDBCAdapter, "producers.list");
                                this.myStatus.setText(String.valueOf(this.getNowMessage()) + " " + n + " producers " + this.getReadMessage() + ".");
                                this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2Producers(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
                                this.setM2x_count(0);
                                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoProducers());
                                this.startTransaction(jDBCAdapter, "producers.list");
                            }
                        }
                        if ((n2 = this.movieArray.getMovieid(dataImportType2.resArray[1])) <= 0) continue;
                        this.m2x_xid[this.getM2x_count()] = n;
                        this.m2x_movieid[this.getM2x_count()] = n2;
                        this.m2x_addinfo[this.getM2x_count()] = new String(dataImportType2.resArray[2]);
                        ++this.m2x_count;
                    }
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                jDBCAdapter.executePreparedBatch();
                this.stopTransaction(jDBCAdapter, "producers.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.isCancelImport()) {
                    this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2Producers(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
                }
                if (!this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies2producers", "movieid", 0));
                }
                if (!this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies2producers", "producerid", 0));
                }
                if (!this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("producers", "name", 10));
                    if (this.getSQLWorker().isSQLMetaTextSearchSupported()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndexFullText("producers", "name", null, null));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("producers: import completed");
                }
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importProductionCompanies(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("production-companies"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("prodcompanies")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("prodcompanies"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " production companies");
            this.writeText("\n" + this.getCreatingTableMessage() + " prod.companies...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateProductionCompanies());
            if (this.checkTableExistence(jDBCAdapter, "prodcompanies")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " prod. companies...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoProductionCompanies());
                DataImportType1 dataImportType1 = new DataImportType1(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "production-companies", "PRODUCTION COMPANIES LIST", 2);
                JMDBMain.myJMDBMain.log("Reading prod. companies...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " prod. companies...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "production-companies.list");
                try {
                    while (dataImportType1.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType1.resArray[0]);
                        if (n2 <= 0) continue;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType1.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "production-companies.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex()) {
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("prodcompanies", "movieid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("prodcompanies", "name", 15));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("prod. companies: import completed");
                }
                dataImportType1 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importProductionDesigners(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("production-designers"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("movies2proddes")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("movies2proddes"));
            }
            if (this.getExistingTableByName("proddesigners")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("proddesigners"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " production-designers");
            this.writeText("\n" + this.getCreatingTableMessage() + " movies2proddes (production designers)...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateMovies2ProductionDesigners());
            if (this.checkTableExistence(jDBCAdapter, "movies2proddes")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getCreatingTableMessage() + " proddesigners (production designers)...");
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateProductionDesigners());
                if (this.checkTableExistence(jDBCAdapter, "proddesigners")) {
                    this.writeText(this.getOkMessage());
                }
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " productions-designers...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                int n = 0;
                this.setM2x_count(0);
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoProductionDesigners());
                DataImportType2 dataImportType2 = new DataImportType2(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "production-designers", "THE PRODUCTION DESIGNERS LIST", 4);
                JMDBMain.myJMDBMain.log("Reading production designers...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " production designers...");
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "production-designers.list");
                try {
                    while (dataImportType2.getData() && !this.isCancelImport()) {
                        if (dataImportType2.resArray[0] == null || dataImportType2.resArray[1] == null) continue;
                        if (!dataImportType2.resArray[0].equals("")) {
                            jDBCAdapter.getPreparedStatement().setString(1, dataImportType2.resArray[0]);
                            jDBCAdapter.getPreparedStatement().addBatch();
                            if (++n % 1000 == 0) {
                                jDBCAdapter.executePreparedBatch();
                            }
                            if (this.getM2x_count() >= this.getM2x_maxcount()) {
                                jDBCAdapter.executePreparedBatch();
                                this.stopTransaction(jDBCAdapter, "production-designers.list");
                                this.myStatus.setText(String.valueOf(this.getNowMessage()) + " " + n + " production designers " + this.getReadMessage() + ".");
                                this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2ProductionDesigners(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
                                this.setM2x_count(0);
                                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoProductionDesigners());
                                this.startTransaction(jDBCAdapter, "production-designers.list");
                            }
                        }
                        if ((n2 = this.movieArray.getMovieid(dataImportType2.resArray[1])) <= 0) continue;
                        this.m2x_xid[this.getM2x_count()] = n;
                        this.m2x_movieid[this.getM2x_count()] = n2;
                        this.m2x_addinfo[this.getM2x_count()] = new String(dataImportType2.resArray[2]);
                        ++this.m2x_count;
                    }
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                jDBCAdapter.executePreparedBatch();
                this.stopTransaction(jDBCAdapter, "production-designers.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.isCancelImport()) {
                    this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2ProductionDesigners(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
                }
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex()) {
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies2proddes", "movieid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies2proddes", "proddesid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("proddesigners", "name", 10));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("production-designers: import completed");
                }
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importQuotes(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("quotes"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("quotes")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("quotes"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " quotes");
            this.writeText("\n" + this.getCreatingTableMessage() + " quotes...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateQuotes());
            if (this.checkTableExistence(jDBCAdapter, "quotes")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " quotes...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoQuotes());
                DataImportType5 dataImportType5 = new DataImportType5(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "quotes", "QUOTES LIST", 1);
                JMDBMain.myJMDBMain.log("Reading quotes...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " quotes...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "quotes.list");
                try {
                    while (dataImportType5.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType5.resArray[0]);
                        if (n2 <= 0) continue;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType5.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                        if (n % 2000 != 0) continue;
                        this.myStatus.setText(String.valueOf(n) + " quotes converted");
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "quotes.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex() && !this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("quotes", "movieid", 0));
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("quotes: import completed");
                }
                dataImportType5 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importRatings(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("ratings"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("ratings")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("ratings"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " ratings");
            this.writeText("\n" + this.getCreatingTableMessage() + " ratings...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateRatings());
            if (this.checkTableExistence(jDBCAdapter, "ratings")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " ratings...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoRatings());
                DataImportType7 dataImportType7 = new DataImportType7(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "ratings", "MOVIE RATINGS REPORT", 2);
                JMDBMain.myJMDBMain.log("Reading ratings...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " ratings...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "ratings.list");
                try {
                    while (dataImportType7.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType7.resArray[3]);
                        if (n2 <= 0) continue;
                        ++n;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType7.resArray[2]);
                        jDBCAdapter.getPreparedStatement().setInt(3, new Integer(dataImportType7.resArray[1]));
                        jDBCAdapter.getPreparedStatement().setString(4, dataImportType7.resArray[0]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "ratings.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex() && !this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("ratings", "movieid", 0));
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("ratings: import completed");
                }
                dataImportType7 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importReleasedates(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("release-dates"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("releasedates")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("releasedates"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " release-dates");
            this.writeText("\n" + this.getCreatingTableMessage() + " releasedates...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateReleasedates());
            if (this.checkTableExistence(jDBCAdapter, "releasedates")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " release-dates...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoReleasedates());
                DataImportType13 dataImportType13 = new DataImportType13(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "release-dates", "RELEASE DATES LIST", 1);
                JMDBMain.myJMDBMain.log("Reading release-dates...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " release-dates...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "release-dates.list");
                try {
                    while (dataImportType13.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType13.resArray[0]);
                        if (n2 <= 0 || dataImportType13.resArray[3] == null) continue;
                        ++n;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType13.resArray[1]);
                        jDBCAdapter.getPreparedStatement().setString(3, dataImportType13.resArray[2]);
                        jDBCAdapter.getPreparedStatement().setDate(4, Date.valueOf(dataImportType13.resArray[3]));
                        jDBCAdapter.getPreparedStatement().setString(5, dataImportType13.resArray[4]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "release-dates.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex()) {
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("releasedates", "movieid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("releasedates", "country", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("releasedates", "releasedate", 0));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("release-dates: import completed");
                }
                dataImportType13 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importRunningtimes(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("running-times"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("runningtimes")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("runningtimes"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " running-times");
            this.writeText("\n" + this.getCreatingTableMessage() + " runningtimes...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateRunningtimes());
            if (this.checkTableExistence(jDBCAdapter, "runningtimes")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " running-times...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoRunningtimes());
                DataImportType6 dataImportType6 = new DataImportType6(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "running-times", "RUNNING TIMES LIST", 1);
                JMDBMain.myJMDBMain.log("Reading running-times...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " running-times...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "running-times.list");
                try {
                    while (dataImportType6.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType6.resArray[0]);
                        if (n2 <= 0) continue;
                        ++n;
                        if (dataImportType6.resArray[1].length() > 50) {
                            dataImportType6.resArray[1] = dataImportType6.resArray[1].substring(0, 50);
                        }
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType6.resArray[1]);
                        jDBCAdapter.getPreparedStatement().setString(3, dataImportType6.resArray[2]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "running-times.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex() && !this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("runningtimes", "movieid", 0));
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("running-times: import completed");
                }
                dataImportType6 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importTaglines(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("taglines"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("taglines")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("taglines"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " taglines");
            this.writeText("\n" + this.getCreatingTableMessage() + " taglines...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateTaglines());
            if (this.checkTableExistence(jDBCAdapter, "taglines")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " taglines...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoTaglines());
                DataImportType9 dataImportType9 = new DataImportType9(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "taglines", "TAG LINES LIST", 3);
                JMDBMain.myJMDBMain.log("Reading taglines...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " taglines...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "taglines.list");
                try {
                    while (dataImportType9.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType9.resArray[0]);
                        if (n2 <= 0) continue;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType9.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "taglines.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex() && !this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("taglines", "movieid", 0));
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("taglines: import completed");
                }
                dataImportType9 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importTechnical(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("technical"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("technical")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("technical"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " technical");
            this.writeText("\n" + this.getCreatingTableMessage() + " technical...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateTechnical());
            if (this.checkTableExistence(jDBCAdapter, "technical")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " technical...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoTechnical());
                DataImportType1 dataImportType1 = new DataImportType1(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "technical", "TECHNICAL LIST", 3);
                JMDBMain.myJMDBMain.log("Reading technical...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " technical...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "technical.list");
                try {
                    while (dataImportType1.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType1.resArray[0]);
                        if (n2 <= 0) continue;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType1.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "technical.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex()) {
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("technical", "movieid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("technical", "name", 15));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("technical: import completed");
                }
                dataImportType1 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importTrivia(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("trivia"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("trivia")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("trivia"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " trivia");
            this.writeText("\n" + this.getCreatingTableMessage() + " trivia...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateTrivia());
            if (this.checkTableExistence(jDBCAdapter, "trivia")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " trivia...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoTrivia());
                DataImportType5 dataImportType5 = new DataImportType5(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "trivia", "FILM TRIVIA", 2);
                JMDBMain.myJMDBMain.log("Reading trivia...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " trivia...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "trivia.list");
                try {
                    while (dataImportType5.getData() && !this.isCancelImport()) {
                        n2 = this.movieArray.getMovieid(dataImportType5.resArray[0]);
                        if (n2 <= 0) continue;
                        jDBCAdapter.getPreparedStatement().setInt(1, n2);
                        jDBCAdapter.getPreparedStatement().setString(2, dataImportType5.resArray[1]);
                        jDBCAdapter.getPreparedStatement().addBatch();
                        if (++n % 1000 != 0) continue;
                        jDBCAdapter.executePreparedBatch();
                    }
                    jDBCAdapter.executePreparedBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                this.stopTransaction(jDBCAdapter, "trivia.list");
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex() && !this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("trivia", "movieid", 0));
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("trivia: import completed");
                }
                dataImportType5 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importUsrMovieLensItems100k(JDBCAdapter jDBCAdapter) {
        String string = "u.item";
        if (new File(String.valueOf(DataBaseConverter2.getCfgImportPath()) + string).exists() && !this.isCancelImport()) {
            if (this.getExistingTableByName("usr_ml_items")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("usr_ml_items"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " " + string);
            this.writeText("\n" + this.getCreatingTableMessage() + " usr_ml_items...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateUsrMLItems());
            if (this.checkTableExistence(jDBCAdapter, "usr_ml_items")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                SQLException sQLException4;
                this.writeText("\n" + this.getConvertingMessage() + " " + string + "...");
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoUsrMLItems());
                UsrDataImportType1 usrDataImportType1 = new UsrDataImportType1(String.valueOf(DataBaseConverter2.getCfgImportPath()) + string);
                JMDBMain.myJMDBMain.log("Reading " + string + "...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " " + string + "...");
                int n = 0;
                int n2 = -1;
                this.startTransaction(jDBCAdapter, string);
                try {
                    try {
                        this.titleSearchStatement = jDBCAdapter.getConnection().prepareStatement("SELECT movieid FROM movies WHERE title " + this.getSQLWorker().getSQLMetaLikeCaseInsensitive() + " ?");
                        this.akaTitleSearchStatement = jDBCAdapter.getConnection().prepareStatement("SELECT movieid FROM akatitles WHERE title " + this.getSQLWorker().getSQLMetaLikeCaseInsensitive() + " ?");
                        String string2 = null;
                        while (usrDataImportType1.getData() && !this.isCancelImport()) {
                            string2 = usrDataImportType1.resArray[1];
                            n2 = this.movieArray.getMovieid(usrDataImportType1.resArray[1]);
                            if (n2 == -1 && (n2 = this.getMovieIdByTitle(jDBCAdapter, usrDataImportType1.resArray[1], false, true)) == 0) {
                                n2 = this.getMovieIdByTitle(jDBCAdapter, usrDataImportType1.resArray[1], true, true);
                                if (n2 == 0 && usrDataImportType1.resArray[3] != null) {
                                    string2 = usrDataImportType1.resArray[3];
                                    n2 = this.movieArray.getMovieid(usrDataImportType1.resArray[3]);
                                    if (n2 == -1 && (n2 = this.getMovieIdByTitle(jDBCAdapter, usrDataImportType1.resArray[3], false, true)) == 0) {
                                        n2 = this.getMovieIdByTitle(jDBCAdapter, usrDataImportType1.resArray[3], true, true);
                                    }
                                }
                                if (n2 == 0 && usrDataImportType1.resArray[4] != null) {
                                    string2 = usrDataImportType1.resArray[4];
                                    n2 = this.movieArray.getMovieid(usrDataImportType1.resArray[4]);
                                    if (n2 == -1 && (n2 = this.getMovieIdByTitle(jDBCAdapter, usrDataImportType1.resArray[4], false, true)) == 0) {
                                        n2 = this.getMovieIdByTitle(jDBCAdapter, usrDataImportType1.resArray[4], true, true);
                                    }
                                }
                            }
                            if (n2 < 0) continue;
                            ++n;
                            jDBCAdapter.getPreparedStatement().setInt(1, new Integer(usrDataImportType1.resArray[0]));
                            jDBCAdapter.getPreparedStatement().setInt(2, n2);
                            jDBCAdapter.getPreparedStatement().setString(3, usrDataImportType1.resArray[1]);
                            if (usrDataImportType1.resArray[1].equals(string2)) {
                                jDBCAdapter.getPreparedStatement().setString(4, null);
                            } else {
                                jDBCAdapter.getPreparedStatement().setString(4, string2);
                            }
                            jDBCAdapter.getPreparedStatement().addBatch();
                            if (n % 1000 != 0) continue;
                            jDBCAdapter.executePreparedBatch();
                            if (n % 2000 != 0) continue;
                            this.myStatus.setText(String.valueOf(n) + " items (ml-movies) converted");
                        }
                        jDBCAdapter.executePreparedBatch();
                    }
                    catch (SQLException sQLException2) {
                        JMDBMain.myJMDBMain.log("An error occured while inserting data/aka query: " + sQLException2 + "Title-/AKA-Title-Search-Statement: " + this.titleSearchStatement.toString() + "/---/" + this.akaTitleSearchStatement.toString() + " - INSERT-Statement: " + jDBCAdapter.getPreparedStatement().toString());
                    }
                }
                catch (Throwable throwable) {
                    SQLException sQLException32;
                    Object var6_9 = null;
                    if (this.titleSearchStatement != null) {
                        try {
                            this.titleSearchStatement.close();
                        }
                        catch (SQLException sQLException32) {
                            JMDBMain.myJMDBMain.log("Warning: Could not close titleSearchStatement. " + sQLException32);
                        }
                    }
                    if (this.akaTitleSearchStatement != null) {
                        try {
                            this.akaTitleSearchStatement.close();
                        }
                        catch (SQLException sQLException32) {
                            JMDBMain.myJMDBMain.log("Warning: Could not close akaTitleSearchStatement. " + sQLException32);
                        }
                    }
                    throw throwable;
                }
                Object var6_10 = null;
                if (this.titleSearchStatement != null) {
                    try {
                        this.titleSearchStatement.close();
                    }
                    catch (SQLException sQLException4) {
                        JMDBMain.myJMDBMain.log("Warning: Could not close titleSearchStatement. " + sQLException4);
                    }
                }
                if (this.akaTitleSearchStatement != null) {
                    try {
                        this.akaTitleSearchStatement.close();
                    }
                    catch (SQLException sQLException4) {
                        JMDBMain.myJMDBMain.log("Warning: Could not close akaTitleSearchStatement. " + sQLException4);
                    }
                }
                this.stopTransaction(jDBCAdapter, string);
                jDBCAdapter.closePreparedStatement();
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex() && !this.isCancelImport()) {
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("usr_ml_items", "itemid", 0));
                    jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("usr_ml_items", "movieid", 0));
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart(String.valueOf(string) + ": import completed");
                }
                usrDataImportType1 = null;
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    private void importWriters(JDBCAdapter jDBCAdapter) {
        DataBaseConverter2Thread.setImportFile(JMDBMain.myJMDBMain.importHelper.getImportFile("writers"));
        if (DataBaseConverter2Thread.getImportFile() != null && DataBaseConverter2Thread.getImportFile().isFileImport() && !this.isCancelImport()) {
            ++this.importCounter;
            if (this.getExistingTableByName("movies2writers")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("movies2writers"));
            }
            if (this.getExistingTableByName("writers")) {
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropTable("writers"));
            }
            this.writeHeading("\n\n" + this.getConvertingMessage() + " writers");
            this.writeText("\n" + this.getCreatingTableMessage() + " movies2writers...");
            jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateMovies2Writers());
            if (this.checkTableExistence(jDBCAdapter, "movies2writers")) {
                this.writeText(this.getOkMessage());
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getCreatingTableMessage() + " writers...");
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateWriters());
                if (this.checkTableExistence(jDBCAdapter, "writers")) {
                    this.writeText(this.getOkMessage());
                }
            }
            if (!this.isCancelImport()) {
                this.writeText("\n" + this.getConvertingMessage() + " writers...");
                JMDBMain.myJMDBMain.importHelper.writeFileImportStatus(DataBaseConverter2Thread.getImportFile().getFileName());
                int n = 0;
                this.setM2x_count(0);
                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoWriters());
                DataImportType2 dataImportType2 = new DataImportType2(String.valueOf(DataBaseConverter2.getCfgImportPath()) + "writers", "THE WRITERS LIST", 4);
                JMDBMain.myJMDBMain.log("Reading writers...");
                this.myStatus.setText(String.valueOf(this.getReadingMessage()) + " writers...");
                int n2 = -1;
                this.startTransaction(jDBCAdapter, "writers.list");
                try {
                    while (dataImportType2.getData() && !this.isCancelImport()) {
                        if (dataImportType2.resArray[0] == null || dataImportType2.resArray[1] == null) continue;
                        if (!dataImportType2.resArray[0].equals("")) {
                            jDBCAdapter.getPreparedStatement().setString(1, dataImportType2.resArray[0]);
                            jDBCAdapter.getPreparedStatement().addBatch();
                            if (++n % 1000 == 0) {
                                jDBCAdapter.executePreparedBatch();
                            }
                            if (this.getM2x_count() >= this.getM2x_maxcount()) {
                                jDBCAdapter.executePreparedBatch();
                                this.stopTransaction(jDBCAdapter, "writers.list");
                                this.myStatus.setText("Now " + n + " writers " + this.getReadMessage() + ".");
                                this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2Writers(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
                                this.setM2x_count(0);
                                jDBCAdapter.setPreparedStatement(this.getSQLWorker().getSQLInsertIntoWriters());
                                this.startTransaction(jDBCAdapter, "writers.list");
                            }
                        }
                        if ((n2 = this.movieArray.getMovieid(dataImportType2.resArray[1])) <= 0) continue;
                        this.m2x_xid[this.getM2x_count()] = n;
                        this.m2x_movieid[this.getM2x_count()] = n2;
                        this.m2x_addinfo[this.getM2x_count()] = new String(dataImportType2.resArray[2]);
                        ++this.m2x_count;
                    }
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("An error occured while inserting data: " + sQLException);
                }
                jDBCAdapter.executePreparedBatch();
                this.stopTransaction(jDBCAdapter, "writers.list");
                if (!this.isCancelImport()) {
                    this.flushLinks(jDBCAdapter, this.getSQLWorker().getSQLInsertIntoMovies2Writers(), this.getM2x_xid(), this.getM2x_movieid(), this.getM2x_addinfo(), this.getM2x_count() - 1);
                }
                if (!this.getSQLWorker().isSQLMetaCreateTableCanCreateIndex()) {
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies2writers", "movieid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("movies2writers", "writerid", 0));
                    }
                    if (!this.isCancelImport()) {
                        jDBCAdapter.executeCommand(this.getSQLWorker().getSQLCreateIndex("writers", "name", 10));
                    }
                }
                this.myStatus.setText("");
                if (!this.isCancelImport()) {
                    if (this.brokenConnection(jDBCAdapter)) {
                        this.writeText(String.valueOf(this.getErrorMessage()) + " (" + this.getConnBrokenMessage() + ")");
                    } else {
                        this.writeText(this.getOkMessage());
                    }
                    this.getStopWatch().restart("writers: import completed");
                }
            }
            System.gc();
            if (!this.isCancelImport()) {
                this.myBar.setValue(100 / this.getNumberOfFilesToImport() * this.importCounter);
            }
        }
    }

    protected boolean isCancelImport() {
        return this.cancelImport;
    }

    private int killDatabase() {
        MessageFormat messageFormat = new MessageFormat(resMessagesBundle.getString("DataBaseConverter2Thread.dialogWindow.killDatabase.message"));
        String[] stringArray = new String[]{JMDBMain.myJMDBMain.getDbname().toUpperCase()};
        if (JMDBMain.appCmdUnattendedImport || JOptionPane.showConfirmDialog(this.myDataBaseConverter, messageFormat.format(stringArray), resMessagesBundle.getString("DataBaseConverter2Thread.dialogWindow.killDatabase.title"), 0, 2) == 0) {
            JDBCAdapter jDBCAdapter = null;
            String string = JMDBMain.myJMDBMain.getDburl();
            String string2 = JMDBMain.myJMDBMain.getDbname();
            String string3 = string;
            if (this.getSQLWorker().getSQLMetaControlDB() != null) {
                string3 = String.valueOf(string) + (string.endsWith("/") ? "" : "/") + this.getSQLWorker().getSQLMetaControlDB();
            }
            int n = -1;
            boolean bl = false;
            this.myBar.setValue(0);
            this.myBar.setVisible(true);
            this.myStatus.setText("");
            this.writeHeading(resMessagesBundle.getString("DatabaseConverter.statusmessageheading.deleteingdb"));
            this.writeText("\n" + resMessagesBundle.getString("DatabaseConverter.statusmessagetext.checkingconnectiontodbserver") + " (" + string3 + ")...");
            try {
                jDBCAdapter = new JDBCAdapter(string3, DataBaseConverter2.getCfgJdbcDriver(), DataBaseConverter2.getCfgUserID(), DataBaseConverter2.getCfgPassword());
                if (jDBCAdapter == null) {
                    this.writeText(String.valueOf(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.error")) + "\n");
                    return -1;
                }
                if (!jDBCAdapter.isConnection()) {
                    this.writeText(String.valueOf(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.error")) + "\n");
                    return -1;
                }
                this.writeText(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.ok"));
                messageFormat = new MessageFormat(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.tryingtodeletedb"));
                stringArray = new String[]{string2};
                this.writeText("\n" + messageFormat.format(stringArray) + "...");
                jDBCAdapter.executeCommand(this.getSQLWorker().getSQLDropDatabase(string2));
                this.writeText(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.ok"));
                messageFormat = new MessageFormat(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.checkdbnamedoesntexist"));
                this.writeText("\n" + messageFormat.format(stringArray));
                jDBCAdapter.executeQuery(this.getSQLWorker().getSQLMetaShowDatabases());
                while (jDBCAdapter.resultSet.next()) {
                    if (!jDBCAdapter.resultSet.getString(1).equalsIgnoreCase(string2)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    n = -1;
                    this.writeText(String.valueOf(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.error")) + "\n");
                } else {
                    n = 0;
                    this.writeText(String.valueOf(resMessagesBundle.getString("DatabaseConverter.statusmessagetext.ok")) + "\n");
                }
                if (jDBCAdapter.isConnection()) {
                    jDBCAdapter.close();
                }
                JMDBMain.myJMDBMain.importHelper.deleteFileImportStatus();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("InterruptedException in DataBaseConverter2Thread.killDatabase(): " + interruptedException);
                }
                JMDBMain.myJMDBMain.importHelper.updateImportFileList(this.myDataBaseConverter);
                jDBCAdapter = null;
                return n;
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in jmdb.database.DataBaseConverter2.killDatabase(): " + sQLException);
                return -1;
            }
        }
        return 1;
    }

    public void run() {
        if (this.commando.equals("CREATE_INDEX")) {
            this.createIndex();
            this.myDataBaseConverter.threadHasFinished();
            return;
        }
        if (this.commando.equals("IMPORT") || this.commando.equals("IMPORT_INDEX")) {
            try {
                try {
                    this.importData(this.commando);
                }
                catch (OutOfMemoryException outOfMemoryException) {
                    JMDBMain.myJMDBMain.log("Import automatically canceled because of an Exception --> " + outOfMemoryException);
                    this.myDataBaseConverter.showExceptionInformation(outOfMemoryException);
                }
            }
            catch (Throwable throwable) {
                Object var1_3 = null;
                this.myDataBaseConverter.threadHasFinished();
                throw throwable;
            }
            Object var1_4 = null;
            this.myDataBaseConverter.threadHasFinished();
            return;
        }
        if (this.commando.equals("KILL_DB")) {
            int n = this.killDatabase();
            if (n == 0) {
                this.writeHeading("\n" + resMessagesBundle.getString("DatabaseConverter.statusmessageheading.finished"));
            } else if (n == 1) {
                this.writeHeading("\n" + resMessagesBundle.getString("DatabaseConverter.statusmessageheading.canceldeletedb_finished"));
            } else {
                this.writeHeading(resMessagesBundle.getString("DatabaseConverter.statusmessageheading.erroroccured_finished"));
            }
            this.myStatus.setText(resMessagesBundle.getString("JMDB.label.status_finished"));
            this.myBar.setVisible(false);
            this.myDataBaseConverter.threadHasFinished();
            return;
        }
    }

    protected void setCancelImport(boolean bl) {
        this.cancelImport = bl;
    }

    private static void setImportFile(ImportFile importFile) {
        DataBaseConverter2Thread.importFile = importFile;
    }

    private void setImportFileList(Vector vector) {
        this.importFileList = vector;
    }

    private void setM2x_addinfo(String[] stringArray) {
        this.m2x_addinfo = stringArray;
    }

    private void setM2x_count(int n) {
        this.m2x_count = n;
    }

    private void setM2x_maxcount(int n) {
        this.m2x_maxcount = n;
    }

    private void setM2x_movieid(int[] nArray) {
        this.m2x_movieid = nArray;
    }

    private void setM2x_xid(int[] nArray) {
        this.m2x_xid = nArray;
    }

    private void setMovieArray(MovieArray movieArray) {
        this.movieArray = movieArray;
    }

    private void setNumberOfFilesToImport(int n) {
        this.numberOfFilesToImport = n;
    }

    private void setStopWatch(StopWatch stopWatch) {
        this.stopWatch = stopWatch;
    }

    private boolean startTransaction(JDBCAdapter jDBCAdapter, String string) {
        boolean bl = false;
        if (this.getSQLWorker().isSQLMetaTransactionSupported()) {
            try {
                try {
                    jDBCAdapter.getConnection().setAutoCommit(false);
                    bl = true;
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("Error message - transaction start - " + string + ": " + sQLException.getMessage());
                }
            }
            catch (Throwable throwable) {}
            return bl;
        }
        bl = true;
        return bl;
    }

    private boolean stopTransaction(JDBCAdapter jDBCAdapter, String string) {
        boolean bl = false;
        jDBCAdapter.setErrorCount(0);
        jDBCAdapter.setDebugMode(0);
        if (JMDBMain.isAppLogTemporarilyDisabled()) {
            JMDBMain.setAppLogTemporarilyDisabled(false);
        }
        if (this.getSQLWorker().isSQLMetaTransactionSupported()) {
            try {
                try {
                    jDBCAdapter.getConnection().commit();
                    jDBCAdapter.getConnection().setAutoCommit(true);
                    bl = true;
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("Error message - transaction stop - " + string + ": " + sQLException.getMessage());
                }
            }
            catch (Throwable throwable) {}
            return bl;
        }
        bl = true;
        return bl;
    }

    public void writeHeading(String string) {
        try {
            this.doc.insertString(this.doc.getLength(), string, this.myTextPane.getStyle("heading"));
            this.myTextPane.setCaretPosition(this.myTextPane.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException in jmdb.database.DetailWindow2Thread.writeHeading()" + badLocationException);
        }
    }

    public void writeText(String string) {
        try {
            this.doc.insertString(this.doc.getLength(), string, this.myTextPane.getStyle("text"));
            this.myTextPane.setCaretPosition(this.myTextPane.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException in jmdb.database.DetailWindow2Thread.writeHeading()" + badLocationException);
        }
    }
}

