/*
 * Decompiled with CFR 0.152.
 */
package jmdb.database;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.event.MenuEvent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import jmdb.base.DetailWindow2;
import jmdb.base.JMDBMain;
import jmdb.base.JMDBSetup;
import jmdb.database.DataBaseConverter2Thread;
import jmdb.database.JDBCAdapter;
import jmdb.database.SQLWorkerAbstract;
import jmdb.database.SQLWorkerDerby10131;
import jmdb.database.SQLWorkerH2110;
import jmdb.database.SQLWorkerHSQLDB180x;
import jmdb.database.SQLWorkerMySQL323xx;
import jmdb.database.SQLWorkerMySQL410;
import jmdb.database.SQLWorkerMySQL500;
import jmdb.database.SQLWorkerPostgres71x;
import jmdb.database.SQLWorkerPostgres83x;
import jmdb.database.SQLWorkerSQLite330;

public class DataBaseConverter2
extends JInternalFrame {
    private JButton ivjJButtonClose = null;
    private JButton ivjJButtonHelp = null;
    private JButton ivjJButtonSaveSize = null;
    private JPanel ivjJInternalFrameContentPane = null;
    private JLabel ivjJLabelStatus = null;
    private JPanel ivjJPanelCenter = null;
    private CardLayout ivjJPanelCenterCardLayout = null;
    private JPanel ivjJPanelSouth = null;
    private JPanel ivjJPanelSouthBottom = null;
    private GridLayout ivjJPanelSouthBottomGridLayout = null;
    private JPanel ivjJPanelSouthBottomLeft = null;
    private FlowLayout ivjJPanelSouthBottomLeftFlowLayout = null;
    private JPanel ivjJPanelSouthBottomRight = null;
    private CardLayout ivjJPanelSouthBottomRightCardLayout = null;
    private JPanel ivjJPanelSouthTop = null;
    private JProgressBar ivjJProgressBar = null;
    private JScrollPane ivjJScrollPane = null;
    private JTextPane ivjJTextPaneResult = null;
    public static DataBaseConverter2Thread myThread = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    public static int cfgWindowSizeH = 555;
    public static int cfgWindowSizeV = 400;
    private JButton ivjJButtonConvertWithIndex = null;
    private JButton ivjJButtonConvertWithoutIndex = null;
    private JButton ivjJButtonCreateIndex = null;
    private JButton ivjJButtonKillDatabase = null;
    private JPanel ivjJPanel1 = null;
    private static String cfgImportPath = "c:\\imdb\\";
    private static String cfgUrl = "jdbc:mysql://localhost:3306/jmdb?useUnicode=true&rewriteBatchedStatements=true";
    private static String cfgJdbcDriver = "com.mysql.jdbc.Driver";
    private static String cfgUserID = "root";
    private static char[] cfgPassword = new char[]{'r', 'o', 'o', 't'};
    private static boolean converterActive = false;
    private static boolean altKeyPressed;
    private JScrollPane ivjJScrollPaneTable = null;
    private JTable ivjScrollPaneTable = null;
    private static String cfgDatabase;
    private static ResourceBundle resMessagesBundle;
    private static SQLWorkerAbstract sqlWorker;
    private static String lastCommandExecuted;
    private static boolean allowMemoryCheck;
    private double lastTotalMem = 0.0;
    private static int cfgConnectionPoolSize;

    static {
        cfgDatabase = "MySQL >=5.0.0";
        resMessagesBundle = ResourceBundle.getBundle("languages/MessagesBundle");
        lastCommandExecuted = null;
        allowMemoryCheck = true;
        cfgConnectionPoolSize = 2;
    }

    public DataBaseConverter2() {
        this.initialize();
    }

    public DataBaseConverter2(boolean bl) {
        DataBaseConverter2.setAltKeyPressed(bl);
        this.initialize();
    }

    private void changeButtonState(boolean bl) {
        String string;
        String string2 = JMDBMain.myJMDBMain.getDbname();
        String string3 = string = JMDBMain.myJMDBMain.getDburl();
        if (sqlWorker.getSQLMetaControlDB() != null) {
            string3 = String.valueOf(string) + (string.endsWith("/") ? "" : "/") + sqlWorker.getSQLMetaControlDB();
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        JDBCAdapter jDBCAdapter = new JDBCAdapter(string3, DataBaseConverter2.getCfgJdbcDriver(), DataBaseConverter2.getCfgUserID(), DataBaseConverter2.getCfgPassword());
        if (jDBCAdapter != null && jDBCAdapter.isConnection()) {
            jDBCAdapter.executeQuery(DataBaseConverter2.getSQLWorker().getSQLMetaShowDatabases());
            try {
                while (jDBCAdapter.resultSet.next()) {
                    if (!jDBCAdapter.resultSet.getString(1).equalsIgnoreCase(string2)) continue;
                    bl2 = true;
                    break;
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in DataBaseConverter2.changeButtonState() - Database_exists: " + sQLException);
            }
            if (bl2) {
                jDBCAdapter.closedb();
                jDBCAdapter = new JDBCAdapter(DataBaseConverter2.getCfgUrl(), DataBaseConverter2.getCfgJdbcDriver(), DataBaseConverter2.getCfgUserID(), DataBaseConverter2.getCfgPassword());
                jDBCAdapter.executeQuery(DataBaseConverter2.getSQLWorker().getSQLMetaShowTables());
                try {
                    while (jDBCAdapter.resultSet.next()) {
                        if (!jDBCAdapter.resultSet.getString(1).equals("movies2actors")) continue;
                        bl3 = true;
                        break;
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DataBaseConverter2.changeButtonState() - Table_exists: " + sQLException);
                }
                if (bl3 && DataBaseConverter2.getSQLWorker().isSQLMetaListIndexesSupported()) {
                    jDBCAdapter.executeQuery(DataBaseConverter2.getSQLWorker().getSQLMetaShowIndexes("movies2actors"));
                    try {
                        if (jDBCAdapter.resultSet.next()) {
                            bl4 = true;
                        }
                    }
                    catch (SQLException sQLException) {
                        System.out.println("SQLException in DataBaseConverter2.changeButtonState() - Index_exists: " + sQLException);
                    }
                }
                if (bl) {
                    bl5 = JMDBMain.myJMDBMain.importHelper.updateImportFileList(this);
                }
                this.ivjJButtonKillDatabase.setEnabled(true);
                if (bl5) {
                    this.ivjJButtonConvertWithIndex.setEnabled(true);
                    this.ivjJButtonConvertWithoutIndex.setEnabled(true);
                } else {
                    this.ivjJButtonConvertWithIndex.setEnabled(false);
                    this.ivjJButtonConvertWithoutIndex.setEnabled(false);
                }
                if (bl4) {
                    this.ivjJButtonCreateIndex.setEnabled(false);
                } else if (bl3) {
                    this.ivjJButtonCreateIndex.setEnabled(true);
                } else {
                    this.ivjJButtonCreateIndex.setEnabled(false);
                }
                this.ivjJButtonClose.setEnabled(true);
                this.ivjJButtonHelp.setEnabled(true);
                this.ivjJButtonSaveSize.setEnabled(true);
            } else {
                this.ivjJButtonKillDatabase.setEnabled(false);
                this.ivjJButtonConvertWithIndex.setEnabled(true);
                this.ivjJButtonConvertWithoutIndex.setEnabled(true);
                this.ivjJButtonCreateIndex.setEnabled(false);
                this.ivjJButtonClose.setEnabled(true);
                this.ivjJButtonHelp.setEnabled(true);
                this.ivjJButtonSaveSize.setEnabled(true);
            }
        }
        jDBCAdapter.closedb();
    }

    private void changeConverterStatus() {
        int n;
        if (DataBaseConverter2.isConverterActive()) {
            DataBaseConverter2.setConverterActive(false);
        } else {
            DataBaseConverter2.setConverterActive(true);
        }
        Component[] componentArray = JMDBMain.myJMDBMain.getJMenuBar().getComponents();
        if (DataBaseConverter2.isConverterActive()) {
            n = 0;
            while (n < componentArray.length) {
                if (!componentArray[n].getName().equalsIgnoreCase("HelpMenu") && componentArray[n].isEnabled()) {
                    componentArray[n].setEnabled(false);
                }
                ++n;
            }
        } else {
            n = 0;
            while (n < componentArray.length) {
                if (!componentArray[n].getName().equalsIgnoreCase("HelpMenu")) {
                    if (componentArray[n].getName().equalsIgnoreCase("JMenuMovieCollection")) {
                        int n2 = ((JMenu)componentArray[n]).getItemCount();
                        if (n2 > 0) {
                            componentArray[n].setEnabled(true);
                        }
                    } else if (!componentArray[n].isEnabled()) {
                        componentArray[n].setEnabled(true);
                    }
                }
                ++n;
            }
        }
        this.closable = !DataBaseConverter2.isConverterActive();
        Component[] componentArray2 = JMDBMain.myJMDBMain.getContentPane().getComponents();
        int n3 = 0;
        while (n3 < componentArray2.length) {
            if (componentArray2[n3].getName().equalsIgnoreCase("ToolBarPane")) {
                if (componentArray2[n3].isVisible()) {
                    componentArray2[n3].setVisible(false);
                    break;
                }
                componentArray2[n3].setVisible(true);
                break;
            }
            ++n3;
        }
    }

    protected int checkMemoryUtilisation(boolean bl) {
        int n = 1;
        boolean bl2 = false;
        double d = (double)Runtime.getRuntime().freeMemory() / 1048576.0;
        double d2 = (double)Runtime.getRuntime().totalMemory() / 1048576.0;
        if (this.getLastTotalMem() == 0.0) {
            this.setLastTotalMem(d2);
        } else if (this.lastTotalMem == d2) {
            bl2 = true;
        }
        double d3 = d2 - d;
        double d4 = d / (d2 / 100.0);
        DecimalFormat decimalFormat = new DecimalFormat("###,###,###,##0.000");
        if (bl) {
            JMDBMain.myJMDBMain.log("INFO: Normal memory status message!\n\t\t\t\t\tTotal memory: " + decimalFormat.format(d2) + " MB\n\t\t\t\t\tUsed memory.: " + decimalFormat.format(d3) + " MB\n\t\t\t\t\tUsed memory.:There are " + decimalFormat.format(d) + " MB (" + decimalFormat.format(d4) + "%)");
        } else if (DataBaseConverter2.isAllowMemoryCheck() && bl2 && d < JMDBMain.getCfgMemoryLeftLimit()) {
            n = 0;
            if (!JMDBMain.appCmdUnattendedImport) {
                String[] stringArray = new String[]{decimalFormat.format(d), decimalFormat.format(d4), decimalFormat.format(d2), decimalFormat.format(d3)};
                MessageFormat messageFormat = new MessageFormat(resMessagesBundle.getString("DataBaseConverter2.dialogWindow.memoryWarning.message"));
                if (JOptionPane.showConfirmDialog(this, messageFormat.format(stringArray), resMessagesBundle.getString("DataBaseConverter2.dialogWindow.memoryWarning.title"), 0, 2) == 0) {
                    n = 1;
                }
            }
            JMDBMain.myJMDBMain.log("WARNING: Low memory warning!\n\t\t\t\t\tTotal memory: " + decimalFormat.format(d2) + " MB\n\t\t\t\t\tUsed memory.: " + decimalFormat.format(d3) + " MB\n\t\t\t\t\tUsed memory.:There are " + decimalFormat.format(d) + " MB (" + decimalFormat.format(d4) + "%)\n\t\t\t\t\tPlease increase the memory on the -Xmx start parameter and restart the application.");
            DataBaseConverter2.setAllowMemoryCheck(false);
        }
        return n;
    }

    public int closeWindow() {
        if (this.ivjJButtonClose.getText().equalsIgnoreCase(resMessagesBundle.getString("JMDB.button.close"))) {
            JMDBMain.myJMDBMain.removeFrame(this);
        } else if (myThread != null) {
            this.ivjJButtonClose.setEnabled(false);
            myThread.setCancelImport(true);
            this.setClosable(false);
            JMDBMain.myJMDBMain.log("DatabaseConverter2Thread canceled processing of further data because of manual intervention...");
            if (JMDBMain.appCmdUnattendedImport) {
                JMDBMain.appCmdUnattendedImport = false;
            }
            JOptionPane.showMessageDialog(this, resMessagesBundle.getString("DataBaseConverter2.dialogWindow.closeWindow.message"), resMessagesBundle.getString("DataBaseConverter2.dialogWindow.closeWindow.title"), 1);
        }
        return 0;
    }

    public void componentHidden() {
        if (!converterActive) {
            this.closeWindow();
        }
    }

    private void connEtoC1() {
        try {
            this.saveSize();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private int connEtoC2() {
        int n = 0;
        try {
            n = this.closeWindow();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return n;
    }

    private void connEtoC3(ActionEvent actionEvent) {
        try {
            this.convertWithIndex();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC4(ActionEvent actionEvent) {
        try {
            this.convertWithoutIndex();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC5(ActionEvent actionEvent) {
        try {
            this.createIndex();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC6(ActionEvent actionEvent) {
        try {
            this.killDatabase();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC7() {
        try {
            this.showHelp();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC8(ComponentEvent componentEvent) {
        try {
            this.componentHidden();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    public void convertWithIndex() {
        this.startWorking("IMPORT_INDEX");
    }

    public void convertWithoutIndex() {
        this.startWorking("IMPORT");
    }

    public void createIndex() {
        this.startWorking("CREATE_INDEX");
    }

    public static int getCfgConnectionPoolSize() {
        return cfgConnectionPoolSize;
    }

    public static String getCfgDatabase() {
        return cfgDatabase;
    }

    public static String getCfgImportPath() {
        return cfgImportPath;
    }

    public static String getCfgJdbcDriver() {
        return cfgJdbcDriver;
    }

    public static String getCfgPassword() {
        return new String(cfgPassword);
    }

    public static String getCfgUrl() {
        return cfgUrl;
    }

    public static String getCfgUserID() {
        return cfgUserID;
    }

    private JButton getJButtonClose() {
        if (this.ivjJButtonClose == null) {
            try {
                this.ivjJButtonClose = new JButton();
                this.ivjJButtonClose.setName("JButtonClose");
                this.ivjJButtonClose.setToolTipText(resMessagesBundle.getString("JMDB.button.close.tooltip"));
                this.ivjJButtonClose.setText(resMessagesBundle.getString("JMDB.button.close"));
                this.ivjJButtonClose.setMnemonic(resMessagesBundle.getString("JMDB.button.close.mnemonic").charAt(0));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJButtonClose;
    }

    private JButton getJButtonConvertWithIndex() {
        if (this.ivjJButtonConvertWithIndex == null) {
            try {
                this.ivjJButtonConvertWithIndex = new JButton();
                this.ivjJButtonConvertWithIndex.setName("JButtonConvertWithIndex");
                this.ivjJButtonConvertWithIndex.setToolTipText(resMessagesBundle.getString("JMDB.button.convertandindex.tooltip"));
                this.ivjJButtonConvertWithIndex.setText(resMessagesBundle.getString("JMDB.button.convertandindex"));
                this.ivjJButtonConvertWithIndex.setMnemonic(resMessagesBundle.getString("JMDB.button.convertandindex.mnemonic").charAt(0));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJButtonConvertWithIndex;
    }

    private JButton getJButtonConvertWithoutIndex() {
        if (this.ivjJButtonConvertWithoutIndex == null) {
            try {
                this.ivjJButtonConvertWithoutIndex = new JButton();
                this.ivjJButtonConvertWithoutIndex.setName("JButtonConvertWithoutIndex");
                this.ivjJButtonConvertWithoutIndex.setToolTipText(resMessagesBundle.getString("JMDB.button.convert.tooltip"));
                this.ivjJButtonConvertWithoutIndex.setText(resMessagesBundle.getString("JMDB.button.convert"));
                this.ivjJButtonConvertWithoutIndex.setMnemonic(resMessagesBundle.getString("JMDB.button.convert.mnemonic").charAt(0));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJButtonConvertWithoutIndex;
    }

    private JButton getJButtonCreateIndex() {
        if (this.ivjJButtonCreateIndex == null) {
            try {
                this.ivjJButtonCreateIndex = new JButton();
                this.ivjJButtonCreateIndex.setName("JButtonCreateIndex");
                this.ivjJButtonCreateIndex.setToolTipText(resMessagesBundle.getString("JMDB.button.index.tooltip"));
                this.ivjJButtonCreateIndex.setText(resMessagesBundle.getString("JMDB.button.index"));
                this.ivjJButtonCreateIndex.setMnemonic(resMessagesBundle.getString("JMDB.button.index.mnemonic").charAt(0));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJButtonCreateIndex;
    }

    private JButton getJButtonHelp() {
        if (this.ivjJButtonHelp == null) {
            try {
                this.ivjJButtonHelp = new JButton();
                this.ivjJButtonHelp.setName("JButtonHelp");
                this.ivjJButtonHelp.setToolTipText(resMessagesBundle.getString("JMDB.button.help.tooltip"));
                this.ivjJButtonHelp.setText(resMessagesBundle.getString("JMDB.button.help"));
                this.ivjJButtonHelp.setMnemonic(resMessagesBundle.getString("JMDB.button.help.mnemonic").charAt(0));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJButtonHelp;
    }

    private JButton getJButtonKillDatabase() {
        if (this.ivjJButtonKillDatabase == null) {
            try {
                this.ivjJButtonKillDatabase = new JButton();
                this.ivjJButtonKillDatabase.setName("JButtonKillDatabase");
                this.ivjJButtonKillDatabase.setToolTipText(resMessagesBundle.getString("JMDB.button.dropdb.tooltip"));
                this.ivjJButtonKillDatabase.setText(resMessagesBundle.getString("JMDB.button.dropdb"));
                this.ivjJButtonKillDatabase.setForeground(Color.red);
                this.ivjJButtonKillDatabase.setMnemonic(resMessagesBundle.getString("JMDB.button.dropdb.mnemonic").charAt(0));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJButtonKillDatabase;
    }

    private JButton getJButtonSaveSize() {
        if (this.ivjJButtonSaveSize == null) {
            try {
                this.ivjJButtonSaveSize = new JButton();
                this.ivjJButtonSaveSize.setName("JButtonSaveSize");
                this.ivjJButtonSaveSize.setToolTipText(resMessagesBundle.getString("JMDB.button.savesize.tooltip"));
                this.ivjJButtonSaveSize.setText(resMessagesBundle.getString("JMDB.button.savesize"));
                this.ivjJButtonSaveSize.setMnemonic(resMessagesBundle.getString("JMDB.button.savesize.mnemonic").charAt(0));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJButtonSaveSize;
    }

    private JPanel getJInternalFrameContentPane() {
        if (this.ivjJInternalFrameContentPane == null) {
            try {
                this.ivjJInternalFrameContentPane = new JPanel();
                this.ivjJInternalFrameContentPane.setName("JInternalFrameContentPane");
                this.ivjJInternalFrameContentPane.setPreferredSize(new Dimension(550, 126));
                this.ivjJInternalFrameContentPane.setLayout(new BorderLayout());
                this.ivjJInternalFrameContentPane.setMinimumSize(new Dimension(550, 122));
                this.getJInternalFrameContentPane().add((Component)this.getJPanelCenter(), "Center");
                this.getJInternalFrameContentPane().add((Component)this.getJPanelSouth(), "South");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJInternalFrameContentPane;
    }

    private JLabel getJLabelStatus() {
        if (this.ivjJLabelStatus == null) {
            try {
                this.ivjJLabelStatus = new JLabel();
                this.ivjJLabelStatus.setName("JLabelStatus");
                this.ivjJLabelStatus.setText("Status");
                this.ivjJLabelStatus.setMaximumSize(new Dimension(400, 14));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabelStatus;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = -1;
                gridBagConstraints.gridy = -1;
                gridBagConstraints.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJButtonConvertWithIndex(), gridBagConstraints);
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.gridx = -1;
                gridBagConstraints2.gridy = -1;
                gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJButtonConvertWithoutIndex(), gridBagConstraints2);
                GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
                gridBagConstraints3.gridx = -1;
                gridBagConstraints3.gridy = -1;
                gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJButtonCreateIndex(), gridBagConstraints3);
                GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
                gridBagConstraints4.gridx = -1;
                gridBagConstraints4.gridy = -1;
                gridBagConstraints4.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJButtonKillDatabase(), gridBagConstraints4);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJPanel1;
    }

    private JPanel getJPanelCenter() {
        if (this.ivjJPanelCenter == null) {
            try {
                this.ivjJPanelCenter = new JPanel();
                this.ivjJPanelCenter.setName("JPanelCenter");
                this.ivjJPanelCenter.setLayout(this.getJPanelCenterCardLayout());
                this.getJPanelCenter().add((Component)this.getJScrollPane(), this.getJScrollPane().getName());
                this.getJPanelCenter().add((Component)this.getJScrollPaneTable(), this.getJScrollPaneTable().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJPanelCenter;
    }

    private CardLayout getJPanelCenterCardLayout() {
        CardLayout cardLayout = null;
        try {
            cardLayout = new CardLayout();
            cardLayout.setVgap(5);
            cardLayout.setHgap(5);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return cardLayout;
    }

    private JPanel getJPanelSouth() {
        if (this.ivjJPanelSouth == null) {
            try {
                this.ivjJPanelSouth = new JPanel();
                this.ivjJPanelSouth.setName("JPanelSouth");
                this.ivjJPanelSouth.setLayout(new BorderLayout());
                this.getJPanelSouth().add((Component)this.getJPanel1(), "North");
                this.getJPanelSouth().add((Component)this.getJPanelSouthTop(), "Center");
                this.getJPanelSouth().add((Component)this.getJPanelSouthBottom(), "South");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJPanelSouth;
    }

    private JPanel getJPanelSouthBottom() {
        if (this.ivjJPanelSouthBottom == null) {
            try {
                this.ivjJPanelSouthBottom = new JPanel();
                this.ivjJPanelSouthBottom.setName("JPanelSouthBottom");
                this.ivjJPanelSouthBottom.setLayout(this.getJPanelSouthBottomGridLayout());
                this.getJPanelSouthBottom().add((Component)this.getJPanelSouthBottomLeft(), this.getJPanelSouthBottomLeft().getName());
                this.getJPanelSouthBottom().add((Component)this.getJPanelSouthBottomRight(), this.getJPanelSouthBottomRight().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJPanelSouthBottom;
    }

    private GridLayout getJPanelSouthBottomGridLayout() {
        GridLayout gridLayout = null;
        try {
            gridLayout = new GridLayout();
            gridLayout.setColumns(2);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return gridLayout;
    }

    private JPanel getJPanelSouthBottomLeft() {
        if (this.ivjJPanelSouthBottomLeft == null) {
            try {
                this.ivjJPanelSouthBottomLeft = new JPanel();
                this.ivjJPanelSouthBottomLeft.setName("JPanelSouthBottomLeft");
                this.ivjJPanelSouthBottomLeft.setLayout(this.getJPanelSouthBottomLeftFlowLayout());
                this.getJPanelSouthBottomLeft().add((Component)this.getJLabelStatus(), this.getJLabelStatus().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJPanelSouthBottomLeft;
    }

    private FlowLayout getJPanelSouthBottomLeftFlowLayout() {
        FlowLayout flowLayout = null;
        try {
            flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return flowLayout;
    }

    private JPanel getJPanelSouthBottomRight() {
        if (this.ivjJPanelSouthBottomRight == null) {
            try {
                this.ivjJPanelSouthBottomRight = new JPanel();
                this.ivjJPanelSouthBottomRight.setName("JPanelSouthBottomRight");
                this.ivjJPanelSouthBottomRight.setLayout(this.getJPanelSouthBottomRightCardLayout());
                this.getJPanelSouthBottomRight().add((Component)this.getJProgressBar(), this.getJProgressBar().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJPanelSouthBottomRight;
    }

    private CardLayout getJPanelSouthBottomRightCardLayout() {
        CardLayout cardLayout = null;
        try {
            cardLayout = new CardLayout();
            cardLayout.setVgap(5);
            cardLayout.setHgap(5);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return cardLayout;
    }

    private JPanel getJPanelSouthTop() {
        if (this.ivjJPanelSouthTop == null) {
            try {
                this.ivjJPanelSouthTop = new JPanel();
                this.ivjJPanelSouthTop.setName("JPanelSouthTop");
                this.ivjJPanelSouthTop.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = -1;
                gridBagConstraints.gridy = -1;
                gridBagConstraints.insets = new Insets(4, 4, 4, 4);
                this.getJPanelSouthTop().add((Component)this.getJButtonSaveSize(), gridBagConstraints);
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.gridx = -1;
                gridBagConstraints2.gridy = -1;
                gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
                this.getJPanelSouthTop().add((Component)this.getJButtonHelp(), gridBagConstraints2);
                GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
                gridBagConstraints3.gridx = -1;
                gridBagConstraints3.gridy = -1;
                gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
                this.getJPanelSouthTop().add((Component)this.getJButtonClose(), gridBagConstraints3);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJPanelSouthTop;
    }

    private JProgressBar getJProgressBar() {
        if (this.ivjJProgressBar == null) {
            try {
                this.ivjJProgressBar = new JProgressBar();
                this.ivjJProgressBar.setName("JProgressBar");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJProgressBar;
    }

    private JScrollPane getJScrollPane() {
        if (this.ivjJScrollPane == null) {
            try {
                this.ivjJScrollPane = new JScrollPane();
                this.ivjJScrollPane.setName("JScrollPane");
                this.ivjJScrollPane.setAutoscrolls(true);
                this.getJScrollPane().setViewportView(this.getJTextPaneResult());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJScrollPane;
    }

    private JScrollPane getJScrollPaneTable() {
        if (this.ivjJScrollPaneTable == null) {
            try {
                this.ivjJScrollPaneTable = new JScrollPane();
                this.ivjJScrollPaneTable.setName("JScrollPaneTable");
                this.ivjJScrollPaneTable.setAutoscrolls(true);
                this.ivjJScrollPaneTable.setVerticalScrollBarPolicy(20);
                this.ivjJScrollPaneTable.setHorizontalScrollBarPolicy(30);
                this.ivjJScrollPaneTable.setOpaque(true);
                this.ivjJScrollPaneTable.setVisible(false);
                this.ivjJScrollPaneTable.setPreferredSize(new Dimension(14, 26));
                this.ivjJScrollPaneTable.setMinimumSize(new Dimension(22, 22));
                this.getJScrollPaneTable().setViewportView(this.getScrollPaneTable());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJScrollPaneTable;
    }

    private JTextPane getJTextPaneResult() {
        if (this.ivjJTextPaneResult == null) {
            try {
                this.ivjJTextPaneResult = new JTextPane();
                this.ivjJTextPaneResult.setName("JTextPaneResult");
                this.ivjJTextPaneResult.setBounds(0, 0, 547, 348);
                this.ivjJTextPaneResult.setEditable(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJTextPaneResult;
    }

    private double getLastTotalMem() {
        return this.lastTotalMem;
    }

    private JTable getScrollPaneTable() {
        if (this.ivjScrollPaneTable == null) {
            try {
                this.ivjScrollPaneTable = new JTable();
                this.ivjScrollPaneTable.setName("ScrollPaneTable");
                this.getJScrollPaneTable().setColumnHeaderView(this.ivjScrollPaneTable.getTableHeader());
                this.getJScrollPaneTable().getViewport().setBackingStoreEnabled(true);
                this.ivjScrollPaneTable.setToolTipText("Select the files you want to import - some are required!");
                this.ivjScrollPaneTable.setBounds(0, 0, 200, 200);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjScrollPaneTable;
    }

    public static SQLWorkerAbstract getSQLWorker() {
        return sqlWorker;
    }

    public static SQLWorkerAbstract getSQLWorker(String string) {
        if (string != null) {
            if (string.equals("MySQL >3.23.28")) {
                return new SQLWorkerMySQL323xx();
            }
            if (string.equals("MySQL >=4.1.0")) {
                return new SQLWorkerMySQL410();
            }
            if (string.equals("MySQL >=5.0.0")) {
                return new SQLWorkerMySQL500();
            }
            if (string.equals("PostgreSQL >=7.1.0")) {
                return new SQLWorkerPostgres71x();
            }
            if (string.equals("PostgreSQL >=8.3.0")) {
                return new SQLWorkerPostgres83x();
            }
            if (string.equals("SQLite >=3.3.0")) {
                return new SQLWorkerSQLite330();
            }
            if (string.equals("Derby >=10.1.3.1")) {
                return new SQLWorkerDerby10131();
            }
            if (string.equals("HSQLDB >=1.8.0.0")) {
                return new SQLWorkerHSQLDB180x();
            }
            if (string.equals("H2 >=1.1.0")) {
                return new SQLWorkerH2110();
            }
            return new SQLWorkerMySQL323xx();
        }
        return new SQLWorkerMySQL323xx();
    }

    private void handleException(Throwable throwable) {
    }

    private void initConnections() throws Exception {
        this.getJButtonSaveSize().addActionListener(this.ivjEventHandler);
        this.getJButtonConvertWithIndex().addActionListener(this.ivjEventHandler);
        this.getJButtonConvertWithoutIndex().addActionListener(this.ivjEventHandler);
        this.getJButtonCreateIndex().addActionListener(this.ivjEventHandler);
        this.getJButtonKillDatabase().addActionListener(this.ivjEventHandler);
        this.getJButtonHelp().addActionListener(this.ivjEventHandler);
        this.addComponentListener(this.ivjEventHandler);
        this.getJButtonClose().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("DatabaseConverter2");
            this.setDefaultCloseOperation(1);
            this.setTitle(resMessagesBundle.getString("DatabaseConverter.title"));
            this.setClosable(true);
            this.setIconifiable(true);
            this.setClosed(false);
            this.setPreferredSize(new Dimension(550, 400));
            this.setSize(555, 400);
            this.setMaximizable(true);
            this.setMinimumSize(new Dimension(555, 180));
            this.setResizable(true);
            this.setContentPane(this.getJInternalFrameContentPane());
            this.initConnections();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = this.ivjJTextPaneResult.addStyle("regular", style);
        StyleConstants.setFontFamily(style2, "SansSerif");
        Style style3 = this.ivjJTextPaneResult.addStyle("text", style2);
        StyleConstants.setFontSize(style3, 11);
        style3 = this.ivjJTextPaneResult.addStyle("heading", style2);
        StyleConstants.setFontSize(style3, 15);
        StyleConstants.setBold(style3, true);
        this.setSize(cfgWindowSizeH, cfgWindowSizeV);
        this.changeButtonState(true);
        this.setVisible(true);
        if (JMDBMain.appCmdUnattendedImport) {
            System.out.println("DatabaseConverter2.initialize()...UNATTENED MODE WAITING FOR ACTION!!!...");
            if (this.ivjJButtonKillDatabase.isEnabled() && !this.ivjJButtonConvertWithIndex.isEnabled() && !this.ivjJButtonConvertWithoutIndex.isEnabled()) {
                this.killDatabase();
                System.out.println("DatabaseConverter2.initialize() - KillDatabase executed...");
            } else {
                this.startUnattendedImport();
            }
        }
    }

    private static boolean isAllowMemoryCheck() {
        return allowMemoryCheck;
    }

    public static boolean isAltKeyPressed() {
        return altKeyPressed;
    }

    public static boolean isConverterActive() {
        return converterActive;
    }

    public void jMenuItem1_ActionEvents() {
        System.out.println("Action");
    }

    public void jMenuQuickNavigate_Icon(Icon icon) {
        System.out.println("Icon");
        System.out.println(icon.toString());
    }

    public void jMenuQuickNavigate_ItemEvent() {
        System.out.println("Item event");
    }

    public void jMenuQuickNavigate_ItemStateChanged(ItemEvent itemEvent) {
        System.out.println(itemEvent.getItem());
    }

    public void jMenuQuickNavigate_MenuSelected(MenuEvent menuEvent) {
        System.out.println("Menu selected.");
    }

    public void killDatabase() {
        this.startWorking("KILL_DB");
    }

    public static void main(String[] stringArray) {
        try {
            JFrame jFrame = new JFrame();
            DetailWindow2 detailWindow2 = new DetailWindow2();
            jFrame.setContentPane(detailWindow2);
            ((Component)jFrame).setSize(detailWindow2.getSize());
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            jFrame.show();
            Insets insets = jFrame.getInsets();
            ((Component)jFrame).setSize(jFrame.getWidth() + insets.left + insets.right, jFrame.getHeight() + insets.top + insets.bottom);
            ((Component)jFrame).setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of javax.swing.JInternalFrame");
            throwable.printStackTrace(System.out);
        }
    }

    public void saveSize() {
        cfgWindowSizeH = this.getWidth();
        cfgWindowSizeV = this.getHeight();
        JMDBSetup.writeConfig();
    }

    private static void setAllowMemoryCheck(boolean bl) {
        allowMemoryCheck = bl;
    }

    public static void setAltKeyPressed(boolean bl) {
        altKeyPressed = bl;
    }

    public static void setCfgConnectionPoolSize(int n) {
        cfgConnectionPoolSize = n;
    }

    public static void setCfgDatabase(String string) {
        cfgDatabase = string;
    }

    public static void setCfgImportPath(String string) {
        cfgImportPath = string;
    }

    public static void setCfgJdbcDriver(String string) {
        cfgJdbcDriver = string;
    }

    public static void setCfgPassword(String string) {
        cfgPassword = string.toCharArray();
    }

    public static void setCfgUrl(String string) {
        cfgUrl = string;
    }

    public static void setCfgUserID(String string) {
        cfgUserID = string;
    }

    public static void setConverterActive(boolean bl) {
        converterActive = bl;
    }

    private void setLastTotalMem(double d) {
        this.lastTotalMem = d;
    }

    public static void setSQLWorker(String string) {
        if (string == null) {
            string = DataBaseConverter2.getCfgDatabase();
        }
        sqlWorker = string.equals("MySQL >3.23.28") ? new SQLWorkerMySQL323xx() : (string.equals("MySQL >=4.1.0") ? new SQLWorkerMySQL410() : (string.equals("MySQL >=5.0.0") ? new SQLWorkerMySQL500() : (string.equals("PostgreSQL >=7.1.0") ? new SQLWorkerPostgres71x() : (string.equals("PostgreSQL >=8.3.0") ? new SQLWorkerPostgres83x() : (string.equals("SQLite >=3.3.0") ? new SQLWorkerSQLite330() : (string.equals("Derby >=10.1.3.1") ? new SQLWorkerDerby10131() : (string.equals("HSQLDB >=1.8.0.0") ? new SQLWorkerHSQLDB180x() : (string.equals("H2 >=1.1.0") ? new SQLWorkerH2110() : new SQLWorkerMySQL323xx()))))))));
    }

    protected void showExceptionInformation(Exception exception) {
        if (exception != null) {
            JOptionPane.showMessageDialog(this, exception.getMessage() != null && exception.getMessage().length() > 0 ? exception.getMessage() : resMessagesBundle.getString("DataBaseConverter2.dialogWindow.exceptionInformation.messageUnknown"), resMessagesBundle.getString("DataBaseConverter2.dialogWindow.exceptionInformation.title"), 0);
        }
    }

    protected void showHelp() {
        JMDBMain.myJMDBMain.newHelpWindow("DataBaseConverter");
    }

    private void startUnattendedImport() {
        if (JMDBMain.appCmdImportWithIndex) {
            System.out.println("DatabaseConverter2.startUnattendedImport() - Import executed (with index creation)...");
            this.convertWithIndex();
        } else {
            System.out.println("DatabaseConverter2.startUnattendedImport() - Import executed (without index creation)...");
            this.convertWithoutIndex();
        }
    }

    protected void startWorking(String string) {
        lastCommandExecuted = string;
        this.changeConverterStatus();
        this.ivjJTextPaneResult.setText("");
        this.ivjJButtonClose.setEnabled(true);
        this.ivjJButtonConvertWithIndex.setEnabled(false);
        this.ivjJButtonConvertWithoutIndex.setEnabled(false);
        this.ivjJButtonCreateIndex.setEnabled(false);
        this.ivjJButtonHelp.setEnabled(false);
        this.ivjJButtonKillDatabase.setEnabled(false);
        this.ivjJButtonSaveSize.setEnabled(false);
        myThread = new DataBaseConverter2Thread(this, this.ivjJTextPaneResult, this.ivjJLabelStatus, this.ivjJProgressBar, string);
        myThread.start();
        this.ivjJButtonClose.setText(resMessagesBundle.getString("JMDB.button.cancel"));
        this.ivjJButtonClose.setToolTipText(resMessagesBundle.getString("JMDB.button.cancel_import.tooltip"));
        this.setClosable(false);
    }

    protected void threadHasFinished() {
        myThread = null;
        this.ivjJButtonClose.setText(resMessagesBundle.getString("JMDB.button.close"));
        this.ivjJButtonClose.setToolTipText(resMessagesBundle.getString("JMDB.button.close.tooltip"));
        this.changeConverterStatus();
        this.changeButtonState(false);
        JMDBMain.myJMDBMain.updateStatusMessage();
        JMDBMain.myJMDBMain.playSound();
        if (JMDBMain.appCmdUnattendedImport && !lastCommandExecuted.equalsIgnoreCase("KILL_DB")) {
            lastCommandExecuted = null;
            this.closeWindow();
        } else if (JMDBMain.appCmdUnattendedImport && lastCommandExecuted.equalsIgnoreCase("KILL_DB")) {
            this.startUnattendedImport();
        } else {
            lastCommandExecuted = null;
        }
        DataBaseConverter2.setAllowMemoryCheck(true);
    }

    class IvjEventHandler
    implements ActionListener,
    ComponentListener {
        IvjEventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DataBaseConverter2.this.getJButtonSaveSize()) {
                DataBaseConverter2.this.connEtoC1();
            }
            if (actionEvent.getSource() == DataBaseConverter2.this.getJButtonConvertWithIndex()) {
                DataBaseConverter2.this.connEtoC3(actionEvent);
            }
            if (actionEvent.getSource() == DataBaseConverter2.this.getJButtonConvertWithoutIndex()) {
                DataBaseConverter2.this.connEtoC4(actionEvent);
            }
            if (actionEvent.getSource() == DataBaseConverter2.this.getJButtonCreateIndex()) {
                DataBaseConverter2.this.connEtoC5(actionEvent);
            }
            if (actionEvent.getSource() == DataBaseConverter2.this.getJButtonKillDatabase()) {
                DataBaseConverter2.this.connEtoC6(actionEvent);
            }
            if (actionEvent.getSource() == DataBaseConverter2.this.getJButtonHelp()) {
                DataBaseConverter2.this.connEtoC7();
            }
            if (actionEvent.getSource() == DataBaseConverter2.this.getJButtonClose()) {
                DataBaseConverter2.this.connEtoC2();
            }
        }

        public void componentHidden(ComponentEvent componentEvent) {
            if (componentEvent.getSource() == DataBaseConverter2.this) {
                DataBaseConverter2.this.connEtoC8(componentEvent);
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }
    }
}

