/*
 * Decompiled with CFR 0.152.
 */
package jmdb.base;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmdb.base.JMDBMain;
import jmdb.base.MovieCollectionWindow;
import jmdb.base.SimpleResultWindow;
import jmdb.database.DataBaseConverter2;
import jmdb.database.JDBCAdapter;
import jmdb.database.SQLWorkerAbstract;
import jmdb.sortabletable.MultiLineColorColumnRenderer;
import jmdb.sortabletable.SortButtonRenderer;
import jmdb.sortabletable.SortableTableModel2;

class MovieCollectionWindowThread
extends Thread {
    private JTable myTable;
    private JProgressBar myBar;
    private MovieCollectionWindow myMovieCollectionWindow;
    private JLabel myStatus;
    private int columnCount = 0;
    private SortButtonRenderer sortButtonRenderer;
    private TableColumnModel tableColumnModel;
    private int sortColumn;
    private int rowCount = 0;
    private Hashtable macro;
    private JDBCAdapter myDb = null;
    private String[] sqlCommand;
    private int sqlCommandCount = 0;
    private JTextField mySearchField;
    private JCheckBox myShowFullRows;
    private SQLWorkerAbstract sqlWorker = null;
    private String givenFileEncoding = null;
    private boolean skipCreatingTmpMovies = false;
    static /* synthetic */ Class class$0;

    public MovieCollectionWindowThread(MovieCollectionWindow movieCollectionWindow, JTable jTable, JLabel jLabel, JProgressBar jProgressBar, JTextField jTextField, JCheckBox jCheckBox) {
        this.myMovieCollectionWindow = movieCollectionWindow;
        this.myTable = jTable;
        this.myStatus = jLabel;
        this.myBar = jProgressBar;
        this.mySearchField = jTextField;
        this.myShowFullRows = jCheckBox;
        this.macro = new Hashtable();
        this.sqlCommand = new String[100];
        this.sqlCommandCount = 0;
        this.sqlWorker = DataBaseConverter2.getSQLWorker();
    }

    private boolean addData() {
        try {
            BufferedReader bufferedReader = null;
            if (this.givenFileEncoding == null) {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(String.valueOf(MovieCollectionWindow.cfgMovieCollectionPath) + this.myMovieCollectionWindow.myName + ".data")));
            } else {
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(String.valueOf(MovieCollectionWindow.cfgMovieCollectionPath) + this.myMovieCollectionWindow.myName + ".data"), this.givenFileEncoding));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    JMDBMain.myJMDBMain.log("An unsupported encoding (" + this.givenFileEncoding + ") has been given, falling back to default reader: " + unsupportedEncodingException);
                    bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(String.valueOf(MovieCollectionWindow.cfgMovieCollectionPath) + this.myMovieCollectionWindow.myName + ".data")));
                }
            }
            SortableTableModel2 sortableTableModel2 = (SortableTableModel2)this.myTable.getModel();
            while (bufferedReader.ready()) {
                String string = bufferedReader.readLine();
                if (string == null || string.length() <= 0 || string.charAt(0) == '#') continue;
                String[] stringArray = this.splitInArray(string);
                if (stringArray.length == this.columnCount) {
                    Object[] objectArray = new Object[this.columnCount];
                    ++this.rowCount;
                    int n = 0;
                    while (n < this.columnCount) {
                        Class clazz = sortableTableModel2.getColumnClass(n);
                        Class<?> clazz2 = class$0;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("java.lang.Integer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        objectArray[n] = clazz == clazz2 ? new Integer(stringArray[n].trim()) : new String(stringArray[n].trim());
                        ++n;
                    }
                    sortableTableModel2.addRow(objectArray);
                    continue;
                }
                JMDBMain.myJMDBMain.log("Malformed data line read in MovieCollectionWindowThread, columnCount=" + this.columnCount + ", colums detected=" + stringArray.length + " : " + string);
            }
            bufferedReader.close();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            JMDBMain.myJMDBMain.log("FileNotFoundException in MovieCollectionWindowThread.addData: " + fileNotFoundException);
        }
        catch (IOException iOException) {
            JMDBMain.myJMDBMain.log("IOException in MovieCollectionWindowThread.addData: " + iOException);
        }
        return false;
    }

    private boolean createTable() {
        String[] stringArray = new String[150];
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(String.valueOf(MovieCollectionWindow.cfgMovieCollectionPath) + this.myMovieCollectionWindow.myName + ".def")));
            while (bufferedReader.ready()) {
                int n;
                String string = bufferedReader.readLine();
                if (string == null || (string = string.trim()).length() <= 0 || string.charAt(0) == '#' || string.indexOf("=") <= 0) continue;
                String string2 = string.substring(0, string.indexOf("=")).trim();
                String string3 = string.substring(string.indexOf("=") + 1, string.length()).trim();
                if (string2.equalsIgnoreCase("FileEncoding")) {
                    if (string3.length() <= 0) continue;
                    this.givenFileEncoding = string3;
                    continue;
                }
                if (string2.equalsIgnoreCase("SkipTmpMovies")) {
                    this.skipCreatingTmpMovies = string3.equalsIgnoreCase("yes");
                    continue;
                }
                if (string2.equals("WindowPosX")) {
                    try {
                        int n2 = new Integer(string3);
                        n = this.myMovieCollectionWindow.getLocation().y;
                        this.myMovieCollectionWindow.setLocation(n2, n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        JMDBMain.myJMDBMain.log("NumberFormatException in MovieCollectionWindowThread.createTable (WindowPosX): " + numberFormatException);
                    }
                    continue;
                }
                if (string2.equals("WindowPosY")) {
                    try {
                        int n3 = this.myMovieCollectionWindow.getLocation().x;
                        n = new Integer(string3);
                        this.myMovieCollectionWindow.setLocation(n3, n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        JMDBMain.myJMDBMain.log("NumberFormatException in MovieCollectionWindowThread.createTable (WindowPosY): " + numberFormatException);
                    }
                    continue;
                }
                if (string2.equals("WindowWidth")) {
                    try {
                        int n4 = new Integer(string3);
                        n = this.myMovieCollectionWindow.getHeight();
                        this.myMovieCollectionWindow.setSize(n4, n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        JMDBMain.myJMDBMain.log("NumberFormatException in MovieCollectionWindowThread.createTable (WindowWidth): " + numberFormatException);
                    }
                    continue;
                }
                if (string2.equals("WindowHeight")) {
                    try {
                        int n5 = this.myMovieCollectionWindow.getWidth();
                        n = new Integer(string3);
                        this.myMovieCollectionWindow.setSize(n5, n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        JMDBMain.myJMDBMain.log("NumberFormatException in MovieCollectionWindowThread.createTable (WindowHeight): " + numberFormatException);
                    }
                    continue;
                }
                if (string2.equals("WindowMaximize")) {
                    string3.equalsIgnoreCase("yes");
                    continue;
                }
                if (string2.equals("WindowScrollH")) {
                    bl3 = string3.equalsIgnoreCase("yes");
                    continue;
                }
                if (string2.equals("COLUMN")) {
                    stringArray[this.columnCount++] = string3;
                    continue;
                }
                if (string2.equals("SHOWVERTICALLINES")) {
                    bl = string3.equalsIgnoreCase("yes");
                    continue;
                }
                if (string2.equals("SHOWHORIZONTALLINES")) {
                    bl2 = string3.equalsIgnoreCase("yes");
                    continue;
                }
                if (string2.equals("SORTCOLUMN")) {
                    this.setSortColumn(string3);
                    continue;
                }
                if (string2.equals("SQLCOMMAND")) {
                    this.sqlCommand[this.sqlCommandCount++] = string3;
                    continue;
                }
                if (string2.equals("LINESPERROW")) {
                    try {
                        MovieCollectionWindow.setMovieCollectionLinesPerRow(new Integer(string3));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                this.macro.put(string2, string3);
            }
            bufferedReader.close();
            SortableTableModel2 sortableTableModel2 = new SortableTableModel2();
            ++this.columnCount;
            Object[] objectArray = new String[this.columnCount];
            int n = 0;
            while (n < this.columnCount) {
                objectArray[n] = "";
                ++n;
            }
            sortableTableModel2.setDataVector(new Object[0][], objectArray);
            this.myTable.setModel(sortableTableModel2);
            this.myTable.setShowVerticalLines(bl);
            this.myTable.setShowHorizontalLines(bl2);
            this.myTable.setColumnSelectionAllowed(false);
            this.myTable.setRowSelectionAllowed(true);
            this.myTable.setSelectionMode(0);
            n = bl ? 1 : 0;
            int n6 = bl2 ? 1 : 0;
            this.myTable.setIntercellSpacing(new Dimension(n, n6));
            this.sortButtonRenderer = new SortButtonRenderer();
            this.tableColumnModel = this.myTable.getColumnModel();
            JTableHeader jTableHeader = this.myTable.getTableHeader();
            jTableHeader.addMouseListener(new HeaderListener(jTableHeader, this.sortButtonRenderer));
            TableColumn tableColumn = this.myTable.getColumnModel().getColumn(0);
            tableColumn.setHeaderValue("IMDB-title");
            tableColumn.setMinWidth(0);
            tableColumn.setMaxWidth(0);
            tableColumn.setPreferredWidth(0);
            tableColumn.setWidth(0);
            ((SortableTableModel2)this.myTable.getModel()).setColumnClass(0, new String("String"));
            int n7 = 1;
            while (n7 < this.columnCount) {
                this.setColumn(n7, stringArray[n7 - 1]);
                ++n7;
            }
            this.myTable.setAutoResizeMode(bl3 ? 0 : 2);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            JMDBMain.myJMDBMain.log("FileNotFoundException in MovieCollectionWindowThread.createTable: " + fileNotFoundException);
        }
        catch (IOException iOException) {
            JMDBMain.myJMDBMain.log("IOException in MovieCollectionWindowThread.createTable: " + iOException);
        }
        return false;
    }

    private String executeMacro(String string, String string2) {
        String[] stringArray = new String[1];
        int[] nArray = new int[1];
        int n = 0;
        stringArray[0] = string2;
        this.myDb.executePreparedQuery((String)this.macro.get(string), stringArray, nArray);
        String string3 = "";
        try {
            n = this.myDb.resultSet.getMetaData().getColumnCount();
            while (this.myDb.resultSet.next()) {
                int n2 = 1;
                while (n2 <= n) {
                    string3 = String.valueOf(string3) + this.myDb.resultSet.getString(n2) + ", ";
                    ++n2;
                }
                if (n > 0 && string3.length() > 0) {
                    string3 = string3.trim();
                    string3 = string3.substring(0, string3.length() - 1);
                }
                string3 = String.valueOf(string3) + "\n";
            }
            string3 = string3.trim();
        }
        catch (SQLException sQLException) {
            JMDBMain.myJMDBMain.log("SQLException in MovieCollectionWindowThread.executeMacro(String, String): " + sQLException);
            JMDBMain.myJMDBMain.log("Macrotext for key " + string + " is " + this.macro.get(string));
        }
        return string3;
    }

    private void executeSqlCommands() {
        if (this.macro.isEmpty()) {
            return;
        }
        this.myDb = JMDBMain.myJMDBMain.getNewJDBCAdapter();
        if (!this.skipCreatingTmpMovies) {
            this.myDb.executeCommand(DataBaseConverter2.getSQLWorker().getSQLCreateTemporaryTableMovieAndReleasedates("tmpmovies"));
            try {
                try {
                    this.myDb.setPreparedStatement("INSERT INTO tmpmovies (title, movieid, year) SELECT title, movieid, year FROM movies WHERE title = ?");
                    int n = 0;
                    while (n < this.rowCount) {
                        this.myDb.getPreparedStatement().setString(1, (String)this.myTable.getModel().getValueAt(n, 0));
                        this.myDb.getPreparedStatement().addBatch();
                        ++n;
                    }
                    this.myDb.getPreparedStatement().executeBatch();
                }
                catch (SQLException sQLException) {
                    JMDBMain.myJMDBMain.log("SQL Exception inserting data into table tmpmovies: " + this.myDb.getPreparedStatement().toString() + " - " + sQLException);
                }
            }
            catch (Throwable throwable) {
                Object var1_4 = null;
                this.myDb.closePreparedStatement();
                throw throwable;
            }
            Object var1_5 = null;
            this.myDb.closePreparedStatement();
        }
        int n = 0;
        while (n < this.sqlCommandCount) {
            this.myDb.executeCommand(this.sqlCommand[n]);
            ++n;
        }
    }

    private Color getColor(String string) {
        if (string.equals("black")) {
            return Color.black;
        }
        if (string.equals("blue")) {
            return Color.blue;
        }
        if (string.equals("cyan")) {
            return Color.cyan;
        }
        if (string.equals("darkGray")) {
            return Color.darkGray;
        }
        if (string.equals("gray")) {
            return Color.gray;
        }
        if (string.equals("green")) {
            return Color.green;
        }
        if (string.equals("lightGray")) {
            return Color.lightGray;
        }
        if (string.equals("magenta")) {
            return Color.magenta;
        }
        if (string.equals("orange")) {
            return Color.orange;
        }
        if (string.equals("pink")) {
            return Color.pink;
        }
        if (string.equals("red")) {
            return Color.red;
        }
        if (string.equals("white")) {
            return Color.white;
        }
        if (string.equals("yellow")) {
            return Color.yellow;
        }
        return Color.decode(string);
    }

    private SQLWorkerAbstract getSQLWorker() {
        return this.sqlWorker;
    }

    private boolean replaceMacrowords() {
        int n;
        int n2 = this.columnCount * this.rowCount;
        int n3 = 0;
        int n4 = this.myMovieCollectionWindow.getDefaultRowHeight();
        int n5 = 1;
        int n6 = this.myMovieCollectionWindow.getMaxLineCount();
        if (this.macro.isEmpty()) {
            return true;
        }
        int n7 = 0;
        while (n7 < this.rowCount) {
            n = 1;
            while (n < this.columnCount) {
                this.myBar.setValue(++n3 * 50 / n2 + 50);
                try {
                    String string = (String)this.myTable.getModel().getValueAt(n7, n);
                    Enumeration enumeration = this.macro.keys();
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        if (string.indexOf(string2) < 0) continue;
                        int n8 = string.indexOf(string2);
                        int n9 = string.lastIndexOf("<", n8);
                        int n10 = string.indexOf(">", n8);
                        if (n9 < 0 || n8 < 0 || n10 < 0 || n9 >= n8 || n8 >= n10) continue;
                        String string3 = this.executeMacro(string2, (String)this.myTable.getModel().getValueAt(n7, 0));
                        string = string3.length() > 0 ? String.valueOf(string.substring(0, n9)) + string.substring(n9 + 1, n8) + string3 + string.substring(n8 + string2.length(), n10) + string.substring(n10 + 1, string.length()) : String.valueOf(string.substring(0, n9)) + string.substring(n10 + 1, string.length());
                        this.myTable.getModel().setValueAt(string, n7, n);
                    }
                }
                catch (ClassCastException classCastException) {}
                ++n;
            }
            ++n7;
        }
        if (MovieCollectionWindow.getMovieCollectionLinesPerRow() == 0) {
            n7 = 0;
            while (n7 < this.rowCount) {
                n = 1;
                while (n < this.columnCount) {
                    n5 = ((MultiLineColorColumnRenderer)this.myTable.getColumnModel().getColumn(n).getCellRenderer()).getLineCount();
                    if (n5 > n6) {
                        n6 = n5;
                    }
                    ++n;
                }
                ++n7;
            }
            if (n6 > 1) {
                if (this.myShowFullRows.isSelected()) {
                    this.myTable.setRowHeight(n6 * n4);
                }
                this.myMovieCollectionWindow.setMaxLineCount(n6);
            }
        } else {
            if (this.myShowFullRows.isSelected()) {
                this.myTable.setRowHeight(MovieCollectionWindow.getMovieCollectionLinesPerRow() * n4);
            }
            this.myMovieCollectionWindow.setMaxLineCount(MovieCollectionWindow.getMovieCollectionLinesPerRow());
        }
        this.myDb.closedb();
        return true;
    }

    public void run() {
        this.myBar.setValue(0);
        this.myStatus.setText(this.myMovieCollectionWindow.getResMessagesBundle().getString("MovieCollectionWindow.label.status_creating_table"));
        this.createTable();
        this.myMovieCollectionWindow.setSize(this.myMovieCollectionWindow.getWidth() - 1, this.myMovieCollectionWindow.getHeight());
        this.myMovieCollectionWindow.setVisible(true);
        this.myBar.setValue(10);
        this.myStatus.setText(this.myMovieCollectionWindow.getResMessagesBundle().getString("MovieCollectionWindow.label.status_adding_data"));
        this.addData();
        this.myBar.setValue(20);
        this.myStatus.setText(this.myMovieCollectionWindow.getResMessagesBundle().getString("MovieCollectionWindow.label.status_executing_sql_commands"));
        this.executeSqlCommands();
        this.myBar.setValue(60);
        this.myStatus.setText(this.myMovieCollectionWindow.getResMessagesBundle().getString("MovieCollectionWindow.label.status_replacing_macrowords"));
        this.replaceMacrowords();
        ((SortableTableModel2)this.myTable.getModel()).setSortEnabled(true);
        if (SimpleResultWindow.cfgAutoSort && this.myTable.getModel().getRowCount() < 500 && !this.myMovieCollectionWindow.userEnteredTable) {
            this.myStatus.setText(this.myMovieCollectionWindow.getResMessagesBundle().getString("JMDB.label.status_autosort_rows"));
            ((SortableTableModel2)this.myTable.getModel()).sortByColumn(this.sortColumn, true);
        }
        this.myBar.setValue(100);
        this.myBar.setEnabled(false);
        this.myStatus.setText(String.valueOf(this.myMovieCollectionWindow.getResMessagesBundle().getString("JMDB.label.status_finished")) + " (" + this.rowCount + " " + this.myMovieCollectionWindow.getResMessagesBundle().getString("MovieCollectionWindow.label.status_x_movies_in_collection") + ")");
        this.myMovieCollectionWindow.selectTableRow();
        this.myBar.setVisible(false);
        this.mySearchField.setVisible(true);
        if (this.myMovieCollectionWindow.getMaxLineCount() > 1) {
            this.myShowFullRows.setEnabled(true);
        }
        JMDBMain.myJMDBMain.playSound();
    }

    private boolean setColumn(int n, String string) {
        String[] stringArray = this.splitInArray(string);
        if (stringArray.length != 7) {
            JMDBMain.myJMDBMain.log("ERROR in MovieCollectionWindowThread.setColumn(int, String): Column definition has not 7 elements.");
            return false;
        }
        String string2 = stringArray[0];
        int n2 = new Integer(stringArray[1]);
        int n3 = new Integer(stringArray[2]);
        int n4 = new Integer(stringArray[3]);
        if (n2 < 0 || n2 > 5000 || n4 < 0 || n4 > 5000 || n3 < 0 || n3 > 5000 || n2 > n3 || n3 > n4) {
            JMDBMain.myJMDBMain.log("ERROR in MovieCollectionWindowThread.setColumn: Column widths malformed: min=" + n2 + ", pref=" + n3 + ", max=" + n4);
            return false;
        }
        Color color = this.getColor(stringArray[5]);
        Color color2 = this.getColor(stringArray[6]);
        MultiLineColorColumnRenderer multiLineColorColumnRenderer = new MultiLineColorColumnRenderer(true, true, true, color, color2);
        TableColumn tableColumn = this.myTable.getColumnModel().getColumn(n);
        tableColumn.setHeaderValue(string2);
        tableColumn.setHeaderRenderer(this.sortButtonRenderer);
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n4);
        tableColumn.setPreferredWidth(n3);
        tableColumn.setWidth(n3);
        tableColumn.setCellRenderer(multiLineColorColumnRenderer);
        ((SortableTableModel2)this.myTable.getModel()).setColumnClass(n, new String(stringArray[4].trim()));
        return true;
    }

    private boolean setSortColumn(String string) {
        this.sortColumn = 1;
        return true;
    }

    private String[] splitInArray(String string) {
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(";", n2 + 1)) > 0) {
            ++n;
        }
        String[] stringArray = new String[n + 1];
        n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (string.indexOf(";") != -1) {
                stringArray[n3] = string.substring(0, string.indexOf(";")).trim();
                string = string.substring(string.indexOf(";") + 1);
            }
            ++n3;
        }
        stringArray[n] = string.trim();
        return stringArray;
    }

    class HeaderListener
    extends MouseAdapter {
        JTableHeader header;
        SortButtonRenderer renderer;

        HeaderListener(JTableHeader jTableHeader, SortButtonRenderer sortButtonRenderer) {
            this.header = jTableHeader;
            this.renderer = sortButtonRenderer;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.header.getCursor().getType() == 11) {
                return;
            }
            int n = this.header.columnAtPoint(mouseEvent.getPoint());
            int n2 = this.header.getTable().convertColumnIndexToModel(n);
            this.renderer.setPressedColumn(n);
            this.renderer.setSelectedColumn(n);
            this.header.repaint();
            if (this.header.getTable().isEditing()) {
                this.header.getTable().getCellEditor().stopCellEditing();
            }
            boolean bl = 1 == this.renderer.getState(n);
            ((SortableTableModel2)this.header.getTable().getModel()).sortByColumn(n2, bl);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.header.columnAtPoint(mouseEvent.getPoint());
            this.renderer.setPressedColumn(-1);
            this.header.repaint();
        }
    }
}

