/*
 * Decompiled with CFR 0.152.
 */
package jmdb.base;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.table.JTableHeader;
import javax.swing.tree.DefaultMutableTreeNode;
import jmdb.base.DraggableTree;
import jmdb.base.ExpertResultWindow;
import jmdb.base.JMDBMain;
import jmdb.database.JDBCAdapter;
import jmdb.sortabletable.SortButtonRenderer;
import jmdb.sortabletable.SortableTableModel;

class ExpertResultWindowThread
extends Thread {
    private JProgressBar myBar;
    private ExpertResultWindow myExpertResultWindow;
    private static ResourceBundle myResMessagesBundle;
    public JDBCAdapter db;
    public String tmpTableID;
    public String searchTable;
    public String selectColumnName;
    public String selectColumnId;
    public String searchAKATable;
    public String selectColumnAKAName;
    public JLabel myStatus;
    private DraggableTree myTree;
    private boolean isFirstSearch;

    public ExpertResultWindowThread(ExpertResultWindow expertResultWindow, boolean bl, DraggableTree draggableTree, JLabel jLabel, JProgressBar jProgressBar, ResourceBundle resourceBundle) {
        this.myExpertResultWindow = expertResultWindow;
        this.isFirstSearch = bl;
        this.myTree = draggableTree;
        this.myStatus = jLabel;
        this.myBar = jProgressBar;
        myResMessagesBundle = resourceBundle;
    }

    private void firstSearch() {
        this.myBar.setVisible(true);
        this.tmpTableID = JMDBMain.myJMDBMain.getUniqueID();
        this.searchTable = this.myExpertResultWindow.category.toLowerCase();
        this.searchAKATable = this.myExpertResultWindow.category.equalsIgnoreCase("Movies") ? "akatitles" : "akanames";
        this.selectColumnName = this.myExpertResultWindow.category.equalsIgnoreCase("Movies") ? "title" : "name";
        String string = this.selectColumnAKAName = this.myExpertResultWindow.category.equalsIgnoreCase("Movies") ? "title" : "akaname";
        if (this.searchTable.equals("movies")) {
            this.selectColumnId = "movieid";
        }
        if (this.searchTable.equals("actors")) {
            this.selectColumnId = "actorid";
        }
        if (this.searchTable.equals("directors")) {
            this.selectColumnId = "directorid";
        }
        if (this.searchTable.equals("producers")) {
            this.selectColumnId = "producerid";
        }
        this.myBar.setValue(0);
        this.db = JMDBMain.myJMDBMain.getNewJDBCAdapter();
        String string2 = this.myExpertResultWindow.expression;
        int[] nArray = null;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.myExpertResultWindow.category);
        if (this.searchTable.equals("movies")) {
            this.tmpTableID = JMDBMain.myJMDBMain.getUniqueID();
            this.db.executeCommand("CREATE TEMPORARY TABLE " + this.tmpTableID + " (title varchar(200) not null, primary key (title));");
            this.myBar.setValue(15);
            this.myStatus.setText(myResMessagesBundle.getString("JMDB.label.status_searching_expression_in_normal"));
            String string3 = "INSERT INTO " + this.tmpTableID + " (title) SELECT title from movies where " + this.myExpertResultWindow.sqlEqualString("title", string2, this.myExpertResultWindow.searchType, this.myExpertResultWindow.expBeginWith, this.myExpertResultWindow.expEndWith);
            String[] stringArray = this.myExpertResultWindow.sqlParamStringArray("title", string2, this.myExpertResultWindow.searchType, this.myExpertResultWindow.expBeginWith, this.myExpertResultWindow.expEndWith, 0);
            this.db.executePreparedCommand(string3, stringArray, nArray);
            if (this.myExpertResultWindow.AKASearch) {
                this.myBar.setValue(50);
                this.myStatus.setText(myResMessagesBundle.getString("JMDB.label.status_searching_expression_in_aka"));
                string3 = "INSERT INTO " + this.tmpTableID + " (title) SELECT movies.title from movies, akatitles where movies.movieid=akatitles.movieid AND " + this.myExpertResultWindow.sqlEqualString("akatitles.title", string2, this.myExpertResultWindow.searchType, this.myExpertResultWindow.expBeginWith, this.myExpertResultWindow.expEndWith);
                stringArray = this.myExpertResultWindow.sqlParamStringArray("akatitles.title", string2, this.myExpertResultWindow.searchType, this.myExpertResultWindow.expBeginWith, this.myExpertResultWindow.expEndWith, 0);
                this.db.executePreparedCommand(string3, stringArray, nArray);
            }
            this.myBar.setValue(90);
            this.myStatus.setText(myResMessagesBundle.getString("JMDB.label.status_updating_tree"));
            this.db.executeQuery("SELECT title from " + this.tmpTableID + " order by title asc;");
            try {
                while (this.db.resultSet.next()) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.db.resultSet.getString(1)));
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in ExpertResultWindowThread.firstSearch(): " + sQLException);
            }
        } else {
            this.tmpTableID = JMDBMain.myJMDBMain.getUniqueID();
            this.db.executeCommand("CREATE TEMPORARY TABLE " + this.tmpTableID + " (name varchar(200) not null, primary key (name));");
            this.myBar.setValue(15);
            this.myStatus.setText(myResMessagesBundle.getString("JMDB.label.status_searching_expression_in_normal"));
            String string4 = "INSERT INTO " + this.tmpTableID + " (name) SELECT name from " + this.searchTable + " where " + this.myExpertResultWindow.sqlEqualString("name", string2, this.myExpertResultWindow.searchType, this.myExpertResultWindow.expBeginWith, this.myExpertResultWindow.expEndWith);
            String[] stringArray = this.myExpertResultWindow.sqlParamStringArray("name", string2, this.myExpertResultWindow.searchType, this.myExpertResultWindow.expBeginWith, this.myExpertResultWindow.expEndWith, 0);
            this.db.executePreparedCommand(string4, stringArray, nArray);
            if (this.myExpertResultWindow.AKASearch) {
                string4 = "INSERT INTO " + this.tmpTableID + " (name) SELECT name from akanames where " + this.myExpertResultWindow.sqlEqualString("akaname", string2, this.myExpertResultWindow.searchType, this.myExpertResultWindow.expBeginWith, this.myExpertResultWindow.expEndWith);
                stringArray = this.myExpertResultWindow.sqlParamStringArray("akaname", string2, this.myExpertResultWindow.searchType, this.myExpertResultWindow.expBeginWith, this.myExpertResultWindow.expEndWith, 0);
                this.db.executePreparedCommand(string4, stringArray, nArray);
                this.myBar.setValue(50);
                this.myStatus.setText(myResMessagesBundle.getString("JMDB.label.status_searching_expression_in_aka"));
            }
            this.myBar.setValue(90);
            this.myStatus.setText(myResMessagesBundle.getString("JMDB.label.status_updating_tree"));
            this.db.executeQuery("SELECT name from " + this.tmpTableID + " order by name asc;");
            try {
                while (this.db.resultSet.next()) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.db.resultSet.getString(1)));
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in ExpertResultWindowThread.firstSearch(): " + sQLException);
            }
        }
        this.myTree.clearTreeSetCategoryNode(defaultMutableTreeNode);
        this.db.closedb();
        this.myBar.setValue(100);
        this.myStatus.setText(String.valueOf(myResMessagesBundle.getString("JMDB.label.status_finished")) + " (" + this.myTree.getElementCount() + " " + myResMessagesBundle.getString("JMDB.label." + this.searchTable.toLowerCase()) + " " + myResMessagesBundle.getString("JMDB.label.status_found") + ")");
        this.myBar.setVisible(false);
        JMDBMain.myJMDBMain.playSound();
    }

    private void newSearch() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        DefaultMutableTreeNode defaultMutableTreeNode3;
        DefaultMutableTreeNode defaultMutableTreeNode4;
        JDBCAdapter jDBCAdapter = JMDBMain.myJMDBMain.getNewJDBCAdapter();
        JMDBMain.myJMDBMain.getDbname();
        String[] cfr_ignored_0 = new String[1];
        int[] cfr_ignored_1 = new int[1];
        this.myBar.setVisible(true);
        this.myBar.setValue(5);
        this.myStatus.setText(myResMessagesBundle.getString("JMDB.label.status_transfering_ids2tmptables"));
        this.newSearchWriteIds(jDBCAdapter, this.myTree.nodeMovies, "movie", "title");
        this.newSearchWriteIds(jDBCAdapter, this.myTree.nodeActors, "actor", "name");
        this.newSearchWriteIds(jDBCAdapter, this.myTree.nodeDirectors, "director", "name");
        this.newSearchWriteIds(jDBCAdapter, this.myTree.nodeProducers, "producer", "name");
        this.myBar.setValue(15);
        this.myStatus.setText(myResMessagesBundle.getString("JMDB.label.status_searching_for_data"));
        this.newSearchFindMovies(jDBCAdapter, this.myTree.nodeActors, "actor", this.myExpertResultWindow.getJRadioButtonActorsOr().isSelected());
        this.newSearchFindMovies(jDBCAdapter, this.myTree.nodeDirectors, "director", this.myExpertResultWindow.getJRadioButtonDirectorsOr().isSelected());
        this.newSearchFindMovies(jDBCAdapter, this.myTree.nodeProducers, "producer", this.myExpertResultWindow.getJRadioButtonProducersOr().isSelected());
        this.myBar.setValue(45);
        this.myStatus.setText(myResMessagesBundle.getString("JMDB.label.status_merge_results"));
        this.newSearchMergeMovies(jDBCAdapter, this.myExpertResultWindow.getJRadioButtonCategoriesOr().isSelected(), this.myTree.nodeMovies != null, this.myTree.nodeActors != null, this.myTree.nodeDirectors != null, this.myTree.nodeProducers != null);
        if (this.myExpertResultWindow.getJCheckBoxMoviesOut().isSelected()) {
            this.myBar.setValue(70);
            this.myStatus.setText(myResMessagesBundle.getString("JMDB.label.status_creating_new_treenode_movies"));
            defaultMutableTreeNode4 = new DefaultMutableTreeNode("Movies");
            jDBCAdapter.executeQuery("select DISTINCT title from movies NATURAL JOIN tmpresult order by title asc;", defaultMutableTreeNode4);
        } else {
            defaultMutableTreeNode4 = null;
        }
        if (this.myExpertResultWindow.getJCheckBoxActorsOut().isSelected()) {
            this.myBar.setValue(77);
            this.myStatus.setText(myResMessagesBundle.getString("JMDB.label.status_creating_new_treenode_actors"));
            defaultMutableTreeNode3 = new DefaultMutableTreeNode("Actors");
            jDBCAdapter.executeQuery("select DISTINCT name from actors NATURAL JOIN movies2actors NATURAL JOIN tmpresult order by name asc;", defaultMutableTreeNode3);
        } else {
            defaultMutableTreeNode3 = null;
        }
        if (this.myExpertResultWindow.getJCheckBoxDirectorsOut().isSelected()) {
            this.myBar.setValue(84);
            this.myStatus.setText(myResMessagesBundle.getString("JMDB.label.status_creating_new_treenode_directors"));
            defaultMutableTreeNode2 = new DefaultMutableTreeNode("Directors");
            jDBCAdapter.executeQuery("select DISTINCT name from directors NATURAL JOIN movies2directors NATURAL JOIN tmpresult order by name asc;", defaultMutableTreeNode2);
        } else {
            defaultMutableTreeNode2 = null;
        }
        if (this.myExpertResultWindow.getJCheckBoxProducersOut().isSelected()) {
            this.myBar.setValue(91);
            this.myStatus.setText(myResMessagesBundle.getString("JMDB.label.status_creating_new_treenode_producers"));
            defaultMutableTreeNode = new DefaultMutableTreeNode("Producers");
            jDBCAdapter.executeQuery("select DISTINCT name from producers NATURAL JOIN movies2producers NATURAL JOIN tmpresult order by name asc;", defaultMutableTreeNode);
        } else {
            defaultMutableTreeNode = null;
        }
        this.myBar.setValue(97);
        this.myStatus.setText(myResMessagesBundle.getString("JMDB.label.status_creating_new_resultwindow"));
        ExpertResultWindow expertResultWindow = new ExpertResultWindow(defaultMutableTreeNode4, defaultMutableTreeNode3, defaultMutableTreeNode2, defaultMutableTreeNode, myResMessagesBundle.getString("ExpertResultWindow.title"));
        JMDBMain.myJMDBMain.addFrame(expertResultWindow, this.myExpertResultWindow, true);
        expertResultWindow.setVisible(true);
        jDBCAdapter.closedb();
        this.myBar.setValue(100);
        this.myStatus.setText(myResMessagesBundle.getString("JMDB.label.status_finished"));
        this.myBar.setVisible(false);
        JMDBMain.myJMDBMain.playSound();
    }

    public void newSearchFindMovies(JDBCAdapter jDBCAdapter, DefaultMutableTreeNode defaultMutableTreeNode, String string, boolean bl) {
        String[] cfr_ignored_0 = new String[1];
        int[] cfr_ignored_1 = new int[1];
        if (defaultMutableTreeNode != null) {
            jDBCAdapter.executeCommand("CREATE TEMPORARY TABLE tmp" + string + "smovies (movieId mediumint unsigned NOT NULL, PRIMARY KEY (movieId));");
            if (bl) {
                jDBCAdapter.executeCommand("INSERT INTO tmp" + string + "smovies (movieId) SELECT movieId FROM tmp" + string + "s NATURAL JOIN movies2" + string + "s;");
            } else {
                jDBCAdapter.executeCommand("INSERT INTO tmp" + string + "smovies (movieId) SELECT movieId FROM tmp" + string + "s NATURAL JOIN movies2" + string + "s GROUP BY movieId HAVING count(movieId)=" + defaultMutableTreeNode.getChildCount() + ";");
            }
        }
    }

    public void newSearchMergeMovies(JDBCAdapter jDBCAdapter, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        boolean bl6 = true;
        jDBCAdapter.executeCommand("CREATE TEMPORARY TABLE tmpresult (movieId mediumint unsigned NOT NULL, PRIMARY KEY (movieId));");
        if (bl) {
            if (bl2) {
                jDBCAdapter.executeCommand("INSERT INTO tmpresult (movieId) SELECT movieId FROM tmpmovies;");
            }
            if (bl3) {
                jDBCAdapter.executeCommand("INSERT INTO tmpresult (movieId) SELECT movieId FROM tmpactorsmovies;");
            }
            if (bl4) {
                jDBCAdapter.executeCommand("INSERT INTO tmpresult (movieId) SELECT movieId FROM tmpdirectorsmovies;");
            }
            if (bl5) {
                jDBCAdapter.executeCommand("INSERT INTO tmpresult (movieId) SELECT movieId FROM tmpproducersmovies;");
            }
        } else {
            String string = "INSERT INTO tmpresult (movieId) SELECT ";
            if (bl2) {
                string = bl6 ? String.valueOf(string) + "tmpmovies.movieId FROM " : String.valueOf(string) + " NATURAL JOIN ";
                string = String.valueOf(string) + "tmpmovies";
                bl6 = false;
            }
            if (bl3) {
                string = bl6 ? String.valueOf(string) + "tmpactorsmovies.movieId FROM " : String.valueOf(string) + " NATURAL JOIN ";
                string = String.valueOf(string) + "tmpactorsmovies";
                bl6 = false;
            }
            if (bl4) {
                string = bl6 ? String.valueOf(string) + "tmpdirectorsmovies.movieId FROM " : String.valueOf(string) + " NATURAL JOIN ";
                string = String.valueOf(string) + "tmpdirectorsmovies";
                bl6 = false;
            }
            if (bl5) {
                string = bl6 ? String.valueOf(string) + "tmpproducersmovies.movieId FROM " : String.valueOf(string) + " NATURAL JOIN ";
                string = String.valueOf(string) + "tmpproducersmovies";
                bl6 = false;
            }
            string = String.valueOf(string) + ";";
            jDBCAdapter.executeCommand(string);
        }
    }

    public void newSearchWriteIds(JDBCAdapter jDBCAdapter, DefaultMutableTreeNode defaultMutableTreeNode, String string, String string2) {
        String[] stringArray = new String[1];
        int[] nArray = new int[1];
        if (defaultMutableTreeNode != null) {
            jDBCAdapter.executeCommand("CREATE TEMPORARY TABLE tmp" + string + "s (" + string + "Id mediumint unsigned NOT NULL, PRIMARY KEY (" + string + "Id));");
            jDBCAdapter.setPreparedStatement("INSERT INTO tmp" + string + "s (" + string + "Id) select " + string + "id FROM " + string + "s where " + string2 + "=?;");
            int n = defaultMutableTreeNode.getChildCount();
            int n2 = 0;
            while (n2 < n) {
                stringArray[0] = defaultMutableTreeNode.getChildAt(n2).toString();
                jDBCAdapter.executePreparedCommand(stringArray, nArray);
                ++n2;
            }
        }
    }

    public void run() {
        this.myExpertResultWindow.setVisible(true);
        if (this.isFirstSearch) {
            this.firstSearch();
        } else {
            this.newSearch();
        }
        this.myExpertResultWindow.setButtonsEnabled(true);
    }

    class HeaderListener
    extends MouseAdapter {
        JTableHeader header;
        SortButtonRenderer renderer;

        HeaderListener(JTableHeader jTableHeader, SortButtonRenderer sortButtonRenderer) {
            this.header = jTableHeader;
            this.renderer = sortButtonRenderer;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = this.header.columnAtPoint(mouseEvent.getPoint());
            int n2 = this.header.getTable().convertColumnIndexToModel(n);
            this.renderer.setPressedColumn(n);
            this.renderer.setSelectedColumn(n);
            this.header.repaint();
            if (this.header.getTable().isEditing()) {
                this.header.getTable().getCellEditor().stopCellEditing();
            }
            boolean bl = 1 == this.renderer.getState(n);
            ((SortableTableModel)this.header.getTable().getModel()).sortByColumn(n2, bl);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.header.columnAtPoint(mouseEvent.getPoint());
            this.renderer.setPressedColumn(-1);
            this.header.repaint();
        }
    }
}

