/*
 * Decompiled with CFR 0.152.
 */
package jmdb.base;

class ExpertBuffer {
    private int actorsCount;
    private int moviesCount;
    private int producersCount;
    private int directorsCount;
    private String[] actors;
    private String[] movies;
    private String[] producers;
    private String[] directors;
    private int maxCount;

    public ExpertBuffer(int n) {
        this.maxCount = n;
    }

    public void addActor(String string) {
        if (this.actorsCount < this.maxCount) {
            this.actors[this.actorsCount++] = new String(string);
        }
    }

    public void addDirector(String string) {
        if (this.directorsCount < this.maxCount) {
            this.directors[this.directorsCount++] = new String(string);
        }
    }

    public void addMovie(String string) {
        if (this.moviesCount < this.maxCount) {
            this.movies[this.moviesCount++] = new String(string);
        }
    }

    public void addProducer(String string) {
        if (this.producersCount < this.maxCount) {
            this.producers[this.producersCount++] = new String(string);
        }
    }

    public void clear() {
        this.actors = new String[this.maxCount];
        this.directors = new String[this.maxCount];
        this.movies = new String[this.maxCount];
        this.producers = new String[this.maxCount];
        this.producersCount = 0;
        this.moviesCount = 0;
        this.directorsCount = 0;
        this.actorsCount = 0;
    }

    public String getActor(int n) {
        if (n < this.actorsCount && this.actors[n] != null) {
            return this.actors[n];
        }
        return null;
    }

    public int getActorsCount() {
        return this.actorsCount;
    }

    public String getDirector(int n) {
        if (n < this.directorsCount && this.directors[n] != null) {
            return this.directors[n];
        }
        return null;
    }

    public int getDirectorsCount() {
        return this.directorsCount;
    }

    public String getMovie(int n) {
        if (n < this.moviesCount && this.movies[n] != null) {
            return this.movies[n];
        }
        return null;
    }

    public int getMoviesCount() {
        return this.moviesCount;
    }

    public String getProducer(int n) {
        if (n < this.producersCount && this.producers[n] != null) {
            return this.producers[n];
        }
        return null;
    }

    public int getProducersCount() {
        return this.producersCount;
    }

    public boolean isEmpty() {
        return this.actorsCount == 0 && this.moviesCount == 0 && this.directorsCount == 0 && this.producersCount == 0;
    }
}

