/*
 * Decompiled with CFR 0.152.
 */
package jmdb.base;

import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jmdb.base.ExpertBuffer;
import jmdb.base.TransferableStrings;

public class DraggableTree
extends JTree
implements DragGestureListener,
DropTargetListener {
    DragSource dragSource = DragSource.getDefaultDragSource();
    DragSourceListener dragSourceListener = new JTreeDragSourceListener();
    DropTarget dropTarget;
    public DefaultMutableTreeNode nodeMovies;
    public DefaultMutableTreeNode nodeActors;
    public DefaultMutableTreeNode nodeDirectors;
    public DefaultMutableTreeNode nodeProducers;
    public DefaultTreeModel treeModel;
    public DefaultMutableTreeNode rootNode;
    public static DraggableTree dragSourceTree;

    public DraggableTree() {
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.dropTarget = new DropTarget(this, this);
        this.clearTree();
    }

    public DraggableTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        super(defaultMutableTreeNode);
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.dropTarget = new DropTarget(this, this);
        this.clearTree();
        this.treeModel.insertNodeInto(defaultMutableTreeNode, this.rootNode, 0);
        this.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        System.out.println("Node is " + defaultMutableTreeNode.toString());
        if (defaultMutableTreeNode.toString().equals("Movies")) {
            this.nodeMovies = defaultMutableTreeNode;
        } else if (defaultMutableTreeNode.toString().equals("Actors")) {
            this.nodeActors = defaultMutableTreeNode;
        } else if (defaultMutableTreeNode.toString().equals("Directors")) {
            this.nodeDirectors = defaultMutableTreeNode;
        } else {
            this.nodeProducers = defaultMutableTreeNode;
        }
    }

    public DraggableTree(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, DefaultMutableTreeNode defaultMutableTreeNode3, DefaultMutableTreeNode defaultMutableTreeNode4) {
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.dropTarget = new DropTarget(this, this);
        this.clearTree();
        if (defaultMutableTreeNode != null) {
            this.nodeMovies = defaultMutableTreeNode;
            this.rootNode.add(this.nodeMovies);
            this.expandPath(new TreePath(this.nodeMovies.getPath()));
        }
        if (defaultMutableTreeNode2 != null) {
            this.nodeActors = defaultMutableTreeNode2;
            this.rootNode.add(this.nodeActors);
            this.expandPath(new TreePath(this.nodeActors.getPath()));
        }
        if (defaultMutableTreeNode3 != null) {
            this.nodeDirectors = defaultMutableTreeNode3;
            this.rootNode.add(this.nodeDirectors);
            this.expandPath(new TreePath(this.nodeDirectors.getPath()));
        }
        if (defaultMutableTreeNode4 != null) {
            this.nodeProducers = defaultMutableTreeNode4;
            this.rootNode.add(this.nodeProducers);
            this.expandPath(new TreePath(this.nodeProducers.getPath()));
        }
        this.deleteEmptyCategoryNodes();
        this.refreshView();
    }

    private void changeCategoryNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.nodeMovies != null) {
            this.rootNode.remove(this.nodeMovies);
        }
        if (this.nodeActors != null) {
            this.rootNode.remove(this.nodeActors);
        }
        if (this.nodeDirectors != null) {
            this.rootNode.remove(this.nodeDirectors);
        }
        if (this.nodeProducers != null) {
            this.rootNode.remove(this.nodeProducers);
        }
        if (defaultMutableTreeNode.toString().equals("Movies")) {
            this.nodeMovies = defaultMutableTreeNode;
        } else if (defaultMutableTreeNode.toString().equals("Actors")) {
            this.nodeActors = defaultMutableTreeNode;
        } else if (defaultMutableTreeNode.toString().equals("Directors")) {
            this.nodeDirectors = defaultMutableTreeNode;
        } else if (defaultMutableTreeNode.toString().equals("Producers")) {
            this.nodeProducers = defaultMutableTreeNode;
        }
        if (this.nodeMovies != null) {
            this.rootNode.add(this.nodeMovies);
        }
        if (this.nodeActors != null) {
            this.rootNode.add(this.nodeActors);
        }
        if (this.nodeDirectors != null) {
            this.rootNode.add(this.nodeDirectors);
        }
        if (this.nodeProducers != null) {
            this.rootNode.add(this.nodeProducers);
        }
    }

    private void clearTree() {
        this.nodeMovies = null;
        this.nodeActors = null;
        this.nodeDirectors = null;
        this.nodeProducers = null;
        this.rootNode = new DefaultMutableTreeNode("rootNode");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.setModel(this.treeModel);
        this.setRootVisible(false);
    }

    public void clearTreeSetCategoryNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.clearTree();
        this.changeCategoryNode(defaultMutableTreeNode);
        this.deleteEmptyCategoryNodes();
        this.refreshView();
    }

    public void cutToExpertBuffer(ExpertBuffer expertBuffer) {
        TreePath[] treePathArray = this.getSelectionPaths();
        expertBuffer.clear();
        int n = 0;
        while (n < treePathArray.length) {
            if (treePathArray[n].getPathCount() == 3) {
                if (treePathArray[n].getPathComponent(1).toString().equals("Actors")) {
                    expertBuffer.addActor(treePathArray[n].getPathComponent(2).toString());
                } else if (treePathArray[n].getPathComponent(1).toString().equals("Movies")) {
                    expertBuffer.addMovie(treePathArray[n].getPathComponent(2).toString());
                } else if (treePathArray[n].getPathComponent(1).toString().equals("Directors")) {
                    expertBuffer.addDirector(treePathArray[n].getPathComponent(2).toString());
                } else {
                    expertBuffer.addProducer(treePathArray[n].getPathComponent(2).toString());
                }
            }
            ((DefaultMutableTreeNode)treePathArray[n].getPathComponent(1)).remove((DefaultMutableTreeNode)treePathArray[n].getPathComponent(2));
            ++n;
        }
        this.deleteEmptyCategoryNodes();
        this.refreshView();
    }

    private void deleteEmptyCategoryNodes() {
        if (this.nodeMovies != null && this.nodeMovies.getChildCount() == 0) {
            this.rootNode.remove(this.nodeMovies);
            this.nodeMovies = null;
        }
        if (this.nodeActors != null && this.nodeActors.getChildCount() == 0) {
            this.rootNode.remove(this.nodeActors);
            this.nodeActors = null;
        }
        if (this.nodeDirectors != null && this.nodeDirectors.getChildCount() == 0) {
            this.rootNode.remove(this.nodeDirectors);
            this.nodeDirectors = null;
        }
        if (this.nodeProducers != null && this.nodeProducers.getChildCount() == 0) {
            this.rootNode.remove(this.nodeProducers);
            this.nodeProducers = null;
        }
    }

    public void deleteSelectedItems() {
        TreePath[] treePathArray = this.getSelectionPaths();
        int n = 0;
        while (n < treePathArray.length) {
            if (treePathArray[n].getPathCount() == 3) {
                ((DefaultMutableTreeNode)treePathArray[n].getPathComponent(1)).remove((DefaultMutableTreeNode)treePathArray[n].getPathComponent(2));
            }
            ++n;
        }
        this.deleteEmptyCategoryNodes();
        this.refreshView();
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        System.out.println("INSIDE dragEnter");
        dropTargetDragEvent.acceptDrag(3);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        System.out.println("INSIDE dragExit");
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        TransferableStrings transferableStrings = new TransferableStrings(new String[1]);
        System.out.println("startDrag now...");
        dragSourceTree = this;
        this.dragSource.startDrag(dragGestureEvent, DragSource.DefaultCopyDrop, transferableStrings, this.dragSourceListener);
        System.out.println("...startDrag ended");
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        System.out.println("Inside Drop-Method!");
        System.out.println("SOURCE was   :" + dragSourceTree.toString());
        System.out.println("DEST is (me) :" + this.toString());
        if (dragSourceTree == this) {
            return;
        }
        TreePath[] treePathArray = dragSourceTree.getSelectionPaths();
        int n = 0;
        while (n < treePathArray.length) {
            if (treePathArray[n].getPathCount() == 3) {
                if (treePathArray[n].getPathComponent(1).toString().equals("Actors")) {
                    if (this.nodeActors == null) {
                        this.nodeActors = new DefaultMutableTreeNode("Actors");
                        this.rootNode.add(this.nodeActors);
                    }
                    this.nodeActors.add(new DefaultMutableTreeNode(treePathArray[n].getPathComponent(2).toString()));
                } else if (treePathArray[n].getPathComponent(1).toString().equals("Movies")) {
                    if (this.nodeMovies == null) {
                        this.nodeMovies = new DefaultMutableTreeNode("Movies");
                        this.rootNode.add(this.nodeMovies);
                    }
                    this.nodeMovies.add(new DefaultMutableTreeNode(treePathArray[n].getPathComponent(2).toString()));
                } else if (treePathArray[n].getPathComponent(1).toString().equals("Directors")) {
                    if (this.nodeDirectors == null) {
                        this.nodeDirectors = new DefaultMutableTreeNode("Directors");
                        this.rootNode.add(this.nodeDirectors);
                    }
                    this.nodeDirectors.add(new DefaultMutableTreeNode(treePathArray[n].getPathComponent(2).toString()));
                } else {
                    if (this.nodeProducers == null) {
                        this.nodeProducers = new DefaultMutableTreeNode("Producers");
                        this.rootNode.add(this.nodeProducers);
                    }
                    this.nodeProducers.add(new DefaultMutableTreeNode(treePathArray[n].getPathComponent(2).toString()));
                }
            }
            ++n;
        }
        this.refreshView();
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        System.out.println("INSIDE dropActionChanged");
    }

    public void exportExpertBuffer(ExpertBuffer expertBuffer) {
        TreePath[] treePathArray = this.getSelectionPaths();
        expertBuffer.clear();
        int n = 0;
        while (n < treePathArray.length) {
            if (treePathArray[n].getPathCount() == 3) {
                if (treePathArray[n].getPathComponent(1).toString().equals("Actors")) {
                    expertBuffer.addActor(treePathArray[n].getPathComponent(2).toString());
                } else if (treePathArray[n].getPathComponent(1).toString().equals("Movies")) {
                    expertBuffer.addMovie(treePathArray[n].getPathComponent(2).toString());
                } else if (treePathArray[n].getPathComponent(1).toString().equals("Directors")) {
                    expertBuffer.addDirector(treePathArray[n].getPathComponent(2).toString());
                } else {
                    expertBuffer.addProducer(treePathArray[n].getPathComponent(2).toString());
                }
            }
            ++n;
        }
    }

    public int getElementCount() {
        int n = this.getRowCount();
        if (this.nodeMovies != null) {
            --n;
        }
        if (this.nodeActors != null) {
            --n;
        }
        if (this.nodeDirectors != null) {
            --n;
        }
        if (this.nodeProducers != null) {
            --n;
        }
        return n;
    }

    public void importExpertBuffer(ExpertBuffer expertBuffer) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (expertBuffer.getMoviesCount() > 0) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("Movies");
            n5 = expertBuffer.getMoviesCount();
            if (this.nodeMovies == null) {
                n4 = 0;
                while (n4 < n5) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(expertBuffer.getMovie(n4)));
                    ++n4;
                }
            } else {
                n3 = this.nodeMovies.getChildCount();
                n2 = 1;
                n = 1;
                n4 = 1;
                do {
                    if (this.nodeMovies.getChildAt(n2 - 1).toString().compareTo(expertBuffer.getMovie(n - 1)) < 0) {
                        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.nodeMovies.getChildAt(n2 - 1).toString()));
                        ++n2;
                    } else {
                        defaultMutableTreeNode.add(new DefaultMutableTreeNode(expertBuffer.getMovie(n - 1)));
                        ++n;
                    }
                    ++n4;
                } while (n2 <= n3 & n <= n5);
                while (n2 <= n3) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.nodeMovies.getChildAt(n2 - 1).toString()));
                    ++n2;
                }
                while (n <= n5) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(expertBuffer.getMovie(n - 1)));
                    ++n;
                }
            }
            this.changeCategoryNode(defaultMutableTreeNode);
        }
        if (expertBuffer.getActorsCount() > 0) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("Actors");
            n5 = expertBuffer.getActorsCount();
            if (this.nodeActors == null) {
                n4 = 0;
                while (n4 < n5) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(expertBuffer.getActor(n4)));
                    ++n4;
                }
            } else {
                n3 = this.nodeActors.getChildCount();
                n2 = 1;
                n = 1;
                n4 = 1;
                do {
                    if (this.nodeActors.getChildAt(n2 - 1).toString().compareTo(expertBuffer.getActor(n - 1)) < 0) {
                        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.nodeActors.getChildAt(n2 - 1).toString()));
                        ++n2;
                    } else {
                        defaultMutableTreeNode.add(new DefaultMutableTreeNode(expertBuffer.getActor(n - 1)));
                        ++n;
                    }
                    ++n4;
                } while (n2 <= n3 & n <= n5);
                while (n2 <= n3) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.nodeActors.getChildAt(n2 - 1).toString()));
                    ++n2;
                }
                while (n <= n5) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(expertBuffer.getActor(n - 1)));
                    ++n;
                }
            }
            this.changeCategoryNode(defaultMutableTreeNode);
        }
        if (expertBuffer.getDirectorsCount() > 0) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("Directors");
            n5 = expertBuffer.getDirectorsCount();
            if (this.nodeDirectors == null) {
                n4 = 0;
                while (n4 < n5) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(expertBuffer.getDirector(n4)));
                    ++n4;
                }
            } else {
                n3 = this.nodeDirectors.getChildCount();
                n2 = 1;
                n = 1;
                n4 = 1;
                do {
                    if (this.nodeDirectors.getChildAt(n2 - 1).toString().compareTo(expertBuffer.getDirector(n - 1)) < 0) {
                        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.nodeDirectors.getChildAt(n2 - 1).toString()));
                        ++n2;
                    } else {
                        defaultMutableTreeNode.add(new DefaultMutableTreeNode(expertBuffer.getDirector(n - 1)));
                        ++n;
                    }
                    ++n4;
                } while (n2 <= n3 & n <= n5);
                while (n2 <= n3) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.nodeDirectors.getChildAt(n2 - 1).toString()));
                    ++n2;
                }
                while (n <= n5) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(expertBuffer.getDirector(n - 1)));
                    ++n;
                }
            }
            this.changeCategoryNode(defaultMutableTreeNode);
        }
        if (expertBuffer.getProducersCount() > 0) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("Producers");
            n5 = expertBuffer.getProducersCount();
            if (this.nodeProducers == null) {
                n4 = 0;
                while (n4 < n5) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(expertBuffer.getProducer(n4)));
                    ++n4;
                }
            } else {
                n3 = this.nodeProducers.getChildCount();
                n2 = 1;
                n = 1;
                n4 = 1;
                do {
                    if (this.nodeProducers.getChildAt(n2 - 1).toString().compareTo(expertBuffer.getProducer(n - 1)) < 0) {
                        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.nodeProducers.getChildAt(n2 - 1).toString()));
                        ++n2;
                    } else {
                        defaultMutableTreeNode.add(new DefaultMutableTreeNode(expertBuffer.getProducer(n - 1)));
                        ++n;
                    }
                    ++n4;
                } while (n2 <= n3 & n <= n5);
                while (n2 <= n3) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.nodeProducers.getChildAt(n2 - 1).toString()));
                    ++n2;
                }
                while (n <= n5) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(expertBuffer.getProducer(n - 1)));
                    ++n;
                }
            }
            this.changeCategoryNode(defaultMutableTreeNode);
        }
        this.refreshView();
    }

    private void refreshView() {
        this.treeModel.nodeStructureChanged(this.rootNode);
        if (this.nodeMovies != null && this.nodeMovies.getChildCount() > 0) {
            this.expandPath(new TreePath(this.nodeMovies.getPath()));
            this.makeVisible(new TreePath(((DefaultMutableTreeNode)this.nodeMovies.getChildAt(0)).getPath()));
        }
        if (this.nodeActors != null && this.nodeActors.getChildCount() > 0) {
            this.expandPath(new TreePath(this.nodeActors.getPath()));
            this.makeVisible(new TreePath(((DefaultMutableTreeNode)this.nodeActors.getChildAt(0)).getPath()));
        }
        if (this.nodeDirectors != null && this.nodeDirectors.getChildCount() > 0) {
            this.expandPath(new TreePath(this.nodeDirectors.getPath()));
            this.makeVisible(new TreePath(((DefaultMutableTreeNode)this.nodeDirectors.getChildAt(0)).getPath()));
        }
        if (this.nodeProducers != null && this.nodeProducers.getChildCount() > 0) {
            this.expandPath(new TreePath(this.nodeProducers.getPath()));
            this.makeVisible(new TreePath(((DefaultMutableTreeNode)this.nodeProducers.getChildAt(0)).getPath()));
        }
    }

    public void trimSelection() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Movies");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Actors");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Directors");
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("Producers");
        TreePath[] treePathArray = this.getSelectionPaths();
        int n = 0;
        while (n < treePathArray.length) {
            if (treePathArray[n].getPathCount() == 3) {
                if (treePathArray[n].getPathComponent(1).toString().equals("Actors")) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(treePathArray[n].getPathComponent(2).toString()));
                } else if (treePathArray[n].getPathComponent(1).toString().equals("Movies")) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(treePathArray[n].getPathComponent(2).toString()));
                    System.out.println("Adding to nodeMovies: " + treePathArray[n].getPathComponent(2).toString());
                } else if (treePathArray[n].getPathComponent(1).toString().equals("Directors")) {
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(treePathArray[n].getPathComponent(2).toString()));
                } else {
                    defaultMutableTreeNode4.add(new DefaultMutableTreeNode(treePathArray[n].getPathComponent(2).toString()));
                }
            }
            ++n;
        }
        this.clearTree();
        if (defaultMutableTreeNode.getChildCount() > 0) {
            this.nodeMovies = defaultMutableTreeNode;
            this.rootNode.add(this.nodeMovies);
        } else {
            this.nodeMovies = null;
        }
        if (defaultMutableTreeNode2.getChildCount() > 0) {
            this.nodeActors = defaultMutableTreeNode2;
            this.rootNode.add(this.nodeActors);
        } else {
            this.nodeActors = null;
        }
        if (defaultMutableTreeNode3.getChildCount() > 0) {
            this.nodeDirectors = defaultMutableTreeNode3;
            this.rootNode.add(this.nodeDirectors);
        } else {
            this.nodeDirectors = null;
        }
        if (defaultMutableTreeNode4.getChildCount() > 0) {
            this.nodeProducers = defaultMutableTreeNode4;
            this.rootNode.add(this.nodeProducers);
        } else {
            this.nodeProducers = null;
        }
        this.refreshView();
    }

    class JTreeDragSourceListener
    implements DragSourceListener {
        JTreeDragSourceListener() {
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }
    }
}

