/*
 * Decompiled with CFR 0.152.
 */
package jmdb.base;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import jmdb.base.DetailWindow2;
import jmdb.base.JMDBMain;
import jmdb.database.DataBaseConverter2;
import jmdb.database.JDBCAdapter;
import jmdb.database.SQLWorkerAbstract;
import jmdb.util.ActorDetailWindowMovieArray;
import jmdb.util.EncodeURL;
import jmdb.util.MovieDetailWindowActorArray;
import jmdb.util.SortableArray;
import jmdb.util.SortableArrayHeapSorter;

public class DetailWindow2Thread
extends Thread {
    private DetailWindow2 myDetailWindow;
    private JTextPane myTextPane;
    private JLabel myStatus;
    private JProgressBar myBar;
    private String myCategory;
    private String myItem;
    private String myQueryTable;
    public Document doc;
    private SQLWorkerAbstract sqlWorker = null;

    public DetailWindow2Thread(DetailWindow2 detailWindow2, JTextPane jTextPane, JLabel jLabel, JProgressBar jProgressBar) {
        this.myDetailWindow = detailWindow2;
        this.myTextPane = jTextPane;
        this.myStatus = jLabel;
        this.myBar = jProgressBar;
        this.myItem = detailWindow2.item;
        this.myQueryTable = detailWindow2.category.toLowerCase();
        this.myCategory = detailWindow2.category.substring(0, detailWindow2.category.length() - 1);
        this.doc = jTextPane.getDocument();
        this.sqlWorker = DataBaseConverter2.getSQLWorker();
    }

    public void dbQueryMovie() {
        Object object;
        JDBCAdapter jDBCAdapter = JMDBMain.myJMDBMain.getNewJDBCAdapter();
        String string = this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.no_info_available");
        String string2 = this.myDetailWindow.getResMessagesBundle().getString("JMDB.label.status_searching_for_data");
        int n = 0;
        String string3 = null;
        this.writeHeading(String.valueOf(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.details_to_movie")) + " " + this.myItem);
        String[] stringArray = new String[1];
        int[] nArray = new int[1];
        stringArray[0] = this.myItem;
        try {
            jDBCAdapter.executePreparedQuery("SELECT movieid, imdbid FROM movies WHERE title=?", stringArray, nArray);
            if (jDBCAdapter.resultSet.next()) {
                n = Integer.parseInt(jDBCAdapter.resultSet.getString("movieid"));
                string3 = jDBCAdapter.resultSet.getString("imdbid");
            }
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
        }
        if (n == 0) {
            this.writeText("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.error_cannot_get_movieid"));
        }
        stringArray = new String[1];
        nArray = new int[]{n};
        if (n != 0) {
            object = null;
            if (string3 != null) {
                object = new String("http://www.IMDb.com/title/" + string3 + "/");
            } else {
                try {
                    object = new String("http://www.IMDb.com/Title?" + EncodeURL.encode(this.myItem, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            if (object != null) {
                this.myDetailWindow.quickNavAdd("IMDb URL");
                this.writeCategory("\n\nIMDb URL:\n");
                this.writeHyperlinkUrl((String)object);
            }
        }
        if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("akatitles") && DetailWindow2.cfgMovieDetailWindowAKATitles && n != 0) {
            this.myBar.setValue(5);
            this.myStatus.setText(String.valueOf(string2) + " (akatitles)...");
            this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_aka_titles") + ":");
            this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_aka_titles"));
            jDBCAdapter.executePreparedQuery("SELECT DISTINCT title, addition FROM akatitles WHERE movieid=? ORDER BY TITLE ASC", stringArray, nArray);
            try {
                if (jDBCAdapter.resultSet.next()) {
                    this.writeText("\n" + jDBCAdapter.resultSet.getString("title") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    while (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("title") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    }
                } else {
                    this.writeText("\n" + string);
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
            }
        }
        if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("altversions")) {
            this.myBar.setValue(6);
            this.myStatus.setText(String.valueOf(string2) + " (alternate-versions)...");
            this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_alternateversions") + ":");
            this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_alternateversions"));
            jDBCAdapter.executePreparedQuery("SELECT versiontext FROM altversions WHERE movieid=?", stringArray, nArray);
            try {
                if (jDBCAdapter.resultSet.next()) {
                    this.writeText("\n" + jDBCAdapter.resultSet.getString("versiontext"));
                } else {
                    this.writeText("\n" + string);
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
            }
        }
        if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("directors") && DetailWindow2.cfgMovieDetailWindowImportantPeople && n != 0) {
            this.myBar.setValue(8);
            this.myStatus.setText(String.valueOf(string2) + " (directors)...");
            this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_directors") + ":");
            this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_directors"));
            jDBCAdapter.executePreparedQuery("SELECT directors.name, movies2directors.addition FROM directors INNER JOIN movies2directors ON directors.directorid=movies2directors.directorid WHERE movies2directors.movieid=?", stringArray, nArray);
            try {
                if (jDBCAdapter.resultSet.next()) {
                    this.writeHyperlinkDirector("\n" + jDBCAdapter.resultSet.getString("name") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    while (jDBCAdapter.resultSet.next()) {
                        this.writeHyperlinkDirector("\n" + jDBCAdapter.resultSet.getString("name") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    }
                } else {
                    this.writeText("\n" + string);
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
            }
        }
        if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("actors") && DetailWindow2.cfgMovieDetailWindowActors && n != 0) {
            object = new MovieDetailWindowActorArray(1000);
            this.myBar.setValue(13);
            this.myStatus.setText(String.valueOf(string2) + " (actors)...");
            this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_cast") + ":");
            this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_cast"));
            jDBCAdapter.executePreparedQuery("SELECT actors.name,movies2actors.as_character FROM actors INNER JOIN movies2actors ON actors.actorid=movies2actors.actorid WHERE movies2actors.movieid=?", stringArray, nArray);
            try {
                if (jDBCAdapter.resultSet.next()) {
                    ((MovieDetailWindowActorArray)object).add(jDBCAdapter.resultSet.getString("name"), jDBCAdapter.resultSet.getString("as_character"));
                    while (jDBCAdapter.resultSet.next()) {
                        ((MovieDetailWindowActorArray)object).add(jDBCAdapter.resultSet.getString("name"), jDBCAdapter.resultSet.getString("as_character"));
                    }
                } else {
                    this.writeText("\n" + string);
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
            }
            new SortableArrayHeapSorter().sort((SortableArray)object, ((MovieDetailWindowActorArray)object).getCount() - 1);
            int n2 = 0;
            while (n2 < ((MovieDetailWindowActorArray)object).getCount()) {
                this.writeHyperlinkActor("\n" + ((MovieDetailWindowActorArray)object).getText(n2));
                ++n2;
            }
        }
        if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("plots") && DetailWindow2.cfgMovieDetailWindowPlot && n != 0) {
            this.myBar.setValue(16);
            this.myStatus.setText(String.valueOf(string2) + " (plots)...");
            this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_plot") + ":");
            this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_plot"));
            stringArray = new String[1];
            nArray = new int[]{n};
            jDBCAdapter.executePreparedQuery("SELECT plottext FROM plots WHERE movieid=?", stringArray, nArray);
            try {
                if (jDBCAdapter.resultSet.next()) {
                    this.writeText("\n" + jDBCAdapter.resultSet.getString("plottext"));
                    while (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n\n" + jDBCAdapter.resultSet.getString("plottext"));
                    }
                } else {
                    this.writeText("\n" + string);
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
            }
        }
        if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("producers") && DetailWindow2.cfgMovieDetailWindowImportantPeople && n != 0) {
            this.myBar.setValue(19);
            this.myStatus.setText(String.valueOf(string2) + " (producers)...");
            this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_producers") + ":");
            this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_producers"));
            jDBCAdapter.executePreparedQuery("SELECT producers.name,movies2producers.addition FROM producers INNER JOIN movies2producers ON producers.producerid=movies2producers.producerid WHERE movies2producers.movieid=?", stringArray, nArray);
            try {
                if (jDBCAdapter.resultSet.next()) {
                    this.writeHyperlinkProducer("\n" + jDBCAdapter.resultSet.getString("name") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    while (jDBCAdapter.resultSet.next()) {
                        this.writeHyperlinkProducer("\n" + jDBCAdapter.resultSet.getString("name") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    }
                } else {
                    this.writeText("\n" + string);
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
            }
        }
        if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("writers") && DetailWindow2.cfgMovieDetailWindowImportantPeople && n != 0) {
            this.myBar.setValue(21);
            this.myStatus.setText(String.valueOf(string2) + " (writers)...");
            this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_writers") + ":");
            this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_writers"));
            jDBCAdapter.executePreparedQuery("SELECT writers.name,movies2writers.addition FROM writers INNER JOIN movies2writers ON writers.writerid=movies2writers.writerid WHERE movies2writers.movieid=?", stringArray, nArray);
            try {
                if (jDBCAdapter.resultSet.next()) {
                    this.writeText("\n" + jDBCAdapter.resultSet.getString("name") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    while (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("name") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    }
                } else {
                    this.writeText("\n" + string);
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
            }
        }
        if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("composers") && DetailWindow2.cfgMovieDetailWindowImportantPeople && n != 0) {
            this.myBar.setValue(24);
            this.myStatus.setText(String.valueOf(string2) + " (composers)...");
            this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_composers") + ":");
            this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_composers"));
            jDBCAdapter.executePreparedQuery("SELECT composers.name,movies2composers.addition FROM composers INNER JOIN movies2composers ON composers.composerid=movies2composers.composerid WHERE movies2composers.movieid=?", stringArray, nArray);
            try {
                if (jDBCAdapter.resultSet.next()) {
                    this.writeText("\n" + jDBCAdapter.resultSet.getString("name") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    while (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("name") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    }
                } else {
                    this.writeText("\n" + string);
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
            }
        }
        if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("editors") && DetailWindow2.cfgMovieDetailWindowImportantPeople && n != 0) {
            this.myBar.setValue(27);
            this.myStatus.setText(String.valueOf(string2) + " (editors)...");
            this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_editors") + ":");
            this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_editors"));
            jDBCAdapter.executePreparedQuery("SELECT editors.name,movies2editors.addition FROM editors INNER JOIN movies2editors ON editors.editorid=movies2editors.editorid WHERE movies2editors.movieid=?", stringArray, nArray);
            try {
                if (jDBCAdapter.resultSet.next()) {
                    this.writeText("\n" + jDBCAdapter.resultSet.getString("name") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    while (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("name") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    }
                } else {
                    this.writeText("\n" + string);
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
            }
        }
        if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("cinematgrs") && DetailWindow2.cfgMovieDetailWindowImportantPeople && n != 0) {
            this.myBar.setValue(31);
            this.myStatus.setText(String.valueOf(string2) + " (cinematgrs)...");
            this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_cinematographers") + ":");
            this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_cinematographers"));
            jDBCAdapter.executePreparedQuery("SELECT cinematgrs.name,movies2cinematgrs.addition FROM cinematgrs INNER JOIN movies2cinematgrs ON cinematgrs.cinematid=movies2cinematgrs.cinematid WHERE movies2cinematgrs.movieid=?", stringArray, nArray);
            try {
                if (jDBCAdapter.resultSet.next()) {
                    this.writeText("\n" + jDBCAdapter.resultSet.getString("name") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    while (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("name") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    }
                } else {
                    this.writeText("\n" + string);
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
            }
        }
        if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("proddesigners") && DetailWindow2.cfgMovieDetailWindowImportantPeople && n != 0) {
            this.myBar.setValue(35);
            this.myStatus.setText(String.valueOf(string2) + " (proddesigners)...");
            this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_production_designers") + ":");
            this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_production_designers"));
            jDBCAdapter.executePreparedQuery("SELECT proddesigners.name,movies2proddes.addition FROM proddesigners INNER JOIN movies2proddes ON proddesigners.proddesid=movies2proddes.proddesid WHERE movies2proddes.movieid=?", stringArray, nArray);
            try {
                if (jDBCAdapter.resultSet.next()) {
                    this.writeText("\n" + jDBCAdapter.resultSet.getString("name") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    while (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("name") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    }
                } else {
                    this.writeText("\n" + string);
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
            }
        }
        if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("costdesigners") && DetailWindow2.cfgMovieDetailWindowImportantPeople && n != 0) {
            this.myBar.setValue(40);
            this.myStatus.setText(String.valueOf(string2) + " (costdesigners)...");
            this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_costume_designers") + ":");
            this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_costume_designers"));
            jDBCAdapter.executePreparedQuery("SELECT costdesigners.name,movies2costdes.addition FROM costdesigners INNER JOIN movies2costdes ON costdesigners.costdesid=movies2costdes.costdesid WHERE movies2costdes.movieid=?", stringArray, nArray);
            try {
                if (jDBCAdapter.resultSet.next()) {
                    this.writeText("\n" + jDBCAdapter.resultSet.getString("name") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    while (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("name") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    }
                } else {
                    this.writeText("\n" + string);
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
            }
        }
        if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("misc") && DetailWindow2.cfgMovieDetailWindowMiscPeople && n != 0) {
            this.myBar.setValue(45);
            this.myStatus.setText(String.valueOf(string2) + " (misc)...");
            this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_miscellaneous_people") + ":");
            this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_miscellaneous_people"));
            jDBCAdapter.executePreparedQuery("SELECT misc.name,movies2misc.addition FROM misc INNER JOIN movies2misc ON misc.miscid=movies2misc.miscid WHERE movies2misc.movieid=?", stringArray, nArray);
            try {
                if (jDBCAdapter.resultSet.next()) {
                    this.writeText("\n" + jDBCAdapter.resultSet.getString("name") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    while (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("name") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    }
                } else {
                    this.writeText("\n" + string);
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
            }
        }
        if (DetailWindow2.cfgMovieDetailWindowTechnical && n != 0) {
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("keywords")) {
                this.myBar.setValue(50);
                this.myStatus.setText(String.valueOf(string2) + " (keywords)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_keywords") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_keywords"));
                jDBCAdapter.executePreparedQuery("SELECT keyword FROM keywords WHERE movieid=? ORDER BY keyword ASC", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("keyword"));
                        while (jDBCAdapter.resultSet.next()) {
                            this.writeText("\n" + jDBCAdapter.resultSet.getString("keyword"));
                        }
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("prodcompanies")) {
                this.myBar.setValue(53);
                this.myStatus.setText(String.valueOf(string2) + " (prodcompanies)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_production_companies") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_production_companies"));
                jDBCAdapter.executePreparedQuery("SELECT name FROM prodcompanies WHERE movieid=? ORDER BY name ASC", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("name"));
                        while (jDBCAdapter.resultSet.next()) {
                            this.writeText("\n" + jDBCAdapter.resultSet.getString("name"));
                        }
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("countries")) {
                this.myBar.setValue(56);
                this.myStatus.setText(String.valueOf(string2) + " (countries)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_countries") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_countries"));
                jDBCAdapter.executePreparedQuery("SELECT country FROM countries WHERE movieid=? ORDER BY country ASC", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("country"));
                        while (jDBCAdapter.resultSet.next()) {
                            this.writeText("\n" + jDBCAdapter.resultSet.getString("country"));
                        }
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("releasedates")) {
                this.myBar.setValue(59);
                this.myStatus.setText(String.valueOf(string2) + " (releasedates)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_release_dates") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_release_dates"));
                if (DetailWindow2.isCfgMovieDetailWindowReleasedateByDate()) {
                    jDBCAdapter.executePreparedQuery("SELECT country, imdbdate, " + this.getSQLWorker().getSQLMetaNotNullValue(this.getSQLWorker().getSQLMetaConcat("' - '", "addition"), "''") + " FROM releasedates WHERE movieid=? ORDER BY releasedate ASC", stringArray, nArray);
                } else {
                    jDBCAdapter.executePreparedQuery("SELECT country, imdbdate, " + this.getSQLWorker().getSQLMetaNotNullValue(this.getSQLWorker().getSQLMetaConcat("' - '", "addition"), "''") + " FROM releasedates WHERE movieid=? ORDER BY country ASC", stringArray, nArray);
                }
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        if (DetailWindow2.isCfgMovieDetailWindowReleasedateByDate()) {
                            this.writeText("\n" + jDBCAdapter.resultSet.getString(2) + jDBCAdapter.resultSet.getString(3) + ": " + jDBCAdapter.resultSet.getString(1));
                            while (jDBCAdapter.resultSet.next()) {
                                this.writeText("\n" + jDBCAdapter.resultSet.getString(2) + jDBCAdapter.resultSet.getString(3) + ": " + jDBCAdapter.resultSet.getString(1));
                            }
                        } else {
                            this.writeText("\n" + jDBCAdapter.resultSet.getString(1) + ": " + jDBCAdapter.resultSet.getString(2) + jDBCAdapter.resultSet.getString(3));
                            while (jDBCAdapter.resultSet.next()) {
                                this.writeText("\n" + jDBCAdapter.resultSet.getString(1) + ": " + jDBCAdapter.resultSet.getString(2) + jDBCAdapter.resultSet.getString(3));
                            }
                        }
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("genres")) {
                this.myBar.setValue(61);
                this.myStatus.setText(String.valueOf(string2) + " (genres)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_genres") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_genres"));
                jDBCAdapter.executePreparedQuery("SELECT genre FROM genres WHERE movieid=? ORDER BY genre ASC", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("genre"));
                        while (jDBCAdapter.resultSet.next()) {
                            this.writeText("\n" + jDBCAdapter.resultSet.getString("genre"));
                        }
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("colorinfo")) {
                this.myBar.setValue(64);
                this.myStatus.setText(String.valueOf(string2) + " (colorinfo)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_color_info") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_color_info"));
                jDBCAdapter.executePreparedQuery("SELECT color, addition FROM colorinfo WHERE movieid=? ORDER BY color ASC", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("color") + " " + jDBCAdapter.resultSet.getString("addition"));
                        while (jDBCAdapter.resultSet.next()) {
                            this.writeText("\n" + jDBCAdapter.resultSet.getString("color") + " " + jDBCAdapter.resultSet.getString("addition"));
                        }
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("technical")) {
                this.myBar.setValue(67);
                this.myStatus.setText(String.valueOf(string2) + " (technical)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_technical") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_technical"));
                jDBCAdapter.executePreparedQuery("SELECT name FROM technical WHERE movieid=? ORDER BY name ASC", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("name"));
                        while (jDBCAdapter.resultSet.next()) {
                            this.writeText("\n" + jDBCAdapter.resultSet.getString("name"));
                        }
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("language")) {
                this.myBar.setValue(70);
                this.myStatus.setText(String.valueOf(string2) + " (language)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_languages") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_languages"));
                jDBCAdapter.executePreparedQuery("SELECT language FROM language WHERE movieid=? ORDER BY language ASC", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("language"));
                        while (jDBCAdapter.resultSet.next()) {
                            this.writeText("\n" + jDBCAdapter.resultSet.getString("language"));
                        }
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("distributors")) {
                this.myBar.setValue(73);
                this.myStatus.setText(String.valueOf(string2) + " (distributors)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_distributors") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_distributors"));
                jDBCAdapter.executePreparedQuery("SELECT name FROM distributors WHERE movieid=? ORDER BY name ASC", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("name"));
                        while (jDBCAdapter.resultSet.next()) {
                            this.writeText("\n" + jDBCAdapter.resultSet.getString("name"));
                        }
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("quotes")) {
                this.myBar.setValue(76);
                this.myStatus.setText(String.valueOf(string2) + " (quotes)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_quotes") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_quotes"));
                jDBCAdapter.executePreparedQuery("SELECT quotetext FROM quotes WHERE movieid=?", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("quotetext"));
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("runningtimes")) {
                this.myBar.setValue(79);
                this.myStatus.setText(String.valueOf(string2) + " (runningtimes)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_running_times") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_running_times"));
                jDBCAdapter.executePreparedQuery("SELECT time, addition FROM runningtimes WHERE movieid=? ORDER BY time ASC", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("time") + " " + jDBCAdapter.resultSet.getString("addition"));
                        while (jDBCAdapter.resultSet.next()) {
                            this.writeText("\n" + jDBCAdapter.resultSet.getString("time") + " " + jDBCAdapter.resultSet.getString("addition"));
                        }
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("ratings")) {
                this.myBar.setValue(82);
                this.myStatus.setText(String.valueOf(string2) + " (ratings)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_rating") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_rating"));
                jDBCAdapter.executePreparedQuery("SELECT rank, votes, distribution FROM ratings WHERE movieid=?", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.rating_header"));
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("rank") + " - " + jDBCAdapter.resultSet.getInt("votes") + " - " + jDBCAdapter.resultSet.getString("distribution"));
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("business")) {
                this.myBar.setValue(85);
                this.myStatus.setText(String.valueOf(string2) + " (business)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_business") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_business"));
                jDBCAdapter.executePreparedQuery("SELECT businesstext FROM business WHERE movieid=?", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("businesstext"));
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("trivia")) {
                this.myBar.setValue(88);
                this.myStatus.setText(String.valueOf(string2) + " (trivia)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_trivia") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_trivia"));
                jDBCAdapter.executePreparedQuery("SELECT triviatext FROM trivia WHERE movieid=?", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("triviatext"));
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("taglines")) {
                this.myBar.setValue(90);
                this.myStatus.setText(String.valueOf(string2) + " (taglines)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_taglines") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_taglines"));
                jDBCAdapter.executePreparedQuery("SELECT taglinetext FROM taglines WHERE movieid=?", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("taglinetext"));
                        while (jDBCAdapter.resultSet.next()) {
                            this.writeText("\n" + jDBCAdapter.resultSet.getString("taglinetext"));
                        }
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("crazycredits")) {
                this.myBar.setValue(91);
                this.myStatus.setText(String.valueOf(string2) + " (crazy-credits)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_crazycredits") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_crazycredits"));
                jDBCAdapter.executePreparedQuery("SELECT credittext FROM crazycredits WHERE movieid=?", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("credittext"));
                        while (jDBCAdapter.resultSet.next()) {
                            this.writeText("\n" + jDBCAdapter.resultSet.getString("credittext"));
                        }
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("certificates")) {
                this.myBar.setValue(92);
                this.myStatus.setText(String.valueOf(string2) + " (certificates)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_certification") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_certification"));
                jDBCAdapter.executePreparedQuery("SELECT country, certification, " + this.getSQLWorker().getSQLMetaNotNullValue(this.getSQLWorker().getSQLMetaConcat("' - '", "addition"), "''") + " FROM certificates WHERE movieid=? order by country ASC", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString(1) + ": " + jDBCAdapter.resultSet.getString(2) + jDBCAdapter.resultSet.getString(3));
                        while (jDBCAdapter.resultSet.next()) {
                            this.writeText("\n" + jDBCAdapter.resultSet.getString(1) + ": " + jDBCAdapter.resultSet.getString(2) + jDBCAdapter.resultSet.getString(3));
                        }
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("mpaaratings")) {
                this.myBar.setValue(94);
                this.myStatus.setText(String.valueOf(string2) + " (mpaaratings)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_mpaa_ratings_reasons") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_mpaa_ratings_reasons"));
                jDBCAdapter.executePreparedQuery("SELECT reasontext FROM mpaaratings WHERE movieid=?", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("reasontext"));
                        while (jDBCAdapter.resultSet.next()) {
                            this.writeText("\n" + jDBCAdapter.resultSet.getString("reasontext"));
                        }
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("goofs")) {
                this.myBar.setValue(96);
                this.myStatus.setText(String.valueOf(string2) + " (goofs)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_goofs") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_goofs"));
                jDBCAdapter.executePreparedQuery("SELECT gooftext FROM goofs WHERE movieid=?", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("gooftext"));
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("movielinks")) {
                this.myBar.setValue(97);
                this.myStatus.setText(String.valueOf(string2) + " (movielinks)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_movielinks") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_movielinks"));
                jDBCAdapter.executePreparedQuery("SELECT movielinkstext FROM movielinks WHERE movieid=?", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString(1));
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("literature")) {
                this.myBar.setValue(98);
                this.myStatus.setText(String.valueOf(string2) + " (literature)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_literature") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_literature"));
                jDBCAdapter.executePreparedQuery("SELECT literaturetext FROM literature WHERE movieid=?", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("literaturetext"));
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
            if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("locations")) {
                this.myBar.setValue(99);
                this.myStatus.setText(String.valueOf(string2) + " (locations)...");
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_locations") + ":");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_locations"));
                jDBCAdapter.executePreparedQuery("SELECT location FROM locations WHERE movieid=? ORDER BY location ASC", stringArray, nArray);
                try {
                    if (jDBCAdapter.resultSet.next()) {
                        this.writeHyperlinkUrlForMappingService("\n" + jDBCAdapter.resultSet.getString("location"));
                        while (jDBCAdapter.resultSet.next()) {
                            this.writeHyperlinkUrlForMappingService("\n" + jDBCAdapter.resultSet.getString("location"));
                        }
                    } else {
                        this.writeText("\n" + string);
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("SQLException in DetailWindow.showMovieDetails(): " + sQLException);
                }
            }
        }
        this.writeText("\n\nInformation courtesy of The Internet Movie Database. Used with permission.\n");
        this.writeHyperlinkUrl("http://www.IMDb.com/");
        this.myBar.setValue(100);
        this.myBar.setVisible(false);
        this.myStatus.setText(this.myDetailWindow.getResMessagesBundle().getString("JMDB.label.status_finished"));
        jDBCAdapter.closedb();
    }

    public void dbQueryPerson() {
        Object object;
        boolean bl;
        boolean bl2;
        boolean bl3;
        JDBCAdapter jDBCAdapter = JMDBMain.myJMDBMain.getNewJDBCAdapter();
        String string = this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.no_info_available");
        String string2 = this.myDetailWindow.getResMessagesBundle().getString("JMDB.label.status_searching_for_data");
        this.myBar.setValue(0);
        this.myStatus.setText("Searching ID");
        if (this.myCategory.equalsIgnoreCase("actor")) {
            bl3 = DetailWindow2.cfgActorDetailWindowAKANames;
            bl2 = DetailWindow2.cfgActorDetailWindowMovies;
            bl = DetailWindow2.cfgActorDetailWindowBiography;
        } else if (this.myCategory.equalsIgnoreCase("director")) {
            bl3 = DetailWindow2.cfgDirectorDetailWindowAKANames;
            bl2 = DetailWindow2.cfgDirectorDetailWindowMovies;
            bl = DetailWindow2.cfgDirectorDetailWindowBiography;
        } else {
            bl3 = DetailWindow2.cfgProducerDetailWindowAKANames;
            bl2 = DetailWindow2.cfgProducerDetailWindowMovies;
            bl = DetailWindow2.cfgProducerDetailWindowBiography;
        }
        String string3 = this.myCategory.toLowerCase();
        int n = 0;
        this.writeHeading(String.valueOf(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.details_to_" + string3)) + " " + this.myItem);
        String[] stringArray = new String[1];
        int[] nArray = new int[1];
        String[] stringArray2 = new String[1];
        int[] nArray2 = new int[1];
        stringArray2[0] = this.myItem;
        try {
            jDBCAdapter.executePreparedQuery("SELECT " + string3 + "id FROM " + string3 + "s WHERE name=?", stringArray2, nArray2);
            if (jDBCAdapter.resultSet.next()) {
                n = Integer.parseInt(jDBCAdapter.resultSet.getString(String.valueOf(string3) + "id"));
            }
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException in DetailWindow2Thread.dbQueryPerson(): " + sQLException);
        }
        if (n == 0) {
            this.writeText("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.error_cannot_get_personid"));
        }
        stringArray = new String[1];
        nArray = new int[]{n};
        if (n != 0) {
            try {
                object = new String("http://www.IMDb.com/Name?" + EncodeURL.encode(this.myItem, "UTF-8"));
                this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_imdb_url") + ":\n");
                this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_imdb_url"));
                this.writeHyperlinkUrl((String)object);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("akanames") && bl3 && n != 0) {
            this.myBar.setValue(10);
            this.myStatus.setText(String.valueOf(string2) + " (akanames)...");
            this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_aka_names") + ":");
            this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_aka_names"));
            try {
                jDBCAdapter.executePreparedQuery("SELECT DISTINCT akaname, addition FROM akanames WHERE name=? ORDER BY AKANAME ASC", stringArray2, nArray2);
                if (jDBCAdapter.resultSet.next()) {
                    this.writeText("\n" + jDBCAdapter.resultSet.getString("akaname") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    while (jDBCAdapter.resultSet.next()) {
                        this.writeText("\n" + jDBCAdapter.resultSet.getString("akaname") + " - " + jDBCAdapter.resultSet.getString("addition"));
                    }
                } else {
                    this.writeText("\n" + string);
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in DetailWindow2Thread.dbQueryPerson(): " + sQLException);
            }
        }
        if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("movies2actors") && string3.equals("actor") && bl2 && n != 0) {
            this.myBar.setValue(40);
            this.myStatus.setText(String.valueOf(string2) + " (movies)...");
            this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_movies") + ":");
            this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_movies"));
            jDBCAdapter.executePreparedQuery("SELECT movies.title, movies2actors.as_character FROM movies INNER JOIN movies2actors ON movies.movieid=movies2actors.movieid WHERE movies2actors.actorid=?", stringArray, nArray);
            object = new ActorDetailWindowMovieArray(1000);
            try {
                if (jDBCAdapter.resultSet.next()) {
                    ((ActorDetailWindowMovieArray)object).add(jDBCAdapter.resultSet.getString("title"), jDBCAdapter.resultSet.getString("as_character"));
                    while (jDBCAdapter.resultSet.next()) {
                        ((ActorDetailWindowMovieArray)object).add(jDBCAdapter.resultSet.getString("title"), jDBCAdapter.resultSet.getString("as_character"));
                    }
                    new SortableArrayHeapSorter().sort((SortableArray)object, ((ActorDetailWindowMovieArray)object).getCount() - 1);
                    int n2 = 0;
                    while (n2 < ((ActorDetailWindowMovieArray)object).getCount()) {
                        this.writeHyperlinkMovie("\n" + ((ActorDetailWindowMovieArray)object).getText(n2));
                        ++n2;
                    }
                    this.writeText("\n\n" + ((ActorDetailWindowMovieArray)object).getCount() + " " + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.x_movies_found"));
                    object = null;
                } else {
                    this.writeText("\n" + string);
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in DetailWindow2Thread.dbQueryPerson(): " + sQLException);
            }
        }
        if ((JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("producers") || JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("directors")) && !string3.equals("actor") && bl2 && n != 0) {
            this.myBar.setValue(40);
            this.myStatus.setText(String.valueOf(string2) + " (movies)...");
            this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_movies") + ":");
            this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_movies"));
            jDBCAdapter.executePreparedQuery("SELECT movies.title,movies2" + string3 + "s.addition FROM movies INNER JOIN movies2" + string3 + "s ON movies.movieid=movies2" + string3 + "s.movieid WHERE movies2" + string3 + "s." + string3 + "id=?", stringArray, nArray);
            object = new ActorDetailWindowMovieArray(1000);
            try {
                if (jDBCAdapter.resultSet.next()) {
                    ((ActorDetailWindowMovieArray)object).add(jDBCAdapter.resultSet.getString("title"), jDBCAdapter.resultSet.getString("addition"));
                    while (jDBCAdapter.resultSet.next()) {
                        ((ActorDetailWindowMovieArray)object).add(jDBCAdapter.resultSet.getString("title"), jDBCAdapter.resultSet.getString("addition"));
                    }
                    new SortableArrayHeapSorter().sort((SortableArray)object, ((ActorDetailWindowMovieArray)object).getCount() - 1);
                    int n3 = 0;
                    while (n3 < ((ActorDetailWindowMovieArray)object).getCount()) {
                        this.writeHyperlinkMovie("\n" + ((ActorDetailWindowMovieArray)object).getText(n3));
                        ++n3;
                    }
                    this.writeText("\n\n" + ((ActorDetailWindowMovieArray)object).getCount() + " " + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.x_movies_found"));
                    object = null;
                } else {
                    this.writeText("\n" + string);
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in DetailWindow2Thread.dbQueryPerson(): " + sQLException);
            }
        }
        if (JMDBMain.myJMDBMain.getTableExistenceChecker().isTableExistent("biographies") && bl && n != 0) {
            this.myBar.setValue(70);
            this.myStatus.setText(String.valueOf(string2) + " (biographies)...");
            this.writeCategory("\n\n" + this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_biography") + ":");
            this.myDetailWindow.quickNavAdd(this.myDetailWindow.getResMessagesBundle().getString("JMDBDetail.label.heading_biography"));
            try {
                jDBCAdapter.executePreparedQuery("SELECT biotext FROM biographies WHERE name=?", stringArray2, nArray2);
                if (jDBCAdapter.resultSet.next()) {
                    this.writeText("\n" + jDBCAdapter.resultSet.getString("biotext"));
                } else {
                    this.writeText("\n" + string);
                }
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException in DetailWindow2Thread.dbQueryPerson(): " + sQLException);
            }
        }
        this.writeText("\n\nInformation courtesy of The Internet Movie Database. Used with permission.\n");
        this.writeHyperlinkUrl("http://www.IMDb.com/");
        this.myBar.setValue(100);
        this.myBar.setVisible(false);
        this.myStatus.setText(this.myDetailWindow.getResMessagesBundle().getString("JMDB.label.status_finished"));
        jDBCAdapter.closedb();
    }

    private SQLWorkerAbstract getSQLWorker() {
        return this.sqlWorker;
    }

    public void run() {
        this.myDetailWindow.setSize(DetailWindow2.cfgWindowSizeH, DetailWindow2.cfgWindowSizeV);
        this.myDetailWindow.setVisible(true);
        if (this.myCategory.equalsIgnoreCase("Movie")) {
            this.dbQueryMovie();
        } else {
            this.dbQueryPerson();
        }
        if (this.myDetailWindow.threadRunAllowed()) {
            this.myDetailWindow.quickNavSortAndSetMenu();
        }
        JMDBMain.myJMDBMain.playSound();
    }

    private void writeCategory(String string) {
        try {
            this.doc.insertString(this.doc.getLength(), string, this.myTextPane.getStyle("category"));
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException in DetailWindow2Thread.writeCategory(String)");
        }
    }

    private void writeHeading(String string) {
        try {
            this.doc.insertString(this.doc.getLength(), string, this.myTextPane.getStyle("heading"));
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException in DetailWindow2Thread.writeHeading(String)");
        }
    }

    private void writeHyperlinkActor(String string) {
        try {
            this.doc.insertString(this.doc.getLength(), string, this.myTextPane.getStyle("hyperlinkActor"));
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException in DetailWindow2Thread.writeHyperlinkActor(String)");
        }
    }

    private void writeHyperlinkDirector(String string) {
        try {
            this.doc.insertString(this.doc.getLength(), string, this.myTextPane.getStyle("hyperlinkDirector"));
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException in DetailWindow2Thread.writeHyperlinkDirector(String)");
        }
    }

    private void writeHyperlinkMovie(String string) {
        try {
            this.doc.insertString(this.doc.getLength(), string, this.myTextPane.getStyle("hyperlinkMovie"));
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException in DetailWindow2Thread.writeHyperlinkMovie(String)");
        }
    }

    private void writeHyperlinkProducer(String string) {
        try {
            this.doc.insertString(this.doc.getLength(), string, this.myTextPane.getStyle("hyperlinkProducer"));
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException in DetailWindow2Thread.writeHyperlinkProducer(String)");
        }
    }

    private void writeHyperlinkUrl(String string) {
        try {
            this.doc.insertString(this.doc.getLength(), string, this.myTextPane.getStyle("hyperlinkUrl"));
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException in DetailWindow2Thread.writeHyperlinkUrl(String)");
        }
    }

    private void writeHyperlinkUrlForMappingService(String string) {
        try {
            this.doc.insertString(this.doc.getLength(), string, this.myTextPane.getStyle("hyperlinkUrlForMappingService"));
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException in DetailWindow2Thread.writeHyperlinkUrlForMappingService(String)");
        }
    }

    private void writeText(String string) {
        try {
            if (string.indexOf("#http://") == -1) {
                this.doc.insertString(this.doc.getLength(), string, this.myTextPane.getStyle("text"));
            } else {
                String string2 = "#http://";
                String string3 = "/#";
                int n = 0;
                int[] nArray = new int[]{};
                int[] nArray2 = new int[]{};
                boolean bl = true;
                int n2 = string.indexOf(string2);
                while (n2 < string.length()) {
                    if (string.indexOf(string2, n2) == -1) break;
                    n2 = string.indexOf(string2, n2) + 1;
                    ++n;
                }
                nArray = new int[n];
                nArray2 = new int[n];
                n = 0;
                n2 = string.indexOf(string2);
                while (n2 < string.length()) {
                    if (string.indexOf(string2, n2) == -1) break;
                    nArray[n] = string.indexOf(string2, n2);
                    ++n;
                    n2 = string.indexOf(string2, n2) + 1;
                }
                n2 = 0;
                while (n2 < nArray.length) {
                    if (string.indexOf(string3, nArray[n2]) != -1) {
                        nArray2[n2] = string.indexOf(string3, nArray[n2]) + 1;
                    }
                    ++n2;
                }
                n2 = 0;
                while (n2 < nArray.length) {
                    if (n2 == nArray.length - 1) {
                        if (nArray[n2] >= nArray2[n2]) {
                            bl = false;
                            break;
                        }
                    } else if (nArray[n2] >= nArray2[n2] && nArray[n2 + 1] <= nArray2[n2]) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
                if (bl) {
                    n2 = 0;
                    while (n2 < nArray.length) {
                        if (n2 == 0) {
                            this.doc.insertString(this.doc.getLength(), string.substring(0, nArray[n2]), this.myTextPane.getStyle("text"));
                            this.writeHyperlinkUrl(string.substring(nArray[n2] + 1, nArray2[n2]));
                        } else if (n2 == nArray.length - 1) {
                            this.doc.insertString(this.doc.getLength(), string.substring(nArray2[n2 - 1] + 1, nArray[n2]), this.myTextPane.getStyle("text"));
                            this.writeHyperlinkUrl(string.substring(nArray[n2] + 1, nArray2[n2]));
                            this.doc.insertString(this.doc.getLength(), string.substring(nArray2[n2] + 1), this.myTextPane.getStyle("text"));
                        } else {
                            this.doc.insertString(this.doc.getLength(), string.substring(nArray2[n2 - 1] + 1, nArray[n2]), this.myTextPane.getStyle("text"));
                            this.writeHyperlinkUrl(string.substring(nArray[n2] + 1, nArray2[n2]));
                        }
                        ++n2;
                    }
                } else {
                    this.doc.insertString(this.doc.getLength(), string, this.myTextPane.getStyle("text"));
                }
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException in DetailWindow2Thread.writeHeading");
        }
    }
}

