/*
 * Decompiled with CFR 0.152.
 */
package com.javaexchange.dbConnectionBroker;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DbConnectionBroker
implements Runnable {
    private Thread runner;
    private Connection[] connPool;
    private int[] connStatus;
    private long[] connLockTime;
    private long[] connCreateDate;
    private String[] connID;
    private String dbDriver;
    private String dbServer;
    private String dbLogin;
    private String dbPassword;
    private String logFileString;
    private int currConnections;
    private int connLast;
    private int minConns;
    private int maxConns;
    private int maxConnMSec;
    private int maxCheckoutSeconds;
    private int debugLevel;
    private boolean available = true;
    private PrintWriter log;
    private SQLWarning currSQLWarning;
    private String pid;
    private final int DEFAULTMAXCHECKOUTSECONDS = 60;
    private final int DEFAULTDEBUGLEVEL = 2;

    public DbConnectionBroker(String string, String string2, String string3, String string4, int n, int n2, String string5, double d) throws IOException {
        this.setupBroker(string, string2, string3, string4, n, n2, string5, d, false, 60, 2);
    }

    public DbConnectionBroker(String string, String string2, String string3, String string4, int n, int n2, String string5, double d, boolean bl) throws IOException {
        this.setupBroker(string, string2, string3, string4, n, n2, string5, d, bl, 60, 2);
    }

    public DbConnectionBroker(String string, String string2, String string3, String string4, int n, int n2, String string5, double d, boolean bl, int n3, int n4) throws IOException {
        this.setupBroker(string, string2, string3, string4, n, n2, string5, d, bl, n3, n4);
    }

    private void setupBroker(String string, String string2, String string3, String string4, int n, int n2, String string5, double d, boolean bl, int n3, int n4) throws IOException {
        this.connPool = new Connection[n2];
        this.connStatus = new int[n2];
        this.connLockTime = new long[n2];
        this.connCreateDate = new long[n2];
        this.connID = new String[n2];
        this.currConnections = n;
        this.maxConns = n2;
        this.dbDriver = string;
        this.dbServer = string2;
        this.dbLogin = string3;
        this.dbPassword = string4;
        this.logFileString = string5;
        this.maxCheckoutSeconds = n3;
        this.debugLevel = n4;
        this.maxConnMSec = (int)(d * 8.64E7);
        if (this.maxConnMSec < 30000) {
            this.maxConnMSec = 30000;
        }
        try {
            this.log = new PrintWriter(new FileOutputStream(string5, bl), true);
        }
        catch (IOException iOException) {
            try {
                this.log = new PrintWriter(new FileOutputStream("DCB_" + System.currentTimeMillis() + ".log", bl), true);
            }
            catch (IOException iOException2) {
                throw new IOException("Can't open any log file");
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd G 'at' hh:mm:ss a zzz");
        Date date = new Date();
        this.pid = simpleDateFormat.format(date);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string5 + "pid"));
        bufferedWriter.write(this.pid);
        bufferedWriter.close();
        this.log.println("-----------------------------------------");
        this.log.println("-----------------------------------------");
        this.log.println("Starting DbConnectionBroker Version 1.0.13:");
        this.log.println("dbDriver = " + string);
        this.log.println("dbServer = " + string2);
        this.log.println("dbLogin = " + string3);
        this.log.println("log file = " + string5);
        this.log.println("minconnections = " + n);
        this.log.println("maxconnections = " + n2);
        this.log.println("Total refresh interval = " + d + " days");
        this.log.println("logAppend = " + bl);
        this.log.println("maxCheckoutSeconds = " + n3);
        this.log.println("debugLevel = " + n4);
        this.log.println("-----------------------------------------");
        boolean bl2 = false;
        int n5 = 20;
        try {
            int n6 = 1;
            while (n6 < n5) {
                try {
                    int n7 = 0;
                    while (n7 < this.currConnections) {
                        this.createConn(n7);
                        ++n7;
                    }
                    bl2 = true;
                    break;
                }
                catch (SQLException sQLException) {
                    if (n4 > 0) {
                        this.log.println("--->Attempt (" + String.valueOf(n6) + " of " + String.valueOf(n5) + ") failed to create new connections set at startup: ");
                        this.log.println("    " + sQLException);
                        this.log.println("    Will try again in 15 seconds...");
                    }
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++n6;
                }
            }
            if (!bl2) {
                if (n4 > 0) {
                    this.log.println("\r\nAll attempts at connecting to Database exhausted");
                }
                throw new IOException();
            }
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.runner = new Thread(this);
        this.runner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        var1_1 = true;
        var2_2 = null;
        var3_3 = null;
        var4_4 = this.maxCheckoutSeconds * 1000;
        while (true) {
            block44: {
                if (!var1_1) {
                    return;
                }
                try {
                    var6_7 = new BufferedReader(new FileReader(this.logFileString + "pid"));
                    var7_10 = var6_7.readLine();
                    if (var7_10.equals(this.pid)) {
                        var6_7.close();
                        break block44;
                    }
                    this.log.close();
                    var8_13 = 0;
                    while (true) {
                        if (var8_13 >= this.currConnections) {
                            return;
                        }
                        try {
                            this.connPool[var8_13].close();
                        }
                        catch (SQLException var9_21) {
                            // empty catch block
                        }
                        ++var8_13;
                    }
                }
                catch (IOException var6_8) {
                    this.log.println("Can't read the file for pid info: " + this.logFileString + "pid");
                }
            }
            var6_6 = 0;
            while (true) {
                block45: {
                    if (var6_6 >= this.currConnections) break;
                    try {
                        this.currSQLWarning = this.connPool[var6_6].getWarnings();
                        if (this.currSQLWarning != null) {
                            if (this.debugLevel > 1) {
                                this.log.println("Warnings on connection " + String.valueOf(var6_6) + " " + this.currSQLWarning);
                            }
                            this.connPool[var6_6].clearWarnings();
                        }
                    }
                    catch (SQLException var7_11) {
                        if (this.debugLevel <= 1) break block45;
                        this.log.println("Cannot access Warnings: " + var7_11);
                    }
                }
                ++var6_6;
            }
            var7_9 = 0;
            while (true) {
                block49: {
                    block47: {
                        block46: {
                            if (var7_9 >= this.currConnections) {
                                ** try [egrp 10[TRYBLOCK] [14 : 786->795)] { 
lbl49:
                                // 1 sources

                                break;
                            }
                            var8_12 = System.currentTimeMillis() - this.connCreateDate[var7_9];
                            try {
                                try {
                                    var10_15 = this.connStatus;
                                    synchronized (var10_15) {
                                        if (this.connStatus[var7_9] > 0) {
                                            var11_17 = System.currentTimeMillis() - this.connLockTime[var7_9];
                                            if (this.debugLevel > 2) {
                                                this.log.println("Warning.  Connection " + var7_9 + " in use for " + var11_17 + " ms");
                                            }
                                            if (var4_4 != 0L && var11_17 > var4_4) {
                                                if (this.debugLevel <= 1) throw new SQLException();
                                                this.log.println("Warning. Connection " + var7_9 + " failed to be returned in time.  Recycling...");
                                                throw new SQLException();
                                            }
                                            // MONITOREXIT @DISABLED, blocks:[3, 4, 24, 42, 11, 27] lbl62 : MonitorExitStatement: MONITOREXIT : var10_15
                                            var15_20 = null;
                                            break block46;
                                        }
                                        this.connStatus[var7_9] = 2;
                                        ** if (var8_12 <= (long)this.maxConnMSec) goto lbl70
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        throw new SQLException();
                                    }
lbl70:
                                    // 1 sources

                                    var2_2 = this.connPool[var7_9].createStatement();
                                    this.connStatus[var7_9] = 0;
                                    if (this.connPool[var7_9].isClosed()) {
                                        throw new SQLException();
                                    }
                                    break block47;
                                }
                                catch (SQLException var10_16) {
                                    block48: {
                                        if (this.debugLevel > 1) {
                                            this.log.println(new Date().toString() + " ***** Recycling connection " + String.valueOf(var7_9) + ":");
                                        }
                                        try {
                                            this.connPool[var7_9].close();
                                        }
                                        catch (SQLException var11_18) {
                                            if (this.debugLevel <= 0) break block48;
                                            this.log.println("Error!  Can't close connection!  Might have been closed already.  Trying to recycle anyway... (" + var11_18 + ")");
                                        }
                                    }
                                    try {
                                        this.createConn(var7_9);
                                    }
                                    catch (SQLException var11_19) {
                                        if (this.debugLevel > 0) {
                                            this.log.println("Failed to create connection: " + var11_19);
                                        }
                                        this.connStatus[var7_9] = 0;
                                    }
                                    var15_20 = null;
                                    try {
                                        if (var2_2 != null) {
                                            var2_2.close();
                                        }
                                        break block49;
                                    }
                                    catch (SQLException var16_5) {}
                                    break block49;
                                }
                            }
                            catch (Throwable var14_22) {
                                var15_20 = null;
                                ** try [egrp 9[TRYBLOCK] [13 : 757->770)] { 
lbl105:
                                // 1 sources

                                if (var2_2 == null) throw var14_22;
                                var2_2.close();
                                throw var14_22;
lbl108:
                                // 1 sources

                                catch (SQLException var16_5) {
                                    // empty catch block
                                }
                                throw var14_22;
                            }
                        }
                        try {}
                        catch (SQLException var16_5) {}
                        if (var2_2 != null) {
                            var2_2.close();
                        }
                        break block49;
                    }
                    var15_20 = null;
                    try {}
                    catch (SQLException var16_5) {}
                    if (var2_2 != null) {
                        var2_2.close();
                    }
                }
                ++var7_9;
            }
            {
                Thread.sleep(20000L);
                continue;
            }
lbl132:
            // 1 sources

            catch (InterruptedException var8_14) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() {
        Connection connection = null;
        if (this.available) {
            boolean bl = false;
            int n = 1;
            while (n <= 10) {
                try {
                    int n2 = 0;
                    int n3 = this.connLast + 1;
                    if (n3 >= this.currConnections) {
                        n3 = 0;
                    }
                    do {
                        int[] nArray = this.connStatus;
                        synchronized (nArray) {
                            if (this.connStatus[n3] < 1 && !this.connPool[n3].isClosed()) {
                                connection = this.connPool[n3];
                                this.connStatus[n3] = 1;
                                this.connLockTime[n3] = System.currentTimeMillis();
                                this.connLast = n3;
                                bl = true;
                                break;
                            }
                            ++n2;
                            if (++n3 >= this.currConnections) {
                                n3 = 0;
                            }
                        }
                    } while (!bl && n2 < this.currConnections);
                }
                catch (SQLException sQLException) {
                    this.log.println("Error: " + sQLException);
                }
                if (bl) break;
                DbConnectionBroker dbConnectionBroker = this;
                synchronized (dbConnectionBroker) {
                    block25: {
                        if (this.currConnections < this.maxConns) {
                            try {
                                this.createConn(this.currConnections);
                                ++this.currConnections;
                            }
                            catch (SQLException sQLException) {
                                if (this.debugLevel <= 0) break block25;
                                this.log.println("Error: Unable to create new connection: " + sQLException);
                            }
                        }
                    }
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.debugLevel > 0) {
                    this.log.println("-----> Connections Exhausted!  Will wait and try again in loop " + String.valueOf(n));
                }
                ++n;
            }
        } else if (this.debugLevel > 0) {
            this.log.println("Unsuccessful getConnection() request during destroy()");
        }
        if (this.debugLevel > 2) {
            this.log.println("Handing out connection " + this.idOfConnection(connection) + " --> " + new SimpleDateFormat("MM/dd/yyyy  hh:mm:ss a").format(new Date()));
        }
        return connection;
    }

    public int idOfConnection(Connection connection) {
        String string;
        try {
            string = connection.toString();
        }
        catch (NullPointerException nullPointerException) {
            string = "none";
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.currConnections) {
            if (this.connID[n2].equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public String freeConnection(Connection connection) {
        String string = "";
        int n = this.idOfConnection(connection);
        if (n >= 0) {
            this.connStatus[n] = 0;
            string = "freed " + connection.toString();
        } else if (this.debugLevel > 0) {
            this.log.println("----> Error: Could not free connection!!!");
        }
        return string;
    }

    public long getAge(Connection connection) {
        int n = this.idOfConnection(connection);
        return System.currentTimeMillis() - this.connLockTime[n];
    }

    private void createConn(int n) throws SQLException {
        Date date;
        block2: {
            date = new Date();
            try {
                Class.forName(this.dbDriver);
                this.connPool[n] = DriverManager.getConnection(this.dbServer, this.dbLogin, this.dbPassword);
                this.connStatus[n] = 0;
                this.connID[n] = this.connPool[n].toString();
                this.connLockTime[n] = 0L;
                this.connCreateDate[n] = date.getTime();
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.debugLevel <= 0) break block2;
                this.log.println("Error creating connection: " + classNotFoundException);
            }
        }
        this.log.println(date.toString() + "  Opening connection " + String.valueOf(n) + " " + this.connPool[n].toString() + ":");
    }

    public void destroy(int n) throws SQLException {
        int n2;
        this.available = false;
        this.runner.interrupt();
        try {
            this.runner.join(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long l = System.currentTimeMillis();
        while ((n2 = this.getUseCount()) > 0 && System.currentTimeMillis() - l <= (long)n) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        int n3 = 0;
        while (n3 < this.currConnections) {
            block9: {
                try {
                    this.connPool[n3].close();
                }
                catch (SQLException sQLException) {
                    if (this.debugLevel <= 0) break block9;
                    this.log.println("Cannot close connections on Destroy");
                }
            }
            ++n3;
        }
        if (n2 > 0) {
            String string = "Unsafe shutdown: Had to close " + n2 + " active DB connections after " + n + "ms";
            this.log.println(string);
            this.log.close();
            throw new SQLException(string);
        }
        this.log.close();
    }

    public void destroy() {
        try {
            this.destroy(10000);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUseCount() {
        int n = 0;
        int[] nArray = this.connStatus;
        synchronized (nArray) {
            int n2 = 0;
            while (n2 < this.currConnections) {
                if (this.connStatus[n2] > 0) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    public int getSize() {
        return this.currConnections;
    }
}

