/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlme.decoder;

import javazoom.jlme.decoder.BitReserve;
import javazoom.jlme.decoder.BitStream;
import javazoom.jlme.decoder.Header;
import javazoom.jlme.decoder.LayerIIIDecoder;
import javazoom.jlme.decoder.SampleBuffer;
import javazoom.jlme.decoder.SynthesisFilter;

public class Decoder {
    private SampleBuffer output;
    private SynthesisFilter filter1;
    private SynthesisFilter filter2;
    private LayerIIIDecoder decoder;
    private int outputFrequency;
    private int outputChannels;
    private boolean initialized;

    public Decoder(Header header, BitStream bitStream) {
        BitReserve.totbit = 0;
        BitReserve.buf_bit_idx = 0;
        BitReserve.buf_byte_idx = 0;
        BitReserve.offset = 0;
        if (header.layer() == 3) {
            float f = 32700.0f;
            int n = header.mode();
            int n2 = header.layer();
            int n3 = n == 3 ? 1 : 2;
            this.output = new SampleBuffer(header.frequency(), n3);
            this.filter1 = new SynthesisFilter(0, f);
            if (n3 == 2) {
                this.filter2 = new SynthesisFilter(1, f);
            }
            this.outputChannels = n3;
            this.outputFrequency = header.frequency();
            this.decoder = new LayerIIIDecoder(bitStream, header, this.filter1, this.filter2, this.output, 0);
        } else {
            System.out.println("only supports mp3 files");
            System.exit(1);
        }
    }

    public final void setOutputBuffer(SampleBuffer sampleBuffer) {
        this.output = sampleBuffer;
    }

    public final int getOutputFrequency() {
        return this.outputFrequency;
    }

    public final int getOutputChannels() {
        return this.outputChannels;
    }

    public final int getOutputBlockSize() {
        return 4608;
    }

    public final SampleBuffer decodeFrame() {
        this.output.clear();
        this.decoder.decodeFrame();
        return this.output;
    }
}

