/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class TimeQueueManager
implements TimerHandler.WakeupProcess {
    private TimeQueue m_tq = new TimeQueue();

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public boolean check() {
        Object object;
        while ((object = this.m_tq.getAnyLessThan(this.getCurrentTime() + 900L)) != null) {
            TQCarrier tQCarrier = (TQCarrier)object;
            MQFactory.getConcrete(tQCarrier.getDestinationQueue()).enqueue(tQCarrier.getPayload());
            if (tQCarrier.getRepeatRate() == 0L) continue;
            if (tQCarrier.getRepeatCount() > 0L) {
                tQCarrier.decrementCount();
            }
            if (tQCarrier.getRepeatCount() == 0L) continue;
            this.m_tq.addEvent(this.getCurrentTime() + tQCarrier.getRepeatRate(), tQCarrier);
        }
        return false;
    }

    public void add(Object object, String string, long l) {
        this.m_tq.addEvent(l, new TQCarrier(object, string));
    }

    public void add(Object object, String string, long l, long l2) {
        this.m_tq.addEvent(l, new TQCarrier(object, string, l2));
    }

    public void add(Object object, String string, long l, long l2, int n) {
        this.m_tq.addEvent(l, new TQCarrier(object, string, l2, n));
    }

    public boolean erase(Object object) {
        TimeQueue.QObject qObject;
        ArrayList<TimeQueue.QObject> arrayList = new ArrayList<TimeQueue.QObject>();
        List list = this.m_tq.getUnsorted();
        boolean bl = false;
        Iterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            qObject = (TimeQueue.QObject)iterator.next();
            TQCarrier tQCarrier = (TQCarrier)qObject.getEvent();
            if (tQCarrier.getPayload() != object) continue;
            arrayList.add(qObject);
            bl = true;
        }
        if (bl) {
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                qObject = (TimeQueue.QObject)iterator.next();
                this.m_tq.erase(qObject);
            }
        }
        return bl;
    }

    public void dumpQueue() {
        List list = this.m_tq.getSorted();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            TimeQueue.QObject qObject = (TimeQueue.QObject)listIterator.next();
            TQCarrier tQCarrier = (TQCarrier)qObject.getEvent();
            System.err.println("Queue: " + tQCarrier.getDestinationQueue());
            System.err.println("Object: [" + tQCarrier.getPayload() + "]");
            System.err.println("When: " + new Date(qObject.getTime()));
            System.err.println();
        }
    }

    private class TQCarrier {
        private Object payload;
        private String destination_queue;
        private long repeatRate;
        private int repeatCount;

        public Object getPayload() {
            return this.payload;
        }

        public String getDestinationQueue() {
            return this.destination_queue;
        }

        public long getRepeatRate() {
            return this.repeatRate;
        }

        public long getRepeatCount() {
            return this.repeatCount;
        }

        public void decrementCount() {
            --this.repeatCount;
        }

        public TQCarrier(Object object, String string) {
            this.destination_queue = string;
            this.payload = object;
            this.repeatRate = 0L;
            this.repeatCount = 1;
        }

        public TQCarrier(Object object, String string, long l) {
            this.destination_queue = string;
            this.payload = object;
            this.repeatRate = l;
            this.repeatCount = -1;
        }

        public TQCarrier(Object object, String string, long l, int n) {
            this.destination_queue = string;
            this.payload = object;
            this.repeatRate = l;
            this.repeatCount = n;
        }
    }
}

