/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;

public class SnipeDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField quantityField;
    private JTextField snipeAmount;
    private JCheckBox subtractShipping;
    private JLabel auctionInfo;
    private boolean cancelled = false;
    private JLabel quantityLabel;

    public SnipeDialog() {
        super((Frame)null, "Sniping", true, JMouseAdapter.getCurrentGraphicsConfiguration());
        this.setupUI();
        this.setContentPane(this.contentPane);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.setLocationRelativeTo(null);
        this.buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnipeDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnipeDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SnipeDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnipeDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void onOK() {
        this.cancelled = false;
        this.dispose();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getQuantity() {
        if (this.quantityField.isEnabled()) {
            return this.quantityField.getText();
        }
        return "1";
    }

    public String getAmount() {
        return this.snipeAmount.getText().replace(',', '.');
    }

    public boolean subtractShipping() {
        return this.subtractShipping.isSelected();
    }

    private void onCancel() {
        this.cancelled = true;
        this.setVisible(false);
    }

    public void useQuantity(boolean bl) {
        this.quantityLabel.setEnabled(bl);
        this.quantityField.setEnabled(bl);
    }

    public void setPrompt(String string) {
        this.auctionInfo.setText(string);
        this.auctionInfo.setVisible(true);
        this.auctionInfo.invalidate();
        this.contentPane.validate();
        this.validate();
    }

    public void clear() {
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.quantityField.setText("1");
        this.snipeAmount.setText("");
    }

    private void setupUI() {
        this.contentPane = new JPanel(new SpringLayout());
        this.auctionInfo = new JLabel();
        this.auctionInfo.setText("Auction Information");
        this.contentPane.add(this.auctionInfo);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.snipeAmount = new JTextField(10);
        this.snipeAmount.setText("");
        this.quantityField = new JTextField(10);
        this.quantityField.setEnabled(false);
        this.quantityField.setText("1");
        this.subtractShipping = new JCheckBox();
        this.subtractShipping.setText("Auto-subtract shipping and insurance (p/p)");
        JPanel jPanel2 = new JPanel(new SpringLayout());
        JLabel jLabel = new JLabel("How much do you wish to snipe?", 11);
        jPanel2.add(jLabel);
        jLabel.setLabelFor(this.snipeAmount);
        jPanel2.add(this.snipeAmount);
        this.quantityLabel = new JLabel("Quantity?", 11);
        jPanel2.add(this.quantityLabel);
        this.quantityLabel.setLabelFor(this.quantityField);
        jPanel2.add(this.quantityField);
        SpringUtilities.makeCompactGrid(jPanel2, 2, 2, 6, 6, 6, 3);
        this.contentPane.add(jPanel2);
        this.contentPane.add(this.subtractShipping);
        this.buttonOK = new JButton();
        this.buttonOK.setText("OK");
        this.buttonCancel = new JButton();
        this.buttonCancel.setText("Cancel");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)JConfigTab.makeLine(this.buttonOK, this.buttonCancel), "East");
        this.contentPane.add(jPanel3);
        SpringUtilities.makeCompactGrid(this.contentPane, 4, 1, 6, 6, 6, 6);
    }
}

