/*
 * Decompiled with CFR 0.152.
 */
public abstract class Searcher
extends XMLSerializeSimple {
    protected long _id;
    protected String _name = "";
    protected String _search = "";
    protected String _server = "";
    protected String _category;
    protected String _currency;
    protected int _period;
    protected long _last;
    protected boolean _enabled;
    protected boolean _skip_deleted;
    protected boolean _initialized;
    protected String[] infoTags = new String[]{"name", "search", "period", "server", "last", "enabled", "category", "currency", "finddeleted"};

    public Searcher() {
        this._id = 0L;
        this._last = 0L;
        this._initialized = false;
        this._skip_deleted = true;
    }

    public Searcher(String string, String string2, String string3, int n) {
        this._id = System.currentTimeMillis();
        this._name = string;
        this._search = string2;
        this._period = n;
        this._server = string3;
        this._enabled = n != -1;
        this._initialized = true;
        this._skip_deleted = true;
        this._last = 0L;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public boolean shouldSkipDeleted() {
        return this._skip_deleted;
    }

    public void setSkipDeleted(boolean bl) {
        this._skip_deleted = bl;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
        this._initialized = true;
    }

    public String getSearch() {
        return this._search;
    }

    public void setSearch(String string) {
        this._search = string;
        this._initialized = true;
    }

    public String getCategory() {
        return this._category == null ? this.getName() : this._category;
    }

    public void setCategory(String string) {
        this._category = string;
    }

    public String getServer() {
        return this._server;
    }

    public void setServer(String string) {
        this._server = string;
        this._initialized = true;
    }

    public String getCurrency() {
        return this._currency;
    }

    public void setCurrency(String string) {
        this._currency = string;
        this._initialized = true;
    }

    public int getPeriod() {
        return this._period;
    }

    public void setPeriod(int n) {
        this._period = n;
        this._initialized = true;
    }

    public void setId(long l) {
        this._id = l;
        this._initialized = true;
    }

    public long getId() {
        return this._id;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void enable() {
        this._enabled = true;
    }

    public void disable() {
        this._enabled = false;
    }

    public long getLastRun() {
        return this._last;
    }

    protected void setLastRun() {
        this._last = System.currentTimeMillis();
    }

    protected void setLastRun(long l) {
        this._last = l;
    }

    public boolean shouldExecute() {
        long l;
        return this._enabled && this._period != -1 && this._last + (long)(this._period * 3600000) <= (l = System.currentTimeMillis());
    }

    public abstract String getTypeName();

    public void execute() {
        this.setLastRun();
        this.fire();
    }

    protected abstract void fire();

    public XMLElement toXML() {
        XMLElement xMLElement;
        XMLElement xMLElement2 = new XMLElement("search");
        xMLElement2.setProperty("type", this.getTypeName());
        xMLElement2.setProperty("id", Long.toString(this.getId()));
        XMLElement xMLElement3 = new XMLElement("name");
        xMLElement3.setContents(this.getName());
        xMLElement2.addChild(xMLElement3);
        XMLElement xMLElement4 = new XMLElement("search");
        xMLElement4.setContents(this.getSearch());
        xMLElement2.addChild(xMLElement4);
        XMLElement xMLElement5 = new XMLElement("period");
        xMLElement5.setContents(Integer.toString(this.getPeriod()));
        xMLElement2.addChild(xMLElement5);
        XMLElement xMLElement6 = new XMLElement("server");
        xMLElement6.setContents(this.getServer());
        xMLElement2.addChild(xMLElement6);
        XMLElement xMLElement7 = new XMLElement("currency");
        xMLElement7.setContents(this.getCurrency());
        xMLElement2.addChild(xMLElement7);
        XMLElement xMLElement8 = new XMLElement("last");
        xMLElement8.setContents(Long.toString(this.getLastRun()));
        xMLElement2.addChild(xMLElement8);
        if (this._enabled) {
            xMLElement = new XMLElement("enabled");
            xMLElement.setEmpty();
            xMLElement2.addChild(xMLElement);
        }
        if (!this._skip_deleted) {
            xMLElement = new XMLElement("finddeleted");
            xMLElement.setEmpty();
            xMLElement2.addChild(xMLElement);
        }
        xMLElement = new XMLElement("category");
        if (this._category == null) {
            xMLElement.setContents(this.getName());
        } else {
            xMLElement.setContents(this._category);
        }
        xMLElement2.addChild(xMLElement);
        this._initialized = true;
        return xMLElement2;
    }

    protected String[] getTags() {
        return this.infoTags;
    }

    protected void handleTag(int n, XMLElement xMLElement) {
        String string = xMLElement.getContents();
        switch (n) {
            case 0: {
                this.setName(string);
                break;
            }
            case 1: {
                this.setSearch(string);
                break;
            }
            case 2: {
                this.setPeriod(Integer.parseInt(string));
                break;
            }
            case 3: {
                this.setServer(string);
                break;
            }
            case 4: {
                this.setLastRun(Long.parseLong(string));
                break;
            }
            case 5: {
                this.enable();
                break;
            }
            case 6: {
                this.setCategory(string);
                break;
            }
            case 7: {
                this.setCurrency(string);
                break;
            }
            case 8: {
                this.setSkipDeleted(false);
                break;
            }
        }
    }
}

