/*
 * Decompiled with CFR 0.152.
 */
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ListIterator;

public class SearchTableModel
extends BaseTransformation {
    String[] column_names = new String[]{"Name", "Type", "Search Value", "Site", "Repeat Time", "Next Run"};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;

    public int getRowCount() {
        return SearchManager.getInstance().getSearchCount();
    }

    public int getColumnCount() {
        return this.column_names.length;
    }

    public String getColumnName(int n) {
        return this.column_names[n];
    }

    public int getColumnNumber(String string) {
        for (int i = 0; i < this.column_names.length; ++i) {
            if (!string.equals(this.column_names[i])) continue;
            return i;
        }
        return -1;
    }

    public Class getColumnClass(int n) {
        return class$java$lang$String == null ? (class$java$lang$String = SearchTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public Class getSortByColumnClass(int n) {
        if (n == 5) {
            return class$java$lang$Long == null ? (class$java$lang$Long = SearchTableModel.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (n == 4) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = SearchTableModel.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        return this.getColumnClass(n);
    }

    public Object getSortByValueAt(int n, int n2) {
        Searcher searcher = SearchManager.getInstance().getSearchByIndex(n);
        switch (n2) {
            case -1: {
                return searcher;
            }
            case 0: {
                return searcher.getName();
            }
            case 1: {
                return searcher.getTypeName();
            }
            case 2: {
                return searcher.getSearch();
            }
            case 3: {
                return searcher.getServer();
            }
            case 4: {
                return new Integer(searcher.getPeriod());
            }
            case 5: {
                return new Long(searcher.getLastRun() + (long)(searcher.getPeriod() * 3600000));
            }
        }
        return null;
    }

    public Object getValueAt(int n, int n2) {
        Searcher searcher = SearchManager.getInstance().getSearchByIndex(n);
        switch (n2) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.getSortByValueAt(n, n2);
            }
            case 4: {
                int n3 = searcher.getPeriod();
                if (n3 == -1) {
                    return "None";
                }
                if (n3 < 24) {
                    return n3 + " hour" + (n3 != 1 ? "s" : "");
                }
                if (n3 % 24 == 0) {
                    return n3 / 24 + " day" + (n3 != 24 ? "s" : "");
                }
                String string = n3 / 24 + " day" + (n3 > 48 ? "s" : "");
                string = string + ", " + n3 % 24 + " hour" + (n3 % 24 != 1 ? "s" : "");
                return string;
            }
            case 5: {
                return this.dateFormat(searcher);
            }
        }
        return null;
    }

    public String dateFormat(Searcher searcher) {
        if (searcher.getPeriod() == -1) {
            return "Never";
        }
        if (!searcher.isEnabled()) {
            return "Disabled";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd/yyyy @ hh:mm");
        long l = searcher.getLastRun();
        if (l == 0L) {
            l = System.currentTimeMillis();
        }
        return simpleDateFormat.format(new Date(l += (long)(searcher.getPeriod() * 3600000)));
    }

    public int compare(int n, int n2, ColumnStateList columnStateList) {
        int n3 = 0;
        ListIterator listIterator = columnStateList.listIterator();
        while (listIterator.hasNext()) {
            Object object;
            ColumnState columnState = (ColumnState)listIterator.next();
            Class clazz = this.getSortByColumnClass(columnState.getColumn());
            Object object2 = this.getSortByValueAt(n, columnState.getColumn());
            n3 = SearchTableModel.compareByClass(object2, object = this.getSortByValueAt(n2, columnState.getColumn()), clazz) * columnState.getSort();
            if (n3 == 0) continue;
            break;
        }
        return n3;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void delete(int n) {
        SearchManager.getInstance().deleteSearch(SearchManager.getInstance().getSearchByIndex(n));
    }

    public int insert(Object object) {
        SearchManager.getInstance().addSearch((Searcher)object);
        return this.getRowCount() - 1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

