/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;

public class RSSDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private boolean cancelled = false;
    private JComboBox tabList = new JComboBox();

    public RSSDialog() {
        this.setupUI();
        this.setTitle("RSS Feed Information");
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.setLocationRelativeTo(null);
        this.buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RSSDialog.this.onOK();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RSSDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RSSDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void onOK() {
        this.cancelled = false;
        this.dispose();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private void onCancel() {
        this.cancelled = true;
        this.setVisible(false);
    }

    public void prepare() {
        this.buildTabList();
    }

    private String getHost() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            ErrorManagement.handleException("Local host is unknown?!?", unknownHostException);
            return "127.0.0.1";
        }
        return inetAddress.getHostAddress();
    }

    public void fireFeed(String string) {
        String string2 = "feed://" + this.getHost() + ":" + JConfig.queryConfiguration("server.port", "9099") + "/syndicate/" + string + ".xml";
        try {
            BrowserLauncher.openURL(string2);
        }
        catch (IOException iOException) {
            ErrorManagement.handleException("Can't browse to: " + string2, iOException);
        }
        this.onOK();
    }

    public void fireCopy(String string) {
        String string2 = "http://" + this.getHost() + ":" + JConfig.queryConfiguration("server.port", "9099") + "/syndicate/" + string + ".xml";
        JBidMouse.setClipboardString(string2);
        this.onOK();
    }

    private JPanel buildLinePanel(String string, String string2) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JButton jButton = new JButton("Copy");
        jButton.setActionCommand("Copy-" + string2);
        jPanel.add((Component)jButton, "West");
        jPanel.add((Component)new JLabel(" " + string), "Center");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().startsWith("BT-Feed-")) {
                    RSSDialog.this.fireFeed(actionEvent.getActionCommand().substring(8));
                } else if (actionEvent.getActionCommand().startsWith("Copy-")) {
                    RSSDialog.this.fireCopy(actionEvent.getActionCommand().substring(5));
                }
            }
        };
        jButton.addActionListener(actionListener);
        JButton jButton2 = JBidWatch.makeButton("icons/feed.gif", "Launch feed:// URL", "Feed-" + string2, actionListener, true);
        jPanel.add((Component)JConfigTab.makeLine(jButton2, new JLabel(" ")), "East");
        return jPanel;
    }

    private void setupUI() {
        this.contentPane = new JPanel(new SpringLayout());
        this.buttonOK = new JButton();
        this.buttonOK.setText("Close");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.buttonOK, "Center");
        JPanel jPanel2 = this.buildLinePanel("Subscribe to the recently ended items list.", "ended");
        JPanel jPanel3 = this.buildLinePanel("Subscribe to items you're bidding or sniping on.", "bid");
        JPanel jPanel4 = this.buildLinePanel("Subscribe to items closest to ending.", "ending");
        this.contentPane.add(jPanel2);
        this.contentPane.add(jPanel3);
        this.contentPane.add(jPanel4);
        this.contentPane.add(this.buttonOK);
        SpringUtilities.makeCompactGrid(this.contentPane, 4, 1, 6, 6, 6, 6);
    }

    private void buildTabList() {
        this.tabList.removeAllItems();
        this.tabList.setEditable(true);
        List list = FilterManager.getInstance().allCategories();
        if (list != null) {
            list.remove("complete");
            list.remove("selling");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.tabList.addItem(string);
            }
        }
    }
}

