/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JTabProperties
extends JConfigTab
implements ActionListener {
    private String _tab;
    private JFrame _frame = null;
    private JComboBox cbWonTarget = null;
    private JComboBox cbLostTarget = null;
    private JComboBox cbOtherTarget = null;
    private String WON_TARGET;
    private String LOST_TARGET;
    private String OTHER_TARGET;
    private Map columns2Boxes = null;

    public JTabProperties(String string) {
        super.setLayout(new BorderLayout());
        this._tab = string;
        this.WON_TARGET = this._tab + ".won_target";
        this.LOST_TARGET = this._tab + ".lost_target";
        this.OTHER_TARGET = this._tab + ".other_target";
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)JTabProperties.panelPack(this.buildDropdownPanel()), "North");
        jPanel.add((Component)JTabProperties.panelPack(this.buildColumnPanel()), "Center");
        super.add((Component)jPanel, "North");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.apply();
            this._frame.setVisible(false);
        } else {
            FilterManager.getInstance().toggleField(this._tab, string);
        }
    }

    public void setColumnStatus(String string, boolean bl) {
        JCheckBox jCheckBox = (JCheckBox)this.columns2Boxes.get(string);
        if (jCheckBox != null) {
            jCheckBox.setSelected(bl);
        }
    }

    public void updateValues() {
        JTabProperties.prepareComboBox(this.cbWonTarget);
        JTabProperties.prepareComboBox(this.cbLostTarget);
        JTabProperties.prepareComboBox(this.cbOtherTarget);
        this.cbWonTarget.setSelectedItem(JConfig.queryConfiguration(this.WON_TARGET, "complete"));
        this.cbLostTarget.setSelectedItem(JConfig.queryConfiguration(this.LOST_TARGET, "complete"));
        this.cbOtherTarget.setSelectedItem(JConfig.queryConfiguration(this.OTHER_TARGET, "complete"));
    }

    private JPanel buildDropdownPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("End-of-listing item targets"));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.cbWonTarget = new JComboBox();
        this.cbLostTarget = new JComboBox();
        this.cbOtherTarget = new JComboBox();
        jPanel.add(JTabProperties.makeLine(new JLabel("Send items won to: "), this.cbWonTarget));
        jPanel.add(JTabProperties.makeLine(new JLabel("Send items bid but not won to: "), this.cbLostTarget));
        jPanel.add(JTabProperties.makeLine(new JLabel("Send everything else to: "), this.cbOtherTarget));
        this.updateValues();
        return jPanel;
    }

    private static void prepareComboBox(JComboBox jComboBox) {
        jComboBox.removeAllItems();
        List list = FilterManager.getInstance().allCategories();
        jComboBox.setEditable(true);
        if (list != null) {
            list.remove("selling");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                jComboBox.addItem(string);
            }
        }
    }

    private JPanel buildColumnPanel() {
        JPanel jPanel = new JPanel();
        if (this.columns2Boxes == null) {
            this.columns2Boxes = new TreeMap();
        }
        jPanel.setBorder(BorderFactory.createTitledBorder("Custom Column Settings"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 4, 20, 0));
        List list = FilterManager.getInstance().getColumns(this._tab);
        Object[] objectArray = TableColumnController.getInstance().getColumnNames().toArray();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            if (string == null) continue;
            JCheckBox jCheckBox = new JCheckBox(string, list.contains(string));
            jCheckBox.addActionListener(this);
            this.columns2Boxes.put(string, jCheckBox);
            jPanel2.add(jCheckBox);
        }
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    public String getTabName() {
        return this._tab;
    }

    public void cancel() {
    }

    public boolean apply() {
        String string = (String)this.cbWonTarget.getSelectedItem();
        String string2 = (String)this.cbLostTarget.getSelectedItem();
        String string3 = (String)this.cbOtherTarget.getSelectedItem();
        JConfig.setConfiguration(this.WON_TARGET, string);
        JConfig.setConfiguration(this.LOST_TARGET, string2);
        JConfig.setConfiguration(this.OTHER_TARGET, string3);
        return true;
    }

    public void setFrame(JFrame jFrame) {
        this._frame = jFrame;
    }
}

