/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;

public class JTabPopupMenu
extends JContext {
    private JTabbedPane _myTabs = null;
    private JMenu customize = null;
    private JMenuItem _print = null;
    private JMenuItem _export = null;
    private JMenu _deleteSubmenu = null;
    private Method _indexLocation = null;
    private Map menuItemMap = new TreeMap();
    private Object[] _indexParams = new Object[2];
    protected int _curIndex = 0;
    private JMenuItem _properties = null;
    protected JFrame propFrame = null;
    private TreeMap tabToProperties = null;
    static /* synthetic */ Class class$javax$swing$JTabbedPane;

    private JPopupMenu makeTabMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        Collection collection = TableColumnController.getInstance().getColumnNames();
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList);
        this.customize = new JMenu("Custom Columns");
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
            jCheckBoxMenuItem.setActionCommand('~' + string);
            this.customize.add(jCheckBoxMenuItem).addActionListener(this);
            this.menuItemMap.put(string, jCheckBoxMenuItem);
        }
        jPopupMenu.add(this.makeMenuItem("Add Tab")).addActionListener(this);
        this._deleteSubmenu = new JMenu("Delete");
        this._deleteSubmenu.add(this.makeMenuItem("Just Tab")).addActionListener(this);
        this._deleteSubmenu.add(this.makeMenuItem("Tab & All Entries")).addActionListener(this);
        jPopupMenu.add(this._deleteSubmenu);
        jPopupMenu.add(this.customize).addActionListener(this);
        this._print = this.makeMenuItem("Print");
        jPopupMenu.add(this._print).addActionListener(this);
        this._export = this.makeMenuItem("Export");
        jPopupMenu.add(this._export).addActionListener(this);
        this._properties = this.makeMenuItem("Properties");
        jPopupMenu.add(this._properties).addActionListener(this);
        return jPopupMenu;
    }

    protected void beforePopup(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        super.beforePopup(jPopupMenu, mouseEvent);
        if (this._indexLocation == null) {
            this._deleteSubmenu.setEnabled(false);
            this._print.setEnabled(false);
            this.customize.setEnabled(false);
            this._export.setEnabled(false);
            this._properties.setEnabled(false);
            this._curIndex = -1;
        } else {
            try {
                this._indexParams[0] = new Integer(mouseEvent.getX());
                this._indexParams[1] = new Integer(mouseEvent.getY());
                Integer n = (Integer)this._indexLocation.invoke((Object)this._myTabs, this._indexParams);
                this._curIndex = n;
                this._indexParams[1] = null;
                this._indexParams[0] = null;
                if (this._curIndex == -1) {
                    this.customize.setEnabled(false);
                    this._deleteSubmenu.setEnabled(false);
                    this._print.setEnabled(false);
                    ErrorManagement.logDebug("Whoops!  Click-point not found!");
                } else {
                    this.customize.setEnabled(true);
                    this._print.setEnabled(true);
                    String string = this._myTabs.getTitleAt(this._curIndex);
                    this.uncheckAll();
                    this.setColumnChecks(string);
                    if (this._curIndex < 3) {
                        this._deleteSubmenu.setEnabled(false);
                    } else {
                        this._deleteSubmenu.setEnabled(true);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setColumnChecks(String string) {
        List list = FilterManager.getInstance().getColumns(string);
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.menuItemMap.get(string2);
            jCheckBoxMenuItem.setState(true);
        }
    }

    private void uncheckAll() {
        Iterator iterator = this.menuItemMap.values().iterator();
        while (iterator.hasNext()) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)iterator.next();
            jCheckBoxMenuItem.setState(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        this.DoAction(actionEvent.getActionCommand(), this._curIndex);
    }

    protected JFrame getFrame(String string) {
        JTabProperties jTabProperties;
        if (this.propFrame == null) {
            this.propFrame = new JFrame("Tab Properties");
        }
        if (this.tabToProperties == null) {
            this.tabToProperties = new TreeMap();
        }
        if ((jTabProperties = (JTabProperties)this.tabToProperties.get(string)) == null) {
            jTabProperties = new JTabProperties(string);
            this.tabToProperties.put(string, jTabProperties);
        }
        Platform.setMacFrameMenu(this.propFrame);
        Container container = this.propFrame.getContentPane();
        container.removeAll();
        container.setLayout(new BorderLayout());
        container.add((Component)jTabProperties, "Center");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("OK");
        jButton.addActionListener(jTabProperties);
        jPanel.add((Component)jButton, "Center");
        container.add((Component)jPanel, "South");
        this.propFrame.addWindowListener(new JConfigFrame.IconifyingWindowAdapter(this.propFrame));
        this.propFrame.pack();
        this.propFrame.setResizable(false);
        jTabProperties.setFrame(this.propFrame);
        return this.propFrame;
    }

    protected void DoAction(String string, int n) {
        if (string.equals("Add Tab")) {
            OptionUI optionUI = new OptionUI();
            String string2 = optionUI.promptString(this._myTabs.getComponentAt(n >= 0 ? n : 0), "Enter the name of the tab to add.  Prefer brevity.", "Add New Tab", "");
            if (string2 == null) {
                return;
            }
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            FilterManager.getInstance().addTab(string2);
            return;
        }
        String string3 = this._myTabs.getTitleAt(n);
        if (string.charAt(0) == '~') {
            JTabProperties jTabProperties;
            boolean bl = FilterManager.getInstance().toggleField(string3, string.substring(1));
            if (this.tabToProperties != null && (jTabProperties = (JTabProperties)this.tabToProperties.get(string3)) != null) {
                jTabProperties.setColumnStatus(string.substring(1), bl);
            }
        }
        if (string.equals("Properties")) {
            JFrame jFrame = this.getFrame(string3);
            jFrame.setState(0);
            jFrame.setVisible(true);
        }
        if (string.equals("Export")) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setApproveButtonText("Export");
            int n2 = jFileChooser.showSaveDialog(null);
            switch (n2) {
                case 0: {
                    String string4 = jFileChooser.getSelectedFile().getAbsolutePath();
                    if (!FilterManager.getInstance().exportTab(string3, string4)) {
                        JOptionPane.showMessageDialog(null, "Could not export tab [" + string3 + "].", "Export error", -1);
                    }
                    return;
                }
            }
            return;
        }
        if (string.equals("Print")) {
            if (n == -1) {
                ErrorManagement.logDebug("Can't print unknown tab, must prompt...");
            } else if (!FilterManager.getInstance().printTab(string3)) {
                JOptionPane.showMessageDialog(null, "Could not print tab [" + string3 + "].", "Print error", -1);
            }
        }
        boolean bl = false;
        if (string.equals("Tab & All Entries")) {
            bl = true;
            string = "Just Tab";
        }
        if (string.equals("Just Tab")) {
            if (n == -1) {
                ErrorManagement.logDebug("Prompting for Delete...\n");
            } else {
                ErrorManagement.logDebug("Deleting tab [" + string3 + "]...\n");
                if (!FilterManager.getInstance().deleteTab(string3, bl)) {
                    JOptionPane.showMessageDialog(null, "Could not delete tab [" + string3 + "].", "Tab deletion error", -1);
                }
            }
        }
    }

    public JTabPopupMenu(JTabbedPane jTabbedPane) {
        try {
            Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
            Class clazz = class$javax$swing$JTabbedPane == null ? (class$javax$swing$JTabbedPane = JTabPopupMenu.class$("javax.swing.JTabbedPane")) : class$javax$swing$JTabbedPane;
            this._indexLocation = clazz.getDeclaredMethod("indexAtLocation", classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._myTabs = jTabbedPane;
        this.localPopup = this.makeTabMenu();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

