/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class JMouseAdapter
extends MouseInputAdapter
implements ActionListener {
    protected JPopupMenu localPopup;
    private int x = 0;
    private int y = 0;

    public JMouseAdapter(JPopupMenu jPopupMenu) {
        this.localPopup = jPopupMenu;
    }

    public JMouseAdapter() {
        this.localPopup = new JPopupMenu();
    }

    public int getPopupX() {
        return this.x;
    }

    public int getPopupY() {
        return this.y;
    }

    private void evaluatePopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this.localPopup != null) {
            this.x = mouseEvent.getX();
            this.y = mouseEvent.getY();
            this.beforePopup(this.localPopup, mouseEvent);
            this.internalPopupMenu(mouseEvent);
            this.afterPopup(this.localPopup, mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        this.evaluatePopup(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.evaluatePopup(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (mouseEvent.isPopupTrigger()) {
            this.evaluatePopup(mouseEvent);
        } else if (mouseEvent.getClickCount() == 2) {
            this.beforePopup(this.localPopup, mouseEvent);
            this.internalDoubleClick(mouseEvent);
        }
    }

    private static Rectangle ensureRectIsVisible(Rectangle rectangle) {
        Rectangle rectangle2 = JMouseAdapter.getUsableScreenBounds();
        return new Rectangle(Math.max(rectangle2.x, Math.min(rectangle2.width + rectangle2.x - rectangle.width, rectangle.x)), Math.max(rectangle2.y, Math.min(rectangle2.height + rectangle2.y - rectangle.height, rectangle.y)), rectangle.width, rectangle.height);
    }

    protected void beforePopup(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
    }

    protected void afterPopup(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
    }

    private void internalPopupMenu(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        this.localPopup.show(component, this.x, this.y);
        Point point = this.localPopup.getLocationOnScreen();
        Dimension dimension = this.localPopup.getSize();
        Rectangle rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
        Rectangle rectangle2 = JMouseAdapter.ensureRectIsVisible(rectangle);
        if (!rectangle.equals(rectangle2)) {
            this.localPopup.setLocation(rectangle2.x, rectangle2.y);
        }
    }

    protected void internalDoubleClick(MouseEvent mouseEvent) {
    }

    protected void OnDoubleClick(JTable jTable, Object object, MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public static GraphicsConfiguration getCurrentGraphicsConfiguration() {
        Window window;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component != null && (window = SwingUtilities.getWindowAncestor(component)) != null) {
            return window.getGraphicsConfiguration();
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static Rectangle getUsableScreenBounds() {
        return JMouseAdapter.getUsableScreenBounds(JMouseAdapter.getCurrentGraphicsConfiguration());
    }

    public static Rectangle getUsableScreenBounds(GraphicsConfiguration graphicsConfiguration) {
        if (graphicsConfiguration == null) {
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle rectangle = new Rectangle(graphicsConfiguration.getBounds());
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Insets insets = toolkit.getScreenInsets(graphicsConfiguration);
            rectangle.y += insets.top;
            rectangle.x += insets.left;
            rectangle.height -= insets.top + insets.bottom;
            rectangle.width -= insets.left + insets.right;
        }
        catch (Exception exception) {
            ErrorManagement.handleException("There was a problem getting screen-related information.", exception);
        }
        return rectangle;
    }
}

