/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;

public class JDropListener
implements DropTargetListener {
    private static boolean do_uber_debug = false;
    private JDropHandler handler;
    private boolean _windows = false;
    private DataFlavor _isoFlavor = null;
    private DataFlavor _ascFlavor = null;
    private DataFlavor _plainFlavor = null;
    private DataFlavor _utf8HtmlFlavor = null;
    private DataFlavor _thtmlFlavor = null;
    private DataFlavor _pl2Flavor = null;
    private DataFlavor _htmlFlavor = null;
    private DataFlavor _urlFlavor = null;
    private static final String[][] _str_flavors = new String[][]{{"UTF8Html", "text/html; class=java.io.InputStream; charset=utf-8"}, {"isoFlavor", "text/plain; class=java.io.InputStream; charset=iso8859-1"}, {"ascFlavor", "text/plain; class=java.io.InputStream; charset=ascii"}, {"pl2Flavor", "text/plain; class=java.io.InputStream"}, {"thtmlFlavor", "text/html"}, {"htmlFlavor", "text/html; class=java.io.Reader; charset=Unicode"}, {"urlFlavor", "application/x-url; class=java.io.InputStream"}};
    private static final int ALL_ACTIONS = 0x40000003;
    static /* synthetic */ Class class$java$awt$datatransfer$Transferable;
    static /* synthetic */ Class class$java$awt$datatransfer$DataFlavor;

    public JDropListener(JDropHandler jDropHandler) {
        this.setupFlavors();
        this.handler = jDropHandler;
    }

    private DataFlavor getDataFlavor(DataFlavor dataFlavor, String string) {
        DataFlavor dataFlavor2 = null;
        if (dataFlavor != null) {
            return dataFlavor;
        }
        for (int i = 0; i < _str_flavors.length; ++i) {
            if (!string.equals(_str_flavors[i][0])) continue;
            try {
                dataFlavor2 = new DataFlavor(_str_flavors[i][1]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorManagement.logDebug("Failed to initialize " + string);
                dataFlavor2 = null;
            }
            return dataFlavor2;
        }
        return null;
    }

    private void setupFlavors() {
        boolean bl = this._windows = System.getProperty("os.name").indexOf("indows") != -1;
        if (this._plainFlavor == null) {
            this._plainFlavor = DataFlavor.getTextPlainUnicodeFlavor();
        }
        this._isoFlavor = this.getDataFlavor(this._isoFlavor, "isoFlavor");
        this._ascFlavor = this.getDataFlavor(this._ascFlavor, "ascFlavor");
        this._pl2Flavor = this.getDataFlavor(this._pl2Flavor, "pl2Flavor");
        this._htmlFlavor = this.getDataFlavor(this._htmlFlavor, "htmlFlavor");
        this._utf8HtmlFlavor = this.getDataFlavor(this._htmlFlavor, "UTF8Html");
        this._thtmlFlavor = this.getDataFlavor(this._htmlFlavor, "thtmlFlavor");
        this._urlFlavor = this.getDataFlavor(this._urlFlavor, "urlFlavor");
    }

    private void dumpDataFlavors(DataFlavor[] dataFlavorArray) {
        if (dataFlavorArray != null) {
            if (dataFlavorArray.length == 0) {
                System.err.println("Length is still zero!");
            }
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                System.err.println("Flavah " + i + " == " + dataFlavorArray[i].getHumanPresentableName());
                System.err.println("Flavah/mime " + i + " == " + dataFlavorArray[i].getMimeType());
            }
        } else {
            System.err.println("Flavahs supported: none!\n");
        }
    }

    private boolean testFlavor(DataFlavor dataFlavor, Transferable transferable) {
        if (dataFlavor != null && transferable.isDataFlavorSupported(dataFlavor)) {
            if (do_uber_debug) {
                ErrorManagement.logDebug("Accepting(2): " + dataFlavor.getMimeType());
            }
            return true;
        }
        return false;
    }

    private boolean testFlavor(DataFlavor dataFlavor, DropTargetDragEvent dropTargetDragEvent) {
        if (dataFlavor != null && dropTargetDragEvent.isDataFlavorSupported(dataFlavor)) {
            if (do_uber_debug) {
                ErrorManagement.logDebug("Accepting(1): " + dataFlavor.getMimeType());
            }
            return true;
        }
        return false;
    }

    private DataFlavor testAllFlavors(Transferable transferable) {
        if (this.testFlavor(this._htmlFlavor, transferable)) {
            return this._htmlFlavor;
        }
        if (this.testFlavor(this._utf8HtmlFlavor, transferable)) {
            return this._utf8HtmlFlavor;
        }
        if (this.testFlavor(this._thtmlFlavor, transferable)) {
            return this._thtmlFlavor;
        }
        if (this.testFlavor(this._urlFlavor, transferable)) {
            return this._urlFlavor;
        }
        if (this._windows && this.testFlavor(this._ascFlavor, transferable)) {
            return this._ascFlavor;
        }
        if (this.testFlavor(this._isoFlavor, transferable)) {
            return this._isoFlavor;
        }
        if (this.testFlavor(this._plainFlavor, transferable)) {
            return this._plainFlavor;
        }
        if (this.testFlavor(this._pl2Flavor, transferable)) {
            return this._pl2Flavor;
        }
        if (this.testFlavor(DataFlavor.stringFlavor, transferable)) {
            return DataFlavor.stringFlavor;
        }
        return null;
    }

    private DataFlavor testAllFlavors(DropTargetDragEvent dropTargetDragEvent) {
        if (this.testFlavor(this._htmlFlavor, dropTargetDragEvent)) {
            return this._htmlFlavor;
        }
        if (this.testFlavor(this._utf8HtmlFlavor, dropTargetDragEvent)) {
            return this._utf8HtmlFlavor;
        }
        if (this.testFlavor(this._thtmlFlavor, dropTargetDragEvent)) {
            return this._thtmlFlavor;
        }
        if (this.testFlavor(this._urlFlavor, dropTargetDragEvent)) {
            return this._urlFlavor;
        }
        if (this._windows && this.testFlavor(this._ascFlavor, dropTargetDragEvent)) {
            return this._ascFlavor;
        }
        if (this.testFlavor(this._isoFlavor, dropTargetDragEvent)) {
            return this._isoFlavor;
        }
        if (this.testFlavor(this._plainFlavor, dropTargetDragEvent)) {
            return this._plainFlavor;
        }
        if (this.testFlavor(this._pl2Flavor, dropTargetDragEvent)) {
            return this._pl2Flavor;
        }
        if (this.testFlavor(DataFlavor.stringFlavor, dropTargetDragEvent)) {
            return DataFlavor.stringFlavor;
        }
        return null;
    }

    private void acceptDrag(DropTargetDragEvent dropTargetDragEvent) {
        int n = dropTargetDragEvent.getDropAction();
        if (n != 0) {
            dropTargetDragEvent.acceptDrag(n);
        } else {
            dropTargetDragEvent.acceptDrag(0x40000003);
        }
    }

    private void acceptDrop(DropTargetDropEvent dropTargetDropEvent) {
        int n = dropTargetDropEvent.getDropAction();
        if (n != 0) {
            dropTargetDropEvent.acceptDrop(n);
        } else {
            dropTargetDropEvent.acceptDrop(0x40000003);
        }
    }

    private void checkDrag(DropTargetDragEvent dropTargetDragEvent) {
        int n = dropTargetDragEvent.getDropAction();
        if (dropTargetDragEvent.getCurrentDataFlavors().length == 0) {
            if (do_uber_debug) {
                ErrorManagement.logDebug("Zero length accepted... (" + n + ")");
            }
            this.acceptDrag(dropTargetDragEvent);
            return;
        }
        if (this.testAllFlavors(dropTargetDragEvent) != null) {
            if (do_uber_debug) {
                ErrorManagement.logDebug("Accepting drag! (" + n + ")");
            }
            this.acceptDrag(dropTargetDragEvent);
        } else {
            dropTargetDragEvent.rejectDrag();
            if (do_uber_debug) {
                ErrorManagement.logDebug("Rejecting drag! (" + n + ")");
            }
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (do_uber_debug) {
            ErrorManagement.logDebug("DragEnter!");
        }
        this.checkDrag(dropTargetDragEvent);
        if (do_uber_debug && JConfig.debugging) {
            this.dumpDataFlavors(dropTargetDragEvent.getCurrentDataFlavors());
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.checkDrag(dropTargetDragEvent);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (do_uber_debug) {
            ErrorManagement.logDebug("Drag exited!");
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        this.acceptDrag(dropTargetDragEvent);
        if (do_uber_debug) {
            ErrorManagement.logDebug("Drag Action Changed!");
        }
    }

    private void dumpFlavorsOld(Transferable transferable) {
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        if (dataFlavorArray != null && dataFlavorArray.length == 0) {
            if (do_uber_debug) {
                ErrorManagement.logDebug("Trying a second attack...");
            }
            try {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable transferable2 = clipboard.getContents(null);
                StringBuffer stringBuffer = this.getTransferData(transferable2);
                if (do_uber_debug) {
                    ErrorManagement.logDebug("Check out: " + stringBuffer);
                }
            }
            catch (Exception exception) {
                ErrorManagement.handleException("Caught: " + exception, exception);
            }
            if (do_uber_debug) {
                ErrorManagement.logDebug("Done trying a second attack...");
            }
        }
        this.dumpDataFlavors(dataFlavorArray);
    }

    private Method getSpecialAPI() {
        Class[] classArray = new Class[1];
        Method method = null;
        classArray[0] = class$java$awt$datatransfer$Transferable == null ? (class$java$awt$datatransfer$Transferable = JDropListener.class$("java.awt.datatransfer.Transferable")) : class$java$awt$datatransfer$Transferable;
        try {
            method = (class$java$awt$datatransfer$DataFlavor == null ? (class$java$awt$datatransfer$DataFlavor = JDropListener.class$("java.awt.datatransfer.DataFlavor")) : class$java$awt$datatransfer$DataFlavor).getMethod("getReaderForText", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorManagement.logDebug("No such method getReaderForText!");
            return null;
        }
        return method;
    }

    private BufferedReader useNewAPI(Transferable transferable, DataFlavor dataFlavor) {
        Method method = null;
        Object[] objectArray = new Object[1];
        Reader reader = null;
        BufferedReader bufferedReader = null;
        method = this.getSpecialAPI();
        if (method != null) {
            try {
                if (do_uber_debug) {
                    ErrorManagement.logDebug("Trying getReaderForText");
                }
                objectArray[0] = transferable;
                reader = (Reader)method.invoke((Object)dataFlavor, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorManagement.logDebug("Failed to invoke getReaderForText!  Illegal Access!");
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorManagement.logDebug("Failed to invoke getReaderForText!  Bad Invocation Target!");
            }
            if (reader != null) {
                bufferedReader = new BufferedReader(reader);
                return bufferedReader;
            }
        }
        return null;
    }

    private StringBuffer getDataFromReader(Reader reader) {
        StringBuffer stringBuffer = null;
        char[] cArray = new char[513];
        int n = -1;
        try {
            do {
                if ((n = reader.read(cArray, 0, 512)) == -1) continue;
                if (do_uber_debug) {
                    ErrorManagement.logDebug("Read: " + n + " characters.");
                }
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append(cArray, 0, n);
            } while (n != -1);
            reader.close();
        }
        catch (IOException iOException) {
            ErrorManagement.logDebug("Caught an IO Exception trying to read the drag/drop data!");
            return null;
        }
        return stringBuffer;
    }

    private StringBuffer getDataFromStream(InputStream inputStream) {
        return this.getDataFromReader(new InputStreamReader(inputStream));
    }

    private StringBuffer getInputStreamData(Transferable transferable, DataFlavor dataFlavor, InputStream inputStream) {
        StringBuffer stringBuffer = null;
        BufferedReader bufferedReader = this.useNewAPI(transferable, dataFlavor);
        if (bufferedReader == null) {
            if (do_uber_debug) {
                ErrorManagement.logDebug("Non-getReaderForText: " + inputStream);
            }
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-16le");
                stringBuffer = this.getDataFromStream(inputStream);
                if (stringBuffer != null) {
                    return stringBuffer;
                }
                bufferedReader = new BufferedReader(inputStreamReader);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ErrorManagement.logDebug("Unicode encoding unsupported.");
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            }
        }
        if (bufferedReader != null) {
            stringBuffer = this.getDataFromReader(bufferedReader);
        }
        return stringBuffer;
    }

    public StringBuffer getTransferData(Transferable transferable) {
        StringBuffer stringBuffer = null;
        Object object = null;
        DataFlavor dataFlavor = this.testAllFlavors(transferable);
        if (do_uber_debug) {
            ErrorManagement.logDebug("dtf == " + dataFlavor);
        }
        try {
            if ((dataFlavor == this._htmlFlavor || dataFlavor == this._utf8HtmlFlavor || dataFlavor == this._thtmlFlavor) && do_uber_debug && JConfig.debugging) {
                System.out.println("Ick: " + transferable.getTransferData(DataFlavor.getTextPlainUnicodeFlavor()));
            }
            object = transferable.getTransferData(dataFlavor);
        }
        catch (IOException iOException) {
            try {
                object = transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                ErrorManagement.logDebug("I/O Exception: " + iOException);
                return null;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            try {
                object = transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                ErrorManagement.logDebug("Unsupported flavor: " + dataFlavor);
                return null;
            }
        }
        if (object != null) {
            if (object instanceof InputStream) {
                if (do_uber_debug) {
                    ErrorManagement.logDebug("Dropped an InputStream");
                }
                stringBuffer = this.getInputStreamData(transferable, dataFlavor, (InputStream)object);
            } else if (object instanceof Reader) {
                if (do_uber_debug) {
                    ErrorManagement.logDebug("Dropped a Reader");
                }
                stringBuffer = this.getDataFromReader(new BufferedReader((Reader)object));
            } else if (object instanceof URL) {
                if (do_uber_debug) {
                    ErrorManagement.logDebug("Dropped a URL");
                    ErrorManagement.logDebug("Got: " + object.toString());
                }
                stringBuffer = new StringBuffer(object.toString());
            } else if (object instanceof String) {
                if (do_uber_debug) {
                    ErrorManagement.logDebug("Dropped a String");
                }
                stringBuffer = new StringBuffer((String)object);
            }
            return stringBuffer;
        }
        return null;
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        DataFlavor dataFlavor;
        Transferable transferable = dropTargetDropEvent.getTransferable();
        StringBuffer stringBuffer = null;
        if (do_uber_debug) {
            ErrorManagement.logDebug("Dropping!");
        }
        if (transferable.getTransferDataFlavors().length == 0) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable2 = clipboard.getContents(null);
            ErrorManagement.logDebug("Dropped 0 data flavors, trying clipboard.");
            DataFlavor[] dataFlavorArray = null;
            if (transferable2 != null) {
                if (do_uber_debug) {
                    ErrorManagement.logDebug("t2 is not null: " + transferable2);
                }
                dataFlavorArray = transferable2.getTransferDataFlavors();
                if (do_uber_debug) {
                    ErrorManagement.logDebug("Back from getTransferDataFlavors()!");
                }
            } else if (do_uber_debug) {
                ErrorManagement.logDebug("t2 is null!");
            }
            if (do_uber_debug) {
                if (dataFlavorArray != null) {
                    if (dataFlavorArray.length == 0) {
                        ErrorManagement.logDebug("Length is still zero!");
                    }
                    for (int i = 0; i < dataFlavorArray.length; ++i) {
                        ErrorManagement.logDebug("Flavah " + i + " == " + dataFlavorArray[i].getHumanPresentableName());
                        ErrorManagement.logDebug("Flavah/mime " + i + " == " + dataFlavorArray[i].getMimeType());
                    }
                } else {
                    ErrorManagement.logDebug("Flavahs supported: none!\n");
                }
            }
        }
        if (do_uber_debug && JConfig.debugging) {
            this.dumpFlavorsOld(transferable);
        }
        if ((dataFlavor = this.testAllFlavors(transferable)) != null) {
            if (do_uber_debug) {
                ErrorManagement.logDebug("Accepting!");
            }
            this.acceptDrop(dropTargetDropEvent);
            stringBuffer = this.getTransferData(transferable);
            dropTargetDropEvent.dropComplete(true);
            dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            if (stringBuffer != null && this.handler != null) {
                this.handler.receiveDropString(stringBuffer);
            }
        } else {
            if (do_uber_debug) {
                ErrorManagement.logDebug("Rejecting!");
            }
            dropTargetDropEvent.rejectDrop();
            this.handler.receiveDropString(stringBuffer);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

