/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JConfigFirewallTab
extends JConfigTab {
    private ButtonGroup allButtons;
    private JRadioButton noFirewall;
    private JRadioButton socksFirewall;
    private JRadioButton webProxy;
    private JCheckBox proxyHttps;
    String holdProxyHost = null;
    String holdProxyPort = null;
    String holdHTTPSProxyHost = null;
    String holdHTTPSProxyPort = null;
    String holdProxyUser = null;
    String holdProxyPass = null;
    String holdFireHost = null;
    String holdFirePort = null;
    private JTextField proxyHost;
    private JTextField proxyPort;
    private JTextField httpsProxyHost;
    private JTextField httpsProxyPort;
    private JTextField proxyUser;
    private JPasswordField proxyPass;
    private JTextField firewallHost;
    private JTextField firewallPort;
    private DocumentListener firewallTextFieldListener;

    public JConfigFirewallTab() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.firewallTextFieldListener = new textAction();
        this.setLayout(new BorderLayout());
        jPanel.setLayout(new GridLayout(1, 2));
        jPanel.add(JConfigFirewallTab.panelPack(this.buildRadioButtons()));
        jPanel.add(JConfigFirewallTab.panelPack(this.buildFirewallPrompt()));
        this.add((Component)jPanel, "North");
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.add(JConfigFirewallTab.panelPack(this.buildProxyPanel()));
        jPanel2.add(JConfigFirewallTab.panelPack(this.buildHTTPSProxyPanel()));
        this.add((Component)jPanel2, "Center");
        this.updateValues();
    }

    public String getTabName() {
        return "Firewall";
    }

    public void cancel() {
        this.holdHTTPSProxyPort = null;
        this.holdHTTPSProxyHost = null;
        this.holdFirePort = null;
        this.holdFireHost = null;
        this.holdProxyPass = null;
        this.holdProxyUser = null;
        this.holdProxyPort = null;
        this.holdProxyHost = null;
        this.updateValues();
    }

    public boolean apply() {
        String string = "none";
        if (this.noFirewall.isSelected()) {
            string = "none";
        } else if (this.socksFirewall.isSelected()) {
            string = "firewall";
        } else if (this.webProxy.isSelected()) {
            string = "proxy";
        }
        JConfig.setConfiguration("proxyfirewall", string);
        if (this.holdProxyHost != null) {
            JConfig.setConfiguration("proxy.host", this.holdProxyHost);
        }
        if (this.holdProxyPort != null) {
            JConfig.setConfiguration("proxy.port", this.holdProxyPort);
        }
        if (this.holdProxyUser != null) {
            JConfig.setConfiguration("proxy.user", this.holdProxyUser);
        }
        if (this.holdProxyPass != null) {
            JConfig.setConfiguration("proxy.pass", this.holdProxyPass);
        }
        if (this.holdFireHost != null) {
            JConfig.setConfiguration("firewall.host", this.holdFireHost);
        }
        if (this.holdFirePort != null) {
            JConfig.setConfiguration("firewall.port", this.holdFirePort);
        }
        if (this.proxyHttps.isSelected()) {
            JConfig.setConfiguration("proxy.https.set", "true");
            if (this.holdHTTPSProxyHost != null) {
                JConfig.setConfiguration("proxy.https.host", this.holdHTTPSProxyHost);
            }
            if (this.holdHTTPSProxyPort != null) {
                JConfig.setConfiguration("proxy.https.port", this.holdHTTPSProxyPort);
            }
        } else {
            JConfig.setConfiguration("proxy.https.set", "false");
        }
        return true;
    }

    private String getConfigValue(JToggleButton jToggleButton, String string, String string2) {
        if (jToggleButton.isSelected()) {
            if (string2 == null) {
                String string3 = JConfig.queryConfiguration(string);
                if (string3 == null) {
                    return "";
                }
                return string3;
            }
            return string2;
        }
        return "<disabled>";
    }

    private void setAllProxyText() {
        this.proxyHost.setText(this.getConfigValue(this.webProxy, "proxy.host", this.holdProxyHost));
        this.proxyPort.setText(this.getConfigValue(this.webProxy, "proxy.port", this.holdProxyPort));
        this.proxyUser.setText(this.getConfigValue(this.webProxy, "proxy.user", this.holdProxyUser));
        this.proxyPass.setText(this.getConfigValue(this.webProxy, "proxy.pass", this.holdProxyPass));
    }

    private void setAllProxyStatus(boolean bl) {
        this.proxyHost.setEnabled(bl);
        this.proxyPort.setEnabled(bl);
        this.proxyUser.setEnabled(bl);
        this.proxyPass.setEnabled(bl);
    }

    private void setAllFirewallText() {
        this.firewallHost.setText(this.getConfigValue(this.socksFirewall, "firewall.host", this.holdFireHost));
        this.firewallPort.setText(this.getConfigValue(this.socksFirewall, "firewall.port", this.holdFirePort));
    }

    private void setAllFirewallStatus(boolean bl) {
        this.firewallHost.setEnabled(bl);
        this.firewallPort.setEnabled(bl);
    }

    private void setAllHTTPSText() {
        this.httpsProxyHost.setText(this.getConfigValue(this.proxyHttps, "proxy.https.host", this.holdHTTPSProxyHost));
        this.httpsProxyPort.setText(this.getConfigValue(this.proxyHttps, "proxy.https.port", this.holdHTTPSProxyPort));
    }

    private void setAllHTTPSStatus(boolean bl) {
        this.httpsProxyHost.setEnabled(bl);
        this.httpsProxyPort.setEnabled(bl);
    }

    private void updateProxyFirewall(boolean bl, boolean bl2, boolean bl3) {
        if (!bl) {
            this.setAllProxyStatus(bl);
            this.setAllProxyText();
        } else {
            this.setAllProxyText();
            this.setAllProxyStatus(bl);
        }
        if (!bl2) {
            this.setAllFirewallStatus(bl2);
            this.setAllFirewallText();
        } else {
            this.setAllFirewallText();
            this.setAllFirewallStatus(bl2);
        }
        if (!bl3) {
            this.setAllHTTPSStatus(bl3);
            this.setAllHTTPSText();
        } else {
            this.setAllHTTPSText();
            this.setAllHTTPSStatus(bl3);
        }
    }

    public final void updateValues() {
        String string = JConfig.queryConfiguration("proxyfirewall");
        boolean bl = false;
        boolean bl2 = false;
        if (string == null) {
            this.noFirewall.setSelected(true);
            bl2 = false;
            bl = false;
        } else if (string.equals("proxy")) {
            this.webProxy.setSelected(true);
            bl2 = false;
            bl = true;
        } else if (string.equals("firewall")) {
            this.socksFirewall.setSelected(true);
            bl2 = true;
            bl = false;
        } else {
            this.noFirewall.setSelected(true);
            bl2 = false;
            bl = false;
        }
        if (JConfig.queryConfiguration("proxy.https.set", "false").equals("true")) {
            this.proxyHttps.setSelected(true);
        }
        this.updateProxyFirewall(bl, bl2, this.proxyHttps.isSelected());
    }

    private JPanel buildRadioButtons() {
        radioAction radioAction2 = new radioAction();
        JPanel jPanel = new JPanel();
        Box box = Box.createVerticalBox();
        this.noFirewall = new JRadioButton("No firewall or proxy");
        this.socksFirewall = new JRadioButton("SOCKS 4/5 Firewall");
        this.webProxy = new JRadioButton("HTTP Web Proxy");
        this.allButtons = new ButtonGroup();
        this.allButtons.add(this.socksFirewall);
        this.allButtons.add(this.webProxy);
        this.allButtons.add(this.noFirewall);
        this.socksFirewall.addActionListener(radioAction2);
        this.webProxy.addActionListener(radioAction2);
        this.noFirewall.addActionListener(radioAction2);
        jPanel.setBorder(BorderFactory.createTitledBorder("Firewall/Proxy"));
        jPanel.setLayout(new BorderLayout());
        box.add(this.socksFirewall);
        box.add(this.webProxy);
        box.add(this.noFirewall);
        jPanel.add((Component)box, "North");
        return jPanel;
    }

    private JPanel buildFirewallPrompt() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("SOCKS Settings"));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.firewallHost = new JTextField();
        this.firewallPort = new JTextField();
        this.setAllFirewallStatus(false);
        JConfigFirewallTab.adjustField(this.firewallHost, "Host name or IP address of SOCKS firewall", this.firewallTextFieldListener);
        JConfigFirewallTab.adjustField(this.firewallPort, "Port number for SOCKS firewall", this.firewallTextFieldListener);
        Box box = Box.createVerticalBox();
        box.add(JConfigFirewallTab.makeLine(new JLabel("SOCKS Host: "), this.firewallHost));
        box.add(JConfigFirewallTab.makeLine(new JLabel("SOCKS Port:  "), this.firewallPort));
        jPanel.add(box);
        return jPanel;
    }

    private JPanel buildProxyPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("HTTP/Web Proxy Settings"));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.proxyHost = new JTextField();
        this.proxyPort = new JTextField();
        this.proxyUser = new JTextField();
        this.proxyPass = new JPasswordField();
        this.setAllProxyStatus(false);
        JConfigFirewallTab.adjustField(this.proxyHost, "Host name or IP address of web proxy server", this.firewallTextFieldListener);
        JConfigFirewallTab.adjustField(this.proxyPort, "Port number that a web proxy server runs on", this.firewallTextFieldListener);
        JConfigFirewallTab.adjustField(this.proxyUser, "Username (if needed) for web proxy server", this.firewallTextFieldListener);
        JConfigFirewallTab.adjustField(this.proxyPass, "Password (if needed) for web proxy server", this.firewallTextFieldListener);
        jPanel.add(JConfigFirewallTab.makeLine(new JLabel("Host: "), this.proxyHost));
        jPanel.add(JConfigFirewallTab.makeLine(new JLabel("Port:  "), this.proxyPort));
        jPanel.add(JConfigFirewallTab.makeLine(new JLabel("Username: "), this.proxyUser));
        jPanel.add(JConfigFirewallTab.makeLine(new JLabel("Password:  "), this.proxyPass));
        return jPanel;
    }

    private JPanel buildHTTPSProxyPanel() {
        JPanel jPanel = new JPanel();
        radioAction radioAction2 = new radioAction();
        jPanel.setBorder(BorderFactory.createTitledBorder("HTTPS/Secure Proxy Settings"));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.httpsProxyHost = new JTextField();
        this.httpsProxyPort = new JTextField();
        this.setAllHTTPSStatus(false);
        JConfigFirewallTab.adjustField(this.httpsProxyHost, "Host name or IP address of HTTPS proxy server", this.firewallTextFieldListener);
        JConfigFirewallTab.adjustField(this.httpsProxyPort, "Port number that the HTTPS proxy server runs on", this.firewallTextFieldListener);
        this.proxyHttps = new JCheckBox("Enable HTTPS (secure http) proxy?");
        this.proxyHttps.addActionListener(radioAction2);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.proxyHttps, "West");
        jPanel.add(jPanel2);
        jPanel.add(JConfigFirewallTab.makeLine(new JLabel("HTTPS Host: "), this.httpsProxyHost));
        jPanel.add(JConfigFirewallTab.makeLine(new JLabel("HTTPS Port: "), this.httpsProxyPort));
        return jPanel;
    }

    private class textAction
    implements DocumentListener {
        private textAction() {
        }

        private void anyEvent() {
            if (JConfigFirewallTab.this.proxyHost.isEnabled()) {
                JConfigFirewallTab.this.holdProxyHost = JConfigFirewallTab.this.proxyHost.getText();
            }
            if (JConfigFirewallTab.this.proxyPort.isEnabled()) {
                JConfigFirewallTab.this.holdProxyPort = JConfigFirewallTab.this.proxyPort.getText();
            }
            if (JConfigFirewallTab.this.proxyUser.isEnabled()) {
                JConfigFirewallTab.this.holdProxyUser = JConfigFirewallTab.this.proxyUser.getText();
            }
            if (JConfigFirewallTab.this.proxyPass.isEnabled()) {
                JConfigFirewallTab.this.holdProxyPass = new String(JConfigFirewallTab.this.proxyPass.getPassword());
            }
            if (JConfigFirewallTab.this.firewallHost.isEnabled()) {
                JConfigFirewallTab.this.holdFireHost = JConfigFirewallTab.this.firewallHost.getText();
            }
            if (JConfigFirewallTab.this.firewallPort.isEnabled()) {
                JConfigFirewallTab.this.holdFirePort = JConfigFirewallTab.this.firewallPort.getText();
            }
            if (JConfigFirewallTab.this.httpsProxyHost.isEnabled()) {
                JConfigFirewallTab.this.holdHTTPSProxyHost = JConfigFirewallTab.this.httpsProxyHost.getText();
            }
            if (JConfigFirewallTab.this.httpsProxyPort.isEnabled()) {
                JConfigFirewallTab.this.holdHTTPSProxyPort = JConfigFirewallTab.this.httpsProxyPort.getText();
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.anyEvent();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.anyEvent();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.anyEvent();
        }
    }

    private class radioAction
    implements ActionListener {
        private radioAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            boolean bl2 = false;
            if (JConfigFirewallTab.this.noFirewall.isSelected()) {
                bl2 = false;
                bl = false;
            } else if (JConfigFirewallTab.this.socksFirewall.isSelected()) {
                bl2 = true;
                bl = false;
            } else if (JConfigFirewallTab.this.webProxy.isSelected()) {
                bl2 = false;
                bl = true;
            }
            JConfigFirewallTab.this.updateProxyFirewall(bl, bl2, JConfigFirewallTab.this.proxyHttps.isSelected());
        }
    }
}

