/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JConfigBrowserTab
extends JConfigTab {
    JTextField linuxBrowserLaunchCommand;
    JTextField windowsBrowserLaunchCommand;
    JCheckBox overrideDefault;

    public String getTabName() {
        return "Browser";
    }

    public void cancel() {
    }

    public boolean apply() {
        JConfig.setConfiguration("browser.launch.Linux", this.linuxBrowserLaunchCommand.getText());
        JConfig.setConfiguration("browser.launch.Windows", this.windowsBrowserLaunchCommand.getText());
        JConfig.setConfiguration("browser.override", this.overrideDefault.isSelected() ? "true" : "false");
        return true;
    }

    public void updateValues() {
        String string = JConfig.queryConfiguration("browser.override", "false");
        this.linuxBrowserLaunchCommand.setText(JConfig.queryConfiguration("browser.launch.Linux", "netscape"));
        this.windowsBrowserLaunchCommand.setText(JConfig.queryConfiguration("browser.launch.Windows", "start netscape"));
        this.overrideDefault.setSelected(string.equals("true"));
    }

    private JPanel buildLinuxBrowserLaunch() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Browser Command"));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.linuxBrowserLaunchCommand = new JTextField();
        this.linuxBrowserLaunchCommand.addMouseListener(JPasteListener.getInstance());
        this.linuxBrowserLaunchCommand.setText(JConfig.queryConfiguration("browser.launch.Linux"));
        this.linuxBrowserLaunchCommand.setEditable(true);
        this.linuxBrowserLaunchCommand.getAccessibleContext().setAccessibleName("Command to use to launch the web browser under Linux");
        this.windowsBrowserLaunchCommand = new JTextField();
        this.windowsBrowserLaunchCommand.addMouseListener(JPasteListener.getInstance());
        this.windowsBrowserLaunchCommand.setText(JConfig.queryConfiguration("browser.launch.Windows"));
        this.windowsBrowserLaunchCommand.setEditable(true);
        this.windowsBrowserLaunchCommand.getAccessibleContext().setAccessibleName("Command to use to launch the web browser under Windows");
        jPanel.add(new JLabel("Linux command:"));
        jPanel.add(this.linuxBrowserLaunchCommand);
        jPanel.add(new JLabel("Windows command:"));
        jPanel.add(this.windowsBrowserLaunchCommand);
        return jPanel;
    }

    private JPanel buildOverridePreference() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Browser Command"));
        jPanel.setLayout(new GridLayout(2, 2));
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("Detect Browser");
        String string = JConfig.queryConfiguration("browser.override", "false");
        jPanel2.setLayout(new BorderLayout());
        this.overrideDefault = new JCheckBox("Override 'detected' browser");
        this.overrideDefault.setSelected(string.equals("true"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("Detect Browser")) {
                    if (JConfig.getOS().equalsIgnoreCase("windows")) {
                        String string = JBConfig.getBrowserCommand();
                        if (string != null) {
                            JConfigBrowserTab.this.windowsBrowserLaunchCommand.setText(string);
                        } else {
                            JOptionPane.showMessageDialog(null, "This Java Virtual Machine cannot detect the default browser type.\nUpgrading to a post-1.4 version of Java might help.", "Cannot detect browser", 1);
                        }
                    } else {
                        JConfigBrowserTab.this.linuxBrowserLaunchCommand.setText(JBConfig.getBrowserCommand());
                    }
                }
            }
        });
        jPanel.add((Component)jPanel2, "West");
        jPanel2.add((Component)jButton, "West");
        jPanel2.add((Component)this.buildTestButton(), "East");
        jPanel.add((Component)this.overrideDefault, "South");
        return jPanel;
    }

    private JButton buildTestButton() {
        JButton jButton = new JButton("Test Browser");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("Test Browser")) {
                    boolean bl = false;
                    JConfigBrowserTab.this.apply();
                    bl = JBConfig.launchBrowser("http://www.jbidwatcher.com");
                    if (!bl) {
                        JOptionPane.showMessageDialog(null, "<html><body>Failed to launch browser.  The error log contains more details,<br>but some common problems are:<ul><li>Your path does not include the binary to launch.</li><li>The executable is misnamed.</li><li>The executable path contains spaces, but is not quoted.</li></ul>You should be able to copy the browser line, and execute it\nat the command line, followed by a URL, and it should go to\nthat page.", "Failed to launch browser", 1);
                    }
                }
            }
        });
        return jButton;
    }

    public JConfigBrowserTab() {
        this.setLayout(new BorderLayout());
        this.add((Component)JConfigBrowserTab.panelPack(this.buildLinuxBrowserLaunch()), "North");
        this.add((Component)JConfigBrowserTab.panelPack(this.buildOverridePreference()), "Center");
    }
}

