/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.JFrame;

public class JConfig {
    protected static Properties soleProperty = new Properties();
    protected static Properties displayProperty;
    protected static Properties mAuxProps;
    protected static Runtime curRuntime;
    protected static String _configFileName;
    public static int screenx;
    public static int screeny;
    public static int height;
    public static int width;
    public static volatile boolean debugging;
    private static Vector _listeners;
    private static boolean _anyUpdates;

    public static void load(InputStream inputStream) {
        try {
            if (inputStream != null) {
                soleProperty.load(inputStream);
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            ErrorManagement.handleException("Fatal error loading config file.", iOException);
            System.exit(1);
        }
        JConfig.handleConfigLoading();
    }

    public static boolean debugging() {
        return debugging;
    }

    public static void registerListener(ConfigListener configListener) {
        _listeners.add(configListener);
    }

    public static void killAll(String string) {
        Set<Object> set = soleProperty.keySet();
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            iterator.remove();
        }
    }

    public static void kill(String string) {
        Set<Object> set = soleProperty.keySet();
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.equals(string)) continue;
            iterator.remove();
        }
    }

    public static String getOS() {
        String string = System.getProperty("os.name");
        int n = string.indexOf(32);
        String string2 = n == -1 ? string : string.substring(0, n);
        return string2;
    }

    public static void updateComplete() {
        JConfig.setDebugging(JConfig.queryConfiguration("debugging", "false").equals("true"));
        if (_anyUpdates) {
            for (int i = 0; i < _listeners.size(); ++i) {
                ConfigListener configListener = (ConfigListener)_listeners.get(i);
                configListener.updateConfiguration();
            }
        }
        _anyUpdates = false;
    }

    private static void handleConfigLoading() {
        JConfig.passwordUnfixup_b64(soleProperty);
        if (soleProperty.containsKey("debugging")) {
            String string = soleProperty.getProperty("debugging");
            if (string.equalsIgnoreCase("true")) {
                JConfig.setDebugging(true);
            } else if (string.equalsIgnoreCase("false")) {
                JConfig.setDebugging(false);
            } else {
                ErrorManagement.logMessage("debugging flag is bad, only 'true' or 'false' allowed.  Presuming true.");
                JConfig.setDebugging(true);
            }
        }
    }

    public static void load(String string) {
        _configFileName = string;
        if (string != null) {
            try {
                JConfig.load(new FileInputStream(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                ErrorManagement.handleException("Property file " + string + " not found.  Retaining default settings!\n", fileNotFoundException);
            }
        }
    }

    public static void saveArbitrary(String string, Properties properties) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            properties.store(fileOutputStream, "Configuration information.  Do not modify while running.");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            ErrorManagement.handleException("Failed to write configuration: " + string, iOException);
        }
    }

    public static Properties loadArbitrary(InputStream inputStream) {
        Properties properties;
        try {
            properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            ErrorManagement.handleException("Failed to load arbitrary stream configuration.", iOException);
            properties = null;
        }
        return properties;
    }

    public static Properties loadArbitrary(String string) {
        File file = new File(string);
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                return JConfig.loadArbitrary(fileInputStream);
            }
            catch (IOException iOException) {
                ErrorManagement.handleException("Failed to load configuration " + string, iOException);
            }
        }
        return null;
    }

    public static String getHomeDirectory(String string) {
        String string2 = System.getProperty("file.separator");
        String string3 = System.getProperty("user.home") + string2 + '.' + string;
        File file = new File(string3);
        if (!file.exists()) {
            file.mkdirs();
        }
        return string3;
    }

    public static String getCanonicalFile(String string, String string2, boolean bl) {
        String string3 = string;
        String string4 = System.getProperty("file.separator");
        if (string.indexOf(string4) == -1) {
            String string5 = JConfig.getHomeDirectory(string2) + string4 + string;
            if (bl) {
                File file = new File(string5);
                if (file.exists() && file.isFile()) {
                    string3 = string5;
                }
            } else {
                string3 = string5;
            }
        }
        return string3;
    }

    public static void snapshotDisplay(JFrame jFrame) {
        Point point = jFrame.getLocationOnScreen();
        JConfig.setConfiguration("temp.last.screenx", Integer.toString(point.x));
        JConfig.setConfiguration("temp.last.screeny", Integer.toString(point.y));
        JConfig.setConfiguration("temp.last.height", Integer.toString(jFrame.getHeight()));
        JConfig.setConfiguration("temp.last.width", Integer.toString(jFrame.getWidth()));
    }

    public static void saveDisplayConfig(JFrame jFrame, Properties properties) {
        Object object;
        Properties properties2 = new Properties();
        if (jFrame.isVisible()) {
            object = jFrame.getLocationOnScreen();
            properties2.setProperty("screenx", Integer.toString(((Point)object).x));
            properties2.setProperty("screeny", Integer.toString(((Point)object).y));
            properties2.setProperty("height", Integer.toString(jFrame.getHeight()));
            properties2.setProperty("width", Integer.toString(jFrame.getWidth()));
        } else {
            properties2.setProperty("screenx", JConfig.queryConfiguration("temp.last.screenx", "-1"));
            properties2.setProperty("screeny", JConfig.queryConfiguration("temp.last.screeny", "-1"));
            properties2.setProperty("width", JConfig.queryConfiguration("temp.last.width", "-1"));
            properties2.setProperty("height", JConfig.queryConfiguration("temp.last.height", "-1"));
        }
        try {
            object = JConfig.getCanonicalFile("display.cfg", "jbidwatcher", false);
            FileOutputStream fileOutputStream = new FileOutputStream((String)object);
            properties2.store(fileOutputStream, "Display information.  Do not modify while running.");
            if (properties != null) {
                properties.store(fileOutputStream, "Column header information.  Do not modify while running.");
            }
            if (mAuxProps != null) {
                mAuxProps.store(fileOutputStream, "Search display information.  Do not modify while running.");
            }
        }
        catch (IOException iOException) {
            ErrorManagement.handleException("Failed to write display configuration.", iOException);
        }
    }

    private static void passwordFixup(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = string.toLowerCase();
            if (string2.indexOf("password") == -1 || string2.indexOf("_b64") != -1) continue;
            String string3 = properties.getProperty(string);
            properties.remove(string);
            properties.setProperty(string + "_b64", Base64.encodeString(string3, false));
        }
    }

    private static void passwordUnfixup_b64(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = string.toLowerCase();
            if (string2.indexOf("_b64") == -1) continue;
            int n = string2.indexOf("_b64");
            String string3 = properties.getProperty(string);
            properties.remove(string);
            string = string.substring(0, n) + string.substring(n + 4);
            properties.setProperty(string, Base64.decodeToString(string3));
        }
    }

    public static void setConfigurationFile(String string) {
        _configFileName = string;
    }

    public static void saveConfiguration() {
        JConfig.passwordFixup(soleProperty);
        JConfig.killAll("temp.");
        if (_configFileName != null) {
            JConfig.saveArbitrary(_configFileName, soleProperty);
            ErrorManagement.logDebug("Saving to: " + _configFileName);
        } else {
            JConfig.saveArbitrary("JBidWatch.cfg", soleProperty);
            ErrorManagement.logDebug("Just saving to: JBidWatch.cfg!");
        }
        JConfig.passwordUnfixup_b64(soleProperty);
    }

    public static void saveConfiguration(String string) {
        _configFileName = string;
        JConfig.passwordFixup(soleProperty);
        JConfig.saveArbitrary(string, soleProperty);
        JConfig.passwordUnfixup_b64(soleProperty);
    }

    public static InputStream bestSource(ClassLoader classLoader, String string) {
        File file = new File(string);
        InputStream inputStream = null;
        if (file.exists()) {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                ErrorManagement.logMessage(string + " deleted between existence check and loading!");
            }
        } else {
            inputStream = classLoader.getResourceAsStream(file.getName());
        }
        return inputStream;
    }

    public static void loadDisplayConfig(ClassLoader classLoader) {
        Properties properties = new Properties();
        boolean bl = false;
        String string = JConfig.getCanonicalFile("display.cfg", "jbidwatcher", true);
        File file = new File(string);
        InputStream inputStream = null;
        if (file.exists()) {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                ErrorManagement.handleException(string + " deleted between existence check and loading!", fileNotFoundException);
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            inputStream = classLoader.getResourceAsStream("display.cfg");
        }
        height = 0;
        width = 0;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        boolean bl2 = false;
        if (inputStream != null) {
            try {
                properties.load(inputStream);
                screenx = Integer.parseInt(properties.getProperty("screenx", "0"));
                screeny = Integer.parseInt(properties.getProperty("screeny", "0"));
                if (screenx < 0 || screeny < 0 || screenx > dimension.width || screeny > dimension.height) {
                    bl2 = true;
                }
                height = Integer.parseInt(properties.getProperty("height", "0"));
                width = Integer.parseInt(properties.getProperty("width", "0"));
                if (height < 0 || width < 0) {
                    height = 0;
                    width = 0;
                    bl2 = true;
                }
            }
            catch (IOException iOException) {
                ErrorManagement.handleException("Error loading display properties.", iOException);
                bl2 = true;
            }
        } else {
            bl2 = true;
        }
        if (bl2) {
            if (height == 0 || width == 0) {
                height = dimension.height / 2;
                width = dimension.width / 2;
            }
            screenx = (dimension.width - width) / 2;
            screeny = (dimension.height - height) / 2;
            properties.setProperty("screenx", Integer.toString(screenx));
            properties.setProperty("screeny", Integer.toString(screeny));
            properties.setProperty("height", Integer.toString(height));
            properties.setProperty("width", Integer.toString(width));
        }
        displayProperty = properties;
    }

    public static void setDebugging(boolean bl) {
        debugging = "1.0.2".indexOf("pre") != -1 || bl;
    }

    public static void setDisplayConfiguration(String string, String string2) {
        displayProperty.setProperty(string, string2);
    }

    public static void setAuxConfiguration(String string, String string2) {
        if (mAuxProps == null) {
            mAuxProps = new Properties();
        }
        mAuxProps.setProperty(string, string2);
    }

    public static String queryAuxConfiguration(String string, String string2) {
        if (mAuxProps == null) {
            return string2;
        }
        return mAuxProps.getProperty(string, string2);
    }

    public static String queryDisplayProperty(String string) {
        return displayProperty.getProperty(string, null);
    }

    public static String queryDisplayProperty(String string, String string2) {
        String string3 = JConfig.queryDisplayProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public static void setConfiguration(String string, String string2) {
        _anyUpdates = true;
        soleProperty.setProperty(string, string2);
    }

    public static String queryConfiguration(String string, String string2) {
        String string3 = JConfig.queryConfiguration(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public static String queryConfiguration(String string) {
        return soleProperty.getProperty(string, null);
    }

    public static List getAllKeys() {
        ArrayList<Object> arrayList = new ArrayList<Object>(soleProperty.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    public static List getMatching(String string) {
        Set<Object> set = soleProperty.keySet();
        ArrayList<String> arrayList = null;
        int n = string.length();
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(string2.substring(n));
        }
        return arrayList;
    }

    static {
        mAuxProps = null;
        curRuntime = Runtime.getRuntime();
        _configFileName = null;
        debugging = true;
        _listeners = new Vector();
        _anyUpdates = false;
    }

    public static interface ConfigListener {
        public void updateConfiguration();
    }
}

