/*
 * Decompiled with CFR 0.152.
 */
import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJPrefsHandler;
import com.apple.mrj.MRJQuitHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class JBidWatch
implements JConfig.ConfigListener,
MessageQueue.Listener {
    private static ClassLoader urlCL = (class$JBidWatch == null ? (class$JBidWatch = JBidWatch.class$("JBidWatch")) : class$JBidWatch).getClassLoader();
    private SimpleProxy sp;
    private static ArrayList gcSafe = new ArrayList();
    private JFrame mainFrame;
    private boolean _linkUp = true;
    private boolean _userValid;
    private JLabel _headerStatus;
    private JPanel _bidBarPanel;
    private JBidMenuBar _bidMenu;
    private JLabel _statusBar;
    private static final int SELECT_BOX_SIZE = 20;
    private JTextField selectBox = new JTextField(20);
    private TimerHandler itemUpdateTimer;
    private TimerHandler searchTimer;
    private JTabManager jtmAuctions;
    private AuctionsManager aucManager;
    private SearchManager searchManager;
    private TimeQueueManager m_tqm = new TimeQueueManager();
    private static String _cfgLoad = "JBidWatch.cfg";
    private RuntimeInfo _rti = null;
    private static final int HOURS_IN_DAY = 24;
    private static final int MINUTES_IN_HOUR = 60;
    private static final int ONE_SECOND = 1000;
    private static final int ONEK = 1024;
    private AudioPlayer m_ap = null;
    private static final String HEADER_MSG = "HEADER ";
    private static final String SNIPE_ALTERED_MSG = "SNIPECHANGED";
    private static final String QUIT_MSG = "QUIT";
    private static final String LINK_MSG = "LINK ";
    private static final String ERROR_MSG = "ERROR ";
    private static final String VISIBILITY_MSG = "VISIBILITY";
    private static final String NEWVERSION_MSG = "NEWVERSION";
    private static final String NO_NEWVERSION_MSG = "NO_NEWVERSION";
    private static final String BAD_NEWVERSION_MSG = "BAD_NEWVERSION";
    private static final String ALERT_MSG = "ALERT ";
    private static final String NOTIFY_MSG = "NOTIFY ";
    private static final String HIDE_MSG = "HIDE";
    private static final String RESTORE_MSG = "RESTORE";
    private static final String IGNORABLE_MSG = "IGNORE ";
    private static final String INVALID_LOGIN_MSG = "INVALID LOGIN";
    private static final String VALID_LOGIN_MSG = "VALID LOGIN";
    private static final String START_UPDATING = "ALLOW_UPDATES";
    private static final int UPDATE_FRAME_WIDTH = 512;
    private static final int UPDATE_FRAME_HEIGHT = 350;
    private Date now = new Date();
    private Calendar cal = new GregorianCalendar();
    static long lastTime = 0L;
    static /* synthetic */ Class class$JBidWatch;
    static /* synthetic */ Class class$JBidProxy;

    public void setLinkUp(boolean bl) {
        this._linkUp = bl;
    }

    public boolean getLinkUp() {
        return this._linkUp;
    }

    public void messageAction(Object object) {
        String string = (String)object;
        if (string.startsWith(HEADER_MSG)) {
            this._headerStatus.setText(string.substring(HEADER_MSG.length()));
            FilterManager.getInstance().check();
        } else if (string.startsWith(LINK_MSG)) {
            String string2 = string.substring(LINK_MSG.length());
            if (!gcSafe.isEmpty()) {
                this.setLinkUp(string2.startsWith("UP"));
                String string3 = string2.substring(string2.startsWith("UP") ? 2 : 4);
                if (string3.length() == 0) {
                    if (this._userValid) {
                        this._headerStatus.setToolTipText("");
                    }
                } else {
                    string3 = string3.substring(1);
                    if (this._userValid) {
                        this._headerStatus.setToolTipText(string3);
                    }
                }
            }
        } else if (string.equals(QUIT_MSG)) {
            this.shutdown();
        } else if (string.equals(VISIBILITY_MSG)) {
            this.mainFrame.setVisible(!this.mainFrame.isVisible());
            MQFactory.getConcrete("tray").enqueue(this.mainFrame.isVisible() ? "RESTORED" : "HIDDEN");
            if (this.mainFrame.isVisible()) {
                this.mainFrame.setState(0);
            }
        } else if (string.equals(HIDE_MSG)) {
            if (this.mainFrame.isVisible()) {
                JConfig.snapshotDisplay(this.mainFrame);
            }
            this.mainFrame.setVisible(false);
            if (Platform.isTrayEnabled()) {
                MQFactory.getConcrete("tray").enqueue("HIDDEN");
            }
        } else if (string.equals(RESTORE_MSG)) {
            this.mainFrame.setVisible(true);
            if (Platform.isTrayEnabled()) {
                MQFactory.getConcrete("tray").enqueue("RESTORED");
            }
            this.mainFrame.setState(0);
        } else if (string.equals(SNIPE_ALTERED_MSG)) {
            if (Platform.isTrayEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("TOOLTIP ");
                AuctionServer.AuctionStats auctionStats = AuctionServerManager.getInstance().getDefaultServer().getStats();
                if (auctionStats.getSnipes() != 0) {
                    stringBuffer.append("Next Snipe at: ").append(Constants.remoteClockFormat.format(auctionStats.getNextSnipe().getSnipeDate())).append('\n');
                    stringBuffer.append(auctionStats.getSnipes()).append(" snipes outstanding\n");
                }
                if (auctionStats.getCompleted() != 0) {
                    stringBuffer.append(auctionStats.getCompleted()).append(" auctions completed\n");
                }
                stringBuffer.append(auctionStats.getCount()).append(" auctions total");
                MQFactory.getConcrete("tray").enqueue(stringBuffer.toString());
            }
        } else if (string.startsWith(ALERT_MSG)) {
            JOptionPane.showMessageDialog(null, string.substring(ALERT_MSG.length()), "Alert", -1);
        } else if (string.startsWith(NOTIFY_MSG)) {
            if (Platform.isTrayEnabled()) {
                MQFactory.getConcrete("tray").enqueue(string);
            } else {
                MQFactory.getConcrete("Swing").enqueue(string.substring(NOTIFY_MSG.length()));
            }
        } else if (string.startsWith(IGNORABLE_MSG)) {
            String string4 = string.substring(IGNORABLE_MSG.length());
            int n = string4.indexOf(32);
            String string5 = string4.substring(n + 1);
            string4 = string4.substring(0, n);
            OptionUI optionUI = new OptionUI();
            optionUI.promptWithCheckbox(null, string5, "Alert", string4, -1, 0);
        } else if (string.startsWith(ERROR_MSG)) {
            JOptionPane.showMessageDialog(null, string.substring(ERROR_MSG.length()), "An error occurred", -1);
        } else if (string.equals(NEWVERSION_MSG)) {
            JBidWatch.announceNewVersion();
        } else if (string.startsWith(INVALID_LOGIN_MSG)) {
            this._userValid = false;
            String string6 = string.substring(INVALID_LOGIN_MSG.length());
            if (string6.length() != 0) {
                string6 = string6.substring(1);
                this._headerStatus.setToolTipText(string6);
            }
        } else if (string.equals(START_UPDATING)) {
            MQFactory.getConcrete("Swing").enqueue(SNIPE_ALTERED_MSG);
            if (this.itemUpdateTimer == null) {
                this.itemUpdateTimer = new TimerHandler(this.aucManager);
                this.itemUpdateTimer.setName("Updates");
                this.itemUpdateTimer.start();
            }
            if (this.searchTimer == null) {
                this.searchTimer = new TimerHandler(this.searchManager, 60000L);
                this.searchTimer.setName("Searches");
                this.searchTimer.start();
            }
            if (!this._userValid) {
                String string7 = ALERT_MSG;
                String string8 = "Swing";
                if (Platform.isTrayEnabled()) {
                    string7 = NOTIFY_MSG;
                    string8 = "tray";
                }
                MQFactory.getConcrete(string8).enqueue(string7 + "Not yet logged in.  Snipes will not fire until logging in\n" + "is successful.  Item updating has been enabled, but any\n" + "features that rely on being logged in will not work.");
            }
        } else if (string.equals(VALID_LOGIN_MSG)) {
            MQFactory.getConcrete("Swing").enqueue(SNIPE_ALTERED_MSG);
            this._userValid = true;
            this._headerStatus.setToolTipText("");
            if (this.itemUpdateTimer == null) {
                this.itemUpdateTimer = new TimerHandler(this.aucManager);
                this.itemUpdateTimer.setName("Updates");
                this.itemUpdateTimer.start();
            }
            if (this.searchTimer == null) {
                this.searchTimer = new TimerHandler(this.searchManager, 60000L);
                this.searchTimer.setName("Searches");
                this.searchTimer.start();
            }
        } else if (string.equals(NO_NEWVERSION_MSG)) {
            JOptionPane.showMessageDialog(null, "No new version available yet.\nKeep checking back!", "No new version", -1);
        } else if (string.equals(BAD_NEWVERSION_MSG)) {
            JOptionPane.showMessageDialog(null, "Failed to check for a new version\nProbably a temporary network issue; try again in a little while.", "Version check failed", -1);
        } else if (string.equals("TOOLBAR")) {
            this._bidBarPanel.setVisible(!this._bidBarPanel.isVisible());
            JConfig.setConfiguration("display.toolbar", this._bidBarPanel.isVisible() ? "true" : "false");
            if (this._bidBarPanel.isVisible()) {
                this._headerStatus.setVisible(false);
                this._bidBarPanel.add((Component)this._headerStatus, "East");
                this._headerStatus.setVisible(true);
            } else if (!Platform.isMac()) {
                this._bidMenu.add(this._headerStatus);
            }
        } else {
            this.setStatus(string);
        }
    }

    private static void announceNewVersion() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Download");
        arrayList.add("Ignore");
        final UpdaterEntry updaterEntry = UpdateManager.getInstance().getUpdateInfo();
        StringBuffer stringBuffer = new StringBuffer(4096);
        stringBuffer.append("<html><body>There is a new version available!<br>The new version is <b>");
        stringBuffer.append(updaterEntry.getVersion());
        stringBuffer.append("</b><br>");
        stringBuffer.append("Upgrading is ");
        stringBuffer.append(updaterEntry.getSeverity());
        stringBuffer.append("<br>The URL is <a href=\"");
        stringBuffer.append(updaterEntry.getURL());
        stringBuffer.append("\">");
        stringBuffer.append(updaterEntry.getURL());
        stringBuffer.append("</a><br><br>");
        stringBuffer.append(updaterEntry.getDescription()).append("</body></html>");
        MyActionListener myActionListener = new MyActionListener(){
            private final String go_to;
            {
                this.go_to = updaterEntry.getURL();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Download")) {
                    MQFactory.getConcrete("browse").enqueue(this.go_to);
                }
                this.m_within.dispose();
                this.m_within = null;
            }
        };
        OptionUI optionUI = new OptionUI();
        JFrame jFrame = optionUI.showChoiceTextDisplay(new JHTMLOutput("Version " + updaterEntry.getVersion() + " available!", stringBuffer).getStringBuffer(), new Dimension(512, 350), "Version " + updaterEntry.getVersion() + " available!", arrayList, "Upgrade information", myActionListener);
        myActionListener.setFrame(jFrame);
    }

    private void setStatus(String string) {
        Object object;
        this.now.setTime(System.currentTimeMillis());
        String string2 = AuctionServerManager.getInstance().getDefaultServerTime();
        String string3 = " [" + string2 + '/' + Constants.localClockFormat.format(this.now) + ']';
        if (JConfig.queryConfiguration("timesync.enabled", "true").equals("false") && (object = AuctionServerManager.getInstance().getDefaultServer().getOfficialServerTimeZone()) != null && ((TimeZone)object).hasSameRules(this.cal.getTimeZone())) {
            string3 = " [" + Constants.localClockFormat.format(this.now) + ']';
        }
        object = string + string3;
        if (this._statusBar != null) {
            this._statusBar.setText("<html><body>" + (String)object + "</body></html>");
            this._statusBar.paintImmediately(this._statusBar.getVisibleRect());
        } else {
            ErrorManagement.logDebug(string + string3);
        }
    }

    private static String makeSaveDirectory(String string) {
        return JBidWatch.makeStandardDirectory(string, "auctionsave", "jbidwatcher");
    }

    private static String makePlatformDirectory(String string) {
        return JBidWatch.makeStandardDirectory(string, "platform", "jbidwatcher");
    }

    private static String makeStandardDirectory(String string, String string2, String string3) {
        Object object;
        String string4 = string;
        if (string4 != null && !((File)(object = new File(string4))).exists() && !((File)object).mkdirs()) {
            string4 = null;
        }
        if (string4 == null) {
            object = JConfig.getCanonicalFile(string2, string3, false);
            File file = new File((String)object);
            if (file.exists()) {
                string4 = file.getAbsolutePath();
            } else {
                file.mkdirs();
                string4 = file.getAbsolutePath();
            }
        }
        return string4;
    }

    private static void getUserSetup() {
        JConfig.setConfiguration("config.firstrun", "true");
        JConfigFrame jConfigFrame = new JConfigFrame();
        jConfigFrame.spinWait();
    }

    private static InputStream checkConfig(String string) {
        JConfig.setConfigurationFile(string);
        return JConfig.bestSource(urlCL, string);
    }

    private static void loadConfig(InputStream inputStream) {
        String string;
        JConfig.load(inputStream);
        Platform.setupMacUI();
        JConfig.loadDisplayConfig(urlCL);
        String string2 = JBidWatch.makeSaveDirectory(JConfig.queryConfiguration("auctions.savepath"));
        if (string2 != null) {
            JConfig.setConfiguration("auctions.savepath", string2);
        }
        if ((string = JBidWatch.makePlatformDirectory(JConfig.queryConfiguration("platform.path"))) != null) {
            JConfig.setConfiguration("platform.path", string);
            if (Platform.isWindows() && Platform.extractAndLoadLibrary()) {
                Platform.setTrayEnabled(true);
            }
        }
    }

    private static boolean CheckHelp(String[] stringArray) {
        if (stringArray.length != 0 && (stringArray[0].startsWith("--help") || stringArray[0].startsWith("-h"))) {
            System.out.println("usage: java JBidWatch [{cfg-file}]");
            JOptionPane.showMessageDialog(null, "<html><body>usage:<br><center>java JBidWatch [{cfg-file}]</center><br>Default user home: " + System.getProperty("user.home") + "</body></html>", "Help display", -1);
            return true;
        }
        return false;
    }

    private static boolean EstablishProxy(Properties properties) {
        String string = JConfig.queryConfiguration("proxy.host", null);
        String string2 = JConfig.queryConfiguration("proxy.port", null);
        if (JConfig.queryConfiguration("proxyfirewall", "none").equals("proxy") && string != null && string2 != null) {
            properties.setProperty("http.proxySet", "true");
            properties.setProperty("http.proxyHost", string);
            properties.setProperty("http.proxyPort", string2);
            properties.setProperty("proxySet", "true");
            properties.setProperty("proxyHost", string);
            properties.setProperty("proxyPort", string2);
            return true;
        }
        return false;
    }

    private static boolean EstablishHTTPSProxy(Properties properties) {
        if (JConfig.queryConfiguration("proxy.https.set", "false").equals("true")) {
            String string = JConfig.queryConfiguration("proxy.https.host");
            String string2 = JConfig.queryConfiguration("proxy.https.port");
            if (string != null && string2 != null) {
                properties.setProperty("https.proxySet", "true");
                properties.setProperty("https.proxyHost", string);
                properties.setProperty("https.proxyPort", string2);
                return true;
            }
        }
        return false;
    }

    private static boolean EstablishFirewall(Properties properties) {
        if (JConfig.queryConfiguration("proxyfirewall", "none").equals("firewall")) {
            String string = JConfig.queryConfiguration("firewall.host", null);
            String string2 = JConfig.queryConfiguration("firewall.port", "1080");
            if (string != null) {
                properties.setProperty("socksProxyHost", string);
                properties.setProperty("socksProxyPort", string2);
                return true;
            }
        }
        return false;
    }

    private static void setUI(String string, JFrame jFrame, UIManager.LookAndFeelInfo[] lookAndFeelInfoArray) {
        String string2 = null;
        if (string != null) {
            for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
                if (!string.equals(lookAndFeelInfoArray[i].getName())) continue;
                string2 = lookAndFeelInfoArray[i].getClassName();
            }
        }
        if (string2 == null && (string2 = System.getProperty("swing.defaultlaf")) == null) {
            string2 = UIManager.getSystemLookAndFeelClassName();
        }
        Platform.checkLaF(string2);
        try {
            UIManager.setLookAndFeel(string2);
            if (jFrame != null) {
                SwingUtilities.updateComponentTreeUI(jFrame);
            }
        }
        catch (Exception exception) {
            ErrorManagement.handleException("Exception in setUI, failure to set " + string2 + ": " + exception, exception);
        }
    }

    public static void main(String[] stringArray) {
        URL uRL;
        Object object;
        boolean bl;
        boolean bl2;
        if (JBidWatch.CheckHelp(stringArray)) {
            System.exit(0);
        }
        System.setProperty("sun.net.client.defaultConnectTimeout", "5000");
        System.setProperty("sun.net.client.defaultReadTimeout", "15000");
        if (stringArray.length != 0 && stringArray[0].charAt(0) != '-') {
            _cfgLoad = stringArray[0];
        }
        _cfgLoad = JConfig.getCanonicalFile(_cfgLoad, "jbidwatcher", false);
        boolean bl3 = false;
        InputStream inputStream = JBidWatch.checkConfig(_cfgLoad);
        boolean bl4 = bl2 = inputStream == null;
        if (bl2) {
            JBidWatch.setUI(null, null, UIManager.getInstalledLookAndFeels());
            AuctionServerManager.getInstance().addServer("ebay", new ebayServer());
            bl3 = true;
            Platform.setupMacUI();
            JConfig.setConfiguration("first.run", "true");
            bl = true;
            JBidWatch.getUserSetup();
            inputStream = JBidWatch.checkConfig(_cfgLoad);
        } else {
            JConfig.setConfiguration("first.run", "false");
            bl = false;
        }
        JBidWatch.loadConfig(inputStream);
        JConfig.setConfiguration("first.run", bl ? "true" : "false");
        if (stringArray.length > 0 && stringArray[0] != null && stringArray[0].equals("-transform")) {
            object = stringArray.length == 1 || stringArray[1] == null ? JConfig.getCanonicalFile("auctions.html", "jbidwatcher", false) : stringArray[1];
            JTransformer.outputHTML(JConfig.queryConfiguration("savefile", "auctions.xml"), (String)object);
            System.exit(0);
        }
        JBidWatch.setUI(null, null, UIManager.getInstalledLookAndFeels());
        if (!bl3) {
            AuctionServerManager.getInstance().addServer("ebay", new ebayServer());
        }
        JBidWatch.loadProxySettings();
        if (JConfig.queryConfiguration("show.badhtml", "false").equals("true")) {
            XMLElement.rejectBadHTML(true);
        }
        object = Calendar.getInstance();
        int n = ((Calendar)object).get(2);
        int n2 = ((Calendar)object).get(5);
        if (n2 == 1 && n == 3 && !JConfig.queryConfiguration("sniperkitty", "false").equals("true")) {
            uRL = urlCL.getResource("jbidwatch_apr1.jpg");
            JConfig.setConfiguration("sniperkitty", "true");
        } else {
            uRL = urlCL.getResource(JConfig.queryConfiguration("splash", "jbidwatch.jpg"));
        }
        JSplashScreen jSplashScreen = new JSplashScreen(new ImageIcon(uRL));
        try {
            JBidWatch jBidWatch = new JBidWatch(jSplashScreen);
            gcSafe.add(jBidWatch);
            Thread.currentThread().join();
            jBidWatch.repaint();
        }
        catch (Exception exception) {
            ErrorManagement.handleException("JBidWatcher: " + exception, exception);
        }
    }

    private void repaint() {
        this.mainFrame.repaint();
    }

    private static void loadProxySettings() {
        boolean bl;
        Properties properties = System.getProperties();
        boolean bl2 = JBidWatch.EstablishProxy(properties);
        boolean bl3 = JBidWatch.EstablishFirewall(properties);
        boolean bl4 = JBidWatch.EstablishHTTPSProxy(properties);
        boolean bl5 = bl = bl2 || bl3 || bl4;
        if (bl) {
            System.setProperties(properties);
        }
    }

    public static Properties getColumnProperties() {
        Properties properties = new Properties();
        properties = FilterManager.getInstance().extractProperties(properties);
        return properties;
    }

    public void shutdown() {
        OptionUI optionUI;
        int n;
        if (AuctionsManager.getInstance().anySnipes() && (n = (optionUI = new OptionUI()).promptWithCheckbox(null, "There are outstanding snipes that will not be able to fire while JBidWatcher is not running.  Are you sure you want to quit?", "Pending Snipes confirmation", "prompt.snipe_quit")) == 2) {
            return;
        }
        this.internal_shutdown();
    }

    public Point getOrigin() {
        return this.mainFrame.getLocationOnScreen();
    }

    public void internal_shutdown() {
        Properties properties = JBidWatch.getColumnProperties();
        SearchManager.getInstance().saveSearchDisplay();
        JConfig.saveDisplayConfig(this.mainFrame, properties);
        String string = _cfgLoad.equals("JBidWatch.cfg") ? JConfig.getCanonicalFile(_cfgLoad, "jbidwatcher", false) : _cfgLoad;
        AuctionsManager.getInstance().saveAuctions();
        SearchManager.getInstance().saveSearches();
        AuctionServer.AuctionStats auctionStats = AuctionServerManager.getInstance().getDefaultServer().getStats();
        JConfig.setConfiguration("last.auctioncount", Integer.toString(auctionStats.getCount()));
        JConfig.saveConfiguration(string);
        System.exit(0);
    }

    private void checkClock() {
        if (lastTime != 0L && lastTime + 60000L < System.currentTimeMillis()) {
            ErrorManagement.logDebug("We appear to be waking from sleep...  Networking is probably not up yet.");
            if (AuctionsManager.getInstance().anySnipes()) {
                ErrorManagement.logDebug("There were snipes outstanding; hopefully none were supposed to fire during the sleep period...");
            }
            this.m_tqm.add(new AuctionQObject(4, "Update login cookie", null), "ebay", System.currentTimeMillis() + 10000L);
        }
        lastTime = System.currentTimeMillis();
        String string = AuctionServerManager.getInstance().getDefaultServerTime();
        if (!this._userValid) {
            string = "Not logged in...";
        }
        String string2 = this._linkUp ? string : "<html><strike>" + string + "</strike></html>";
        MQFactory.getConcrete("Swing").enqueue(HEADER_MSG + string2);
    }

    private static void addbutton(JToolBar jToolBar, ActionListener actionListener, String string, String string2, String string3) {
        JButton jButton = JBidWatch.makeButton(string2, string3, string, actionListener, false);
        jToolBar.add(jButton);
    }

    public static JButton makeButton(String string, String string2, String string3, ActionListener actionListener, boolean bl) {
        JButton jButton = new JButton();
        ImageIcon imageIcon = new ImageIcon((class$JBidWatch == null ? (class$JBidWatch = JBidWatch.class$("JBidWatch")) : class$JBidWatch).getResource(string));
        jButton.setIcon(imageIcon);
        if (bl) {
            Dimension dimension = new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight());
            jButton.setSize(dimension);
            jButton.setMaximumSize(dimension);
            jButton.setMinimumSize(dimension);
            jButton.setPreferredSize(dimension);
        }
        jButton.setToolTipText(string2);
        jButton.setActionCommand("BT-" + string3);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    private JPanel buildHeaderBar(JFrame jFrame, ActionListener actionListener) {
        this._bidBarPanel = new JPanel(new BorderLayout());
        this._bidMenu = JBidMenuBar.getInstance(actionListener, "JBidwatcher");
        this._headerStatus = new JLabel("", 4);
        jFrame.setJMenuBar(this._bidMenu);
        AuctionServerManager.getInstance().addAuctionServerMenus();
        this._bidMenu.add(Box.createHorizontalGlue());
        JToolBar jToolBar = new JToolBar();
        this._bidBarPanel.setBorder(BorderFactory.createEtchedBorder());
        this._bidBarPanel.add((Component)this._headerStatus, "East");
        JBidWatch.addbutton(jToolBar, actionListener, "Add", "icons/add_auction.gif", "Add auction");
        JBidWatch.addbutton(jToolBar, actionListener, "Delete", "icons/delete.gif", "Delete Auction");
        JBidWatch.addbutton(jToolBar, actionListener, "Search", "icons/find.gif", "Auction Search Manager");
        JBidWatch.addbutton(jToolBar, actionListener, "Information", "icons/information.gif", "Get information");
        JBidWatch.addbutton(jToolBar, actionListener, "UpdateAll", "icons/updateall.gif", "Update All Auctions");
        JBidWatch.addbutton(jToolBar, actionListener, "StopUpdating", "icons/stopupdating.gif", "Stop Updating Auctions");
        JBidWatch.addbutton(jToolBar, actionListener, "Configure", "icons/configuration.gif", "Configure");
        JBidWatch.addbutton(jToolBar, actionListener, "Save", "icons/save.gif", "Save Auctions");
        JBidWatch.addbutton(jToolBar, actionListener, "Help", "icons/help.gif", "Help");
        JBidWatch.addbutton(jToolBar, actionListener, "About", "icons/about.gif", "About JBidWatcher");
        if (JConfig.queryConfiguration("toolbar.floater", "false").equals("false")) {
            jToolBar.setFloatable(false);
        }
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void removeUpdate(DocumentEvent documentEvent) {
            }
        };
        JConfigTab.adjustField(this.selectBox, "Search and select items from the current table.", documentListener);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBidWatch.this.jtmAuctions.selectBySearch(JBidWatch.this.selectBox.getText());
            }
        };
        this.selectBox.addActionListener(actionListener2);
        JPanel jPanel = new JPanel();
        jPanel.add(JConfigTab.makeLine(new JLabel(" Select: "), this.selectBox));
        jToolBar.add(JConfigTab.panelPack(jPanel));
        this._bidBarPanel.add((Component)jToolBar, "West");
        this._bidBarPanel.setVisible(JConfig.queryConfiguration("display.toolbar", "true").equals("true"));
        return this._bidBarPanel;
    }

    public final void updateConfiguration() {
        int n = Integer.parseInt(JConfig.queryConfiguration("server.port", "9099"));
        String string = JConfig.queryConfiguration("background", "false");
        if (!string.equals("false")) {
            FilterManager.getInstance().setBackground(Color.decode('#' + string));
        }
        if (JConfig.queryConfiguration("server.enabled", "false").equals("true")) {
            if (this.sp == null) {
                this.sp = new SimpleProxy(n, class$JBidProxy == null ? (class$JBidProxy = JBidWatch.class$("JBidProxy")) : class$JBidProxy, null);
            }
            this.sp.go();
        } else if (this.sp != null) {
            this.sp.halt();
        }
        JBidWatch.loadProxySettings();
        if (JConfig.queryConfiguration("debug.memory", "false").equals("true")) {
            if (this._rti == null) {
                this._rti = new RuntimeInfo();
            } else {
                this._rti.setVisible(true);
            }
        } else if (this._rti != null) {
            this._rti.setVisible(false);
        }
        MQFactory.getConcrete("ebay").enqueue(new AuctionQObject(7, "Reload the strings.", null));
    }

    private JFrame buildFrame() {
        JBidFrameMouse jBidFrameMouse = new JBidFrameMouse();
        this._statusBar = new JLabel("Ready!", 2);
        class JFriendlyFrame
        extends JFrame
        implements MRJQuitHandler,
        MRJAboutHandler,
        MRJPrefsHandler {
            JFriendlyFrame(String string) {
                super(string);
                MRJApplicationUtils.registerQuitHandler(this);
                MRJApplicationUtils.registerAboutHandler(this);
                MRJApplicationUtils.registerPrefsHandler(this);
            }

            public void handleQuit() {
                if (!JConfig.queryConfiguration("prompt.snipe_quit", "false").equals("true") && AuctionsManager.getInstance().anySnipes()) {
                    MQFactory.getConcrete("Swing").enqueue(JBidWatch.QUIT_MSG);
                    throw new IllegalStateException("Ne changez pas mains, il viendra bient\ufffdt.");
                }
                JBidWatch.this.internal_shutdown();
            }

            public void handleAbout() {
                MQFactory.getConcrete("user").enqueue("About");
            }

            public void handlePrefs() {
                MQFactory.getConcrete("user").enqueue("Configure");
            }

            public synchronized void addWindowListener(WindowListener windowListener) {
                super.removeWindowListener(windowListener);
                super.addWindowListener(windowListener);
            }
        }
        JFriendlyFrame jFriendlyFrame = new JFriendlyFrame("JBidwatcher");
        jFriendlyFrame.addMouseListener(jBidFrameMouse);
        jFriendlyFrame.setDefaultCloseOperation(0);
        URL uRL = urlCL.getResource(JConfig.queryConfiguration("icon", "jbidwatch64.jpg"));
        jFriendlyFrame.setIconImage(new ImageIcon(uRL).getImage());
        this.jtmAuctions = AuctionsUIModel.getTabManager();
        JPanel jPanel = this.buildHeaderBar(jFriendlyFrame, this.jtmAuctions);
        jFriendlyFrame.getContentPane().add(this.jtmAuctions.getTabs());
        jFriendlyFrame.getContentPane().add((Component)this._statusBar, "South");
        jFriendlyFrame.getContentPane().add((Component)jPanel, "North");
        jFriendlyFrame.pack();
        jFriendlyFrame.addWindowListener(new WindowAdapter(){

            public void windowIconified(WindowEvent windowEvent) {
                super.windowIconified(windowEvent);
                if (Platform.isWindows() && Platform.isTrayEnabled() && JConfig.queryConfiguration("windows.tray", "true").equals("true") && JConfig.queryConfiguration("windows.minimize", "true").equals("true")) {
                    MQFactory.getConcrete("Swing").enqueue(JBidWatch.HIDE_MSG);
                }
            }

            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                MQFactory.getConcrete("Swing").enqueue(JBidWatch.QUIT_MSG);
            }
        });
        return jFriendlyFrame;
    }

    private JBidWatch(JSplashScreen jSplashScreen) {
        ThumbnailManager.getInstance();
        FilterManager.getInstance().loadFilters();
        this.aucManager = AuctionsManager.getInstance();
        this.aucManager.loadAuctions(jSplashScreen);
        this.searchManager = SearchManager.getInstance();
        this.searchManager.loadSearches();
        AuctionServerManager.getInstance().getDefaultServerTime();
        JConfig.registerListener(this);
        MQFactory.addQueue("Swing", new SwingMessageQueue());
        MQFactory.getConcrete("Swing").registerListener(this);
        String string = AuctionServerManager.getInstance().getDefaultServer().getName();
        MQFactory.getConcrete(string).enqueue(new AuctionQObject(4, "Update login cookie", null));
        gcSafe.add(new JBWDropHandler());
        gcSafe.add(new JBConfig());
        this.mainFrame = this.buildFrame();
        this.mainFrame.setLocation(JConfig.screenx, JConfig.screeny);
        this.mainFrame.setSize(JConfig.width, JConfig.height);
        jSplashScreen.close();
        jSplashScreen = null;
        this.mainFrame.setVisible(true);
        if (Platform.isWindows()) {
            gcSafe.add(new Tray());
            if (JConfig.queryConfiguration("windows.tray", "true").equals("true")) {
                MQFactory.getConcrete("tray").enqueue("TRAY on");
            }
        }
        this.updateConfiguration();
        long l = System.currentTimeMillis();
        if (JConfig.queryConfiguration("updates.enabled", "true").equals("true")) {
            this.m_tqm.add("CHECK", "update", l + 10000L);
        }
        if (JConfig.queryConfiguration("timesync.enabled", "true").equals("true")) {
            this.m_tqm.add("TIMECHECK", "auction_manager", l + 2000L, 1800000L);
        }
        this.m_tqm.add(new AuctionQObject(4, "Update login cookie", null), "ebay", l + 3000L, 0x6DDD00L);
        this.m_tqm.add(START_UPDATING, "Swing", l + 20000L);
        TimerHandler timerHandler = new TimerHandler(this.m_tqm);
        timerHandler.setName("SuperQueue");
        timerHandler.start();
        gcSafe.add(timerHandler);
        TimerHandler timerHandler2 = new TimerHandler(UpdateManager.getInstance(), 86400000L);
        timerHandler2.setName("VersionChecker");
        timerHandler2.start();
        gcSafe.add(timerHandler2);
        TimerHandler timerHandler3 = new TimerHandler(new TimerHandler.WakeupProcess(){

            public boolean check() {
                JBidWatch.this.checkClock();
                return true;
            }
        });
        timerHandler3.setName("Clock");
        timerHandler3.start();
        gcSafe.add(timerHandler3);
        this.m_ap = new AudioPlayer();
        if (JConfig.queryConfiguration("debug.memory", "false").equals("true")) {
            this._rti = new RuntimeInfo();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

