/*
 * Decompiled with CFR 0.152.
 */
import com.stevesoft.pat.Regex;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class JBidMouse
extends JBidContext
implements MessageQueue.Listener {
    private static JConfigFrame jcf = null;
    private static SearchFrame _searchFrame = null;
    private JDropListener _jdl = new JDropListener(null);
    private OptionUI _oui = new OptionUI();
    private RSSDialog _rssDialog = null;
    private static StringBuffer _colorHelp = null;
    private static StringBuffer _aboutText = null;
    private static StringBuffer _faqText = null;
    private boolean _in_deleting = false;
    private JMenu tabMenu = null;
    public static final String ADD_AUCTION = "ADD ";
    private static final String GET_SERVER_TIME = "GETTIME";
    private static final String SEARCH = "SEARCH";
    private static final String newRow = "<tr><td>";
    private static final String newCol = "</td><td>";
    private static final String endRow = "</td></tr>";
    private static final StringBuffer badAbout = new StringBuffer("Error loading About text!  (D'oh!)  Email <a href=\"mailto:cyberfox@users.sourceforge.net\">me</a>!");
    private static final StringBuffer badFAQ = new StringBuffer("Error loading FAQ text!  (D'oh!)  Email <a href=\"mailto:cyberfox@users.sourceforge.net\">me</a>!");
    private static JFrame aboutFrame = null;
    private static JFrame faqFrame = null;
    private static final int DO_COPY_URL = 0;
    private static final int DO_COPY_ID = 1;
    private static final int DO_COPY_DATA = 2;
    private static final StringBuffer badColors = new StringBuffer("Error loading Color help text!  (D'oh!)  Email <a href=\"mailto:cyberfox%40users.sourceforge.net\">me</a>!");
    private static JFrame helpFrame = null;

    public JBidMouse(JPopupMenu jPopupMenu) {
        super(jPopupMenu);
        this.buildMenu(jPopupMenu);
    }

    public JBidMouse() {
        this.buildMenu(this.localPopup);
        MQFactory.getConcrete("user").registerListener(this);
    }

    public static void setConfigFrame(JConfigFrame jConfigFrame) {
        if (jConfigFrame != null) {
            jcf = jConfigFrame;
        }
    }

    private AuctionEntry addAuction(String string) {
        AuctionEntry auctionEntry = AuctionsManager.getInstance().newAuctionEntry(string);
        if (auctionEntry != null && auctionEntry.isLoaded()) {
            auctionEntry.clearNeedsUpdate();
            AuctionsManager.getInstance().addEntry(auctionEntry);
            MQFactory.getConcrete("Swing").enqueue("Added [ " + auctionEntry.getTitle() + " ]");
            return auctionEntry;
        }
        if (auctionEntry != null) {
            AuctionServerManager.getInstance().delete_entry(auctionEntry);
        }
        return null;
    }

    public void messageAction(Object object) {
        String string = (String)object;
        if (string.startsWith(ADD_AUCTION)) {
            String string2 = string.substring(ADD_AUCTION.length());
            this.cmdAddAuction(string2);
        } else if (string.equals(GET_SERVER_TIME)) {
            AuctionServer.reloadTime();
        } else if (string.equals(SEARCH)) {
            this.DoSearch();
        } else if (string.equals("About")) {
            this.DoAbout();
        } else if (string.equals("FAQ")) {
            this.DoFAQ();
        } else if (string.equals("Configure")) {
            this.DoConfigure();
        }
    }

    private void cmdAddAuction(String string) {
        AuctionEntry auctionEntry;
        if (string.regionMatches(true, 0, "<html>", 0, 6)) {
            string = JHTML.getFirstContent(string);
        }
        if ((auctionEntry = this.addAuction(string = string.trim())) == null) {
            String string2;
            AuctionsManager auctionsManager = AuctionsManager.getInstance();
            if (auctionsManager.isDeleted(string2 = AuctionsManager.stripId(string))) {
                auctionsManager.undelete(string2);
                auctionEntry = this.addAuction(string);
            }
            if (auctionEntry == null) {
                if (auctionsManager.verifyEntry(string2)) {
                    MQFactory.getConcrete("Swing").enqueue("ERROR Cannot add auction " + string + ", it is already in your auction list.");
                } else {
                    MQFactory.getConcrete("Swing").enqueue("ERROR Cannot add auction " + string + ", either invalid or\ncommunication error talking to server.");
                }
            }
        }
    }

    protected boolean confirmDeletion(Component component, String string) {
        int n = JOptionPane.showOptionDialog(component, string, "Confirm", 2, -1, null, null, null);
        return n != 2 && n != -1;
    }

    private void DoHideShowToolbar() {
        MQFactory.getConcrete("Swing").enqueue("TOOLBAR");
    }

    private void DoSearch() {
        if (_searchFrame == null) {
            _searchFrame = new SearchFrame();
        } else {
            _searchFrame.show();
        }
    }

    private void DoShowLastError(Component component, AuctionEntry auctionEntry) {
        AuctionEntry auctionEntry2 = auctionEntry;
        int[] nArray = this.getPossibleRows();
        if (auctionEntry2 == null && nArray.length == 0 || nArray.length > 1) {
            JOptionPane.showMessageDialog(component, "You must select a single auction to view the error page for.", "Error view", -1);
            return;
        }
        if (auctionEntry2 == null) {
            auctionEntry2 = (AuctionEntry)this.getIndexedEntry(nArray[0]);
        }
        StringBuffer stringBuffer = auctionEntry2.getErrorPage();
        Dimension dimension = new Dimension(756, 444);
        this._oui.showTextDisplay(new JHTMLOutput("Error Page", stringBuffer).getStringBuffer(), dimension, "Error Page...");
    }

    private void DoDelete(Component component, AuctionEntry auctionEntry) {
        Dimension dimension;
        Object object;
        Object object2;
        int n;
        AuctionEntry auctionEntry2 = auctionEntry;
        if (this._in_deleting) {
            return;
        }
        this._in_deleting = true;
        Vector<AuctionEntry> vector = new Vector<AuctionEntry>();
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = this.getPossibleRows();
        if (auctionEntry2 == null && nArray.length == 0) {
            this._in_deleting = false;
            JOptionPane.showMessageDialog(component, "You must select an auction to delete.", "Delete error", -1);
            return;
        }
        if (nArray.length != 0 && nArray.length != 1) {
            stringBuffer.append("<table border=0 spacing=0 width=\"100%\">");
            stringBuffer.append("<tr><td><u><b>Item Number</b></u></td><td><u><b>Title</b></u></td></tr>");
            for (n = 0; n < nArray.length; ++n) {
                object2 = (AuctionEntry)this.getIndexedEntry(nArray[n]);
                vector.add((AuctionEntry)object2);
                object = "FFFFFF";
                if (n % 2 == 1) {
                    object = "C0C0C0";
                }
                stringBuffer.append("<tr><td bgcolor=#").append((String)object).append("><b>").append(((AuctionEntry)object2).getIdentifier()).append("</b></td><td bgcolor=#").append((String)object).append('>').append(((AuctionEntry)object2).getTitle()).append(endRow);
            }
            stringBuffer.append("</table>");
            dimension = new Dimension(756, Math.min(372, nArray.length * 30 + 30));
        } else {
            if (nArray.length == 1) {
                auctionEntry2 = (AuctionEntry)this.getIndexedEntry(nArray[0]);
            }
            if (auctionEntry2 == null) {
                throw new IllegalArgumentException();
            }
            stringBuffer.append("<table border=0 spacing=0 width=\"100%\"><tr><td><b>").append(auctionEntry2.getIdentifier()).append("</b></td><td>").append(auctionEntry2.getTitle()).append("</td></tr></table>");
            vector.add(auctionEntry2);
            dimension = new Dimension(756, 45);
        }
        if (JConfig.queryConfiguration("prompt.hide_delete_confirm", "false").equals("true")) {
            for (n = 0; n < vector.size(); ++n) {
                AuctionsManager.getInstance().delEntry((AuctionEntry)vector.get(n));
            }
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("TEXT Are you sure you want to delete these auctions: ");
            arrayList.add("Yes");
            arrayList.add("TEXT    ");
            arrayList.add("No, Cancel");
            arrayList.add("CHECK Don't prompt in the future.");
            object2 = new MyActionListener(){
                boolean m_dontprompt = false;

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("Don't prompt in the future.")) {
                        JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                        this.m_dontprompt = jCheckBox.isSelected();
                    } else {
                        if (string.equals("Yes")) {
                            for (int i = 0; i < this.m_entries.size(); ++i) {
                                AuctionsManager.getInstance().delEntry((AuctionEntry)this.m_entries.get(i));
                            }
                            if (this.m_dontprompt) {
                                JConfig.setConfiguration("prompt.hide_delete_confirm", "true");
                            }
                        }
                        this.m_within.dispose();
                        this.m_within = null;
                    }
                }
            };
            ((MyActionListener)object2).setEntries(vector);
            object = this._oui.showChoiceTextDisplay(new JHTMLOutput("Deleting", stringBuffer).getStringBuffer(), dimension, "Deleting...", arrayList, "Items to delete...", (ActionListener)object2);
            ((MyActionListener)object2).setFrame((JFrame)object);
        }
        this._in_deleting = false;
    }

    private void DoConfigure() {
        if (jcf == null) {
            jcf = new JConfigFrame();
        } else {
            jcf.show();
        }
    }

    private String getClipboardString() {
        String string;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        ErrorManagement.logDebug("Clipboard: " + clipboard.getName() + ", valid flavors: " + transferable.getTransferDataFlavors());
        StringBuffer stringBuffer = this._jdl.getTransferData(transferable);
        if (stringBuffer == null) {
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                string = null;
            }
        } else {
            string = stringBuffer.toString();
        }
        return string;
    }

    public static void setClipboardString(String string) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, stringSelection);
    }

    private void DoPasteFromClipboard() {
        String string;
        String string2 = string = this.getClipboardString();
        if (string.charAt(0) == '<' && ((string = JHTML.getFirstContent(string)).charAt(0) < '0' || string.charAt(0) > '9')) {
            Regex regex = new Regex("[0-9]+");
            regex.search(string);
            string = regex.stringMatched();
            if (string == null) {
                ErrorManagement.logDebug("Failed to paste auction id: " + string2);
            }
        }
        if (string != null) {
            MQFactory.getConcrete("user").enqueue(ADD_AUCTION + string);
        }
    }

    private String makeUsefulString(AuctionEntry auctionEntry) {
        String string = auctionEntry.isSeller() ? auctionEntry.getHighBidder() : auctionEntry.getSeller();
        string = string + "  " + auctionEntry.getIdentifier() + "  " + auctionEntry.getCurBid() + " (" + auctionEntry.getTitle() + ")\n";
        return string;
    }

    private void DoCopy(Component component, AuctionEntry auctionEntry) {
        this.DoCopySomething(component, auctionEntry, 2, "No auctions selected to copy!", "");
    }

    Currency getBestBidValue(AuctionEntry auctionEntry) {
        Currency currency = !auctionEntry.isSniped() ? (auctionEntry.isBidOn() && !auctionEntry.isEnded() ? auctionEntry.getBid() : auctionEntry.getCurBid()) : auctionEntry.getSnipeBid();
        return currency;
    }

    protected String sum(int[] nArray) {
        boolean bl = false;
        boolean bl2 = true;
        Currency currency = null;
        Currency currency2 = null;
        for (int i = 0; i < nArray.length; ++i) {
            try {
                AuctionEntry auctionEntry = (AuctionEntry)this.getIndexedEntry(nArray[i]);
                if (currency == null) {
                    currency = auctionEntry.getUSCurBid();
                    currency2 = this.getBestBidValue(auctionEntry);
                } else {
                    Currency currency3 = auctionEntry.getUSCurBid();
                    currency = currency.add(currency3);
                    if (bl2) {
                        try {
                            currency2 = currency2.add(this.getBestBidValue(auctionEntry));
                        }
                        catch (Currency.CurrencyTypeException currencyTypeException) {
                            bl2 = false;
                        }
                    }
                }
                if (auctionEntry.getCurBid().getCurrencyType() == 1) continue;
                bl = true;
                continue;
            }
            catch (Exception exception) {
                ErrorManagement.handleException("Sum currency exception!", exception);
                return "<unknown>";
            }
        }
        if (currency == null) {
            return "<unknown>";
        }
        if (bl2 && currency2 != null) {
            return currency2.toString();
        }
        if (bl) {
            return "Approximately " + currency.toString();
        }
        return currency.toString();
    }

    private void DoSendTo(String string) {
        AuctionEntry auctionEntry;
        int n;
        int[] nArray = this.getPossibleRows();
        if (nArray.length == 0) {
            JOptionPane.showMessageDialog(null, "No auctions selected to move!", "Error moving listings", -1);
            return;
        }
        if (FilterManager.getInstance().findCategory(string) == null) {
            JOptionPane.showMessageDialog(null, "Cannot locate that tab, something has gone wrong.\nClose and restart JBidwatcher.", "Error moving listings", -1);
            return;
        }
        Vector<AuctionEntry> vector = new Vector<AuctionEntry>(nArray.length);
        for (n = 0; n < nArray.length; ++n) {
            auctionEntry = (AuctionEntry)this.getIndexedEntry(nArray[n]);
            vector.add(auctionEntry);
        }
        for (n = 0; n < vector.size(); ++n) {
            auctionEntry = (AuctionEntry)vector.get(n);
            auctionEntry.setCategory(string);
            FilterManager.getInstance().refilterAuction(auctionEntry, true);
        }
    }

    private void DoAdd(Component component) {
        String string = "Enter the auction number to add";
        String string2 = this.promptString(component, string, "Adding");
        if (string2 == null) {
            return;
        }
        string2 = string2.trim();
        MQFactory.getConcrete("user").enqueue(ADD_AUCTION + string2);
    }

    private String promptString(Component component, String string, String string2) {
        return this._oui.promptString(component, string, string2, "");
    }

    private String promptString(Component component, String string, String string2, String string3) {
        return this._oui.promptString(component, string, string2, string3);
    }

    private String[] promptString(Component component, String string, String string2, String string3, String string4, String string5) {
        return this._oui.promptString(component, string, string2, string3, string4, string5);
    }

    private void CancelSnipe(Component component, AuctionEntry auctionEntry) {
        int[] nArray = this.getPossibleRows();
        int n = nArray.length;
        if (auctionEntry == null && n == 0) {
            JOptionPane.showMessageDialog(component, "You must select an auction to be able to cancel snipes.", "Snipe-cancel error", -1);
            return;
        }
        if (n != 0) {
            for (int i = 0; i < nArray.length; ++i) {
                AuctionEntry auctionEntry2 = (AuctionEntry)this.getIndexedEntry(nArray[i]);
                auctionEntry2.cancelSnipe(false);
                FilterManager.getInstance().redrawEntry(auctionEntry2);
            }
        } else {
            auctionEntry.cancelSnipe(false);
            FilterManager.getInstance().redrawEntry(auctionEntry);
        }
    }

    public static String buildInfoHTML(AuctionEntry auctionEntry, boolean bl) {
        return JBidMouse.buildInfoHTML(auctionEntry, bl, false);
    }

    public static String stripHigh(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] <= '\u0080') continue;
            cArray[i] = 32;
        }
        return new String(cArray);
    }

    public static String buildInfoHTML(AuctionEntry auctionEntry, boolean bl, boolean bl2) {
        boolean bl3 = false;
        String string = "";
        if (bl) {
            string = "<html><body>";
        }
        string = bl2 ? string + "<b>" + JBidMouse.stripHigh(auctionEntry.getTitle()) + "</b> (" + auctionEntry.getIdentifier() + ")<br>" : string + "<b>" + auctionEntry.getTitle() + "</b> (" + auctionEntry.getIdentifier() + ")<br>";
        string = string + "<table>";
        if (auctionEntry.getThumbnail() != null) {
            if (bl2) {
                try {
                    InetAddress inetAddress = InetAddress.getLocalHost();
                    string = string + "<tr><td><img src=\"http://" + inetAddress.getHostAddress() + ":" + JConfig.queryConfiguration("server.port", "9099") + "/" + auctionEntry.getIdentifier() + ".jpg\">" + newCol + "<table>";
                    bl3 = true;
                }
                catch (UnknownHostException unknownHostException) {
                    ErrorManagement.logMessage("Unknown host trying to look up the local host.  Is the network off?");
                }
            } else {
                string = string + "<tr><td><img src=\"" + auctionEntry.getThumbnail() + "\">" + newCol + "<table>";
                bl3 = true;
            }
        }
        if (!auctionEntry.isFixed()) {
            string = string + "<tr><td>Currently</td><td>" + auctionEntry.getCurBid() + " (" + auctionEntry.getNumBidders() + " Bids)" + endRow;
            string = string + "<tr><td>High Bidder</td><td>" + auctionEntry.getHighBidder() + endRow;
        } else {
            string = string + "<tr><td>Price</td><td>" + auctionEntry.getCurBid() + endRow;
        }
        if (auctionEntry.isDutch()) {
            string = string + "<tr><td>Quantity</td><td>" + auctionEntry.getQuantity() + endRow;
        }
        if (auctionEntry.isBidOn()) {
            string = string + "<tr><td>Your max bid</td><td>" + auctionEntry.getBid() + endRow;
            if (auctionEntry.getBidQuantity() != 1) {
                string = string + "<tr><td>Quantity of</td><td>" + auctionEntry.getBidQuantity() + endRow;
            }
        }
        if (auctionEntry.isSniped()) {
            string = string + "<tr><td>Sniped for</td><td>" + auctionEntry.getSnipeBid() + endRow;
            if (auctionEntry.getSnipeQuantity() != 1) {
                string = string + "<tr><td>Quantity of</td><td>" + auctionEntry.getSnipeQuantity() + endRow;
            }
            string = string + "<tr><td>Sniping at " + auctionEntry.getSnipeTime() / 1000L + " seconds before the end." + endRow;
        }
        if (auctionEntry.getShipping() != null && !auctionEntry.getShipping().isNull()) {
            string = string + "<tr><td>Shipping</td><td>" + auctionEntry.getShipping() + endRow;
        }
        if (!auctionEntry.getInsurance().isNull()) {
            string = string + "<tr><td>Insurance (" + (auctionEntry.getInsuranceOptional() ? "optional" : "required") + ")" + newCol + auctionEntry.getInsurance() + endRow;
        }
        string = string + "<tr><td>Seller</td><td>" + auctionEntry.getSeller() + endRow;
        string = auctionEntry.isEnded() ? string + "<tr><td>Listing ended at </td><td>" + auctionEntry.getEndDate() + endRow : string + "<tr><td>Listing ends at</td><td>" + auctionEntry.getEndDate() + endRow;
        if (bl3) {
            string = string + "</table></td></tr>";
        }
        string = string + "</table>";
        if (!auctionEntry.isFixed() && !auctionEntry.getBuyNow().isNull()) {
            if (auctionEntry.isEnded()) {
                string = string + "<b>You could have used Buy It Now for " + auctionEntry.getBuyNow() + "</b><br>";
            } else {
                string = string + "<b>Or you could buy it now, for " + auctionEntry.getBuyNow() + ".</b><br>";
                string = string + "Note: <i>To 'Buy Now' through this program,<br>      select 'Buy from the context menu.</i><br>";
            }
        }
        if (auctionEntry.isEnded()) {
            string = string + "<i>Listing is ended.</i><br>";
        }
        if (auctionEntry.getComment() != null) {
            string = string + "<br><u>Comment</u><br>";
            string = string + "<b>" + auctionEntry.getComment() + "</b><br>";
        }
        string = string + "<b><u>Events</u></b><blockquote>" + auctionEntry.getLastStatus(true) + "</blockquote>";
        if (bl) {
            string = string + "</html>";
        }
        return string;
    }

    private void DoShowTime(Component component, AuctionEntry auctionEntry) {
        AuctionServer auctionServer = AuctionServerManager.getInstance().getDefaultServer();
        if (auctionEntry != null) {
            auctionServer = auctionEntry.getServer();
        }
        String string = "<html><body><table>";
        string = string + "<tr><td><b>Current time:</b></td><td>" + new Date() + endRow;
        string = string + "<tr><td><b>Page load time:</td><td>" + auctionServer.getPageRequestTime() + endRow;
        string = string + "<tr><td><b>eBay Time delta:</td><td>" + auctionServer.getOfficialServerTimeDelta() + endRow;
        string = string + "</table></body></html>";
        JOptionPane jOptionPane = new JOptionPane(string, 1);
        JDialog jDialog = jOptionPane.createDialog(component, "Auction Server Time Information");
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowDeactivated(WindowEvent windowEvent) {
                windowEvent.getWindow().toFront();
            }
        });
        jDialog.setVisible(true);
    }

    private void DoInformation(Component component, AuctionEntry auctionEntry) {
        int[] nArray = this.getPossibleRows();
        int n = nArray.length;
        if (auctionEntry == null && n == 0) {
            JOptionPane.showMessageDialog(component, "Must select an auction to get information about.", "Information error", -1);
            return;
        }
        this.showComplexInformation(nArray);
    }

    private void showSimpleInformation(AuctionEntry auctionEntry, Component component) {
        String string = JBidMouse.buildInfoHTML(auctionEntry, true);
        JOptionPane jOptionPane = new JOptionPane(string, 1);
        JDialog jDialog = jOptionPane.createDialog(component, "Auction Information");
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowDeactivated(WindowEvent windowEvent) {
                windowEvent.getWindow().toFront();
            }
        });
        jDialog.setVisible(true);
    }

    private void showComplexInformation(int[] nArray) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            object = (AuctionEntry)this.getIndexedEntry(nArray[i]);
            stringBuffer.append(JBidMouse.buildInfoHTML((AuctionEntry)object, false)).append("<hr>");
        }
        Dimension dimension = new Dimension(480, Math.min(372, nArray.length * 30 + 200));
        object = new Vector(2);
        ((Vector)object).add("Continue");
        MyActionListener myActionListener = new MyActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                this.m_within.dispose();
                this.m_within = null;
            }
        };
        JFrame jFrame = this._oui.showChoiceTextDisplay(new JHTMLOutput("Information", stringBuffer).getStringBuffer(), dimension, "Information...", (List)object, "Information...", myActionListener);
        myActionListener.setFrame(jFrame);
    }

    private boolean dangerousSnipeWarning(Component component) {
        String string = "Two or more of your auctions complete within the snipe time of\nanother.  What will happen is that if the first of those is bid on,\nthe second WILL be bid on as well.  This is very unlikely to be what\nyou want.  It is strongly recommended that you cancel the multisnipe\nand check the end times of your auctions, only selecting auctions\nwhich end more than your snipe timer seconds apart.";
        Object[] objectArray = new Object[]{"Cancel", "Proceed"};
        int n = JOptionPane.showOptionDialog(component, string, "Dangerous Multisnipe", -1, 2, null, objectArray, objectArray[0]);
        return n == 0 || n == -1;
    }

    private boolean checkIfDangerousMultiSnipe(Component component, int[] nArray, MultiSnipe multiSnipe) {
        boolean bl = false;
        for (int i = 0; i < nArray.length && !bl; ++i) {
            AuctionEntry auctionEntry = (AuctionEntry)this.getIndexedEntry(nArray[i]);
            if (multiSnipe != null && !multiSnipe.isSafeToAdd(auctionEntry)) {
                bl = true;
            }
            for (int j = i + 1; j < nArray.length && !bl; ++j) {
                AuctionEntry auctionEntry2 = (AuctionEntry)this.getIndexedEntry(nArray[j]);
                if (MultiSnipe.isSafeMultiSnipe(auctionEntry, auctionEntry2)) continue;
                bl = true;
            }
        }
        return bl && this.dangerousSnipeWarning(component);
    }

    private void DoMultiSnipe(Component component) {
        Object object;
        Object object2;
        Object object3;
        int n;
        int[] nArray = this.getPossibleRows();
        Currency currency = Currency.NoValue();
        MultiSnipe multiSnipe = null;
        if (nArray.length == 0) {
            JOptionPane.showMessageDialog(component, "No auctions selected to set to MultiSnipe mode!", "Error setting multisnipe", -1);
            return;
        }
        for (n = 0; n < nArray.length; ++n) {
            object3 = (AuctionEntry)this.getIndexedEntry(nArray[n]);
            object2 = ((AuctionEntry)object3).getCurBid();
            if (((AuctionEntry)object3).getServer().getUserId().equals("default")) {
                JOptionPane.showMessageDialog(component, "One or more of your auctions to multisnipe is on a server that you have not\nentered your user account information for.  Go to the the " + ((AuctionEntry)object3).getServer().getName() + " configuration tab,\n" + "and fill it out.", "No auction account error", -1);
                return;
            }
            if (((AuctionEntry)object3).isEnded()) {
                JOptionPane.showMessageDialog(component, "You cannot place a multi-snipe on a set of entries that include an ended auction", "Snipe error", -1);
                return;
            }
            if (((AuctionEntry)object3).isPrivate()) {
                JOptionPane.showMessageDialog(component, "Multisnipes cannot include private auctions.  Unfortunately,\nprivate auctions make it impossible under certain circumstances\nto know if a bid was ultimately the winner or not.  The two\npotential answers are to either fail conservatively (think you\nwon, and cancel later multisnipes), or fail liberally (think\nyou lost, and allow later multisnipes).  Neither is a good\nsolution, so private auctions are barred from multisnipe groups.", "Private auction/multisnipe error", -1);
                return;
            }
            try {
                object = ((Currency)object2).add(((AuctionEntry)object3).getServer().getMinimumBidIncrement((Currency)object2, ((AuctionEntry)object3).getNumBidders()));
            }
            catch (Currency.CurrencyTypeException currencyTypeException) {
                object = object2;
            }
            try {
                if (currency.isNull()) {
                    currency = object2;
                } else if (currency.less((Currency)object)) {
                    currency = object2;
                }
            }
            catch (Currency.CurrencyTypeException currencyTypeException) {
                JOptionPane.showMessageDialog(component, "Cannot include auctions in different currencies\nin a multi-snipe group.  It's a really bad idea,\nbecause the snipe value may mean different values\nin each currency.", "Error setting multisnipe", -1);
                return;
            }
            if (!((AuctionEntry)object3).isMultiSniped()) continue;
            if (multiSnipe != null && multiSnipe != ((AuctionEntry)object3).getMultiSnipe()) {
                JOptionPane.showMessageDialog(component, "Cannot add auctions to two multi-snipe auctions\nat once.  Cancel the snipes on one auction or set\nof auctions, and then retry the action.", "Error setting multisnipe", -1);
                return;
            }
            if (multiSnipe != null) continue;
            multiSnipe = ((AuctionEntry)object3).getMultiSnipe();
        }
        if (this.checkIfDangerousMultiSnipe(component, nArray, multiSnipe)) {
            return;
        }
        if (multiSnipe == null) {
            String string = "<html><body><table>";
            string = string + "<tr><td>Highest current bid:</td><td>" + currency + endRow;
            string = string + "<tr><td>Number of auctions selected:</td><td>" + nArray.length + endRow;
            string = string + "</table>";
            string = string + "Approximate minimum bid across all selected auctions is " + currency + "<br>";
            string = string + "<i>Do not enter any punctuation or currency symbols<br>other than the optional decimal point.</i><br>";
            string = string + "How much do you wish to snipe?</body></html>";
            object3 = new SnipeDialog();
            ((SnipeDialog)object3).clear();
            ((SnipeDialog)object3).setPrompt(string);
            ((SnipeDialog)object3).useQuantity(false);
            ((Window)object3).pack();
            object2 = OptionUI.findCenterBounds(((Container)object3).getPreferredSize());
            ((Window)object3).setLocation(((Rectangle)object2).x, ((Rectangle)object2).y);
            ((Dialog)object3).setVisible(true);
            if (((SnipeDialog)object3).isCancelled() || ((SnipeDialog)object3).getAmount().equals("")) {
                JOptionPane.showMessageDialog(component, "Establishing multi-auction snipe canceled.", "Multisnipe canceled", -1);
                return;
            }
            object = ((SnipeDialog)object3).getAmount();
            boolean bl = ((SnipeDialog)object3).subtractShipping();
            Color color = JColorChooser.showDialog(component, "Select a background color for this multi-snipe group", null);
            if (color == null) {
                JOptionPane.showMessageDialog(component, "Establishing multi-auction snipe canceled.", "Multisnipe canceled", -1);
                return;
            }
            multiSnipe = new MultiSnipe(color, Currency.getCurrency(currency.fullCurrencyName(), (String)object), bl);
        }
        for (n = 0; n < nArray.length; ++n) {
            object3 = (AuctionEntry)this.getIndexedEntry(nArray[n]);
            ((AuctionEntry)object3).setMultiSnipe(multiSnipe);
            FilterManager.getInstance().redrawEntry((AuctionEntry)object3);
        }
    }

    private String genBidSnipeHTML(AuctionEntry auctionEntry, Currency currency) {
        String string = "<html><body><table>";
        string = string + "<tr><td>Title:</td><td>" + auctionEntry.getTitle() + endRow;
        string = string + "<tr><td>Cur bid:</td><td>" + auctionEntry.getCurBid() + endRow;
        if (auctionEntry.getShipping() != null && !auctionEntry.getShipping().isNull()) {
            string = string + "<tr><td>Shipping:</td><td>" + auctionEntry.getShipping() + endRow;
        }
        string = string + "<tr><td>High bidder:</td><td>" + auctionEntry.getHighBidder() + endRow;
        string = string + "<tr><td>Seller:</td><td>" + auctionEntry.getSeller() + endRow;
        string = string + "</table>";
        string = currency != null ? string + "Minimum legal bid is " + currency + "<br>" : string + "Cannot calculate minimum legal bid for this currency.<br>";
        string = string + "<i>Do not enter any punctuation or currency symbols<br>other than the optional decimal point.</i><br>";
        return string;
    }

    private void DoSnipe(Component component, AuctionEntry auctionEntry) {
        Currency currency;
        AuctionEntry auctionEntry2 = auctionEntry;
        int[] nArray = this.getPossibleRows();
        if (nArray.length > 1) {
            this.DoMultiSnipe(component);
            return;
        }
        if (nArray.length == 1) {
            auctionEntry2 = (AuctionEntry)this.getIndexedEntry(nArray[0]);
        }
        if (auctionEntry2 == null) {
            JOptionPane.showMessageDialog(component, "You have not chosen an auction to snipe on!", "Snipe error", -1);
            return;
        }
        if (auctionEntry2.getServer().getUserId().equals("default")) {
            JOptionPane.showMessageDialog(component, "You cannot snipe on an auction without first entering your\nuser account information on the " + auctionEntry2.getServer().getName() + " configuration tab.", "No auction account error", -1);
            return;
        }
        if (auctionEntry2.isEnded()) {
            JOptionPane.showMessageDialog(component, "You cannot place a snipe on an ended auction", "Snipe error", -1);
            return;
        }
        try {
            currency = auctionEntry2.getCurBid().add(auctionEntry2.getServer().getMinimumBidIncrement(auctionEntry2.getCurBid(), auctionEntry2.getNumBidders()));
        }
        catch (Currency.CurrencyTypeException currencyTypeException) {
            currency = null;
        }
        String string = this.genBidSnipeHTML(auctionEntry2, currency);
        string = string + "</body></html>";
        SnipeDialog snipeDialog = new SnipeDialog();
        snipeDialog.clear();
        snipeDialog.setPrompt(string);
        if (auctionEntry2.isDutch()) {
            snipeDialog.useQuantity(true);
        } else {
            snipeDialog.useQuantity(false);
        }
        snipeDialog.pack();
        Rectangle rectangle = OptionUI.findCenterBounds(snipeDialog.getPreferredSize());
        snipeDialog.setLocation(rectangle.x, rectangle.y);
        snipeDialog.setVisible(true);
        if (snipeDialog.isCancelled() || snipeDialog.getAmount().equals("")) {
            return;
        }
        String string2 = snipeDialog.getAmount();
        String string3 = snipeDialog.getQuantity();
        try {
            Currency currency2;
            Currency currency3 = Currency.getCurrency(auctionEntry2.getCurBid().fullCurrencyName(), string2);
            if (snipeDialog.subtractShipping() && (currency2 = auctionEntry2.getShippingWithInsurance()) != null && !currency2.isNull()) {
                currency3 = currency3.subtract(currency2);
            }
            auctionEntry2.prepareSnipe(currency3, Integer.parseInt(string3));
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(component, "You have entered a bad price for your snipe.\n" + string2 + " is not a valid snipe.\n" + "Punctuation (other than a decimal point) and currency symbols are not legal.", "Bad snipe value", -1);
            return;
        }
        catch (Currency.CurrencyTypeException currencyTypeException) {
            ErrorManagement.handleException("Couldn't subtract shipping from bid amount.", currencyTypeException);
            return;
        }
        FilterManager.getInstance().redrawEntry(auctionEntry2);
        this._oui.promptWithCheckbox(component, "Sniped for: " + auctionEntry2.getSnipeBid(), "Snipe Alert", "message.sniped", -1, 0);
    }

    private void DoShipping(Component component, AuctionEntry auctionEntry) {
        Currency currency;
        if (auctionEntry == null) {
            JOptionPane.showMessageDialog(component, "You have not chosen an auction to set the shipping for!", "Shipping-set error", -1);
            return;
        }
        String string = "<html><body>" + JBidMouse.buildInfoHTML(auctionEntry, false);
        String[] stringArray = this.promptString(component, string = string + "<br><b>How much is shipping?</b></body></html>", "Shipping", null, null, null);
        if (stringArray == null || stringArray[0] == null) {
            return;
        }
        try {
            if (stringArray[0] != null) {
                stringArray[0] = stringArray[0].replace(',', '.');
            }
            currency = Currency.getCurrency(auctionEntry.getCurBid().fullCurrencyName(), stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(component, "You have entered a bad shipping amount.\n" + stringArray[0] + " is not a valid shipping cost.\n" + "Punctuation (other than a decimal point) and currency symbols are not legal.\n" + "The currency used is always the same as the auction.", "Bad shipping value", -1);
            return;
        }
        if (currency != null) {
            auctionEntry.setShipping(currency);
            FilterManager.getInstance().redrawEntry(auctionEntry);
        }
    }

    private boolean anyBiddingErrors(Component component, AuctionEntry auctionEntry) {
        if (auctionEntry == null) {
            JOptionPane.showMessageDialog(component, "You have not chosen an auction to bid on!", "Bid error", -1);
            return true;
        }
        if (auctionEntry.getServer().getUserId().equals("default")) {
            JOptionPane.showMessageDialog(component, "You cannot bid on an auction without first entering your\nuser account information on the " + auctionEntry.getServer().getName() + " configuration tab.", "No auction account error", -1);
            return true;
        }
        if (auctionEntry.isEnded()) {
            JOptionPane.showMessageDialog(component, "You cannot place a bid on an ended auction", "Bid error", -1);
            return true;
        }
        return false;
    }

    private void DoBuy(Component component, AuctionEntry auctionEntry) {
        if (this.anyBiddingErrors(component, auctionEntry)) {
            return;
        }
        int n = this._oui.promptWithCheckbox(component, "This will buy the item outright at the price of " + auctionEntry.getBuyNow() + ".\nIs this what you want?", "Buy Item", "prompt.bin_confirm");
        if (n != 2 && n != -1) {
            MQFactory.getConcrete("ebay").enqueue(new AuctionQObject(5, new AuctionBuy(auctionEntry, Currency.NoValue(), 1), "none"));
        }
    }

    private void DoBid(Component component, AuctionEntry auctionEntry) {
        Currency currency;
        String[] stringArray;
        Currency currency2;
        if (this.anyBiddingErrors(component, auctionEntry)) {
            return;
        }
        try {
            currency2 = auctionEntry.getCurBid().add(auctionEntry.getServer().getMinimumBidIncrement(auctionEntry.getCurBid(), auctionEntry.getNumBidders()));
        }
        catch (Currency.CurrencyTypeException currencyTypeException) {
            currency2 = null;
        }
        String string = this.genBidSnipeHTML(auctionEntry, currency2);
        string = string + "How much do you wish to bid?</body></html>";
        if (currency2 != null) {
            if (auctionEntry.isDutch()) {
                stringArray = this.promptString(component, string, "Bidding", Float.toString((float)currency2.getValue()), "Quantity", "1");
            } else {
                stringArray = this.promptString(component, string, "Bidding", Float.toString((float)currency2.getValue()), null, null);
                if (stringArray != null) {
                    stringArray[1] = "1";
                }
            }
        } else if (auctionEntry.isDutch()) {
            stringArray = this.promptString(component, string, "Bidding", null, "Quantity", "1");
        } else {
            stringArray = this.promptString(component, string, "Bidding", null, null, null);
            if (stringArray != null) {
                stringArray[1] = "1";
            }
        }
        if (stringArray == null || stringArray[0] == null) {
            return;
        }
        if (stringArray[1] == null || stringArray[1].length() == 0) {
            stringArray[1] = "1";
        }
        try {
            if (stringArray[0] != null) {
                stringArray[0] = stringArray[0].replace(',', '.');
            }
            currency = Currency.getCurrency(auctionEntry.getCurBid().fullCurrencyName(), stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(component, "You have entered a bad price for your bid.\n" + stringArray[0] + " is not a valid bid.\n" + "Punctuation (other than a decimal point) and currency symbols are not legal.", "Bad bid value", -1);
            return;
        }
        MQFactory.getConcrete("ebay").enqueue(new AuctionQObject(5, new AuctionBid(auctionEntry, currency, Integer.parseInt(stringArray[1])), "none"));
    }

    private void DoShowInBrowser(Component component, AuctionEntry auctionEntry) {
        AuctionEntry auctionEntry2 = auctionEntry;
        int[] nArray = this.getPossibleRows();
        if (nArray.length != 0) {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < nArray.length; ++i) {
                AuctionEntry auctionEntry3 = (AuctionEntry)this.getIndexedEntry(nArray[i]);
                vector.add(auctionEntry3.getIdentifier());
            }
            JBidProxy.setItems(vector);
            auctionEntry2 = (AuctionEntry)this.getIndexedEntry(nArray[0]);
        } else if (auctionEntry2 == null) {
            JOptionPane.showMessageDialog(component, "Cannot launch browser from menu, you must select an auction.", "Menu Error", -1);
            return;
        }
        auctionEntry2.getServer().showBrowser(auctionEntry2);
    }

    private void DeleteComment(AuctionEntry auctionEntry) {
        if (auctionEntry == null) {
            ErrorManagement.logMessage("Auction selected to delete comment from is null, unexpected error!");
            return;
        }
        auctionEntry.setComment("");
        FilterManager.getInstance().redrawEntry(auctionEntry);
    }

    private void DoComment(Component component, AuctionEntry auctionEntry) {
        String string;
        if (auctionEntry == null) {
            ErrorManagement.logMessage("Auction selected to comment on is null, unexpected error!");
            return;
        }
        String string2 = auctionEntry.getComment();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = this.promptString(component, "Enter a comment for: " + auctionEntry.getTitle(), "Commenting", string2)) == null) {
            return;
        }
        auctionEntry.setComment(string);
        FilterManager.getInstance().redrawEntry(auctionEntry);
    }

    private void ShowComment(Component component, AuctionEntry auctionEntry) {
        if (auctionEntry == null) {
            ErrorManagement.logMessage("Can't show comments from menu items yet.");
            return;
        }
        JOptionPane.showMessageDialog(component, auctionEntry.getComment(), "Comment", -1);
    }

    private void DoUpdateAll() {
        Iterator iterator = AuctionsManager.getAuctionIterator();
        while (iterator.hasNext()) {
            AuctionEntry auctionEntry = (AuctionEntry)iterator.next();
            if (auctionEntry.isEnded()) continue;
            auctionEntry.setNeedsUpdate();
        }
    }

    private void DoStopUpdating(Component component) {
        int n = this._oui.promptWithCheckbox(component, "This will terminate all searches, as well as\nall updates that are currently pending.\n\nStop all searches?", "Stop updating/searching", "prompt.search_stop");
        if (n != 2 && n != -1) {
            AuctionServerManager.getInstance().cancelSearches();
            MQFactory.getConcrete("drop").clear();
            Iterator iterator = AuctionsManager.getAuctionIterator();
            while (iterator.hasNext()) {
                AuctionEntry auctionEntry = (AuctionEntry)iterator.next();
                if (auctionEntry.isEnded()) continue;
                auctionEntry.clearNeedsUpdate();
                auctionEntry.pauseUpdate();
            }
        }
    }

    private void DoUpdate(AuctionEntry auctionEntry) {
        int[] nArray = this.getPossibleRows();
        if (nArray.length != 0) {
            for (int i = 0; i < nArray.length; ++i) {
                AuctionEntry auctionEntry2 = (AuctionEntry)this.getIndexedEntry(nArray[i]);
                auctionEntry2.setNeedsUpdate();
                if (!auctionEntry2.isEnded() && !auctionEntry2.isPaused()) continue;
                auctionEntry2.forceUpdate();
            }
        } else {
            auctionEntry.setNeedsUpdate();
            if (auctionEntry.isPaused()) {
                auctionEntry.forceUpdate();
            }
        }
    }

    private void DoSetNotEnded(Component component, AuctionEntry auctionEntry) {
        int[] nArray = this.getPossibleRows();
        if (nArray.length != 0) {
            for (int i = 0; i < nArray.length; ++i) {
                AuctionEntry auctionEntry2 = (AuctionEntry)this.getIndexedEntry(nArray[i]);
                auctionEntry2.setEnded(false);
                auctionEntry2.setNeedsUpdate();
            }
        } else {
            auctionEntry.setEnded(false);
            auctionEntry.setNeedsUpdate();
        }
    }

    private void DoResetServerTime() {
        MQFactory.getConcrete("user").enqueue(GET_SERVER_TIME);
    }

    private void DoAbout() {
        if (aboutFrame == null) {
            Dimension dimension = new Dimension(495, 245);
            if (_aboutText == null) {
                _aboutText = JBHelp.loadHelp("help/about.jbh", "About JBidWatcher...");
            }
            aboutFrame = this._oui.showTextDisplay(_aboutText != null ? _aboutText : badAbout, dimension, "About JBidWatcher...");
        } else {
            aboutFrame.setVisible(true);
        }
    }

    private void DoFAQ() {
        if (faqFrame == null) {
            Dimension dimension = new Dimension(625, 500);
            if (_faqText == null) {
                _faqText = JBHelp.loadHelp("help/faq.jbh", "FAQ for JBidWatcher...");
            }
            faqFrame = this._oui.showTextDisplay(_faqText != null ? _faqText : badFAQ, dimension, "JBidWatcher FAQ");
        } else {
            faqFrame.setVisible(true);
        }
    }

    private void DoSerialize() {
        System.out.println(AuctionServerManager.getInstance().toXML());
    }

    private void DoLoad(String string) {
        Object object;
        String string2 = string;
        if (string2 == null) {
            string2 = JConfig.queryConfiguration("savefile", "auctions.xml");
            object = string2;
            if (!(string2 = JConfig.getCanonicalFile(string2, "jbidwatcher", true)).equals(object)) {
                JConfig.setConfiguration("savefile", string2);
            }
        }
        try {
            object = new XMLElement(true);
            InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(string2));
            ((XMLElement)object).parseFromReader(inputStreamReader);
            AuctionServerManager.getInstance().fromXML((XMLElement)object);
        }
        catch (IOException iOException) {
            ErrorManagement.handleException("Error loading XML file with auctions: " + string2, iOException);
        }
    }

    private void DoCloseDown() {
        MQFactory.getConcrete("Swing").enqueue("QUIT");
    }

    private void DoSave(Component component) {
        boolean bl = AuctionsManager.getInstance().saveAuctions();
        System.gc();
        if (bl) {
            this._oui.promptWithCheckbox(component, "Auctions saved!", "Save Complete", "prompt.savecomplete", -1, 0);
        } else {
            JOptionPane.showMessageDialog(component, "An error occurred in saving the auctions!", "Save Failed", 1);
        }
    }

    private String getActionValue(int n, AuctionEntry auctionEntry) {
        switch (n) {
            case 0: {
                return auctionEntry.getServer().getBrowsableURLFromItem(auctionEntry.getIdentifier());
            }
            case 1: {
                return auctionEntry.getIdentifier();
            }
            case 2: {
                return this.makeUsefulString(auctionEntry);
            }
        }
        return "";
    }

    private void DoCopySomething(Component component, AuctionEntry auctionEntry, int n, String string, String string2) {
        AuctionEntry auctionEntry2 = auctionEntry;
        int[] nArray = this.getPossibleRows();
        if (auctionEntry2 == null && nArray.length == 0) {
            JOptionPane.showMessageDialog(component, string, "Error copying", -1);
            return;
        }
        if (nArray.length != 0 && nArray.length != 1) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                AuctionEntry auctionEntry3 = (AuctionEntry)this.getIndexedEntry(nArray[i]);
                if (i != 0) {
                    stringBuffer.append(string2);
                }
                stringBuffer.append(this.getActionValue(n, auctionEntry3));
            }
            JBidMouse.setClipboardString(stringBuffer.toString());
        } else {
            if (nArray.length == 1) {
                auctionEntry2 = (AuctionEntry)this.getIndexedEntry(nArray[0]);
            }
            JBidMouse.setClipboardString(this.getActionValue(n, auctionEntry2));
        }
    }

    private void DoCopyURL(Component component, AuctionEntry auctionEntry) {
        this.DoCopySomething(component, auctionEntry, 0, "No auctions selected to copy URLs of!", "\n");
    }

    private void DoCopyID(Component component, AuctionEntry auctionEntry) {
        this.DoCopySomething(component, auctionEntry, 1, "No auctions selected to copy IDs of!", ", ");
    }

    private void DoHelp(Component component) {
        JOptionPane.showMessageDialog(component, "I'm very sorry, but help has not been implemented yet.\nIf you'd like to assist in getting help up, you could\nwrite me an email at cyberfox@users.sourceforge.net\ndescribing how you use a particular part of JBidWatcher,\nand I'll try to collect those into contextual help options.", "Sorry, no help!", 1);
    }

    private void DoHelpColors() {
        if (helpFrame == null) {
            Dimension dimension = new Dimension(495, 245);
            if (_colorHelp == null) {
                _colorHelp = JBHelp.loadHelp("help/colors.jbh", "Help on Colors");
            }
            helpFrame = this._oui.showTextDisplay(_colorHelp != null ? _colorHelp : badColors, dimension, "Help on color use in JBidwatcher");
        } else {
            helpFrame.setVisible(true);
        }
    }

    private void DoRSS() {
        if (this._rssDialog == null) {
            this._rssDialog = new RSSDialog();
        }
        this._rssDialog.prepare();
        this._rssDialog.pack();
        this._rssDialog.setVisible(true);
    }

    protected void DoCheckUpdates() {
        JConfig.setConfiguration("updates.last_version", "1.0.2");
        UpdateManager.checkUpdate(true);
    }

    protected void DoSetBackgroundColor(Component component) {
        Color color = JColorChooser.showDialog(component, "Select a background color for your auction tables", null);
        if (color == null) {
            return;
        }
        FilterManager.getInstance().setBackground(color);
        myTableCellRenderer.resetBehavior();
        JConfig.setConfiguration("background", MultiSnipe.makeRGB(color));
    }

    private void DoClearDeleted(Component component) {
        int n = AuctionsManager.getInstance().clearDeleted();
        this._oui.promptWithCheckbox(component, "Cleared " + n + " deleted entries.", "Clear Complete", "prompt.clear_complete", -1, 0);
    }

    protected void buildMenu(JPopupMenu jPopupMenu) {
        jPopupMenu.add(this.makeMenuItem("Snipe")).addActionListener(this);
        jPopupMenu.add(this.makeMenuItem("Cancel snipe")).addActionListener(this);
        jPopupMenu.add(new JPopupMenu.Separator());
        jPopupMenu.add(this.makeMenuItem("Bid")).addActionListener(this);
        jPopupMenu.add(this.makeMenuItem("Buy")).addActionListener(this);
        jPopupMenu.add(new JPopupMenu.Separator());
        jPopupMenu.add(this.makeMenuItem("Update auction", "Update")).addActionListener(this);
        jPopupMenu.add(this.makeMenuItem("Show information", "Information")).addActionListener(this);
        jPopupMenu.add(this.makeMenuItem("Show in browser", "Browse")).addActionListener(this);
        jPopupMenu.add(new JPopupMenu.Separator());
        this.tabMenu = new JMenu("Send to...");
        jPopupMenu.add(this.tabMenu);
        JMenu jMenu = new JMenu("Comments...");
        jMenu.add(this.makeMenuItem("Write", "Comment")).addActionListener(this);
        jMenu.add(this.makeMenuItem("Read", "View Comment")).addActionListener(this);
        jMenu.add(this.makeMenuItem("Delete", "Delete Comment")).addActionListener(this);
        jPopupMenu.add(jMenu);
        JMenu jMenu2 = new JMenu("Advanced...");
        jMenu2.add(this.makeMenuItem("Set Shipping", "Shipping")).addActionListener(this);
        jMenu2.add(this.makeMenuItem("Show last error", "ShowError")).addActionListener(this);
        jMenu2.add(this.makeMenuItem("Mark as not ended", "NotEnded")).addActionListener(this);
        jPopupMenu.add(jMenu2);
        jPopupMenu.add(new JPopupMenu.Separator());
        jPopupMenu.add(this.makeMenuItem("Delete")).addActionListener(this);
    }

    protected void beforePopup(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        int[] nArray;
        Object object;
        Object object2;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                JBidMouse.this.DoSendTo(string);
            }
        };
        super.beforePopup(jPopupMenu, mouseEvent);
        if (this.tabMenu != null) {
            this.tabMenu.removeAll();
            object2 = FilterManager.getInstance().allCategories();
            if (object2 == null) {
                this.tabMenu.setEnabled(false);
            } else {
                object2.remove("selling");
                this.tabMenu.setEnabled(true);
                this.tabMenu.add(new JPopupMenu.Separator());
                object = object2.iterator();
                while (object.hasNext()) {
                    this.tabMenu.add(this.makeMenuItem((String)object.next())).addActionListener(actionListener);
                }
            }
        }
        object2 = this.resolvePoint();
        object = null;
        if (object2 != null && object2 instanceof AuctionEntry) {
            object = (AuctionEntry)object2;
        }
        if ((nArray = this.getPossibleRows()) != null && nArray.length != 0) {
            if (nArray.length == 1) {
                Object object3 = this.getIndexedEntry(nArray[0]);
                if (object3 != null && object3 instanceof AuctionEntry) {
                    object = (AuctionEntry)object3;
                }
            } else {
                object = null;
            }
        }
        this.rename("Multisnipe", "Snipe");
        this.rename("Edit", "Write");
        if (object != null) {
            if (((AuctionEntry)object).getComment() != null) {
                this.rename("Write", "Edit");
            }
            if (!((AuctionEntry)object).isSniped()) {
                this.disable("Cancel snipe");
            }
            if (!((AuctionEntry)object).isEnded()) {
                this.disable("complete");
                this.disable("Mark as not ended");
            } else {
                this.enable("Mark as not ended");
            }
            if (((AuctionEntry)object).isSeller() || ((AuctionEntry)object).isEnded()) {
                this.disable("Buy");
                this.disable("Bid");
                this.disable("Snipe");
            }
            if (((AuctionEntry)object).isFixed()) {
                this.disable("Bid");
                this.disable("Snipe");
            }
            if (!((AuctionEntry)object).isFixed() && ((AuctionEntry)object).getBuyNow().isNull()) {
                this.disable("Buy");
            }
        }
        if (nArray != null && nArray.length > 1) {
            this.disable("Bid");
            this.disable("Buy");
            this.disable("Show last error");
            this.disable("Set Shipping");
            this.disable("Make Comment");
            this.disable("View Comment");
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            for (int i = 0; i < nArray.length; ++i) {
                Object object4 = this.getIndexedEntry(nArray[i]);
                AuctionEntry auctionEntry = (AuctionEntry)object4;
                if (auctionEntry.isSniped()) {
                    bl = true;
                }
                if (auctionEntry.isFixed()) {
                    bl2 = true;
                }
                if (auctionEntry.isEnded()) {
                    bl3 = true;
                }
                if (auctionEntry.isEnded()) continue;
                bl4 = true;
            }
            if (!bl) {
                this.disable("Cancel snipe");
            }
            if (bl2 || bl3) {
                this.disable("Snipe");
            }
            if (!bl4) {
                this.enable("complete");
            }
            if (bl3) {
                this.enable("Mark as not ended");
            } else {
                this.disable("Mark as not ended");
            }
            this.rename("Snipe", "Multisnipe");
        }
        if (object == null || ((AuctionEntry)object).getErrorPage() == null) {
            this.disable("Show last error");
        }
    }

    protected void DoAction(Object object, String string, Object object2) {
        this.DoAction(object, string, (AuctionEntry)object2);
    }

    protected void DoAction(Object object, String string, AuctionEntry auctionEntry) {
        Component component = object instanceof Component ? (Component)object : null;
        if (string.equals("Save")) {
            this.DoSave(component);
        } else if (string.equals("Load")) {
            this.DoLoad(null);
        } else if (string.equals("Clear Deleted")) {
            this.DoClearDeleted(component);
        } else if (string.equals("Configure")) {
            this.DoConfigure();
        } else if (string.equals("Check Updates")) {
            this.DoCheckUpdates();
        } else if (string.equals("Check For Updates")) {
            this.DoCheckUpdates();
        } else if (string.equals("Exit")) {
            this.DoCloseDown();
        } else if (string.equals("Help")) {
            this.DoHelp(component);
        } else if (string.equals("Explain the colors and icons")) {
            this.DoHelpColors();
        } else if (string.equals("RSS")) {
            this.DoRSS();
        } else if (string.equals("Serialize")) {
            this.DoSerialize();
        } else if (string.equals("Paste")) {
            this.DoPasteFromClipboard();
        } else if (string.equals("CopyURL")) {
            this.DoCopyURL(component, auctionEntry);
        } else if (string.equals("CopyID")) {
            this.DoCopyID(component, auctionEntry);
        } else if (string.equals("Add")) {
            this.DoAdd(component);
        } else if (string.equals("Delete")) {
            this.DoDelete(component, auctionEntry);
        } else if (string.equals("UpdateAll")) {
            this.DoUpdateAll();
        } else if (string.equals("StopUpdating")) {
            this.DoStopUpdating(component);
        } else if (string.equals("Resync")) {
            this.DoResetServerTime();
        } else if (string.equals("Information")) {
            this.DoInformation(component, auctionEntry);
        } else if (string.equals("Update")) {
            this.DoUpdate(auctionEntry);
        } else if (string.equals("Browse")) {
            this.DoShowInBrowser(component, auctionEntry);
        } else if (string.equals("Show Time Info")) {
            this.DoShowTime(component, auctionEntry);
        } else if (string.equals("ShowError")) {
            this.DoShowLastError(component, auctionEntry);
        } else if (string.equals("Bid")) {
            this.DoBid(component, auctionEntry);
        } else if (string.equals("Buy")) {
            this.DoBuy(component, auctionEntry);
        } else if (string.equals("Shipping")) {
            this.DoShipping(component, auctionEntry);
        } else if (string.equals("NotEnded")) {
            this.DoSetNotEnded(component, auctionEntry);
        } else if (string.equals("Snipe")) {
            this.DoSnipe(component, auctionEntry);
        } else if (string.equals("Multiple Snipe")) {
            this.DoMultiSnipe(component);
        } else if (string.equals("About")) {
            this.DoAbout();
        } else if (string.equals("FAQ")) {
            this.DoFAQ();
        } else if (string.equals("Cancel snipe")) {
            this.CancelSnipe(component, auctionEntry);
        } else if (string.equals("Comment")) {
            this.DoComment(component, auctionEntry);
        } else if (string.equals("View Comment")) {
            this.ShowComment(component, auctionEntry);
        } else if (string.equals("Delete Comment")) {
            this.DeleteComment(auctionEntry);
        } else if (string.equals("Copy")) {
            this.DoCopy(component, auctionEntry);
        } else if (string.equals("Set Background Color")) {
            this.DoSetBackgroundColor(component);
        } else if (string.equals("Toolbar")) {
            this.DoHideShowToolbar();
        } else if (string.equals("Search")) {
            this.DoSearch();
        } else {
            ErrorManagement.logDebug('[' + string + ']');
        }
    }
}

