/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class IconFactory {
    private static Hashtable _icons = new Hashtable();

    public static ImageIcon getCombination(ImageIcon imageIcon, ImageIcon imageIcon2) {
        if (imageIcon == null) {
            return imageIcon2;
        }
        if (imageIcon2 == null) {
            return imageIcon;
        }
        Hashtable<ImageIcon, ImageIcon> hashtable = (Hashtable<ImageIcon, ImageIcon>)_icons.get(imageIcon);
        if (hashtable == null) {
            ImageIcon imageIcon3 = IconFactory.appendIcons(imageIcon, imageIcon2);
            hashtable = new Hashtable<ImageIcon, ImageIcon>();
            hashtable.put(imageIcon2, imageIcon3);
            _icons.put(imageIcon, hashtable);
            return imageIcon3;
        }
        ImageIcon imageIcon4 = (ImageIcon)hashtable.get(imageIcon2);
        if (imageIcon4 == null) {
            _icons.remove(hashtable);
            imageIcon4 = IconFactory.appendIcons(imageIcon, imageIcon2);
            hashtable.put(imageIcon2, imageIcon4);
            _icons.put(imageIcon, hashtable);
        }
        return imageIcon4;
    }

    private static ImageIcon appendIcons(ImageIcon imageIcon, ImageIcon imageIcon2) {
        int n = imageIcon.getIconWidth() + imageIcon2.getIconWidth();
        int n2 = Math.max(imageIcon.getIconHeight(), imageIcon2.getIconHeight());
        BufferedImage bufferedImage = imageIcon.getImage() instanceof BufferedImage ? new BufferedImage(n, n2, ((BufferedImage)imageIcon.getImage()).getType()) : new BufferedImage(n, n2, 6);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(imageIcon.getImage(), 0, 0, null);
        graphics.drawImage(imageIcon2.getImage(), imageIcon.getIconWidth(), 0, null);
        return new ImageIcon(bufferedImage);
    }

    private static BufferedImage createResizedCopy(Image image, int n, int n2, boolean bl) {
        int n3 = bl ? 1 : 2;
        BufferedImage bufferedImage = new BufferedImage(n, n2, n3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        if (bl) {
            graphics2D.setComposite(AlphaComposite.Src);
        }
        graphics2D.drawImage(image, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static boolean resizeImage(String string, String string2, int n, int n2, int n3, int n4) {
        BufferedImage bufferedImage;
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (IOException iOException) {
            ErrorManagement.handleException("Can't read " + string + " to create thumbnail.", iOException);
            return false;
        }
        if (bufferedImage == null) {
            return false;
        }
        int n5 = bufferedImage.getWidth();
        int n6 = bufferedImage.getHeight();
        int n7 = -1;
        int n8 = -1;
        if ((n5 > n || n6 > n3) && (n8 = (n7 = n2) * n6 / n5) > n3) {
            n8 = n4;
            n7 = n8 * n5 / n6;
        }
        if (n7 == -1 || n8 == -1) {
            return false;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            ImageIO.write((RenderedImage)IconFactory.createResizedCopy(bufferedImage, n7, n8, true), "jpeg", fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ErrorManagement.handleException("Can't write " + string2 + " to create thumbnail.", fileNotFoundException);
            return false;
        }
        catch (IOException iOException) {
            ErrorManagement.handleException("Can't generate image " + string2 + ".", iOException);
            return false;
        }
        return true;
    }
}

