/*
 * Decompiled with CFR 0.152.
 */
import java.net.Socket;

public abstract class HTTPProxyClient
extends ProxyClient {
    private static final String AccessDenied = "<html>\n<head><title>Access denied!</title></head>\n<body>Access to this server is denied without an account.</body>\n</html>\n";
    private String _serverName = "Generic HTTP Proxy Server/0.1.0alpha (Java)";
    protected boolean authorized = false;
    protected String requestedFile = null;
    protected boolean firstBlank = true;
    private static final String authTitle = "Authorization: Basic ";

    protected HTTPProxyClient(Socket socket) {
        super(socket);
    }

    protected abstract boolean handleAuthorization(String var1);

    protected void handleLine(String string) {
        if (string.startsWith("GET ")) {
            int n = string.lastIndexOf(32);
            if (n == -1) {
                n = string.length();
            }
            this.requestedFile = string.substring(4, n);
            boolean bl = this.authorized = !this.needsAuthorization(this.requestedFile);
        }
        if (!this.authorized && string.startsWith(authTitle)) {
            String string2 = string.substring(authTitle.length());
            this.authorized = this.handleAuthorization(string2);
        }
    }

    protected abstract boolean needsAuthorization(String var1);

    protected boolean isDone(String string) {
        if (string != null) {
            return string.length() == 0;
        }
        return true;
    }

    protected abstract StringBuffer buildHeaders(String var1, byte[][] var2);

    protected String getServerName() {
        return this._serverName;
    }

    protected void setServerName(String string) {
        this._serverName = string;
    }

    protected StringBuffer buildHTML(String string) {
        StringBuffer stringBuffer = new StringBuffer(15000);
        stringBuffer.append("<HTML>\n");
        stringBuffer.append("<HEAD><TITLE>Default proxy handler document request</TITLE></HEAD>\n");
        stringBuffer.append("<BODY>\n");
        stringBuffer.append("Requesting: <B>");
        stringBuffer.append(string);
        stringBuffer.append("</B>.\n");
        stringBuffer.append("</BODY>\n</HTML>\n");
        return stringBuffer;
    }

    protected String anyResponse(byte[][] byArray) {
        StringBuffer stringBuffer = new StringBuffer(15000);
        if (this.authorized) {
            StringBuffer stringBuffer2 = this.buildHeaders(this.requestedFile, byArray);
            StringBuffer stringBuffer3 = this.buildHTML(this.requestedFile);
            stringBuffer.append("HTTP/1.1 200 OK\n");
            stringBuffer.append("Server: ");
            stringBuffer.append(this.getServerName());
            stringBuffer.append('\n');
            if (stringBuffer2 != null) {
                stringBuffer.append(stringBuffer2);
            } else {
                stringBuffer.append("Content-Type: text/html; charset=UTF-8\n");
            }
            stringBuffer.append('\n');
            if (stringBuffer3 != null) {
                stringBuffer.append(stringBuffer3);
                stringBuffer.append('\n');
            }
            this.authorized = false;
        } else {
            stringBuffer.append("HTTP/1.1 401 Authorization Required\n");
            stringBuffer.append("Server: ");
            stringBuffer.append(this.getServerName());
            stringBuffer.append('\n');
            stringBuffer.append("WWW-Authenticate: Basic realm=\"");
            stringBuffer.append("JBidWatcher");
            stringBuffer.append('\"').append('\n');
            stringBuffer.append("Content-Type: text/html; charset=UTF-8\n");
            stringBuffer.append('\n');
            stringBuffer.append(AccessDenied);
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

