/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class GZip {
    private static byte[] _byteHold = new byte[1];
    private static final Boolean _sync = Boolean.TRUE;
    private static final byte[] gzipHdrData = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 2, -1};
    byte[] _gzTest = new byte[2];
    byte[] _data;
    int _uclength;
    int _uccrc32;
    boolean nowrap = true;
    CRC32 _crc32Calculator = new CRC32();
    static int incrementme;

    public byte[] getCompressedData() {
        return this._data;
    }

    public StringBuffer getUncompressedData() {
        return GZip.uncompress(this._data, this.nowrap);
    }

    public StringBuffer getUncompressedData(boolean bl) {
        return GZip.uncompress(this._data, bl);
    }

    public long getLength() {
        return this._uclength;
    }

    public long getCRC() {
        return this._uccrc32;
    }

    public void reset() {
        this._data = null;
        this._uclength = 0;
        this._uccrc32 = 0;
        this._crc32Calculator.reset();
    }

    public void setData(byte[] byArray, int n, int n2) {
        this._data = byArray;
        this._uclength = n;
        this._uccrc32 = n2;
    }

    public void setData(byte[] byArray) {
        this._crc32Calculator.reset();
        this._crc32Calculator.update(byArray);
        this._uccrc32 = (int)this._crc32Calculator.getValue();
        this._uclength = byArray.length;
        this._data = this.compress(byArray);
    }

    public int readInt(FileInputStream fileInputStream) throws IOException {
        int n = fileInputStream.read();
        int n2 = fileInputStream.read();
        int n3 = fileInputStream.read();
        int n4 = fileInputStream.read();
        return n + n2 << 8 + n3 << 16 + n4 << 24;
    }

    public void load(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(this._gzTest);
        if (this._gzTest[0] == 31 && this._gzTest[1] == -117) {
            if (fileInputStream.skip(8L) == 8L) {
                this._data = new byte[(int)file.length() - 18 + 16];
                fileInputStream.read(this._data, 0, (int)file.length() - 18);
                this._uccrc32 = this.readInt(fileInputStream);
                this._uclength = this.readInt(fileInputStream);
                this.nowrap = true;
            }
        } else {
            this._data = new byte[(int)file.length()];
            System.arraycopy(this._gzTest, 0, this._data, 0, 2);
            this.nowrap = false;
            fileInputStream.read(this._data, 2, this._data.length - 2);
        }
        fileInputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] compress(byte[] byArray) {
        Deflater deflater = new Deflater(9);
        byte[] byArray2 = null;
        int n = 0;
        if (byArray == null) {
            return null;
        }
        Boolean bl = _sync;
        synchronized (bl) {
            if (_byteHold == null || _byteHold.length < byArray.length) {
                _byteHold = new byte[byArray.length * 2];
            }
            deflater.setInput(byArray);
            deflater.finish();
            n = deflater.deflate(_byteHold);
            byArray2 = new byte[n -= 4];
            System.arraycopy(_byteHold, 0, byArray2, 0, n);
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer uncompress(byte[] byArray, boolean bl) {
        Inflater inflater = new Inflater(bl);
        byte[] byArray2 = null;
        Object var4_4 = null;
        int n = 0;
        int n2 = 0;
        if (byArray == null) {
            return null;
        }
        Boolean bl2 = _sync;
        synchronized (bl2) {
            int n3 = _byteHold.length;
            if (n3 < byArray.length) {
                _byteHold = new byte[byArray.length];
            }
            inflater.setInput(byArray);
            try {
                n = n2 = inflater.inflate(_byteHold);
                while (!inflater.finished() && n2 != 0) {
                    byArray2 = _byteHold;
                    n3 = _byteHold.length;
                    if (n >= n3 - 2048) {
                        try {
                            n2 = 0;
                            _byteHold = new byte[_byteHold.length * 3];
                            System.arraycopy(byArray2, 0, _byteHold, 0, n);
                            n2 = inflater.inflate(_byteHold, n, n3 * 2);
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            ErrorManagement.handleException("FAILING to allocate more bytes @ " + _byteHold.length * 3, outOfMemoryError);
                        }
                    } else {
                        n2 = inflater.inflate(_byteHold, n, n3 - n);
                    }
                    n += n2;
                }
                return new StringBuffer(new String(_byteHold, 0, n));
            }
            catch (DataFormatException dataFormatException) {
                ErrorManagement.handleException("Failed to uncompress data: " + dataFormatException, dataFormatException);
                return null;
            }
        }
    }

    private void writeInt(FileOutputStream fileOutputStream, int n) throws IOException {
        byte by = (byte)((n & 0xFF000000) >> 24);
        byte by2 = (byte)((n & 0xFF0000) >> 16);
        byte by3 = (byte)((n & 0xFF00) >> 8);
        byte by4 = (byte)(n & 0xFF);
        fileOutputStream.write(by4);
        fileOutputStream.write(by3);
        fileOutputStream.write(by2);
        fileOutputStream.write(by);
    }

    public void save(String string) {
        block4: {
            Object object;
            File file = new File(string);
            if (file.exists()) {
                object = new File(string + "~");
                if (((File)object).exists()) {
                    ((File)object).delete();
                }
                file.renameTo((File)object);
            }
            try {
                object = new FileOutputStream(file);
                ((FileOutputStream)object).write(gzipHdrData, 0, gzipHdrData.length);
                ((FileOutputStream)object).write(this._data, 2, this._data.length - 2);
                this.writeInt((FileOutputStream)object, this._uccrc32);
                this.writeInt((FileOutputStream)object, this._uclength);
                ((FileOutputStream)object).close();
            }
            catch (IOException iOException) {
                if (!JConfig.debugging) break block4;
                ErrorManagement.handleException("Error writing " + string, iOException);
            }
        }
    }
}

