/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;

public class ErrorManagement {
    static PrintWriter _pw = null;

    private static void init() {
        String string = System.getProperty("file.separator");
        String string2 = JConfig.getHomeDirectory("jbidwatcher");
        String string3 = JConfig.queryConfiguration("logging", "true");
        if (string3.equals("true") && _pw == null) {
            int n = 1;
            String string4 = "";
            try {
                File file;
                do {
                    file = new File(string2 + string + "errors" + string4 + ".log");
                    string4 = "." + n++;
                } while (file.exists());
                _pw = new PrintWriter(new FileOutputStream(file));
            }
            catch (IOException iOException) {
                System.err.println("FAILED TO OPEN AN ERROR LOG.");
                iOException.printStackTrace();
            }
        }
    }

    public static void closeLog() {
        if (_pw != null) {
            _pw.close();
            _pw = null;
        }
    }

    public static void logMessage(String string) {
        ErrorManagement.init();
        Date date = new Date();
        System.err.println(date + ": " + string);
        String string2 = JConfig.queryConfiguration("logging", "true");
        if (string2.equals("true") && _pw != null) {
            _pw.println(date + ": " + string);
            _pw.flush();
        }
    }

    public static void logDebug(String string) {
        if (JConfig.debugging) {
            ErrorManagement.logMessage(string);
        }
    }

    public static void handleException(String string, Throwable throwable) {
        ErrorManagement.init();
        Date date = new Date();
        if (string == null || string.equals("")) {
            System.err.println("[" + date + "]");
        } else {
            System.err.println(date + ": " + string);
        }
        throwable.printStackTrace();
        String string2 = JConfig.queryConfiguration("logging", "true");
        if (string2.equals("true") && _pw != null) {
            if (string == null || string.equals("")) {
                _pw.println("[" + date + "]");
            } else {
                _pw.println(date + ": " + string);
            }
            throwable.printStackTrace(_pw);
            _pw.flush();
        }
    }

    public static void logFile(String string, StringBuffer stringBuffer) {
        String string2 = JConfig.queryConfiguration("logging", "true");
        if (string2.equals("true") && JConfig.debugging) {
            ErrorManagement.init();
            if (_pw != null) {
                _pw.println("+------------------------------");
                _pw.println("| " + string);
                _pw.println("+------------------------------");
                if (stringBuffer != null) {
                    _pw.println(stringBuffer);
                } else {
                    _pw.println("(null)");
                }
                _pw.println("+------------end---------------");
                _pw.flush();
            }
        }
    }
}

