/*
 * Decompiled with CFR 0.152.
 */
import com.stevesoft.pat.Regex;
import java.util.NoSuchElementException;

public class EbayAuctionURLPager
extends AbstractURLPager {
    private static final String URLSTYLE_HTTP_STR = "search.dll";
    private static final int URLSTYLE_HTTP = 0;
    private static final int URLSTYLE_EBAY = 1;
    private static final int ITEMS_PER_PAGE = 100;
    private AuctionServer auctionServer;
    CleanupHandler cleanupHandler;
    private int urlStyle;
    private JHTML lastPage;
    private boolean itemCountSet;

    public EbayAuctionURLPager(String string, AuctionServer auctionServer, CleanupHandler cleanupHandler) {
        this.setURL(string);
        this.setItemsPerPage(100);
        this.auctionServer = auctionServer;
        this.cleanupHandler = cleanupHandler;
        this.getPage(1);
    }

    public EbayAuctionURLPager(String string, int n, AuctionServer auctionServer, CleanupHandler cleanupHandler) {
        this.setURL(string);
        this.setItemsPerPage(n);
        this.auctionServer = auctionServer;
        this.cleanupHandler = cleanupHandler;
        this.getPage(1);
    }

    protected void setURL(String string) {
        this.urlString = string;
        if (string.indexOf("ebay.") != -1) {
            if (string.indexOf(URLSTYLE_HTTP_STR) != -1) {
                this.urlStyle = 0;
                this.removePattern("&frpp=[0-9]*");
                this.removePattern("&skip=[0-9]*");
            } else {
                this.urlStyle = 1;
                this.removePattern("QQfrppZ[0-9]*");
                this.removePattern("QQfrtsZ[0-9]*");
            }
        }
    }

    private void removePattern(String string) {
        Regex regex = new Regex(string, "");
        regex.setIgnoreCase(true);
        this.urlString = regex.replaceAll(this.urlString);
    }

    private String getPageURL(int n) {
        if (this.urlString.indexOf("ebay.") == -1) {
            return this.urlString;
        }
        if (this.urlStyle == 0) {
            return this.urlString + "&frpp=" + this.getItemsPerPage() + "&skip=" + (n - 1) * this.getItemsPerPage();
        }
        if (this.urlStyle == 1) {
            return this.urlString + "QQfrppZ" + this.getItemsPerPage() + "QQfrtsZ" + (n - 1) * this.getItemsPerPage();
        }
        ErrorManagement.logMessage("Unknown URLSTYLE: " + this.urlStyle);
        return null;
    }

    protected JHTML getPage(String string) {
        JHTML jHTML;
        if (string == null) {
            return null;
        }
        CookieJar cookieJar = this.auctionServer.getNecessaryCookie(false);
        String string2 = null;
        if (cookieJar != null) {
            string2 = cookieJar.toString();
        }
        if ((jHTML = new JHTML(string, string2, this.cleanupHandler)).isLoaded()) {
            return jHTML;
        }
        return null;
    }

    public JHTML getPage(int n) {
        if (n < 1 || this.itemCountSet && n > this.size()) {
            throw new NoSuchElementException();
        }
        if (n == this.lastPageNumber) {
            return this.lastPage;
        }
        this.lastPageNumber = n;
        this.lastPage = this.getPage(this.getPageURL(n));
        if (n == 1 && !this.itemCountSet) {
            this.setItemCount();
        }
        return this.lastPage;
    }

    private void setItemCount() {
        if (this.lastPage == null) {
            this.setItemCount(0);
            this.itemCountSet = true;
        } else {
            String string = this.lastPage.getContentBeforeContent("items found for");
            if (string == null) {
                string = this.lastPage.getContentBeforeContent("items found in");
            }
            try {
                this.setItemCount(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                ErrorManagement.logMessage("Unable to find item count on page! URL: " + this.getPageURL(1));
            }
            this.itemCountSet = true;
        }
    }
}

