/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

public class AuctionsManager
implements TimerHandler.WakeupProcess,
EntryManager {
    private static AuctionsManager _instance = null;
    private DeletedManager _deleted = null;
    private int _auctionCount = 0;
    private JSplashScreen _splash = null;
    private FilterManager _filter;
    private long _checkpointFrequency = 600000L;
    private long _lastCheckpointed = System.currentTimeMillis();
    private static final int AUCTIONCOUNT = 100;
    private static final int MAX_PERCENT = 100;
    private static final int ONEK = 1024;
    private static final StringBuffer _saveBuf;

    private AuctionsManager() {
        this._deleted = new DeletedManager();
        this._filter = FilterManager.getInstance();
    }

    public static AuctionsManager getInstance() {
        return _instance;
    }

    public boolean anySnipes() {
        for (int i = 0; i < this._filter.listLength(); ++i) {
            if (!this._filter.getList(i).anySnipes()) continue;
            return true;
        }
        return false;
    }

    private boolean checkAuctions() {
        boolean bl = false;
        for (int i = 0; i < this._filter.listLength(); ++i) {
            if (!this._filter.getList(i).check()) continue;
            bl = true;
        }
        return bl;
    }

    private void checkSnapshot() {
        if (this._lastCheckpointed + this._checkpointFrequency < System.currentTimeMillis()) {
            this._lastCheckpointed = System.currentTimeMillis();
            this.saveAuctions();
            System.gc();
        }
    }

    public boolean check() {
        boolean bl = this.checkAuctions();
        this.checkSnapshot();
        return bl;
    }

    public boolean verifyEntry(String string) {
        Auctions auctions = this._filter.whereIsAuction(string);
        return auctions != null;
    }

    public void addEntry(AuctionEntry auctionEntry) {
        if (this._splash != null) {
            this._splash.showStatus(++this._auctionCount);
        }
        FilterManager.getInstance().addAuction(auctionEntry);
    }

    public void delEntry(AuctionEntry auctionEntry) {
        String string = auctionEntry.getIdentifier();
        this._deleted.delete(string);
        auctionEntry.cancelSnipe(false);
        FilterManager.getInstance().deleteAuction(auctionEntry);
    }

    public AuctionEntry getEntry(String string) {
        Auctions auctions = this._filter.whereIsAuction(string);
        if (auctions == null) {
            return null;
        }
        return auctions.getEntry(string);
    }

    public void changed() {
    }

    public static Iterator getAuctionIterator() {
        return FilterManager.getInstance().getAuctionIterator();
    }

    public void loadAuctions(JSplashScreen jSplashScreen) {
        String string;
        XMLElement xMLElement = new XMLElement(true);
        String string2 = string = JConfig.queryConfiguration("savefile", "auctions.xml");
        if (!(string = JConfig.getCanonicalFile(string, "jbidwatcher", true)).equals(string2)) {
            JConfig.setConfiguration("savefile", string);
        }
        this._splash = jSplashScreen;
        File file = new File(string);
        if (file.exists() && file.length() != 0L) {
            try {
                this.loadXMLFromFile(string, xMLElement);
            }
            catch (IOException iOException) {
                ErrorManagement.handleException("A serious problem occurred trying to load from auctions.xml.", iOException);
                MQFactory.getConcrete("Swing").enqueue("ERROR Failure to load your saved auctions.  Some or all items may be missing.");
            }
            catch (XMLParseException xMLParseException) {
                ErrorManagement.handleException("Trying to load from auctions.xml.", xMLParseException);
                MQFactory.getConcrete("Swing").enqueue("ERROR Failure to load your saved auctions.  Some or all items may be missing.");
            }
        } else {
            ErrorManagement.logDebug("JBW: Failed to load saved auctions, the auctions file is probably not there yet.");
            ErrorManagement.logDebug("JBW: This is not an error, unless you're constantly getting it.");
        }
        this._splash = null;
    }

    private void loadXMLFromFile(String string, XMLElement xMLElement) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(string));
        this._splash.setWidth(100);
        this._splash.showStatus(50);
        xMLElement.parseFromReader(inputStreamReader);
        this._splash.showStatus(100);
        XMLElement xMLElement2 = null;
        String string2 = "0090";
        if (xMLElement.getTagName().equals("JBidWatcher".toLowerCase())) {
            string2 = xMLElement.getProperty("FORMAT", "0100");
            xMLElement2 = xMLElement.getChild("auctions");
        } else if (xMLElement.getTagName().equals("auctions")) {
            xMLElement2 = xMLElement;
        }
        JConfig.setConfiguration("savefile.format", string2);
        if (xMLElement2 == null) {
            throw new XMLParseException(xMLElement.getTagName(), "AuctionsManager requires an <auctions> tag!");
        }
        String string3 = xMLElement2.getProperty("COUNT", null);
        int n = 0;
        if (string3 != null) {
            n = Integer.parseInt(string3);
            this._splash.showStatus(0);
            this._splash.setWidth(n);
            this._auctionCount = 0;
        }
        AuctionServerManager.setEntryManager(this);
        AuctionServerManager.getInstance().fromXML(xMLElement2);
        AuctionServer.AuctionStats auctionStats = AuctionServerManager.getInstance().getDefaultServer().getStats();
        int n2 = Integer.parseInt(JConfig.queryConfiguration("last.auctioncount", "-1"));
        if (auctionStats.getCount() != n || n2 != -1 && auctionStats.getCount() != n2) {
            MQFactory.getConcrete("Swing").enqueue("NOTIFY Failed to load all auctions.");
        }
        if (string2.compareTo("0090") > 0) {
            this._deleted.fromXML(xMLElement.getChild("deleted"));
        }
    }

    public AuctionEntry newAuctionEntry(String string) {
        String string2 = AuctionsManager.stripId(string);
        if (!this._deleted.isDeleted(string2) && !this.verifyEntry(string2)) {
            return new AuctionEntry(string);
        }
        return null;
    }

    public static String stripId(String string) {
        String string2 = string;
        if (string.startsWith("http")) {
            AuctionServer auctionServer = AuctionServerManager.getInstance().getServerForUrlString(string);
            string2 = auctionServer.extractIdentifierFromURLString(string);
        }
        return string2;
    }

    public void undelete(String string) {
        this._deleted.undelete(string);
    }

    public boolean isDeleted(String string) {
        return this._deleted.isDeleted(string);
    }

    public boolean saveAuctions() {
        File file;
        String string;
        XMLElement xMLElement = AuctionServerManager.getInstance().toXML();
        XMLElement xMLElement2 = this._deleted.toXML();
        String string2 = JConfig.queryConfiguration("savefile", "auctions.xml");
        String string3 = string = JConfig.getCanonicalFile(JConfig.queryConfiguration("savefile", "auctions.xml"), "jbidwatcher", false);
        AuctionsManager.ensureDirectories(string);
        boolean bl = AuctionsManager.needSwapSaves(string);
        if (!string.equals(string2)) {
            JConfig.setConfiguration("savefile", string);
        }
        if (bl && (file = new File(string3 = string + ".temp")).exists()) {
            file.delete();
        }
        AuctionsManager.buildSaveBuffer(xMLElement, xMLElement2);
        boolean bl2 = true;
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string3));
            printStream.println(_saveBuf);
            printStream.close();
        }
        catch (IOException iOException) {
            ErrorManagement.handleException("Failed to save auctions.", iOException);
            bl2 = false;
        }
        if (bl2 && bl) {
            AuctionsManager.preserveFiles(string);
        }
        return bl2;
    }

    public int clearDeleted() {
        int n = this._deleted.clearDeleted();
        this.saveAuctions();
        System.gc();
        return n;
    }

    private static void ensureDirectories(String string) {
        File file = new File(string);
        if (!(file = file.getParentFile()).exists()) {
            file.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer buildSaveBuffer(XMLElement xMLElement, XMLElement xMLElement2) {
        StringBuffer stringBuffer = _saveBuf;
        synchronized (stringBuffer) {
            _saveBuf.setLength(0);
            _saveBuf.append("<?xml version=\"1.0\"?>\n\n");
            _saveBuf.append("<!DOCTYPE auctions SYSTEM \"http://www.jbidwatcher.com/auctions.dtd\">");
            _saveBuf.append('\n');
            _saveBuf.append("<jbidwatcher format=\"0101\">\n");
            xMLElement.toStringBuffer(_saveBuf, 1);
            if (xMLElement2 != null) {
                xMLElement2.toStringBuffer(_saveBuf, 1);
            }
            _saveBuf.append("</jbidwatcher>");
        }
        return _saveBuf;
    }

    private static boolean needSwapSaves(String string) {
        File file = new File(string);
        return file.exists();
    }

    private static void preserveFiles(String string) {
        File file;
        String string2;
        File file2 = new File(string);
        File file3 = new File(string + ".temp");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMMyy_HHmm");
        String string3 = simpleDateFormat.format(new Date());
        String string4 = AuctionsManager.makeBackupFilename(string, string3);
        File file4 = new File(string4);
        if (file4.exists()) {
            file4.delete();
        }
        if ((string2 = JConfig.queryConfiguration("save.file.4", "")).length() != 0 && (file = new File(string2)).exists()) {
            AuctionsManager.backupByDate(string, file);
        }
        for (int i = 4; i > 0; --i) {
            JConfig.setConfiguration("save.file." + i, JConfig.queryConfiguration("save.file." + (i - 1), ""));
        }
        File file5 = new File(string4);
        if (!file2.renameTo(file5)) {
            ErrorManagement.logDebug("Renaming the old file (" + file2 + ") to the retain file (" + file5 + ") failed!");
        }
        JConfig.setConfiguration("save.file.0", string4);
        File file6 = new File(string);
        if (!file3.renameTo(file6)) {
            ErrorManagement.logDebug("Renaming the new file (" + file3 + ") to the standard filename (" + file6 + ") failed!");
        }
    }

    private static void backupByDate(String string, File file) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMMyy");
        String string2 = simpleDateFormat.format(new Date());
        String string3 = AuctionsManager.makeBackupFilename(string, string2);
        File file2 = new File(string3);
        if (file2.exists()) {
            file2.delete();
            File file3 = new File(string3);
            file.renameTo(file3);
        } else {
            file.renameTo(file2);
            String string4 = JConfig.queryConfiguration("save.bydate.4", "");
            for (int i = 4; i > 0; --i) {
                JConfig.setConfiguration("save.bydate." + i, JConfig.queryConfiguration("save.bydate." + (i - 1), ""));
            }
            JConfig.setConfiguration("save.bydate.0", string3);
            File file4 = new File(string4);
            file4.delete();
        }
    }

    private static String makeBackupFilename(String string, String string2) {
        int n;
        int n2 = string.lastIndexOf(System.getProperty("file.separator"));
        if (n2 == -1) {
            ErrorManagement.logDebug("Filename has no separators: " + string);
            n2 = 0;
        }
        if ((n = string.indexOf(46, n2)) == -1) {
            ErrorManagement.logDebug("Filename has no dot/extension: " + string);
            n = string.length();
        }
        return string.substring(0, n) + '-' + string2 + string.substring(n);
    }

    static {
        _instance = new AuctionsManager();
        _saveBuf = new StringBuffer(102400);
    }
}

