/*
 * Decompiled with CFR 0.152.
 */
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class AuctionServerManager
implements XMLSerialize,
MessageQueue.Listener {
    private List _serverList = new ArrayList();
    private List _configTabList = null;
    private static final AuctionServerManager _instance = new AuctionServerManager();
    private static EntryManager _em = null;
    private static final boolean uber_debug = false;

    public static void setEntryManager(EntryManager entryManager) {
        _em = entryManager;
    }

    public AuctionServer getServerByName(String string) {
        Iterator iterator = this._serverList.iterator();
        while (iterator.hasNext()) {
            AuctionServer auctionServer = ((AuctionServerListEntry)iterator.next()).getAuctionServer();
            if (!auctionServer.getName().equals(string)) continue;
            return auctionServer;
        }
        return null;
    }

    private AuctionServerManager() {
    }

    public void fromXML(XMLElement xMLElement) {
        Iterator iterator = xMLElement.getChildren();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            if (!xMLElement2.getTagName().equals("server")) continue;
            AuctionServer auctionServer = null;
            String string = xMLElement2.getProperty("NAME", null);
            if (string != null && (auctionServer = this.getServerByName(string)) == null) {
                try {
                    Class<?> clazz = Class.forName(string + "Server");
                    auctionServer = (AuctionServer)clazz.newInstance();
                    auctionServer = this.addServer(string, auctionServer);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ErrorManagement.handleException("Failed to load controller class for server " + string + '.', classNotFoundException);
                    throw new XMLParseException(xMLElement.getTagName(), "Failed to load controller class for server " + string + '.');
                }
                catch (InstantiationException instantiationException) {
                    ErrorManagement.handleException("Failed to instantiate server " + string + '.', instantiationException);
                    throw new XMLParseException(xMLElement.getTagName(), "Failed to instantiate server for " + string + '.');
                }
                catch (IllegalAccessException illegalAccessException) {
                    ErrorManagement.handleException("Illegal access when instantiating server for " + string + '.', illegalAccessException);
                    throw new XMLParseException(xMLElement.getTagName(), "Illegal access when instantiating server for " + string + '.');
                }
            }
            if (auctionServer == null) continue;
            auctionServer.setEntryManager(_em);
            try {
                auctionServer.fromXML(xMLElement2);
            }
            catch (XMLParseException xMLParseException) {
                ErrorManagement.handleException("Parse exception: ", xMLParseException);
            }
        }
    }

    public void messageAction(Object object) {
        String string = (String)object;
        if (string.equals("TIMECHECK")) {
            AuctionServer auctionServer = this.getDefaultServer();
            auctionServer.reloadTimeNow();
            long l = auctionServer.getOfficialServerTimeDelta();
            Date date = new Date(System.currentTimeMillis() + l);
            MQFactory.getConcrete("Swing").enqueue("Server time is now: " + date);
            try {
                boolean bl = false;
                MessageQueue messageQueue = MQFactory.getConcrete("auction_manager");
                while (!bl) {
                    string = messageQueue.dequeue();
                    if (string.equals("TIMECHECK")) continue;
                    bl = true;
                }
                messageQueue.enqueue(string);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public String getDefaultServerTime() {
        AuctionServer auctionServer = this.getDefaultServer();
        return auctionServer.getTime();
    }

    public XMLElement toXML() {
        XMLElement xMLElement = new XMLElement("auctions");
        int n = 0;
        Iterator iterator = this._serverList.iterator();
        while (iterator.hasNext()) {
            AuctionServerListEntry auctionServerListEntry = (AuctionServerListEntry)iterator.next();
            n += auctionServerListEntry.getAuctionServer().getAuctionCount();
            xMLElement.addChild(auctionServerListEntry.getAuctionServer().toXML());
        }
        xMLElement.setProperty("count", Integer.toString(n));
        return xMLElement;
    }

    public void delete_entry(AuctionEntry auctionEntry) {
        AuctionServer auctionServer = auctionEntry.getServer();
        if (auctionServer != null) {
            auctionServer.unregisterAuction(auctionEntry);
        }
    }

    public void add_entry(AuctionEntry auctionEntry) {
        AuctionServer auctionServer = auctionEntry.getServer();
        if (auctionServer != null) {
            auctionServer.registerAuction(auctionEntry);
        }
    }

    public static AuctionServerManager getInstance() {
        return _instance;
    }

    private AuctionServer addServerNoUI(String string, AuctionServer auctionServer) {
        Iterator iterator = this._serverList.iterator();
        while (iterator.hasNext()) {
            AuctionServerListEntry auctionServerListEntry = (AuctionServerListEntry)iterator.next();
            if (auctionServerListEntry.getAuctionServer() != auctionServer && !string.equals(auctionServerListEntry.getName())) continue;
            return auctionServerListEntry.getAuctionServer();
        }
        this._serverList.add(new AuctionServerListEntry(string, auctionServer));
        return auctionServer;
    }

    public AuctionServer addServer(String string, AuctionServer auctionServer) {
        AuctionServer auctionServer2 = this.addServerNoUI(string, auctionServer);
        if (auctionServer2 == auctionServer && this._configTabList != null) {
            this._configTabList.add(auctionServer.getConfigurationTab());
        }
        return auctionServer2;
    }

    private AuctionServer addServer(AuctionServer auctionServer) {
        return this.addServer(auctionServer.getName(), auctionServer);
    }

    public AuctionServer getServerForIdentifier(String string) {
        Iterator iterator = this._serverList.iterator();
        while (iterator.hasNext()) {
            AuctionServer auctionServer = ((AuctionServerListEntry)iterator.next()).getAuctionServer();
            if (!auctionServer.checkIfIdentifierIsHandled(string)) continue;
            return this.addServer(auctionServer);
        }
        return null;
    }

    public AuctionServer getServerForUrlString(String string) {
        Iterator iterator = this._serverList.iterator();
        while (iterator.hasNext()) {
            URL uRL;
            AuctionServer auctionServer = ((AuctionServerListEntry)iterator.next()).getAuctionServer();
            if (!auctionServer.doHandleThisSite(uRL = AuctionServer.getURLFromString(string))) continue;
            return this.addServer(auctionServer);
        }
        ErrorManagement.logDebug("No matches for getServerForUrlString(" + string + ')');
        return null;
    }

    public void addAuctionServerMenus() {
        Iterator iterator = this._serverList.iterator();
        while (iterator.hasNext()) {
            AuctionServer auctionServer = ((AuctionServerListEntry)iterator.next()).getAuctionServer();
            auctionServer.establishMenu();
        }
    }

    public AuctionServer getDefaultServer() {
        Iterator iterator = this._serverList.iterator();
        if (iterator.hasNext()) {
            return ((AuctionServerListEntry)iterator.next()).getAuctionServer();
        }
        return null;
    }

    public void addSearches(SearchManagerInterface searchManagerInterface) {
        Iterator iterator = this._serverList.iterator();
        while (iterator.hasNext()) {
            AuctionServer auctionServer = ((AuctionServerListEntry)iterator.next()).getAuctionServer();
            auctionServer.addSearches(searchManagerInterface);
        }
    }

    public void cancelSearches() {
        Iterator iterator = this._serverList.iterator();
        while (iterator.hasNext()) {
            AuctionServer auctionServer = ((AuctionServerListEntry)iterator.next()).getAuctionServer();
            auctionServer.cancelSearches();
        }
    }

    public List getServerConfigurationTabs() {
        this._configTabList = new ArrayList();
        Iterator iterator = this._serverList.iterator();
        while (iterator.hasNext()) {
            AuctionServer auctionServer = ((AuctionServerListEntry)iterator.next()).getAuctionServer();
            this._configTabList.add(auctionServer.getConfigurationTab());
        }
        return new ArrayList(this._configTabList);
    }

    static {
        MQFactory.getConcrete("auction_manager").registerListener(_instance);
    }

    private static class AuctionServerListEntry {
        private String _serverName;
        private AuctionServer _aucServ;

        private AuctionServerListEntry(String string, AuctionServer auctionServer) {
            this._serverName = string;
            this._aucServ = auctionServer;
        }

        public AuctionServer getAuctionServer() {
            return this._aucServ;
        }

        public String getName() {
            return this._serverName;
        }
    }
}

